package software.amazon.awscdk.services.bedrock;

/**
 * Specifies an agent as a resource in a top-level template. Minimally, you must specify the following properties:.
 * <p>
 * <ul>
 * <li>AgentName – Specify a name for the agent.</li>
 * <li>AgentResourceRoleArn – Specify the Amazon Resource Name (ARN) of the service role with permissions to invoke API operations on the agent. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-permissions.html">Create a service role for Agents for Amazon Bedrock</a> .</li>
 * <li>FoundationModel – Specify the model ID of a foundation model to use when invoking the agent. For more information, see <a href="https://docs.aws.amazon.com//bedrock/latest/userguide/agents-supported.html">Supported regions and models for Agents for Amazon Bedrock</a> .</li>
 * </ul>
 * <p>
 * For more information about using agents in Amazon Bedrock , see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents.html">Agents for Amazon Bedrock</a> .
 * <p>
 * See the <em>Properties</em> section below for descriptions of both the required and optional properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * CfnAgent cfnAgent = CfnAgent.Builder.create(this, "MyCfnAgent")
 *         .agentName("agentName")
 *         // the properties below are optional
 *         .actionGroups(List.of(AgentActionGroupProperty.builder()
 *                 .actionGroupName("actionGroupName")
 *                 // the properties below are optional
 *                 .actionGroupExecutor(ActionGroupExecutorProperty.builder()
 *                         .customControl("customControl")
 *                         .lambda("lambda")
 *                         .build())
 *                 .actionGroupState("actionGroupState")
 *                 .apiSchema(APISchemaProperty.builder()
 *                         .payload("payload")
 *                         .s3(S3IdentifierProperty.builder()
 *                                 .s3BucketName("s3BucketName")
 *                                 .s3ObjectKey("s3ObjectKey")
 *                                 .build())
 *                         .build())
 *                 .description("description")
 *                 .functionSchema(FunctionSchemaProperty.builder()
 *                         .functions(List.of(FunctionProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .description("description")
 *                                 .parameters(Map.of(
 *                                         "parametersKey", ParameterDetailProperty.builder()
 *                                                 .type("type")
 *                                                 // the properties below are optional
 *                                                 .description("description")
 *                                                 .required(false)
 *                                                 .build()))
 *                                 .build()))
 *                         .build())
 *                 .parentActionGroupSignature("parentActionGroupSignature")
 *                 .skipResourceInUseCheckOnDelete(false)
 *                 .build()))
 *         .agentResourceRoleArn("agentResourceRoleArn")
 *         .autoPrepare(false)
 *         .customerEncryptionKeyArn("customerEncryptionKeyArn")
 *         .description("description")
 *         .foundationModel("foundationModel")
 *         .guardrailConfiguration(GuardrailConfigurationProperty.builder()
 *                 .guardrailIdentifier("guardrailIdentifier")
 *                 .guardrailVersion("guardrailVersion")
 *                 .build())
 *         .idleSessionTtlInSeconds(123)
 *         .instruction("instruction")
 *         .knowledgeBases(List.of(AgentKnowledgeBaseProperty.builder()
 *                 .description("description")
 *                 .knowledgeBaseId("knowledgeBaseId")
 *                 // the properties below are optional
 *                 .knowledgeBaseState("knowledgeBaseState")
 *                 .build()))
 *         .promptOverrideConfiguration(PromptOverrideConfigurationProperty.builder()
 *                 .promptConfigurations(List.of(PromptConfigurationProperty.builder()
 *                         .basePromptTemplate("basePromptTemplate")
 *                         .inferenceConfiguration(InferenceConfigurationProperty.builder()
 *                                 .maximumLength(123)
 *                                 .stopSequences(List.of("stopSequences"))
 *                                 .temperature(123)
 *                                 .topK(123)
 *                                 .topP(123)
 *                                 .build())
 *                         .parserMode("parserMode")
 *                         .promptCreationMode("promptCreationMode")
 *                         .promptState("promptState")
 *                         .promptType("promptType")
 *                         .build()))
 *                 // the properties below are optional
 *                 .overrideLambda("overrideLambda")
 *                 .build())
 *         .skipResourceInUseCheckOnDelete(false)
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .testAliasTags(Map.of(
 *                 "testAliasTagsKey", "testAliasTags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:30.056Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgent")
public class CfnAgent extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnAgent(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAgent(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.CfnAgent.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAgent(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.CfnAgentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAgentArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAgentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAgentId() {
        return software.amazon.jsii.Kernel.get(this, "attrAgentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the agent and whether it is ready for use. The following statuses are possible:.
     * <p>
     * <ul>
     * <li>CREATING – The agent is being created.</li>
     * <li>PREPARING – The agent is being prepared.</li>
     * <li>PREPARED – The agent is prepared and ready to be invoked.</li>
     * <li>NOT_PREPARED – The agent has been created but not yet prepared.</li>
     * <li>FAILED – The agent API operation failed.</li>
     * <li>UPDATING – The agent is being updated.</li>
     * <li>DELETING – The agent is being deleted.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAgentStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrAgentStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAgentVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrAgentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time at which the agent was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Contains reasons that the agent-related API that you invoked failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrFailureReasons() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrFailureReasons", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The time at which the agent was last prepared.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPreparedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrPreparedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Contains recommended actions to take for the agent-related API that you invoked to succeed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrRecommendedActions() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrRecommendedActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The time at which the agent was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAgentName() {
        return software.amazon.jsii.Kernel.get(this, "agentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAgentName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "agentName", java.util.Objects.requireNonNull(value, "agentName is required"));
    }

    /**
     * The action groups that belong to an agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getActionGroups() {
        return software.amazon.jsii.Kernel.get(this, "actionGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The action groups that belong to an agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionGroups(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "actionGroups", value);
    }

    /**
     * The action groups that belong to an agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.bedrock.CfnAgent.AgentActionGroupProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.bedrock.CfnAgent.AgentActionGroupProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "actionGroups", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAgentResourceRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "agentResourceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAgentResourceRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "agentResourceRoleArn", value);
    }

    /**
     * Specifies whether to automatically update the <code>DRAFT</code> version of the agent after making changes to the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoPrepare() {
        return software.amazon.jsii.Kernel.get(this, "autoPrepare", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to automatically update the <code>DRAFT</code> version of the agent after making changes to the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoPrepare(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "autoPrepare", value);
    }

    /**
     * Specifies whether to automatically update the <code>DRAFT</code> version of the agent after making changes to the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoPrepare(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoPrepare", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS KMS key that encrypts the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCustomerEncryptionKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "customerEncryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS KMS key that encrypts the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomerEncryptionKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customerEncryptionKeyArn", value);
    }

    /**
     * The description of the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The foundation model used for orchestration by the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFoundationModel() {
        return software.amazon.jsii.Kernel.get(this, "foundationModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The foundation model used for orchestration by the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFoundationModel(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "foundationModel", value);
    }

    /**
     * Details about the guardrail associated with the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGuardrailConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "guardrailConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Details about the guardrail associated with the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGuardrailConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "guardrailConfiguration", value);
    }

    /**
     * Details about the guardrail associated with the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGuardrailConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnAgent.GuardrailConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "guardrailConfiguration", value);
    }

    /**
     * The number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getIdleSessionTtlInSeconds() {
        return software.amazon.jsii.Kernel.get(this, "idleSessionTtlInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdleSessionTtlInSeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "idleSessionTtlInSeconds", value);
    }

    /**
     * Instructions that tell the agent what it should do and how it should interact with users.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstruction() {
        return software.amazon.jsii.Kernel.get(this, "instruction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Instructions that tell the agent what it should do and how it should interact with users.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstruction(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instruction", value);
    }

    /**
     * The knowledge bases associated with the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKnowledgeBases() {
        return software.amazon.jsii.Kernel.get(this, "knowledgeBases", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The knowledge bases associated with the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKnowledgeBases(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "knowledgeBases", value);
    }

    /**
     * The knowledge bases associated with the agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKnowledgeBases(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.bedrock.CfnAgent.AgentKnowledgeBaseProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.bedrock.CfnAgent.AgentKnowledgeBaseProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "knowledgeBases", value);
    }

    /**
     * Contains configurations to override prompt templates in different parts of an agent sequence.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPromptOverrideConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "promptOverrideConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains configurations to override prompt templates in different parts of an agent sequence.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPromptOverrideConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "promptOverrideConfiguration", value);
    }

    /**
     * Contains configurations to override prompt templates in different parts of an agent sequence.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPromptOverrideConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnAgent.PromptOverrideConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "promptOverrideConfiguration", value);
    }

    /**
     * Specifies whether to delete the resource even if it's in use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSkipResourceInUseCheckOnDelete() {
        return software.amazon.jsii.Kernel.get(this, "skipResourceInUseCheckOnDelete", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to delete the resource even if it's in use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSkipResourceInUseCheckOnDelete(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "skipResourceInUseCheckOnDelete", value);
    }

    /**
     * Specifies whether to delete the resource even if it's in use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSkipResourceInUseCheckOnDelete(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "skipResourceInUseCheckOnDelete", value);
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs.
     * <p>
     * For more information, see the following resources:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs.
     * <p>
     * For more information, see the following resources:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs.
     * <p>
     * For more information, see the following resources:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTestAliasTags() {
        return software.amazon.jsii.Kernel.get(this, "testAliasTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs.
     * <p>
     * For more information, see the following resources:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTestAliasTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "testAliasTags", value);
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs.
     * <p>
     * For more information, see the following resources:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTestAliasTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "testAliasTags", value);
    }
    /**
     * Contains details about the OpenAPI schema for the action group.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI schemas</a> . You can either include the schema directly in the <code>payload</code> field or you can upload it to an S3 bucket and specify the S3 bucket location in the <code>s3</code> field.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * APISchemaProperty aPISchemaProperty = APISchemaProperty.builder()
     *         .payload("payload")
     *         .s3(S3IdentifierProperty.builder()
     *                 .s3BucketName("s3BucketName")
     *                 .s3ObjectKey("s3ObjectKey")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-apischema.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-apischema.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgent.APISchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(APISchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface APISchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The JSON or YAML-formatted payload defining the OpenAPI schema for the action group.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI schemas</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-apischema.html#cfn-bedrock-agent-apischema-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-apischema.html#cfn-bedrock-agent-apischema-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPayload() {
            return null;
        }

        /**
         * Contains details about the S3 object containing the OpenAPI schema for the action group.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI schemas</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-apischema.html#cfn-bedrock-agent-apischema-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-apischema.html#cfn-bedrock-agent-apischema-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link APISchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link APISchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<APISchemaProperty> {
            java.lang.String payload;
            java.lang.Object s3;

            /**
             * Sets the value of {@link APISchemaProperty#getPayload}
             * @param payload The JSON or YAML-formatted payload defining the OpenAPI schema for the action group.
             *                For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI schemas</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(java.lang.String payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link APISchemaProperty#getS3}
             * @param s3 Contains details about the S3 object containing the OpenAPI schema for the action group.
             *           For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI schemas</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link APISchemaProperty#getS3}
             * @param s3 Contains details about the S3 object containing the OpenAPI schema for the action group.
             *           For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI schemas</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.bedrock.CfnAgent.S3IdentifierProperty s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link APISchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public APISchemaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link APISchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements APISchemaProperty {
            private final java.lang.String payload;
            private final java.lang.Object s3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.payload = builder.payload;
                this.s3 = builder.s3;
            }

            @Override
            public final java.lang.String getPayload() {
                return this.payload;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }
                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnAgent.APISchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                APISchemaProperty.Jsii$Proxy that = (APISchemaProperty.Jsii$Proxy) o;

                if (this.payload != null ? !this.payload.equals(that.payload) : that.payload != null) return false;
                return this.s3 != null ? this.s3.equals(that.s3) : that.s3 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.payload != null ? this.payload.hashCode() : 0;
                result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains details about the Lambda function containing the business logic that is carried out upon invoking the action or the custom control method for handling the information elicited from the user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ActionGroupExecutorProperty actionGroupExecutorProperty = ActionGroupExecutorProperty.builder()
     *         .customControl("customControl")
     *         .lambda("lambda")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-actiongroupexecutor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-actiongroupexecutor.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgent.ActionGroupExecutorProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionGroupExecutorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionGroupExecutorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * To return the action group invocation results directly in the <code>InvokeAgent</code> response, specify <code>RETURN_CONTROL</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-actiongroupexecutor.html#cfn-bedrock-agent-actiongroupexecutor-customcontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-actiongroupexecutor.html#cfn-bedrock-agent-actiongroupexecutor-customcontrol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomControl() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon invoking the action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-actiongroupexecutor.html#cfn-bedrock-agent-actiongroupexecutor-lambda">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-actiongroupexecutor.html#cfn-bedrock-agent-actiongroupexecutor-lambda</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLambda() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionGroupExecutorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionGroupExecutorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionGroupExecutorProperty> {
            java.lang.String customControl;
            java.lang.String lambda;

            /**
             * Sets the value of {@link ActionGroupExecutorProperty#getCustomControl}
             * @param customControl To return the action group invocation results directly in the <code>InvokeAgent</code> response, specify <code>RETURN_CONTROL</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customControl(java.lang.String customControl) {
                this.customControl = customControl;
                return this;
            }

            /**
             * Sets the value of {@link ActionGroupExecutorProperty#getLambda}
             * @param lambda The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon invoking the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambda(java.lang.String lambda) {
                this.lambda = lambda;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionGroupExecutorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionGroupExecutorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionGroupExecutorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionGroupExecutorProperty {
            private final java.lang.String customControl;
            private final java.lang.String lambda;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customControl = software.amazon.jsii.Kernel.get(this, "customControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lambda = software.amazon.jsii.Kernel.get(this, "lambda", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customControl = builder.customControl;
                this.lambda = builder.lambda;
            }

            @Override
            public final java.lang.String getCustomControl() {
                return this.customControl;
            }

            @Override
            public final java.lang.String getLambda() {
                return this.lambda;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomControl() != null) {
                    data.set("customControl", om.valueToTree(this.getCustomControl()));
                }
                if (this.getLambda() != null) {
                    data.set("lambda", om.valueToTree(this.getLambda()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnAgent.ActionGroupExecutorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionGroupExecutorProperty.Jsii$Proxy that = (ActionGroupExecutorProperty.Jsii$Proxy) o;

                if (this.customControl != null ? !this.customControl.equals(that.customControl) : that.customControl != null) return false;
                return this.lambda != null ? this.lambda.equals(that.lambda) : that.lambda == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customControl != null ? this.customControl.hashCode() : 0;
                result = 31 * result + (this.lambda != null ? this.lambda.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains details about an action group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * AgentActionGroupProperty agentActionGroupProperty = AgentActionGroupProperty.builder()
     *         .actionGroupName("actionGroupName")
     *         // the properties below are optional
     *         .actionGroupExecutor(ActionGroupExecutorProperty.builder()
     *                 .customControl("customControl")
     *                 .lambda("lambda")
     *                 .build())
     *         .actionGroupState("actionGroupState")
     *         .apiSchema(APISchemaProperty.builder()
     *                 .payload("payload")
     *                 .s3(S3IdentifierProperty.builder()
     *                         .s3BucketName("s3BucketName")
     *                         .s3ObjectKey("s3ObjectKey")
     *                         .build())
     *                 .build())
     *         .description("description")
     *         .functionSchema(FunctionSchemaProperty.builder()
     *                 .functions(List.of(FunctionProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .description("description")
     *                         .parameters(Map.of(
     *                                 "parametersKey", ParameterDetailProperty.builder()
     *                                         .type("type")
     *                                         // the properties below are optional
     *                                         .description("description")
     *                                         .required(false)
     *                                         .build()))
     *                         .build()))
     *                 .build())
     *         .parentActionGroupSignature("parentActionGroupSignature")
     *         .skipResourceInUseCheckOnDelete(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgent.AgentActionGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(AgentActionGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AgentActionGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the action group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html#cfn-bedrock-agent-agentactiongroup-actiongroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html#cfn-bedrock-agent-agentactiongroup-actiongroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getActionGroupName();

        /**
         * The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon invoking the action or the custom control method for handling the information elicited from the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html#cfn-bedrock-agent-agentactiongroup-actiongroupexecutor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html#cfn-bedrock-agent-agentactiongroup-actiongroupexecutor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActionGroupExecutor() {
            return null;
        }

        /**
         * Specifies whether the action group is available for the agent to invoke or not when sending an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a> request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html#cfn-bedrock-agent-agentactiongroup-actiongroupstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html#cfn-bedrock-agent-agentactiongroup-actiongroupstate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getActionGroupState() {
            return null;
        }

        /**
         * Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI schemas</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html#cfn-bedrock-agent-agentactiongroup-apischema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html#cfn-bedrock-agent-agentactiongroup-apischema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApiSchema() {
            return null;
        }

        /**
         * The description of the action group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html#cfn-bedrock-agent-agentactiongroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html#cfn-bedrock-agent-agentactiongroup-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Defines functions that each define parameters that the agent needs to invoke from the user.
         * <p>
         * Each function represents an action in an action group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html#cfn-bedrock-agent-agentactiongroup-functionschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html#cfn-bedrock-agent-agentactiongroup-functionschema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFunctionSchema() {
            return null;
        }

        /**
         * If this field is set as <code>AMAZON.UserInput</code> , the agent can request the user for additional information when trying to complete a task. The <code>description</code> , <code>apiSchema</code> , and <code>actionGroupExecutor</code> fields must be blank for this action group.
         * <p>
         * During orchestration, if the agent determines that it needs to invoke an API in an action group, but doesn't have enough information to complete the API request, it will invoke this action group instead and return an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html">Observation</a> reprompting the user for more information.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html#cfn-bedrock-agent-agentactiongroup-parentactiongroupsignature">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html#cfn-bedrock-agent-agentactiongroup-parentactiongroupsignature</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParentActionGroupSignature() {
            return null;
        }

        /**
         * Specifies whether to delete the resource even if it's in use.
         * <p>
         * By default, this value is <code>false</code> .
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html#cfn-bedrock-agent-agentactiongroup-skipresourceinusecheckondelete">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentactiongroup.html#cfn-bedrock-agent-agentactiongroup-skipresourceinusecheckondelete</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSkipResourceInUseCheckOnDelete() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AgentActionGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AgentActionGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AgentActionGroupProperty> {
            java.lang.String actionGroupName;
            java.lang.Object actionGroupExecutor;
            java.lang.String actionGroupState;
            java.lang.Object apiSchema;
            java.lang.String description;
            java.lang.Object functionSchema;
            java.lang.String parentActionGroupSignature;
            java.lang.Object skipResourceInUseCheckOnDelete;

            /**
             * Sets the value of {@link AgentActionGroupProperty#getActionGroupName}
             * @param actionGroupName The name of the action group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionGroupName(java.lang.String actionGroupName) {
                this.actionGroupName = actionGroupName;
                return this;
            }

            /**
             * Sets the value of {@link AgentActionGroupProperty#getActionGroupExecutor}
             * @param actionGroupExecutor The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon invoking the action or the custom control method for handling the information elicited from the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionGroupExecutor(software.amazon.awscdk.IResolvable actionGroupExecutor) {
                this.actionGroupExecutor = actionGroupExecutor;
                return this;
            }

            /**
             * Sets the value of {@link AgentActionGroupProperty#getActionGroupExecutor}
             * @param actionGroupExecutor The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon invoking the action or the custom control method for handling the information elicited from the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionGroupExecutor(software.amazon.awscdk.services.bedrock.CfnAgent.ActionGroupExecutorProperty actionGroupExecutor) {
                this.actionGroupExecutor = actionGroupExecutor;
                return this;
            }

            /**
             * Sets the value of {@link AgentActionGroupProperty#getActionGroupState}
             * @param actionGroupState Specifies whether the action group is available for the agent to invoke or not when sending an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a> request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionGroupState(java.lang.String actionGroupState) {
                this.actionGroupState = actionGroupState;
                return this;
            }

            /**
             * Sets the value of {@link AgentActionGroupProperty#getApiSchema}
             * @param apiSchema Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema.
             *                  For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI schemas</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiSchema(software.amazon.awscdk.IResolvable apiSchema) {
                this.apiSchema = apiSchema;
                return this;
            }

            /**
             * Sets the value of {@link AgentActionGroupProperty#getApiSchema}
             * @param apiSchema Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema.
             *                  For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI schemas</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiSchema(software.amazon.awscdk.services.bedrock.CfnAgent.APISchemaProperty apiSchema) {
                this.apiSchema = apiSchema;
                return this;
            }

            /**
             * Sets the value of {@link AgentActionGroupProperty#getDescription}
             * @param description The description of the action group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link AgentActionGroupProperty#getFunctionSchema}
             * @param functionSchema Defines functions that each define parameters that the agent needs to invoke from the user.
             *                       Each function represents an action in an action group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionSchema(software.amazon.awscdk.IResolvable functionSchema) {
                this.functionSchema = functionSchema;
                return this;
            }

            /**
             * Sets the value of {@link AgentActionGroupProperty#getFunctionSchema}
             * @param functionSchema Defines functions that each define parameters that the agent needs to invoke from the user.
             *                       Each function represents an action in an action group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionSchema(software.amazon.awscdk.services.bedrock.CfnAgent.FunctionSchemaProperty functionSchema) {
                this.functionSchema = functionSchema;
                return this;
            }

            /**
             * Sets the value of {@link AgentActionGroupProperty#getParentActionGroupSignature}
             * @param parentActionGroupSignature If this field is set as <code>AMAZON.UserInput</code> , the agent can request the user for additional information when trying to complete a task. The <code>description</code> , <code>apiSchema</code> , and <code>actionGroupExecutor</code> fields must be blank for this action group.
             *                                   During orchestration, if the agent determines that it needs to invoke an API in an action group, but doesn't have enough information to complete the API request, it will invoke this action group instead and return an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html">Observation</a> reprompting the user for more information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parentActionGroupSignature(java.lang.String parentActionGroupSignature) {
                this.parentActionGroupSignature = parentActionGroupSignature;
                return this;
            }

            /**
             * Sets the value of {@link AgentActionGroupProperty#getSkipResourceInUseCheckOnDelete}
             * @param skipResourceInUseCheckOnDelete Specifies whether to delete the resource even if it's in use.
             *                                       By default, this value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder skipResourceInUseCheckOnDelete(java.lang.Boolean skipResourceInUseCheckOnDelete) {
                this.skipResourceInUseCheckOnDelete = skipResourceInUseCheckOnDelete;
                return this;
            }

            /**
             * Sets the value of {@link AgentActionGroupProperty#getSkipResourceInUseCheckOnDelete}
             * @param skipResourceInUseCheckOnDelete Specifies whether to delete the resource even if it's in use.
             *                                       By default, this value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder skipResourceInUseCheckOnDelete(software.amazon.awscdk.IResolvable skipResourceInUseCheckOnDelete) {
                this.skipResourceInUseCheckOnDelete = skipResourceInUseCheckOnDelete;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AgentActionGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AgentActionGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AgentActionGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AgentActionGroupProperty {
            private final java.lang.String actionGroupName;
            private final java.lang.Object actionGroupExecutor;
            private final java.lang.String actionGroupState;
            private final java.lang.Object apiSchema;
            private final java.lang.String description;
            private final java.lang.Object functionSchema;
            private final java.lang.String parentActionGroupSignature;
            private final java.lang.Object skipResourceInUseCheckOnDelete;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actionGroupName = software.amazon.jsii.Kernel.get(this, "actionGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.actionGroupExecutor = software.amazon.jsii.Kernel.get(this, "actionGroupExecutor", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.actionGroupState = software.amazon.jsii.Kernel.get(this, "actionGroupState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.apiSchema = software.amazon.jsii.Kernel.get(this, "apiSchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.functionSchema = software.amazon.jsii.Kernel.get(this, "functionSchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parentActionGroupSignature = software.amazon.jsii.Kernel.get(this, "parentActionGroupSignature", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.skipResourceInUseCheckOnDelete = software.amazon.jsii.Kernel.get(this, "skipResourceInUseCheckOnDelete", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actionGroupName = java.util.Objects.requireNonNull(builder.actionGroupName, "actionGroupName is required");
                this.actionGroupExecutor = builder.actionGroupExecutor;
                this.actionGroupState = builder.actionGroupState;
                this.apiSchema = builder.apiSchema;
                this.description = builder.description;
                this.functionSchema = builder.functionSchema;
                this.parentActionGroupSignature = builder.parentActionGroupSignature;
                this.skipResourceInUseCheckOnDelete = builder.skipResourceInUseCheckOnDelete;
            }

            @Override
            public final java.lang.String getActionGroupName() {
                return this.actionGroupName;
            }

            @Override
            public final java.lang.Object getActionGroupExecutor() {
                return this.actionGroupExecutor;
            }

            @Override
            public final java.lang.String getActionGroupState() {
                return this.actionGroupState;
            }

            @Override
            public final java.lang.Object getApiSchema() {
                return this.apiSchema;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getFunctionSchema() {
                return this.functionSchema;
            }

            @Override
            public final java.lang.String getParentActionGroupSignature() {
                return this.parentActionGroupSignature;
            }

            @Override
            public final java.lang.Object getSkipResourceInUseCheckOnDelete() {
                return this.skipResourceInUseCheckOnDelete;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actionGroupName", om.valueToTree(this.getActionGroupName()));
                if (this.getActionGroupExecutor() != null) {
                    data.set("actionGroupExecutor", om.valueToTree(this.getActionGroupExecutor()));
                }
                if (this.getActionGroupState() != null) {
                    data.set("actionGroupState", om.valueToTree(this.getActionGroupState()));
                }
                if (this.getApiSchema() != null) {
                    data.set("apiSchema", om.valueToTree(this.getApiSchema()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getFunctionSchema() != null) {
                    data.set("functionSchema", om.valueToTree(this.getFunctionSchema()));
                }
                if (this.getParentActionGroupSignature() != null) {
                    data.set("parentActionGroupSignature", om.valueToTree(this.getParentActionGroupSignature()));
                }
                if (this.getSkipResourceInUseCheckOnDelete() != null) {
                    data.set("skipResourceInUseCheckOnDelete", om.valueToTree(this.getSkipResourceInUseCheckOnDelete()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnAgent.AgentActionGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AgentActionGroupProperty.Jsii$Proxy that = (AgentActionGroupProperty.Jsii$Proxy) o;

                if (!actionGroupName.equals(that.actionGroupName)) return false;
                if (this.actionGroupExecutor != null ? !this.actionGroupExecutor.equals(that.actionGroupExecutor) : that.actionGroupExecutor != null) return false;
                if (this.actionGroupState != null ? !this.actionGroupState.equals(that.actionGroupState) : that.actionGroupState != null) return false;
                if (this.apiSchema != null ? !this.apiSchema.equals(that.apiSchema) : that.apiSchema != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.functionSchema != null ? !this.functionSchema.equals(that.functionSchema) : that.functionSchema != null) return false;
                if (this.parentActionGroupSignature != null ? !this.parentActionGroupSignature.equals(that.parentActionGroupSignature) : that.parentActionGroupSignature != null) return false;
                return this.skipResourceInUseCheckOnDelete != null ? this.skipResourceInUseCheckOnDelete.equals(that.skipResourceInUseCheckOnDelete) : that.skipResourceInUseCheckOnDelete == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actionGroupName.hashCode();
                result = 31 * result + (this.actionGroupExecutor != null ? this.actionGroupExecutor.hashCode() : 0);
                result = 31 * result + (this.actionGroupState != null ? this.actionGroupState.hashCode() : 0);
                result = 31 * result + (this.apiSchema != null ? this.apiSchema.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.functionSchema != null ? this.functionSchema.hashCode() : 0);
                result = 31 * result + (this.parentActionGroupSignature != null ? this.parentActionGroupSignature.hashCode() : 0);
                result = 31 * result + (this.skipResourceInUseCheckOnDelete != null ? this.skipResourceInUseCheckOnDelete.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains details about a knowledge base that is associated with an agent.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * AgentKnowledgeBaseProperty agentKnowledgeBaseProperty = AgentKnowledgeBaseProperty.builder()
     *         .description("description")
     *         .knowledgeBaseId("knowledgeBaseId")
     *         // the properties below are optional
     *         .knowledgeBaseState("knowledgeBaseState")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentknowledgebase.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentknowledgebase.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgent.AgentKnowledgeBaseProperty")
    @software.amazon.jsii.Jsii.Proxy(AgentKnowledgeBaseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AgentKnowledgeBaseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The description of the association between the agent and the knowledge base.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentknowledgebase.html#cfn-bedrock-agent-agentknowledgebase-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentknowledgebase.html#cfn-bedrock-agent-agentknowledgebase-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDescription();

        /**
         * The unique identifier of the association between the agent and the knowledge base.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentknowledgebase.html#cfn-bedrock-agent-agentknowledgebase-knowledgebaseid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentknowledgebase.html#cfn-bedrock-agent-agentknowledgebase-knowledgebaseid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKnowledgeBaseId();

        /**
         * Specifies whether to use the knowledge base or not when sending an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a> request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentknowledgebase.html#cfn-bedrock-agent-agentknowledgebase-knowledgebasestate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-agentknowledgebase.html#cfn-bedrock-agent-agentknowledgebase-knowledgebasestate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKnowledgeBaseState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AgentKnowledgeBaseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AgentKnowledgeBaseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AgentKnowledgeBaseProperty> {
            java.lang.String description;
            java.lang.String knowledgeBaseId;
            java.lang.String knowledgeBaseState;

            /**
             * Sets the value of {@link AgentKnowledgeBaseProperty#getDescription}
             * @param description The description of the association between the agent and the knowledge base. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link AgentKnowledgeBaseProperty#getKnowledgeBaseId}
             * @param knowledgeBaseId The unique identifier of the association between the agent and the knowledge base. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knowledgeBaseId(java.lang.String knowledgeBaseId) {
                this.knowledgeBaseId = knowledgeBaseId;
                return this;
            }

            /**
             * Sets the value of {@link AgentKnowledgeBaseProperty#getKnowledgeBaseState}
             * @param knowledgeBaseState Specifies whether to use the knowledge base or not when sending an <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a> request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knowledgeBaseState(java.lang.String knowledgeBaseState) {
                this.knowledgeBaseState = knowledgeBaseState;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AgentKnowledgeBaseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AgentKnowledgeBaseProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AgentKnowledgeBaseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AgentKnowledgeBaseProperty {
            private final java.lang.String description;
            private final java.lang.String knowledgeBaseId;
            private final java.lang.String knowledgeBaseState;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.knowledgeBaseId = software.amazon.jsii.Kernel.get(this, "knowledgeBaseId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.knowledgeBaseState = software.amazon.jsii.Kernel.get(this, "knowledgeBaseState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
                this.knowledgeBaseId = java.util.Objects.requireNonNull(builder.knowledgeBaseId, "knowledgeBaseId is required");
                this.knowledgeBaseState = builder.knowledgeBaseState;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getKnowledgeBaseId() {
                return this.knowledgeBaseId;
            }

            @Override
            public final java.lang.String getKnowledgeBaseState() {
                return this.knowledgeBaseState;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("description", om.valueToTree(this.getDescription()));
                data.set("knowledgeBaseId", om.valueToTree(this.getKnowledgeBaseId()));
                if (this.getKnowledgeBaseState() != null) {
                    data.set("knowledgeBaseState", om.valueToTree(this.getKnowledgeBaseState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnAgent.AgentKnowledgeBaseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AgentKnowledgeBaseProperty.Jsii$Proxy that = (AgentKnowledgeBaseProperty.Jsii$Proxy) o;

                if (!description.equals(that.description)) return false;
                if (!knowledgeBaseId.equals(that.knowledgeBaseId)) return false;
                return this.knowledgeBaseState != null ? this.knowledgeBaseState.equals(that.knowledgeBaseState) : that.knowledgeBaseState == null;
            }

            @Override
            public final int hashCode() {
                int result = this.description.hashCode();
                result = 31 * result + (this.knowledgeBaseId.hashCode());
                result = 31 * result + (this.knowledgeBaseState != null ? this.knowledgeBaseState.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines parameters that the agent needs to invoke from the user to complete the function.
     * <p>
     * Corresponds to an action in an action group.
     * <p>
     * This data type is used in the following API operations:
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_RequestSyntax">CreateAgentActionGroup request</a></li>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_ResponseSyntax">CreateAgentActionGroup response</a></li>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_RequestSyntax">UpdateAgentActionGroup request</a></li>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_ResponseSyntax">UpdateAgentActionGroup response</a></li>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentActionGroup.html#API_agent_GetAgentActionGroup_ResponseSyntax">GetAgentActionGroup response</a></li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FunctionProperty functionProperty = FunctionProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .description("description")
     *         .parameters(Map.of(
     *                 "parametersKey", ParameterDetailProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .description("description")
     *                         .required(false)
     *                         .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-function.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-function.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgent.FunctionProperty")
    @software.amazon.jsii.Jsii.Proxy(FunctionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FunctionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-function.html#cfn-bedrock-agent-function-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-function.html#cfn-bedrock-agent-function-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * A description of the function and its purpose.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-function.html#cfn-bedrock-agent-function-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-function.html#cfn-bedrock-agent-function-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The parameters that the agent elicits from the user to fulfill the function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-function.html#cfn-bedrock-agent-function-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-function.html#cfn-bedrock-agent-function-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FunctionProperty> {
            java.lang.String name;
            java.lang.String description;
            java.lang.Object parameters;

            /**
             * Sets the value of {@link FunctionProperty#getName}
             * @param name A name for the function. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FunctionProperty#getDescription}
             * @param description A description of the function and its purpose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link FunctionProperty#getParameters}
             * @param parameters The parameters that the agent elicits from the user to fulfill the function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link FunctionProperty#getParameters}
             * @param parameters The parameters that the agent elicits from the user to fulfill the function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FunctionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionProperty {
            private final java.lang.String name;
            private final java.lang.String description;
            private final java.lang.Object parameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.description = builder.description;
                this.parameters = builder.parameters;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnAgent.FunctionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionProperty.Jsii$Proxy that = (FunctionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines functions that each define parameters that the agent needs to invoke from the user.
     * <p>
     * Each function represents an action in an action group.
     * <p>
     * This data type is used in the following API operations:
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_RequestSyntax">CreateAgentActionGroup request</a></li>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_ResponseSyntax">CreateAgentActionGroup response</a></li>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_RequestSyntax">UpdateAgentActionGroup request</a></li>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_ResponseSyntax">UpdateAgentActionGroup response</a></li>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentActionGroup.html#API_agent_GetAgentActionGroup_ResponseSyntax">GetAgentActionGroup response</a></li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FunctionSchemaProperty functionSchemaProperty = FunctionSchemaProperty.builder()
     *         .functions(List.of(FunctionProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .description("description")
     *                 .parameters(Map.of(
     *                         "parametersKey", ParameterDetailProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .description("description")
     *                                 .required(false)
     *                                 .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-functionschema.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-functionschema.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgent.FunctionSchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(FunctionSchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FunctionSchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of functions that each define an action in the action group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-functionschema.html#cfn-bedrock-agent-functionschema-functions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-functionschema.html#cfn-bedrock-agent-functionschema-functions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFunctions();

        /**
         * @return a {@link Builder} of {@link FunctionSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FunctionSchemaProperty> {
            java.lang.Object functions;

            /**
             * Sets the value of {@link FunctionSchemaProperty#getFunctions}
             * @param functions A list of functions that each define an action in the action group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functions(software.amazon.awscdk.IResolvable functions) {
                this.functions = functions;
                return this;
            }

            /**
             * Sets the value of {@link FunctionSchemaProperty#getFunctions}
             * @param functions A list of functions that each define an action in the action group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functions(java.util.List<? extends java.lang.Object> functions) {
                this.functions = functions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FunctionSchemaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FunctionSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionSchemaProperty {
            private final java.lang.Object functions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.functions = software.amazon.jsii.Kernel.get(this, "functions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.functions = java.util.Objects.requireNonNull(builder.functions, "functions is required");
            }

            @Override
            public final java.lang.Object getFunctions() {
                return this.functions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("functions", om.valueToTree(this.getFunctions()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnAgent.FunctionSchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionSchemaProperty.Jsii$Proxy that = (FunctionSchemaProperty.Jsii$Proxy) o;

                return this.functions.equals(that.functions);
            }

            @Override
            public final int hashCode() {
                int result = this.functions.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration information for a guardrail that you use with the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> operation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * GuardrailConfigurationProperty guardrailConfigurationProperty = GuardrailConfigurationProperty.builder()
     *         .guardrailIdentifier("guardrailIdentifier")
     *         .guardrailVersion("guardrailVersion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-guardrailconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-guardrailconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgent.GuardrailConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(GuardrailConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GuardrailConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-guardrailconfiguration.html#cfn-bedrock-agent-guardrailconfiguration-guardrailidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-guardrailconfiguration.html#cfn-bedrock-agent-guardrailconfiguration-guardrailidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGuardrailIdentifier() {
            return null;
        }

        /**
         * The version of the guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-guardrailconfiguration.html#cfn-bedrock-agent-guardrailconfiguration-guardrailversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-guardrailconfiguration.html#cfn-bedrock-agent-guardrailconfiguration-guardrailversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGuardrailVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GuardrailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GuardrailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GuardrailConfigurationProperty> {
            java.lang.String guardrailIdentifier;
            java.lang.String guardrailVersion;

            /**
             * Sets the value of {@link GuardrailConfigurationProperty#getGuardrailIdentifier}
             * @param guardrailIdentifier The identifier for the guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardrailIdentifier(java.lang.String guardrailIdentifier) {
                this.guardrailIdentifier = guardrailIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link GuardrailConfigurationProperty#getGuardrailVersion}
             * @param guardrailVersion The version of the guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardrailVersion(java.lang.String guardrailVersion) {
                this.guardrailVersion = guardrailVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GuardrailConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GuardrailConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GuardrailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GuardrailConfigurationProperty {
            private final java.lang.String guardrailIdentifier;
            private final java.lang.String guardrailVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.guardrailIdentifier = software.amazon.jsii.Kernel.get(this, "guardrailIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.guardrailVersion = software.amazon.jsii.Kernel.get(this, "guardrailVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.guardrailIdentifier = builder.guardrailIdentifier;
                this.guardrailVersion = builder.guardrailVersion;
            }

            @Override
            public final java.lang.String getGuardrailIdentifier() {
                return this.guardrailIdentifier;
            }

            @Override
            public final java.lang.String getGuardrailVersion() {
                return this.guardrailVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGuardrailIdentifier() != null) {
                    data.set("guardrailIdentifier", om.valueToTree(this.getGuardrailIdentifier()));
                }
                if (this.getGuardrailVersion() != null) {
                    data.set("guardrailVersion", om.valueToTree(this.getGuardrailVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnAgent.GuardrailConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GuardrailConfigurationProperty.Jsii$Proxy that = (GuardrailConfigurationProperty.Jsii$Proxy) o;

                if (this.guardrailIdentifier != null ? !this.guardrailIdentifier.equals(that.guardrailIdentifier) : that.guardrailIdentifier != null) return false;
                return this.guardrailVersion != null ? this.guardrailVersion.equals(that.guardrailVersion) : that.guardrailVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.guardrailIdentifier != null ? this.guardrailIdentifier.hashCode() : 0;
                result = 31 * result + (this.guardrailVersion != null ? this.guardrailVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Base inference parameters to pass to a model in a call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a> . For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a> .
     * <p>
     * If you need to pass additional parameters that the model supports, use the <code>additionalModelRequestFields</code> request field in the call to <code>Converse</code> or <code>ConverseStream</code> . For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Model parameters</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * InferenceConfigurationProperty inferenceConfigurationProperty = InferenceConfigurationProperty.builder()
     *         .maximumLength(123)
     *         .stopSequences(List.of("stopSequences"))
     *         .temperature(123)
     *         .topK(123)
     *         .topP(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-inferenceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-inferenceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgent.InferenceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InferenceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InferenceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of tokens allowed in the generated response.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-inferenceconfiguration.html#cfn-bedrock-agent-inferenceconfiguration-maximumlength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-inferenceconfiguration.html#cfn-bedrock-agent-inferenceconfiguration-maximumlength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumLength() {
            return null;
        }

        /**
         * A list of stop sequences.
         * <p>
         * A stop sequence is a sequence of characters that causes the model to stop generating the response.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-inferenceconfiguration.html#cfn-bedrock-agent-inferenceconfiguration-stopsequences">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-inferenceconfiguration.html#cfn-bedrock-agent-inferenceconfiguration-stopsequences</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStopSequences() {
            return null;
        }

        /**
         * The likelihood of the model selecting higher-probability options while generating a response.
         * <p>
         * A lower value makes the model more likely to choose higher-probability options, while a higher value makes the model more likely to choose lower-probability options.
         * <p>
         * The default value is the default value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-inferenceconfiguration.html#cfn-bedrock-agent-inferenceconfiguration-temperature">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-inferenceconfiguration.html#cfn-bedrock-agent-inferenceconfiguration-temperature</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTemperature() {
            return null;
        }

        /**
         * While generating a response, the model determines the probability of the following token at each point of generation.
         * <p>
         * The value that you set for <code>topK</code> is the number of most-likely candidates from which the model chooses the next token in the sequence. For example, if you set <code>topK</code> to 50, the model selects the next token from among the top 50 most likely choices.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-inferenceconfiguration.html#cfn-bedrock-agent-inferenceconfiguration-topk">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-inferenceconfiguration.html#cfn-bedrock-agent-inferenceconfiguration-topk</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTopK() {
            return null;
        }

        /**
         * The percentage of most-likely candidates that the model considers for the next token.
         * <p>
         * For example, if you choose a value of 0.8 for <code>topP</code> , the model selects from the top 80% of the probability distribution of tokens that could be next in the sequence.
         * <p>
         * The default value is the default value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-inferenceconfiguration.html#cfn-bedrock-agent-inferenceconfiguration-topp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-inferenceconfiguration.html#cfn-bedrock-agent-inferenceconfiguration-topp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTopP() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InferenceConfigurationProperty> {
            java.lang.Number maximumLength;
            java.util.List<java.lang.String> stopSequences;
            java.lang.Number temperature;
            java.lang.Number topK;
            java.lang.Number topP;

            /**
             * Sets the value of {@link InferenceConfigurationProperty#getMaximumLength}
             * @param maximumLength The maximum number of tokens allowed in the generated response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumLength(java.lang.Number maximumLength) {
                this.maximumLength = maximumLength;
                return this;
            }

            /**
             * Sets the value of {@link InferenceConfigurationProperty#getStopSequences}
             * @param stopSequences A list of stop sequences.
             *                      A stop sequence is a sequence of characters that causes the model to stop generating the response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stopSequences(java.util.List<java.lang.String> stopSequences) {
                this.stopSequences = stopSequences;
                return this;
            }

            /**
             * Sets the value of {@link InferenceConfigurationProperty#getTemperature}
             * @param temperature The likelihood of the model selecting higher-probability options while generating a response.
             *                    A lower value makes the model more likely to choose higher-probability options, while a higher value makes the model more likely to choose lower-probability options.
             *                    <p>
             *                    The default value is the default value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder temperature(java.lang.Number temperature) {
                this.temperature = temperature;
                return this;
            }

            /**
             * Sets the value of {@link InferenceConfigurationProperty#getTopK}
             * @param topK While generating a response, the model determines the probability of the following token at each point of generation.
             *             The value that you set for <code>topK</code> is the number of most-likely candidates from which the model chooses the next token in the sequence. For example, if you set <code>topK</code> to 50, the model selects the next token from among the top 50 most likely choices.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topK(java.lang.Number topK) {
                this.topK = topK;
                return this;
            }

            /**
             * Sets the value of {@link InferenceConfigurationProperty#getTopP}
             * @param topP The percentage of most-likely candidates that the model considers for the next token.
             *             For example, if you choose a value of 0.8 for <code>topP</code> , the model selects from the top 80% of the probability distribution of tokens that could be next in the sequence.
             *             <p>
             *             The default value is the default value for the model that you are using. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topP(java.lang.Number topP) {
                this.topP = topP;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InferenceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InferenceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InferenceConfigurationProperty {
            private final java.lang.Number maximumLength;
            private final java.util.List<java.lang.String> stopSequences;
            private final java.lang.Number temperature;
            private final java.lang.Number topK;
            private final java.lang.Number topP;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maximumLength = software.amazon.jsii.Kernel.get(this, "maximumLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stopSequences = software.amazon.jsii.Kernel.get(this, "stopSequences", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.temperature = software.amazon.jsii.Kernel.get(this, "temperature", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.topK = software.amazon.jsii.Kernel.get(this, "topK", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.topP = software.amazon.jsii.Kernel.get(this, "topP", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maximumLength = builder.maximumLength;
                this.stopSequences = builder.stopSequences;
                this.temperature = builder.temperature;
                this.topK = builder.topK;
                this.topP = builder.topP;
            }

            @Override
            public final java.lang.Number getMaximumLength() {
                return this.maximumLength;
            }

            @Override
            public final java.util.List<java.lang.String> getStopSequences() {
                return this.stopSequences;
            }

            @Override
            public final java.lang.Number getTemperature() {
                return this.temperature;
            }

            @Override
            public final java.lang.Number getTopK() {
                return this.topK;
            }

            @Override
            public final java.lang.Number getTopP() {
                return this.topP;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaximumLength() != null) {
                    data.set("maximumLength", om.valueToTree(this.getMaximumLength()));
                }
                if (this.getStopSequences() != null) {
                    data.set("stopSequences", om.valueToTree(this.getStopSequences()));
                }
                if (this.getTemperature() != null) {
                    data.set("temperature", om.valueToTree(this.getTemperature()));
                }
                if (this.getTopK() != null) {
                    data.set("topK", om.valueToTree(this.getTopK()));
                }
                if (this.getTopP() != null) {
                    data.set("topP", om.valueToTree(this.getTopP()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnAgent.InferenceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InferenceConfigurationProperty.Jsii$Proxy that = (InferenceConfigurationProperty.Jsii$Proxy) o;

                if (this.maximumLength != null ? !this.maximumLength.equals(that.maximumLength) : that.maximumLength != null) return false;
                if (this.stopSequences != null ? !this.stopSequences.equals(that.stopSequences) : that.stopSequences != null) return false;
                if (this.temperature != null ? !this.temperature.equals(that.temperature) : that.temperature != null) return false;
                if (this.topK != null ? !this.topK.equals(that.topK) : that.topK != null) return false;
                return this.topP != null ? this.topP.equals(that.topP) : that.topP == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maximumLength != null ? this.maximumLength.hashCode() : 0;
                result = 31 * result + (this.stopSequences != null ? this.stopSequences.hashCode() : 0);
                result = 31 * result + (this.temperature != null ? this.temperature.hashCode() : 0);
                result = 31 * result + (this.topK != null ? this.topK.hashCode() : 0);
                result = 31 * result + (this.topP != null ? this.topP.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains details about a parameter in a function for an action group.
     * <p>
     * This data type is used in the following API operations:
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_RequestSyntax">CreateAgentActionGroup request</a></li>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_ResponseSyntax">CreateAgentActionGroup response</a></li>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_RequestSyntax">UpdateAgentActionGroup request</a></li>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_ResponseSyntax">UpdateAgentActionGroup response</a></li>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentActionGroup.html#API_agent_GetAgentActionGroup_ResponseSyntax">GetAgentActionGroup response</a></li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ParameterDetailProperty parameterDetailProperty = ParameterDetailProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .description("description")
     *         .required(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-parameterdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-parameterdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgent.ParameterDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(ParameterDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParameterDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The data type of the parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-parameterdetail.html#cfn-bedrock-agent-parameterdetail-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-parameterdetail.html#cfn-bedrock-agent-parameterdetail-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * A description of the parameter.
         * <p>
         * Helps the foundation model determine how to elicit the parameters from the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-parameterdetail.html#cfn-bedrock-agent-parameterdetail-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-parameterdetail.html#cfn-bedrock-agent-parameterdetail-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Whether the parameter is required for the agent to complete the function for action group invocation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-parameterdetail.html#cfn-bedrock-agent-parameterdetail-required">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-parameterdetail.html#cfn-bedrock-agent-parameterdetail-required</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequired() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParameterDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParameterDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParameterDetailProperty> {
            java.lang.String type;
            java.lang.String description;
            java.lang.Object required;

            /**
             * Sets the value of {@link ParameterDetailProperty#getType}
             * @param type The data type of the parameter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ParameterDetailProperty#getDescription}
             * @param description A description of the parameter.
             *                    Helps the foundation model determine how to elicit the parameters from the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link ParameterDetailProperty#getRequired}
             * @param required Whether the parameter is required for the agent to complete the function for action group invocation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder required(java.lang.Boolean required) {
                this.required = required;
                return this;
            }

            /**
             * Sets the value of {@link ParameterDetailProperty#getRequired}
             * @param required Whether the parameter is required for the agent to complete the function for action group invocation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder required(software.amazon.awscdk.IResolvable required) {
                this.required = required;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParameterDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParameterDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParameterDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParameterDetailProperty {
            private final java.lang.String type;
            private final java.lang.String description;
            private final java.lang.Object required;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.required = software.amazon.jsii.Kernel.get(this, "required", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.description = builder.description;
                this.required = builder.required;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getRequired() {
                return this.required;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getRequired() != null) {
                    data.set("required", om.valueToTree(this.getRequired()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnAgent.ParameterDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParameterDetailProperty.Jsii$Proxy that = (ParameterDetailProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                return this.required != null ? this.required.equals(that.required) : that.required == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.required != null ? this.required.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations to override a prompt template in one part of an agent sequence.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptConfigurationProperty promptConfigurationProperty = PromptConfigurationProperty.builder()
     *         .basePromptTemplate("basePromptTemplate")
     *         .inferenceConfiguration(InferenceConfigurationProperty.builder()
     *                 .maximumLength(123)
     *                 .stopSequences(List.of("stopSequences"))
     *                 .temperature(123)
     *                 .topK(123)
     *                 .topP(123)
     *                 .build())
     *         .parserMode("parserMode")
     *         .promptCreationMode("promptCreationMode")
     *         .promptState("promptState")
     *         .promptType("promptType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgent.PromptConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the prompt template with which to replace the default prompt template.
         * <p>
         * You can use placeholder variables in the base prompt template to customize the prompt. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html">Prompt template placeholder variables</a> . For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts-configure.html">Configure the prompt templates</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptconfiguration.html#cfn-bedrock-agent-promptconfiguration-baseprompttemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptconfiguration.html#cfn-bedrock-agent-promptconfiguration-baseprompttemplate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBasePromptTemplate() {
            return null;
        }

        /**
         * Contains inference parameters to use when the agent invokes a foundation model in the part of the agent sequence defined by the <code>promptType</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptconfiguration.html#cfn-bedrock-agent-promptconfiguration-inferenceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptconfiguration.html#cfn-bedrock-agent-promptconfiguration-inferenceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInferenceConfiguration() {
            return null;
        }

        /**
         * Specifies whether to override the default parser Lambda function when parsing the raw foundation model output in the part of the agent sequence defined by the <code>promptType</code> .
         * <p>
         * If you set the field as <code>OVERRIDEN</code> , the <code>overrideLambda</code> field in the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html">PromptOverrideConfiguration</a> must be specified with the ARN of a Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptconfiguration.html#cfn-bedrock-agent-promptconfiguration-parsermode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptconfiguration.html#cfn-bedrock-agent-promptconfiguration-parsermode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParserMode() {
            return null;
        }

        /**
         * Specifies whether to override the default prompt template for this <code>promptType</code> .
         * <p>
         * Set this value to <code>OVERRIDDEN</code> to use the prompt that you provide in the <code>basePromptTemplate</code> . If you leave it as <code>DEFAULT</code> , the agent uses a default prompt template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptconfiguration.html#cfn-bedrock-agent-promptconfiguration-promptcreationmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptconfiguration.html#cfn-bedrock-agent-promptconfiguration-promptcreationmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPromptCreationMode() {
            return null;
        }

        /**
         * Specifies whether to allow the agent to carry out the step specified in the <code>promptType</code> .
         * <p>
         * If you set this value to <code>DISABLED</code> , the agent skips that step. The default state for each <code>promptType</code> is as follows.
         * <p>
         * <ul>
         * <li><code>PRE_PROCESSING</code> – <code>ENABLED</code></li>
         * <li><code>ORCHESTRATION</code> – <code>ENABLED</code></li>
         * <li><code>KNOWLEDGE_BASE_RESPONSE_GENERATION</code> – <code>ENABLED</code></li>
         * <li><code>POST_PROCESSING</code> – <code>DISABLED</code></li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptconfiguration.html#cfn-bedrock-agent-promptconfiguration-promptstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptconfiguration.html#cfn-bedrock-agent-promptconfiguration-promptstate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPromptState() {
            return null;
        }

        /**
         * The step in the agent sequence that this prompt configuration applies to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptconfiguration.html#cfn-bedrock-agent-promptconfiguration-prompttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptconfiguration.html#cfn-bedrock-agent-promptconfiguration-prompttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPromptType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptConfigurationProperty> {
            java.lang.String basePromptTemplate;
            java.lang.Object inferenceConfiguration;
            java.lang.String parserMode;
            java.lang.String promptCreationMode;
            java.lang.String promptState;
            java.lang.String promptType;

            /**
             * Sets the value of {@link PromptConfigurationProperty#getBasePromptTemplate}
             * @param basePromptTemplate Defines the prompt template with which to replace the default prompt template.
             *                           You can use placeholder variables in the base prompt template to customize the prompt. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html">Prompt template placeholder variables</a> . For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts-configure.html">Configure the prompt templates</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basePromptTemplate(java.lang.String basePromptTemplate) {
                this.basePromptTemplate = basePromptTemplate;
                return this;
            }

            /**
             * Sets the value of {@link PromptConfigurationProperty#getInferenceConfiguration}
             * @param inferenceConfiguration Contains inference parameters to use when the agent invokes a foundation model in the part of the agent sequence defined by the <code>promptType</code> .
             *                               For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceConfiguration(software.amazon.awscdk.IResolvable inferenceConfiguration) {
                this.inferenceConfiguration = inferenceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptConfigurationProperty#getInferenceConfiguration}
             * @param inferenceConfiguration Contains inference parameters to use when the agent invokes a foundation model in the part of the agent sequence defined by the <code>promptType</code> .
             *                               For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceConfiguration(software.amazon.awscdk.services.bedrock.CfnAgent.InferenceConfigurationProperty inferenceConfiguration) {
                this.inferenceConfiguration = inferenceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptConfigurationProperty#getParserMode}
             * @param parserMode Specifies whether to override the default parser Lambda function when parsing the raw foundation model output in the part of the agent sequence defined by the <code>promptType</code> .
             *                   If you set the field as <code>OVERRIDEN</code> , the <code>overrideLambda</code> field in the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html">PromptOverrideConfiguration</a> must be specified with the ARN of a Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parserMode(java.lang.String parserMode) {
                this.parserMode = parserMode;
                return this;
            }

            /**
             * Sets the value of {@link PromptConfigurationProperty#getPromptCreationMode}
             * @param promptCreationMode Specifies whether to override the default prompt template for this <code>promptType</code> .
             *                           Set this value to <code>OVERRIDDEN</code> to use the prompt that you provide in the <code>basePromptTemplate</code> . If you leave it as <code>DEFAULT</code> , the agent uses a default prompt template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptCreationMode(java.lang.String promptCreationMode) {
                this.promptCreationMode = promptCreationMode;
                return this;
            }

            /**
             * Sets the value of {@link PromptConfigurationProperty#getPromptState}
             * @param promptState Specifies whether to allow the agent to carry out the step specified in the <code>promptType</code> .
             *                    If you set this value to <code>DISABLED</code> , the agent skips that step. The default state for each <code>promptType</code> is as follows.
             *                    <p>
             *                    <ul>
             *                    <li><code>PRE_PROCESSING</code> – <code>ENABLED</code></li>
             *                    <li><code>ORCHESTRATION</code> – <code>ENABLED</code></li>
             *                    <li><code>KNOWLEDGE_BASE_RESPONSE_GENERATION</code> – <code>ENABLED</code></li>
             *                    <li><code>POST_PROCESSING</code> – <code>DISABLED</code></li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptState(java.lang.String promptState) {
                this.promptState = promptState;
                return this;
            }

            /**
             * Sets the value of {@link PromptConfigurationProperty#getPromptType}
             * @param promptType The step in the agent sequence that this prompt configuration applies to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptType(java.lang.String promptType) {
                this.promptType = promptType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptConfigurationProperty {
            private final java.lang.String basePromptTemplate;
            private final java.lang.Object inferenceConfiguration;
            private final java.lang.String parserMode;
            private final java.lang.String promptCreationMode;
            private final java.lang.String promptState;
            private final java.lang.String promptType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.basePromptTemplate = software.amazon.jsii.Kernel.get(this, "basePromptTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inferenceConfiguration = software.amazon.jsii.Kernel.get(this, "inferenceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parserMode = software.amazon.jsii.Kernel.get(this, "parserMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.promptCreationMode = software.amazon.jsii.Kernel.get(this, "promptCreationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.promptState = software.amazon.jsii.Kernel.get(this, "promptState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.promptType = software.amazon.jsii.Kernel.get(this, "promptType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.basePromptTemplate = builder.basePromptTemplate;
                this.inferenceConfiguration = builder.inferenceConfiguration;
                this.parserMode = builder.parserMode;
                this.promptCreationMode = builder.promptCreationMode;
                this.promptState = builder.promptState;
                this.promptType = builder.promptType;
            }

            @Override
            public final java.lang.String getBasePromptTemplate() {
                return this.basePromptTemplate;
            }

            @Override
            public final java.lang.Object getInferenceConfiguration() {
                return this.inferenceConfiguration;
            }

            @Override
            public final java.lang.String getParserMode() {
                return this.parserMode;
            }

            @Override
            public final java.lang.String getPromptCreationMode() {
                return this.promptCreationMode;
            }

            @Override
            public final java.lang.String getPromptState() {
                return this.promptState;
            }

            @Override
            public final java.lang.String getPromptType() {
                return this.promptType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBasePromptTemplate() != null) {
                    data.set("basePromptTemplate", om.valueToTree(this.getBasePromptTemplate()));
                }
                if (this.getInferenceConfiguration() != null) {
                    data.set("inferenceConfiguration", om.valueToTree(this.getInferenceConfiguration()));
                }
                if (this.getParserMode() != null) {
                    data.set("parserMode", om.valueToTree(this.getParserMode()));
                }
                if (this.getPromptCreationMode() != null) {
                    data.set("promptCreationMode", om.valueToTree(this.getPromptCreationMode()));
                }
                if (this.getPromptState() != null) {
                    data.set("promptState", om.valueToTree(this.getPromptState()));
                }
                if (this.getPromptType() != null) {
                    data.set("promptType", om.valueToTree(this.getPromptType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnAgent.PromptConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptConfigurationProperty.Jsii$Proxy that = (PromptConfigurationProperty.Jsii$Proxy) o;

                if (this.basePromptTemplate != null ? !this.basePromptTemplate.equals(that.basePromptTemplate) : that.basePromptTemplate != null) return false;
                if (this.inferenceConfiguration != null ? !this.inferenceConfiguration.equals(that.inferenceConfiguration) : that.inferenceConfiguration != null) return false;
                if (this.parserMode != null ? !this.parserMode.equals(that.parserMode) : that.parserMode != null) return false;
                if (this.promptCreationMode != null ? !this.promptCreationMode.equals(that.promptCreationMode) : that.promptCreationMode != null) return false;
                if (this.promptState != null ? !this.promptState.equals(that.promptState) : that.promptState != null) return false;
                return this.promptType != null ? this.promptType.equals(that.promptType) : that.promptType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.basePromptTemplate != null ? this.basePromptTemplate.hashCode() : 0;
                result = 31 * result + (this.inferenceConfiguration != null ? this.inferenceConfiguration.hashCode() : 0);
                result = 31 * result + (this.parserMode != null ? this.parserMode.hashCode() : 0);
                result = 31 * result + (this.promptCreationMode != null ? this.promptCreationMode.hashCode() : 0);
                result = 31 * result + (this.promptState != null ? this.promptState.hashCode() : 0);
                result = 31 * result + (this.promptType != null ? this.promptType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations to override prompts in different parts of an agent sequence.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptOverrideConfigurationProperty promptOverrideConfigurationProperty = PromptOverrideConfigurationProperty.builder()
     *         .promptConfigurations(List.of(PromptConfigurationProperty.builder()
     *                 .basePromptTemplate("basePromptTemplate")
     *                 .inferenceConfiguration(InferenceConfigurationProperty.builder()
     *                         .maximumLength(123)
     *                         .stopSequences(List.of("stopSequences"))
     *                         .temperature(123)
     *                         .topK(123)
     *                         .topP(123)
     *                         .build())
     *                 .parserMode("parserMode")
     *                 .promptCreationMode("promptCreationMode")
     *                 .promptState("promptState")
     *                 .promptType("promptType")
     *                 .build()))
     *         // the properties below are optional
     *         .overrideLambda("overrideLambda")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptoverrideconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptoverrideconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgent.PromptOverrideConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptOverrideConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptOverrideConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains configurations to override a prompt template in one part of an agent sequence.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptoverrideconfiguration.html#cfn-bedrock-agent-promptoverrideconfiguration-promptconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptoverrideconfiguration.html#cfn-bedrock-agent-promptoverrideconfiguration-promptconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPromptConfigurations();

        /**
         * The ARN of the Lambda function to use when parsing the raw foundation model output in parts of the agent sequence.
         * <p>
         * If you specify this field, at least one of the <code>promptConfigurations</code> must contain a <code>parserMode</code> value that is set to <code>OVERRIDDEN</code> . For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/lambda-parser.html">Parser Lambda function in Agents for Amazon Bedrock</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptoverrideconfiguration.html#cfn-bedrock-agent-promptoverrideconfiguration-overridelambda">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-promptoverrideconfiguration.html#cfn-bedrock-agent-promptoverrideconfiguration-overridelambda</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOverrideLambda() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptOverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptOverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptOverrideConfigurationProperty> {
            java.lang.Object promptConfigurations;
            java.lang.String overrideLambda;

            /**
             * Sets the value of {@link PromptOverrideConfigurationProperty#getPromptConfigurations}
             * @param promptConfigurations Contains configurations to override a prompt template in one part of an agent sequence. This parameter is required.
             *                             For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptConfigurations(software.amazon.awscdk.IResolvable promptConfigurations) {
                this.promptConfigurations = promptConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link PromptOverrideConfigurationProperty#getPromptConfigurations}
             * @param promptConfigurations Contains configurations to override a prompt template in one part of an agent sequence. This parameter is required.
             *                             For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptConfigurations(java.util.List<? extends java.lang.Object> promptConfigurations) {
                this.promptConfigurations = promptConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link PromptOverrideConfigurationProperty#getOverrideLambda}
             * @param overrideLambda The ARN of the Lambda function to use when parsing the raw foundation model output in parts of the agent sequence.
             *                       If you specify this field, at least one of the <code>promptConfigurations</code> must contain a <code>parserMode</code> value that is set to <code>OVERRIDDEN</code> . For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/lambda-parser.html">Parser Lambda function in Agents for Amazon Bedrock</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideLambda(java.lang.String overrideLambda) {
                this.overrideLambda = overrideLambda;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptOverrideConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptOverrideConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptOverrideConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptOverrideConfigurationProperty {
            private final java.lang.Object promptConfigurations;
            private final java.lang.String overrideLambda;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.promptConfigurations = software.amazon.jsii.Kernel.get(this, "promptConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.overrideLambda = software.amazon.jsii.Kernel.get(this, "overrideLambda", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.promptConfigurations = java.util.Objects.requireNonNull(builder.promptConfigurations, "promptConfigurations is required");
                this.overrideLambda = builder.overrideLambda;
            }

            @Override
            public final java.lang.Object getPromptConfigurations() {
                return this.promptConfigurations;
            }

            @Override
            public final java.lang.String getOverrideLambda() {
                return this.overrideLambda;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("promptConfigurations", om.valueToTree(this.getPromptConfigurations()));
                if (this.getOverrideLambda() != null) {
                    data.set("overrideLambda", om.valueToTree(this.getOverrideLambda()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnAgent.PromptOverrideConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptOverrideConfigurationProperty.Jsii$Proxy that = (PromptOverrideConfigurationProperty.Jsii$Proxy) o;

                if (!promptConfigurations.equals(that.promptConfigurations)) return false;
                return this.overrideLambda != null ? this.overrideLambda.equals(that.overrideLambda) : that.overrideLambda == null;
            }

            @Override
            public final int hashCode() {
                int result = this.promptConfigurations.hashCode();
                result = 31 * result + (this.overrideLambda != null ? this.overrideLambda.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The identifier information for an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * S3IdentifierProperty s3IdentifierProperty = S3IdentifierProperty.builder()
     *         .s3BucketName("s3BucketName")
     *         .s3ObjectKey("s3ObjectKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-s3identifier.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-s3identifier.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgent.S3IdentifierProperty")
    @software.amazon.jsii.Jsii.Proxy(S3IdentifierProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3IdentifierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-s3identifier.html#cfn-bedrock-agent-s3identifier-s3bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-s3identifier.html#cfn-bedrock-agent-s3identifier-s3bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketName() {
            return null;
        }

        /**
         * The S3 object key for the S3 resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-s3identifier.html#cfn-bedrock-agent-s3identifier-s3objectkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-agent-s3identifier.html#cfn-bedrock-agent-s3identifier-s3objectkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3ObjectKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3IdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3IdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3IdentifierProperty> {
            java.lang.String s3BucketName;
            java.lang.String s3ObjectKey;

            /**
             * Sets the value of {@link S3IdentifierProperty#getS3BucketName}
             * @param s3BucketName The name of the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3IdentifierProperty#getS3ObjectKey}
             * @param s3ObjectKey The S3 object key for the S3 resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ObjectKey(java.lang.String s3ObjectKey) {
                this.s3ObjectKey = s3ObjectKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3IdentifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3IdentifierProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3IdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3IdentifierProperty {
            private final java.lang.String s3BucketName;
            private final java.lang.String s3ObjectKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3ObjectKey = software.amazon.jsii.Kernel.get(this, "s3ObjectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3BucketName = builder.s3BucketName;
                this.s3ObjectKey = builder.s3ObjectKey;
            }

            @Override
            public final java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            public final java.lang.String getS3ObjectKey() {
                return this.s3ObjectKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3BucketName() != null) {
                    data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
                }
                if (this.getS3ObjectKey() != null) {
                    data.set("s3ObjectKey", om.valueToTree(this.getS3ObjectKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnAgent.S3IdentifierProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3IdentifierProperty.Jsii$Proxy that = (S3IdentifierProperty.Jsii$Proxy) o;

                if (this.s3BucketName != null ? !this.s3BucketName.equals(that.s3BucketName) : that.s3BucketName != null) return false;
                return this.s3ObjectKey != null ? this.s3ObjectKey.equals(that.s3ObjectKey) : that.s3ObjectKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3BucketName != null ? this.s3BucketName.hashCode() : 0;
                result = 31 * result + (this.s3ObjectKey != null ? this.s3ObjectKey.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.bedrock.CfnAgent}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.bedrock.CfnAgent> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.bedrock.CfnAgentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.bedrock.CfnAgentProps.Builder();
        }

        /**
         * The name of the agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-agentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-agentname</a>
         * @param agentName The name of the agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentName(final java.lang.String agentName) {
            this.props.agentName(agentName);
            return this;
        }

        /**
         * The action groups that belong to an agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-actiongroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-actiongroups</a>
         * @param actionGroups The action groups that belong to an agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionGroups(final software.amazon.awscdk.IResolvable actionGroups) {
            this.props.actionGroups(actionGroups);
            return this;
        }
        /**
         * The action groups that belong to an agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-actiongroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-actiongroups</a>
         * @param actionGroups The action groups that belong to an agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionGroups(final java.util.List<? extends java.lang.Object> actionGroups) {
            this.props.actionGroups(actionGroups);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-agentresourcerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-agentresourcerolearn</a>
         * @param agentResourceRoleArn The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentResourceRoleArn(final java.lang.String agentResourceRoleArn) {
            this.props.agentResourceRoleArn(agentResourceRoleArn);
            return this;
        }

        /**
         * Specifies whether to automatically update the <code>DRAFT</code> version of the agent after making changes to the agent.
         * <p>
         * The <code>DRAFT</code> version can be continually iterated upon during internal development. By default, this value is <code>false</code> .
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-autoprepare">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-autoprepare</a>
         * @param autoPrepare Specifies whether to automatically update the <code>DRAFT</code> version of the agent after making changes to the agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoPrepare(final java.lang.Boolean autoPrepare) {
            this.props.autoPrepare(autoPrepare);
            return this;
        }
        /**
         * Specifies whether to automatically update the <code>DRAFT</code> version of the agent after making changes to the agent.
         * <p>
         * The <code>DRAFT</code> version can be continually iterated upon during internal development. By default, this value is <code>false</code> .
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-autoprepare">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-autoprepare</a>
         * @param autoPrepare Specifies whether to automatically update the <code>DRAFT</code> version of the agent after making changes to the agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoPrepare(final software.amazon.awscdk.IResolvable autoPrepare) {
            this.props.autoPrepare(autoPrepare);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the AWS KMS key that encrypts the agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-customerencryptionkeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-customerencryptionkeyarn</a>
         * @param customerEncryptionKeyArn The Amazon Resource Name (ARN) of the AWS KMS key that encrypts the agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerEncryptionKeyArn(final java.lang.String customerEncryptionKeyArn) {
            this.props.customerEncryptionKeyArn(customerEncryptionKeyArn);
            return this;
        }

        /**
         * The description of the agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-description</a>
         * @param description The description of the agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The foundation model used for orchestration by the agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-foundationmodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-foundationmodel</a>
         * @param foundationModel The foundation model used for orchestration by the agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder foundationModel(final java.lang.String foundationModel) {
            this.props.foundationModel(foundationModel);
            return this;
        }

        /**
         * Details about the guardrail associated with the agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-guardrailconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-guardrailconfiguration</a>
         * @param guardrailConfiguration Details about the guardrail associated with the agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder guardrailConfiguration(final software.amazon.awscdk.IResolvable guardrailConfiguration) {
            this.props.guardrailConfiguration(guardrailConfiguration);
            return this;
        }
        /**
         * Details about the guardrail associated with the agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-guardrailconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-guardrailconfiguration</a>
         * @param guardrailConfiguration Details about the guardrail associated with the agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder guardrailConfiguration(final software.amazon.awscdk.services.bedrock.CfnAgent.GuardrailConfigurationProperty guardrailConfiguration) {
            this.props.guardrailConfiguration(guardrailConfiguration);
            return this;
        }

        /**
         * The number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent.
         * <p>
         * A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-idlesessionttlinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-idlesessionttlinseconds</a>
         * @param idleSessionTtlInSeconds The number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleSessionTtlInSeconds(final java.lang.Number idleSessionTtlInSeconds) {
            this.props.idleSessionTtlInSeconds(idleSessionTtlInSeconds);
            return this;
        }

        /**
         * Instructions that tell the agent what it should do and how it should interact with users.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-instruction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-instruction</a>
         * @param instruction Instructions that tell the agent what it should do and how it should interact with users. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instruction(final java.lang.String instruction) {
            this.props.instruction(instruction);
            return this;
        }

        /**
         * The knowledge bases associated with the agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-knowledgebases">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-knowledgebases</a>
         * @param knowledgeBases The knowledge bases associated with the agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBases(final software.amazon.awscdk.IResolvable knowledgeBases) {
            this.props.knowledgeBases(knowledgeBases);
            return this;
        }
        /**
         * The knowledge bases associated with the agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-knowledgebases">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-knowledgebases</a>
         * @param knowledgeBases The knowledge bases associated with the agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBases(final java.util.List<? extends java.lang.Object> knowledgeBases) {
            this.props.knowledgeBases(knowledgeBases);
            return this;
        }

        /**
         * Contains configurations to override prompt templates in different parts of an agent sequence.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-promptoverrideconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-promptoverrideconfiguration</a>
         * @param promptOverrideConfiguration Contains configurations to override prompt templates in different parts of an agent sequence. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder promptOverrideConfiguration(final software.amazon.awscdk.IResolvable promptOverrideConfiguration) {
            this.props.promptOverrideConfiguration(promptOverrideConfiguration);
            return this;
        }
        /**
         * Contains configurations to override prompt templates in different parts of an agent sequence.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-promptoverrideconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-promptoverrideconfiguration</a>
         * @param promptOverrideConfiguration Contains configurations to override prompt templates in different parts of an agent sequence. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder promptOverrideConfiguration(final software.amazon.awscdk.services.bedrock.CfnAgent.PromptOverrideConfigurationProperty promptOverrideConfiguration) {
            this.props.promptOverrideConfiguration(promptOverrideConfiguration);
            return this;
        }

        /**
         * Specifies whether to delete the resource even if it's in use.
         * <p>
         * By default, this value is <code>false</code> .
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-skipresourceinusecheckondelete">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-skipresourceinusecheckondelete</a>
         * @param skipResourceInUseCheckOnDelete Specifies whether to delete the resource even if it's in use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipResourceInUseCheckOnDelete(final java.lang.Boolean skipResourceInUseCheckOnDelete) {
            this.props.skipResourceInUseCheckOnDelete(skipResourceInUseCheckOnDelete);
            return this;
        }
        /**
         * Specifies whether to delete the resource even if it's in use.
         * <p>
         * By default, this value is <code>false</code> .
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-skipresourceinusecheckondelete">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-skipresourceinusecheckondelete</a>
         * @param skipResourceInUseCheckOnDelete Specifies whether to delete the resource even if it's in use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipResourceInUseCheckOnDelete(final software.amazon.awscdk.IResolvable skipResourceInUseCheckOnDelete) {
            this.props.skipResourceInUseCheckOnDelete(skipResourceInUseCheckOnDelete);
            return this;
        }

        /**
         * Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
         * <p>
         * <ul>
         * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
         * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-tags</a>
         * @param tags Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
         * <p>
         * <ul>
         * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
         * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-testaliastags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-testaliastags</a>
         * @param testAliasTags Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testAliasTags(final software.amazon.awscdk.IResolvable testAliasTags) {
            this.props.testAliasTags(testAliasTags);
            return this;
        }
        /**
         * Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
         * <p>
         * <ul>
         * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
         * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-testaliastags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-testaliastags</a>
         * @param testAliasTags Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testAliasTags(final java.util.Map<java.lang.String, java.lang.String> testAliasTags) {
            this.props.testAliasTags(testAliasTags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.bedrock.CfnAgent}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.bedrock.CfnAgent build() {
            return new software.amazon.awscdk.services.bedrock.CfnAgent(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
