package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for defining a <code>CfnContinuousDeploymentPolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnContinuousDeploymentPolicyProps cfnContinuousDeploymentPolicyProps = CfnContinuousDeploymentPolicyProps.builder()
 *         .continuousDeploymentPolicyConfig(ContinuousDeploymentPolicyConfigProperty.builder()
 *                 .enabled(false)
 *                 .stagingDistributionDnsNames(List.of("stagingDistributionDnsNames"))
 *                 // the properties below are optional
 *                 .singleHeaderPolicyConfig(SingleHeaderPolicyConfigProperty.builder()
 *                         .header("header")
 *                         .value("value")
 *                         .build())
 *                 .singleWeightPolicyConfig(SingleWeightPolicyConfigProperty.builder()
 *                         .weight(123)
 *                         // the properties below are optional
 *                         .sessionStickinessConfig(SessionStickinessConfigProperty.builder()
 *                                 .idleTtl(123)
 *                                 .maximumTtl(123)
 *                                 .build())
 *                         .build())
 *                 .trafficConfig(TrafficConfigProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .singleHeaderConfig(SingleHeaderConfigProperty.builder()
 *                                 .header("header")
 *                                 .value("value")
 *                                 .build())
 *                         .singleWeightConfig(SingleWeightConfigProperty.builder()
 *                                 .weight(123)
 *                                 // the properties below are optional
 *                                 .sessionStickinessConfig(SessionStickinessConfigProperty.builder()
 *                                         .idleTtl(123)
 *                                         .maximumTtl(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .type("type")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-continuousdeploymentpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-continuousdeploymentpolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:30.364Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnContinuousDeploymentPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnContinuousDeploymentPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Contains the configuration for a continuous deployment policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-continuousdeploymentpolicy.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-continuousdeploymentpolicy.html#cfn-cloudfront-continuousdeploymentpolicy-continuousdeploymentpolicyconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getContinuousDeploymentPolicyConfig();

    /**
     * @return a {@link Builder} of {@link CfnContinuousDeploymentPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnContinuousDeploymentPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnContinuousDeploymentPolicyProps> {
        java.lang.Object continuousDeploymentPolicyConfig;

        /**
         * Sets the value of {@link CfnContinuousDeploymentPolicyProps#getContinuousDeploymentPolicyConfig}
         * @param continuousDeploymentPolicyConfig Contains the configuration for a continuous deployment policy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder continuousDeploymentPolicyConfig(software.amazon.awscdk.IResolvable continuousDeploymentPolicyConfig) {
            this.continuousDeploymentPolicyConfig = continuousDeploymentPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnContinuousDeploymentPolicyProps#getContinuousDeploymentPolicyConfig}
         * @param continuousDeploymentPolicyConfig Contains the configuration for a continuous deployment policy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder continuousDeploymentPolicyConfig(software.amazon.awscdk.services.cloudfront.CfnContinuousDeploymentPolicy.ContinuousDeploymentPolicyConfigProperty continuousDeploymentPolicyConfig) {
            this.continuousDeploymentPolicyConfig = continuousDeploymentPolicyConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnContinuousDeploymentPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnContinuousDeploymentPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnContinuousDeploymentPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnContinuousDeploymentPolicyProps {
        private final java.lang.Object continuousDeploymentPolicyConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.continuousDeploymentPolicyConfig = software.amazon.jsii.Kernel.get(this, "continuousDeploymentPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.continuousDeploymentPolicyConfig = java.util.Objects.requireNonNull(builder.continuousDeploymentPolicyConfig, "continuousDeploymentPolicyConfig is required");
        }

        @Override
        public final java.lang.Object getContinuousDeploymentPolicyConfig() {
            return this.continuousDeploymentPolicyConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("continuousDeploymentPolicyConfig", om.valueToTree(this.getContinuousDeploymentPolicyConfig()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnContinuousDeploymentPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnContinuousDeploymentPolicyProps.Jsii$Proxy that = (CfnContinuousDeploymentPolicyProps.Jsii$Proxy) o;

            return this.continuousDeploymentPolicyConfig.equals(that.continuousDeploymentPolicyConfig);
        }

        @Override
        public final int hashCode() {
            int result = this.continuousDeploymentPolicyConfig.hashCode();
            return result;
        }
    }
}
