package software.amazon.awscdk.services.codebuild;

/**
 * Construction properties of a CodeBuild {@link Fleet}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Fleet fleet = Fleet.Builder.create(this, "Fleet")
 *         .computeType(FleetComputeType.MEDIUM)
 *         .environmentType(EnvironmentType.LINUX_CONTAINER)
 *         .baseCapacity(1)
 *         .build();
 * Project.Builder.create(this, "Project")
 *         .environment(BuildEnvironment.builder()
 *                 .fleet(fleet)
 *                 .buildImage(LinuxBuildImage.STANDARD_7_0)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:30.813Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.FleetProps")
@software.amazon.jsii.Jsii.Proxy(FleetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FleetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of machines allocated to the compute ﬂeet. Deﬁnes the number of builds that can run in parallel.
     * <p>
     * Minimum value of 1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getBaseCapacity();

    /**
     * The instance type of the compute fleet.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_codebuild.ComputeType.html">https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_codebuild.ComputeType.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FleetComputeType getComputeType();

    /**
     * The build environment (operating system/architecture/accelerator) type made available to projects using this fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.EnvironmentType getEnvironmentType();

    /**
     * The name of the Fleet.
     * <p>
     * Default: - CloudFormation generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFleetName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FleetProps> {
        java.lang.Number baseCapacity;
        software.amazon.awscdk.services.codebuild.FleetComputeType computeType;
        software.amazon.awscdk.services.codebuild.EnvironmentType environmentType;
        java.lang.String fleetName;

        /**
         * Sets the value of {@link FleetProps#getBaseCapacity}
         * @param baseCapacity The number of machines allocated to the compute ﬂeet. Deﬁnes the number of builds that can run in parallel. This parameter is required.
         *                     Minimum value of 1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseCapacity(java.lang.Number baseCapacity) {
            this.baseCapacity = baseCapacity;
            return this;
        }

        /**
         * Sets the value of {@link FleetProps#getComputeType}
         * @param computeType The instance type of the compute fleet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeType(software.amazon.awscdk.services.codebuild.FleetComputeType computeType) {
            this.computeType = computeType;
            return this;
        }

        /**
         * Sets the value of {@link FleetProps#getEnvironmentType}
         * @param environmentType The build environment (operating system/architecture/accelerator) type made available to projects using this fleet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentType(software.amazon.awscdk.services.codebuild.EnvironmentType environmentType) {
            this.environmentType = environmentType;
            return this;
        }

        /**
         * Sets the value of {@link FleetProps#getFleetName}
         * @param fleetName The name of the Fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetName(java.lang.String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FleetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FleetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetProps {
        private final java.lang.Number baseCapacity;
        private final software.amazon.awscdk.services.codebuild.FleetComputeType computeType;
        private final software.amazon.awscdk.services.codebuild.EnvironmentType environmentType;
        private final java.lang.String fleetName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.baseCapacity = software.amazon.jsii.Kernel.get(this, "baseCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.computeType = software.amazon.jsii.Kernel.get(this, "computeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FleetComputeType.class));
            this.environmentType = software.amazon.jsii.Kernel.get(this, "environmentType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.EnvironmentType.class));
            this.fleetName = software.amazon.jsii.Kernel.get(this, "fleetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.baseCapacity = java.util.Objects.requireNonNull(builder.baseCapacity, "baseCapacity is required");
            this.computeType = java.util.Objects.requireNonNull(builder.computeType, "computeType is required");
            this.environmentType = java.util.Objects.requireNonNull(builder.environmentType, "environmentType is required");
            this.fleetName = builder.fleetName;
        }

        @Override
        public final java.lang.Number getBaseCapacity() {
            return this.baseCapacity;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.FleetComputeType getComputeType() {
            return this.computeType;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.EnvironmentType getEnvironmentType() {
            return this.environmentType;
        }

        @Override
        public final java.lang.String getFleetName() {
            return this.fleetName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("baseCapacity", om.valueToTree(this.getBaseCapacity()));
            data.set("computeType", om.valueToTree(this.getComputeType()));
            data.set("environmentType", om.valueToTree(this.getEnvironmentType()));
            if (this.getFleetName() != null) {
                data.set("fleetName", om.valueToTree(this.getFleetName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.FleetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FleetProps.Jsii$Proxy that = (FleetProps.Jsii$Proxy) o;

            if (!baseCapacity.equals(that.baseCapacity)) return false;
            if (!computeType.equals(that.computeType)) return false;
            if (!environmentType.equals(that.environmentType)) return false;
            return this.fleetName != null ? this.fleetName.equals(that.fleetName) : that.fleetName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.baseCapacity.hashCode();
            result = 31 * result + (this.computeType.hashCode());
            result = 31 * result + (this.environmentType.hashCode());
            result = 31 * result + (this.fleetName != null ? this.fleetName.hashCode() : 0);
            return result;
        }
    }
}
