package software.amazon.awscdk.services.codebuild;

/**
 * Construction properties for UntrustedCodeBoundaryPolicy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codebuild.*;
 * import software.amazon.awscdk.services.iam.*;
 * PolicyStatement policyStatement;
 * UntrustedCodeBoundaryPolicyProps untrustedCodeBoundaryPolicyProps = UntrustedCodeBoundaryPolicyProps.builder()
 *         .additionalStatements(List.of(policyStatement))
 *         .managedPolicyName("managedPolicyName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:30.857Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.UntrustedCodeBoundaryPolicyProps")
@software.amazon.jsii.Jsii.Proxy(UntrustedCodeBoundaryPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UntrustedCodeBoundaryPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Additional statements to add to the default set of statements.
     * <p>
     * Default: - No additional statements
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getAdditionalStatements() {
        return null;
    }

    /**
     * The name of the managed policy.
     * <p>
     * Default: - A name is automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getManagedPolicyName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UntrustedCodeBoundaryPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UntrustedCodeBoundaryPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UntrustedCodeBoundaryPolicyProps> {
        java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> additionalStatements;
        java.lang.String managedPolicyName;

        /**
         * Sets the value of {@link UntrustedCodeBoundaryPolicyProps#getAdditionalStatements}
         * @param additionalStatements Additional statements to add to the default set of statements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder additionalStatements(java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> additionalStatements) {
            this.additionalStatements = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)additionalStatements;
            return this;
        }

        /**
         * Sets the value of {@link UntrustedCodeBoundaryPolicyProps#getManagedPolicyName}
         * @param managedPolicyName The name of the managed policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedPolicyName(java.lang.String managedPolicyName) {
            this.managedPolicyName = managedPolicyName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UntrustedCodeBoundaryPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UntrustedCodeBoundaryPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UntrustedCodeBoundaryPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UntrustedCodeBoundaryPolicyProps {
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> additionalStatements;
        private final java.lang.String managedPolicyName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.additionalStatements = software.amazon.jsii.Kernel.get(this, "additionalStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class)));
            this.managedPolicyName = software.amazon.jsii.Kernel.get(this, "managedPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.additionalStatements = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)builder.additionalStatements;
            this.managedPolicyName = builder.managedPolicyName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getAdditionalStatements() {
            return this.additionalStatements;
        }

        @Override
        public final java.lang.String getManagedPolicyName() {
            return this.managedPolicyName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdditionalStatements() != null) {
                data.set("additionalStatements", om.valueToTree(this.getAdditionalStatements()));
            }
            if (this.getManagedPolicyName() != null) {
                data.set("managedPolicyName", om.valueToTree(this.getManagedPolicyName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.UntrustedCodeBoundaryPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UntrustedCodeBoundaryPolicyProps.Jsii$Proxy that = (UntrustedCodeBoundaryPolicyProps.Jsii$Proxy) o;

            if (this.additionalStatements != null ? !this.additionalStatements.equals(that.additionalStatements) : that.additionalStatements != null) return false;
            return this.managedPolicyName != null ? this.managedPolicyName.equals(that.managedPolicyName) : that.managedPolicyName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.additionalStatements != null ? this.additionalStatements.hashCode() : 0;
            result = 31 * result + (this.managedPolicyName != null ? this.managedPolicyName.hashCode() : 0);
            return result;
        }
    }
}
