package software.amazon.awscdk.services.codedeploy;

/**
 * A custom Deployment Configuration for a Lambda Deployment Group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * LambdaApplication application;
 * Alias alias;
 * LambdaDeploymentConfig config = LambdaDeploymentConfig.Builder.create(this, "CustomConfig")
 *         .trafficRouting(TimeBasedCanaryTrafficRouting.Builder.create()
 *                 .interval(Duration.minutes(15))
 *                 .percentage(5)
 *                 .build())
 *         .build();
 * LambdaDeploymentGroup deploymentGroup = LambdaDeploymentGroup.Builder.create(this, "BlueGreenDeployment")
 *         .application(application)
 *         .alias(alias)
 *         .deploymentConfig(config)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:30.952Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.LambdaDeploymentConfig")
public class LambdaDeploymentConfig extends software.amazon.awscdk.services.codedeploy.BaseDeploymentConfig implements software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig {

    protected LambdaDeploymentConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaDeploymentConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ALL_AT_ONCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfig.class, "ALL_AT_ONCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig.class));
        CANARY_10_PERCENT_10_MINUTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfig.class, "CANARY_10PERCENT_10MINUTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig.class));
        CANARY_10_PERCENT_15_MINUTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfig.class, "CANARY_10PERCENT_15MINUTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig.class));
        CANARY_10_PERCENT_30_MINUTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfig.class, "CANARY_10PERCENT_30MINUTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig.class));
        CANARY_10_PERCENT_5_MINUTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfig.class, "CANARY_10PERCENT_5MINUTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig.class));
        LINEAR_10_PERCENT_EVERY_10_MINUTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfig.class, "LINEAR_10PERCENT_EVERY_10MINUTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig.class));
        LINEAR_10_PERCENT_EVERY_1_MINUTE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfig.class, "LINEAR_10PERCENT_EVERY_1MINUTE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig.class));
        LINEAR_10_PERCENT_EVERY_2_MINUTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfig.class, "LINEAR_10PERCENT_EVERY_2MINUTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig.class));
        LINEAR_10_PERCENT_EVERY_3_MINUTES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfig.class, "LINEAR_10PERCENT_EVERY_3MINUTES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LambdaDeploymentConfig(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LambdaDeploymentConfig(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import a Deployment Configuration for a Lambda Deployment Group defined outside the CDK.
     * <p>
     * @return a Construct representing a reference to an existing Lambda Deployment Configuration
     * @param scope the parent Construct for this new Construct. This parameter is required.
     * @param id the logical ID of this new Construct. This parameter is required.
     * @param lambdaDeploymentConfigName the name of the Lambda Deployment Configuration to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig fromLambdaDeploymentConfigName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String lambdaDeploymentConfigName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfig.class, "fromLambdaDeploymentConfigName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(lambdaDeploymentConfigName, "lambdaDeploymentConfigName is required") });
    }

    /**
     * (deprecated) Import a Deployment Configuration for a Lambda Deployment Group defined outside the CDK.
     * <p>
     * @return a Construct representing a reference to an existing custom Deployment Configuration
     * @deprecated use <code>fromLambdaDeploymentConfigName</code>
     * @param _scope the parent Construct for this new Construct. This parameter is required.
     * @param _id the logical ID of this new Construct. This parameter is required.
     * @param props the properties of the referenced custom Deployment Configuration. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig doImport(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull java.lang.String _id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfigImportProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfig.class, "import", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_id, "_id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * CodeDeploy predefined deployment configuration that shifts all traffic to the updated Lambda function at once.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig ALL_AT_ONCE;

    /**
     * CodeDeploy predefined deployment configuration that shifts 10 percent of traffic in the first increment.
     * <p>
     * The remaining 90 percent is deployed 10 minutes later.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig CANARY_10_PERCENT_10_MINUTES;

    /**
     * CodeDeploy predefined deployment configuration that shifts 10 percent of traffic in the first increment.
     * <p>
     * The remaining 90 percent is deployed 15 minutes later.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig CANARY_10_PERCENT_15_MINUTES;

    /**
     * CodeDeploy predefined deployment configuration that shifts 10 percent of traffic in the first increment.
     * <p>
     * The remaining 90 percent is deployed 30 minutes later.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig CANARY_10_PERCENT_30_MINUTES;

    /**
     * CodeDeploy predefined deployment configuration that shifts 10 percent of traffic in the first increment.
     * <p>
     * The remaining 90 percent is deployed five minutes later.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig CANARY_10_PERCENT_5_MINUTES;

    /**
     * CodeDeploy predefined deployment configuration that shifts 10 percent of traffic every 10 minutes until all traffic is shifted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig LINEAR_10_PERCENT_EVERY_10_MINUTES;

    /**
     * CodeDeploy predefined deployment configuration that shifts 10 percent of traffic every minute until all traffic is shifted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig LINEAR_10_PERCENT_EVERY_1_MINUTE;

    /**
     * CodeDeploy predefined deployment configuration that shifts 10 percent of traffic every two minutes until all traffic is shifted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig LINEAR_10_PERCENT_EVERY_2_MINUTES;

    /**
     * CodeDeploy predefined deployment configuration that shifts 10 percent of traffic every three minutes until all traffic is shifted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig LINEAR_10_PERCENT_EVERY_3_MINUTES;

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfigProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The physical, human-readable name of the Deployment Configuration.
         * <p>
         * Default: - automatically generated name
         * <p>
         * @return {@code this}
         * @param deploymentConfigName The physical, human-readable name of the Deployment Configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfigName(final java.lang.String deploymentConfigName) {
            this.props().deploymentConfigName(deploymentConfigName);
            return this;
        }

        /**
         * The configuration that specifies how traffic is shifted from the 'blue' target group to the 'green' target group during a deployment.
         * <p>
         * Default: AllAtOnce
         * <p>
         * @return {@code this}
         * @param trafficRouting The configuration that specifies how traffic is shifted from the 'blue' target group to the 'green' target group during a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficRouting(final software.amazon.awscdk.services.codedeploy.TrafficRouting trafficRouting) {
            this.props().trafficRouting(trafficRouting);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfig build() {
            return new software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfig(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfigProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfigProps.Builder();
            }
            return this.props;
        }
    }
}
