package software.amazon.awscdk.services.codedeploy;

/**
 * Represents how traffic is shifted during a CodeDeploy deployment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * LambdaDeploymentConfig config = LambdaDeploymentConfig.Builder.create(this, "CustomConfig")
 *         .trafficRouting(TimeBasedCanaryTrafficRouting.Builder.create()
 *                 .interval(Duration.minutes(15))
 *                 .percentage(5)
 *                 .build())
 *         .deploymentConfigName("MyDeploymentConfig")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:30.976Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.TrafficRouting")
public abstract class TrafficRouting extends software.amazon.jsii.JsiiObject {

    protected TrafficRouting(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TrafficRouting(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected TrafficRouting() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Shifts 100% of traffic in a single shift.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.TrafficRouting allAtOnce() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.TrafficRouting.class, "allAtOnce", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.TrafficRouting.class));
    }

    /**
     * Shifts a specified percentage of traffic, waits for a specified amount of time, then shifts the rest of traffic.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.TrafficRouting timeBasedCanary(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.TimeBasedCanaryTrafficRoutingProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.TrafficRouting.class, "timeBasedCanary", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.TrafficRouting.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Keeps shifting a specified percentage of traffic until reaching 100%, waiting for a specified amount of time in between each traffic shift.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.TrafficRouting timeBasedLinear(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.TimeBasedLinearTrafficRoutingProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.TrafficRouting.class, "timeBasedLinear", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.TrafficRouting.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns the traffic routing configuration.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.TrafficRoutingConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.codedeploy.TrafficRouting {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Returns the traffic routing configuration.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.TrafficRoutingConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.TrafficRoutingConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
