package software.amazon.awscdk.services.cognito;

/**
 * Properties to initialize UserPoolIdentityProviderSaml.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool userpool = new UserPool(this, "Pool");
 * // specify the metadata as a file content
 * // specify the metadata as a file content
 * UserPoolIdentityProviderSaml.Builder.create(this, "userpoolIdpFile")
 *         .userPool(userpool)
 *         .metadata(UserPoolIdentityProviderSamlMetadata.file("my-file-contents"))
 *         // Whether to require encrypted SAML assertions from IdP
 *         .encryptedResponses(true)
 *         // The signing algorithm for the SAML requests
 *         .requestSigningAlgorithm(SigningAlgorithm.RSA_SHA256)
 *         // Enable IdP initiated SAML auth flow
 *         .idpInitiated(true)
 *         .build();
 * // specify the metadata as a URL
 * // specify the metadata as a URL
 * UserPoolIdentityProviderSaml.Builder.create(this, "userpoolidpUrl")
 *         .userPool(userpool)
 *         .metadata(UserPoolIdentityProviderSamlMetadata.url("https://my-metadata-url.com"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:31.358Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolIdentityProviderSamlProps")
@software.amazon.jsii.Jsii.Proxy(UserPoolIdentityProviderSamlProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserPoolIdentityProviderSamlProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cognito.UserPoolIdentityProviderProps {

    /**
     * The SAML metadata.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlMetadata getMetadata();

    /**
     * Whether to require encrypted SAML assertions from IdP.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-SAML-signing-encryption.html#cognito-user-pools-SAML-encryption">https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-SAML-signing-encryption.html#cognito-user-pools-SAML-encryption</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEncryptedResponses() {
        return null;
    }

    /**
     * Identifiers.
     * <p>
     * Identifiers can be used to redirect users to the correct IdP in multitenant apps.
     * <p>
     * Default: - no identifiers used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdentifiers() {
        return null;
    }

    /**
     * Whether to enable IdP-initiated SAML auth flows.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIdpInitiated() {
        return null;
    }

    /**
     * Whether to enable the "Sign-out flow" feature.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIdpSignout() {
        return null;
    }

    /**
     * The name of the provider.
     * <p>
     * Must be between 3 and 32 characters.
     * <p>
     * Default: - the unique ID of the construct
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The signing algorithm for SAML requests.
     * <p>
     * Default: - don't sign requests
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-SAML-signing-encryption.html#cognito-user-pools-SAML-signing">https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-SAML-signing-encryption.html#cognito-user-pools-SAML-signing</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.SigningAlgorithm getRequestSigningAlgorithm() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolIdentityProviderSamlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolIdentityProviderSamlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolIdentityProviderSamlProps> {
        software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlMetadata metadata;
        java.lang.Boolean encryptedResponses;
        java.util.List<java.lang.String> identifiers;
        java.lang.Boolean idpInitiated;
        java.lang.Boolean idpSignout;
        java.lang.String name;
        software.amazon.awscdk.services.cognito.SigningAlgorithm requestSigningAlgorithm;
        software.amazon.awscdk.services.cognito.IUserPool userPool;
        software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping;

        /**
         * Sets the value of {@link UserPoolIdentityProviderSamlProps#getMetadata}
         * @param metadata The SAML metadata. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderSamlProps#getEncryptedResponses}
         * @param encryptedResponses Whether to require encrypted SAML assertions from IdP.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptedResponses(java.lang.Boolean encryptedResponses) {
            this.encryptedResponses = encryptedResponses;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderSamlProps#getIdentifiers}
         * @param identifiers Identifiers.
         *                    Identifiers can be used to redirect users to the correct IdP in multitenant apps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identifiers(java.util.List<java.lang.String> identifiers) {
            this.identifiers = identifiers;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderSamlProps#getIdpInitiated}
         * @param idpInitiated Whether to enable IdP-initiated SAML auth flows.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idpInitiated(java.lang.Boolean idpInitiated) {
            this.idpInitiated = idpInitiated;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderSamlProps#getIdpSignout}
         * @param idpSignout Whether to enable the "Sign-out flow" feature.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idpSignout(java.lang.Boolean idpSignout) {
            this.idpSignout = idpSignout;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderSamlProps#getName}
         * @param name The name of the provider.
         *             Must be between 3 and 32 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderSamlProps#getRequestSigningAlgorithm}
         * @param requestSigningAlgorithm The signing algorithm for SAML requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestSigningAlgorithm(software.amazon.awscdk.services.cognito.SigningAlgorithm requestSigningAlgorithm) {
            this.requestSigningAlgorithm = requestSigningAlgorithm;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderSamlProps#getUserPool}
         * @param userPool The user pool to which this construct provides identities. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPool(software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.userPool = userPool;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderSamlProps#getAttributeMapping}
         * @param attributeMapping Mapping attributes from the identity provider to standard and custom attributes of the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeMapping(software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping) {
            this.attributeMapping = attributeMapping;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolIdentityProviderSamlProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserPoolIdentityProviderSamlProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserPoolIdentityProviderSamlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolIdentityProviderSamlProps {
        private final software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlMetadata metadata;
        private final java.lang.Boolean encryptedResponses;
        private final java.util.List<java.lang.String> identifiers;
        private final java.lang.Boolean idpInitiated;
        private final java.lang.Boolean idpSignout;
        private final java.lang.String name;
        private final software.amazon.awscdk.services.cognito.SigningAlgorithm requestSigningAlgorithm;
        private final software.amazon.awscdk.services.cognito.IUserPool userPool;
        private final software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlMetadata.class));
            this.encryptedResponses = software.amazon.jsii.Kernel.get(this, "encryptedResponses", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.identifiers = software.amazon.jsii.Kernel.get(this, "identifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.idpInitiated = software.amazon.jsii.Kernel.get(this, "idpInitiated", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.idpSignout = software.amazon.jsii.Kernel.get(this, "idpSignout", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requestSigningAlgorithm = software.amazon.jsii.Kernel.get(this, "requestSigningAlgorithm", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.SigningAlgorithm.class));
            this.userPool = software.amazon.jsii.Kernel.get(this, "userPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPool.class));
            this.attributeMapping = software.amazon.jsii.Kernel.get(this, "attributeMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.AttributeMapping.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metadata = java.util.Objects.requireNonNull(builder.metadata, "metadata is required");
            this.encryptedResponses = builder.encryptedResponses;
            this.identifiers = builder.identifiers;
            this.idpInitiated = builder.idpInitiated;
            this.idpSignout = builder.idpSignout;
            this.name = builder.name;
            this.requestSigningAlgorithm = builder.requestSigningAlgorithm;
            this.userPool = java.util.Objects.requireNonNull(builder.userPool, "userPool is required");
            this.attributeMapping = builder.attributeMapping;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        public final java.lang.Boolean getEncryptedResponses() {
            return this.encryptedResponses;
        }

        @Override
        public final java.util.List<java.lang.String> getIdentifiers() {
            return this.identifiers;
        }

        @Override
        public final java.lang.Boolean getIdpInitiated() {
            return this.idpInitiated;
        }

        @Override
        public final java.lang.Boolean getIdpSignout() {
            return this.idpSignout;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.SigningAlgorithm getRequestSigningAlgorithm() {
            return this.requestSigningAlgorithm;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.IUserPool getUserPool() {
            return this.userPool;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.AttributeMapping getAttributeMapping() {
            return this.attributeMapping;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("metadata", om.valueToTree(this.getMetadata()));
            if (this.getEncryptedResponses() != null) {
                data.set("encryptedResponses", om.valueToTree(this.getEncryptedResponses()));
            }
            if (this.getIdentifiers() != null) {
                data.set("identifiers", om.valueToTree(this.getIdentifiers()));
            }
            if (this.getIdpInitiated() != null) {
                data.set("idpInitiated", om.valueToTree(this.getIdpInitiated()));
            }
            if (this.getIdpSignout() != null) {
                data.set("idpSignout", om.valueToTree(this.getIdpSignout()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRequestSigningAlgorithm() != null) {
                data.set("requestSigningAlgorithm", om.valueToTree(this.getRequestSigningAlgorithm()));
            }
            data.set("userPool", om.valueToTree(this.getUserPool()));
            if (this.getAttributeMapping() != null) {
                data.set("attributeMapping", om.valueToTree(this.getAttributeMapping()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.UserPoolIdentityProviderSamlProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolIdentityProviderSamlProps.Jsii$Proxy that = (UserPoolIdentityProviderSamlProps.Jsii$Proxy) o;

            if (!metadata.equals(that.metadata)) return false;
            if (this.encryptedResponses != null ? !this.encryptedResponses.equals(that.encryptedResponses) : that.encryptedResponses != null) return false;
            if (this.identifiers != null ? !this.identifiers.equals(that.identifiers) : that.identifiers != null) return false;
            if (this.idpInitiated != null ? !this.idpInitiated.equals(that.idpInitiated) : that.idpInitiated != null) return false;
            if (this.idpSignout != null ? !this.idpSignout.equals(that.idpSignout) : that.idpSignout != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.requestSigningAlgorithm != null ? !this.requestSigningAlgorithm.equals(that.requestSigningAlgorithm) : that.requestSigningAlgorithm != null) return false;
            if (!userPool.equals(that.userPool)) return false;
            return this.attributeMapping != null ? this.attributeMapping.equals(that.attributeMapping) : that.attributeMapping == null;
        }

        @Override
        public final int hashCode() {
            int result = this.metadata.hashCode();
            result = 31 * result + (this.encryptedResponses != null ? this.encryptedResponses.hashCode() : 0);
            result = 31 * result + (this.identifiers != null ? this.identifiers.hashCode() : 0);
            result = 31 * result + (this.idpInitiated != null ? this.idpInitiated.hashCode() : 0);
            result = 31 * result + (this.idpSignout != null ? this.idpSignout.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.requestSigningAlgorithm != null ? this.requestSigningAlgorithm.hashCode() : 0);
            result = 31 * result + (this.userPool.hashCode());
            result = 31 * result + (this.attributeMapping != null ? this.attributeMapping.hashCode() : 0);
            return result;
        }
    }
}
