package software.amazon.awscdk.services.deadline;

/**
 * Properties for defining a <code>CfnStorageProfile</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.deadline.*;
 * CfnStorageProfileProps cfnStorageProfileProps = CfnStorageProfileProps.builder()
 *         .displayName("displayName")
 *         .osFamily("osFamily")
 *         // the properties below are optional
 *         .farmId("farmId")
 *         .fileSystemLocations(List.of(FileSystemLocationProperty.builder()
 *                 .name("name")
 *                 .path("path")
 *                 .type("type")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-storageprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-storageprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:31.879Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnStorageProfileProps")
@software.amazon.jsii.Jsii.Proxy(CfnStorageProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStorageProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The display name of the storage profile summary to update.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-storageprofile.html#cfn-deadline-storageprofile-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-storageprofile.html#cfn-deadline-storageprofile-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDisplayName();

    /**
     * The operating system (OS) family.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-storageprofile.html#cfn-deadline-storageprofile-osfamily">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-storageprofile.html#cfn-deadline-storageprofile-osfamily</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOsFamily();

    /**
     * The unique identifier of the farm that contains the storage profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-storageprofile.html#cfn-deadline-storageprofile-farmid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-storageprofile.html#cfn-deadline-storageprofile-farmid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFarmId() {
        return null;
    }

    /**
     * Operating system specific file system path to the storage location.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-storageprofile.html#cfn-deadline-storageprofile-filesystemlocations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-storageprofile.html#cfn-deadline-storageprofile-filesystemlocations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFileSystemLocations() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStorageProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStorageProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStorageProfileProps> {
        java.lang.String displayName;
        java.lang.String osFamily;
        java.lang.String farmId;
        java.lang.Object fileSystemLocations;

        /**
         * Sets the value of {@link CfnStorageProfileProps#getDisplayName}
         * @param displayName The display name of the storage profile summary to update. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageProfileProps#getOsFamily}
         * @param osFamily The operating system (OS) family. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder osFamily(java.lang.String osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageProfileProps#getFarmId}
         * @param farmId The unique identifier of the farm that contains the storage profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder farmId(java.lang.String farmId) {
            this.farmId = farmId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageProfileProps#getFileSystemLocations}
         * @param fileSystemLocations Operating system specific file system path to the storage location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemLocations(software.amazon.awscdk.IResolvable fileSystemLocations) {
            this.fileSystemLocations = fileSystemLocations;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageProfileProps#getFileSystemLocations}
         * @param fileSystemLocations Operating system specific file system path to the storage location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemLocations(java.util.List<? extends java.lang.Object> fileSystemLocations) {
            this.fileSystemLocations = fileSystemLocations;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStorageProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStorageProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStorageProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStorageProfileProps {
        private final java.lang.String displayName;
        private final java.lang.String osFamily;
        private final java.lang.String farmId;
        private final java.lang.Object fileSystemLocations;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.osFamily = software.amazon.jsii.Kernel.get(this, "osFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.farmId = software.amazon.jsii.Kernel.get(this, "farmId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileSystemLocations = software.amazon.jsii.Kernel.get(this, "fileSystemLocations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.displayName = java.util.Objects.requireNonNull(builder.displayName, "displayName is required");
            this.osFamily = java.util.Objects.requireNonNull(builder.osFamily, "osFamily is required");
            this.farmId = builder.farmId;
            this.fileSystemLocations = builder.fileSystemLocations;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getOsFamily() {
            return this.osFamily;
        }

        @Override
        public final java.lang.String getFarmId() {
            return this.farmId;
        }

        @Override
        public final java.lang.Object getFileSystemLocations() {
            return this.fileSystemLocations;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("displayName", om.valueToTree(this.getDisplayName()));
            data.set("osFamily", om.valueToTree(this.getOsFamily()));
            if (this.getFarmId() != null) {
                data.set("farmId", om.valueToTree(this.getFarmId()));
            }
            if (this.getFileSystemLocations() != null) {
                data.set("fileSystemLocations", om.valueToTree(this.getFileSystemLocations()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnStorageProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStorageProfileProps.Jsii$Proxy that = (CfnStorageProfileProps.Jsii$Proxy) o;

            if (!displayName.equals(that.displayName)) return false;
            if (!osFamily.equals(that.osFamily)) return false;
            if (this.farmId != null ? !this.farmId.equals(that.farmId) : that.farmId != null) return false;
            return this.fileSystemLocations != null ? this.fileSystemLocations.equals(that.fileSystemLocations) : that.fileSystemLocations == null;
        }

        @Override
        public final int hashCode() {
            int result = this.displayName.hashCode();
            result = 31 * result + (this.osFamily.hashCode());
            result = 31 * result + (this.farmId != null ? this.farmId.hashCode() : 0);
            result = 31 * result + (this.fileSystemLocations != null ? this.fileSystemLocations.hashCode() : 0);
            return result;
        }
    }
}
