package software.amazon.awscdk.services.docdb;

/**
 * Properties for a new database cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .masterUser(Login.builder()
 *                 .username("myuser")
 *                 .build())
 *         .instanceType(InstanceType.of(InstanceClass.MEMORY5, InstanceSize.LARGE))
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PUBLIC)
 *                 .build())
 *         .vpc(vpc)
 *         .caCertificate(CaCertificate.RDS_CA_RSA4096_G1)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:32.082Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_docdb.DatabaseClusterProps")
@software.amazon.jsii.Jsii.Proxy(DatabaseClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DatabaseClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * What type of instance to start for the replicas.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * Username and password for the administrative user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.docdb.Login getMasterUser();

    /**
     * What subnets to run the DocumentDB instances in.
     * <p>
     * Must be at least 2 subnets in two different AZs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * Backup settings.
     * <p>
     * Default: - Backup retention period for automated backups is 1 day.
     * Backup preferred window is set to a 30-minute window selected at random from an
     * 8-hour block of time for each AWS Region, occurring on a random day of the week.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/backup-restore.db-cluster-snapshots.html#backup-restore.backup-window">https://docs.aws.amazon.com/documentdb/latest/developerguide/backup-restore.db-cluster-snapshots.html#backup-restore.backup-window</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.docdb.BackupProps getBackup() {
        return null;
    }

    /**
     * The identifier of the CA certificate used for the instances.
     * <p>
     * Specifying or updating this property triggers a reboot.
     * <p>
     * Default: - DocumentDB will choose a certificate authority
     * <p>
     * @see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/ca_cert_rotation.html">https://docs.aws.amazon.com/documentdb/latest/developerguide/ca_cert_rotation.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.CaCertificate getCaCertificate() {
        return null;
    }

    /**
     * The number of days log events are kept in CloudWatch Logs.
     * <p>
     * When updating
     * this property, unsetting it doesn't remove the log retention policy. To
     * remove the retention policy, set the value to <code>Infinity</code>.
     * <p>
     * Default: - logs never expire
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getCloudWatchLogsRetention() {
        return null;
    }

    /**
     * The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
     * <p>
     * Default: - a new role is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getCloudWatchLogsRetentionRole() {
        return null;
    }

    /**
     * Whether to copy tags to the snapshot when a snapshot is created.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCopyTagsToSnapshot() {
        return null;
    }

    /**
     * An optional identifier for the cluster.
     * <p>
     * Default: - A name is automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbClusterName() {
        return null;
    }

    /**
     * Specifies whether this cluster can be deleted.
     * <p>
     * If deletionProtection is
     * enabled, the cluster cannot be deleted unless it is modified and
     * deletionProtection is disabled. deletionProtection protects clusters from
     * being accidentally deleted.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeletionProtection() {
        return null;
    }

    /**
     * A value that indicates whether to enable Performance Insights for the instances in the DB Cluster.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnablePerformanceInsights() {
        return null;
    }

    /**
     * What version of the database to start.
     * <p>
     * Default: - The default engine version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return null;
    }

    /**
     * Whether the audit logs should be exported to CloudWatch.
     * <p>
     * Note that you also have to configure the audit log export in the Cluster's Parameter Group.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html#event-auditing-enabling-auditing">https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html#event-auditing-enabling-auditing</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getExportAuditLogsToCloudWatch() {
        return null;
    }

    /**
     * Whether the profiler logs should be exported to CloudWatch.
     * <p>
     * Note that you also have to configure the profiler log export in the Cluster's Parameter Group.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html#profiling.enable-profiling">https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html#profiling.enable-profiling</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getExportProfilerLogsToCloudWatch() {
        return null;
    }

    /**
     * Base identifier for instances.
     * <p>
     * Every replica is named by appending the replica number to this string, 1-based.
     * <p>
     * Default: - `dbClusterName` is used with the word "Instance" appended. If `dbClusterName` is not provided, the
     * identifier is automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceIdentifierBase() {
        return null;
    }

    /**
     * The removal policy to apply to the cluster's instances.
     * <p>
     * Cannot be set to <code>SNAPSHOT</code>.
     * <p>
     * Default: - `RemovalPolicy.DESTROY` when `removalPolicy` is set to `SNAPSHOT`, `removalPolicy` otherwise.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getInstanceRemovalPolicy() {
        return null;
    }

    /**
     * Number of DocDB compute instances.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getInstances() {
        return null;
    }

    /**
     * The KMS key for storage encryption.
     * <p>
     * Default: - default master key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKmsKey() {
        return null;
    }

    /**
     * The DB parameter group to associate with the instance.
     * <p>
     * Default: no parameter group
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.docdb.IClusterParameterGroup getParameterGroup() {
        return null;
    }

    /**
     * The port the DocumentDB cluster will listen on.
     * <p>
     * Default: DatabaseCluster.DEFAULT_PORT
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * A weekly time range in which maintenance should preferably execute.
     * <p>
     * Must be at least 30 minutes long.
     * <p>
     * Example: 'tue:04:17-tue:04:47'
     * <p>
     * Default: - 30-minute window selected at random from an 8-hour block of time for
     * each AWS Region, occurring on a random day of the week.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-maintain.html#maintenance-window">https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-maintain.html#maintenance-window</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * The removal policy to apply when the cluster and its instances are removed or replaced during a stack update, or when the stack is deleted.
     * <p>
     * This
     * removal policy also applies to the implicit security group created for the
     * cluster if one is not supplied as a parameter.
     * <p>
     * When set to <code>SNAPSHOT</code>, the removal policy for the instances and the security group
     * will default to <code>DESTROY</code> as those resources do not support the policy.
     * <p>
     * Use the <code>instanceRemovalPolicy</code> and <code>securityGroupRemovalPolicy</code> to change the behavior.
     * <p>
     * Default: - Retain cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * Security group.
     * <p>
     * Default: a new security group is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * The removal policy to apply to the cluster's security group.
     * <p>
     * Cannot be set to <code>SNAPSHOT</code>.
     * <p>
     * Default: - `RemovalPolicy.DESTROY` when `removalPolicy` is set to `SNAPSHOT`, `removalPolicy` otherwise.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getSecurityGroupRemovalPolicy() {
        return null;
    }

    /**
     * Whether to enable storage encryption.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getStorageEncrypted() {
        return null;
    }

    /**
     * Where to place the instances within the VPC.
     * <p>
     * Default: private subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DatabaseClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseClusterProps> {
        software.amazon.awscdk.services.ec2.InstanceType instanceType;
        software.amazon.awscdk.services.docdb.Login masterUser;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        software.amazon.awscdk.services.docdb.BackupProps backup;
        software.amazon.awscdk.services.rds.CaCertificate caCertificate;
        software.amazon.awscdk.services.logs.RetentionDays cloudWatchLogsRetention;
        software.amazon.awscdk.services.iam.IRole cloudWatchLogsRetentionRole;
        java.lang.Boolean copyTagsToSnapshot;
        java.lang.String dbClusterName;
        java.lang.Boolean deletionProtection;
        java.lang.Boolean enablePerformanceInsights;
        java.lang.String engineVersion;
        java.lang.Boolean exportAuditLogsToCloudWatch;
        java.lang.Boolean exportProfilerLogsToCloudWatch;
        java.lang.String instanceIdentifierBase;
        software.amazon.awscdk.RemovalPolicy instanceRemovalPolicy;
        java.lang.Number instances;
        software.amazon.awscdk.services.kms.IKey kmsKey;
        software.amazon.awscdk.services.docdb.IClusterParameterGroup parameterGroup;
        java.lang.Number port;
        java.lang.String preferredMaintenanceWindow;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        software.amazon.awscdk.RemovalPolicy securityGroupRemovalPolicy;
        java.lang.Boolean storageEncrypted;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link DatabaseClusterProps#getInstanceType}
         * @param instanceType What type of instance to start for the replicas. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getMasterUser}
         * @param masterUser Username and password for the administrative user. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUser(software.amazon.awscdk.services.docdb.Login masterUser) {
            this.masterUser = masterUser;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getVpc}
         * @param vpc What subnets to run the DocumentDB instances in. This parameter is required.
         *            Must be at least 2 subnets in two different AZs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getBackup}
         * @param backup Backup settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backup(software.amazon.awscdk.services.docdb.BackupProps backup) {
            this.backup = backup;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getCaCertificate}
         * @param caCertificate The identifier of the CA certificate used for the instances.
         *                      Specifying or updating this property triggers a reboot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificate(software.amazon.awscdk.services.rds.CaCertificate caCertificate) {
            this.caCertificate = caCertificate;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getCloudWatchLogsRetention}
         * @param cloudWatchLogsRetention The number of days log events are kept in CloudWatch Logs.
         *                                When updating
         *                                this property, unsetting it doesn't remove the log retention policy. To
         *                                remove the retention policy, set the value to <code>Infinity</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogsRetention(software.amazon.awscdk.services.logs.RetentionDays cloudWatchLogsRetention) {
            this.cloudWatchLogsRetention = cloudWatchLogsRetention;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getCloudWatchLogsRetentionRole}
         * @param cloudWatchLogsRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogsRetentionRole(software.amazon.awscdk.services.iam.IRole cloudWatchLogsRetentionRole) {
            this.cloudWatchLogsRetentionRole = cloudWatchLogsRetentionRole;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getCopyTagsToSnapshot}
         * @param copyTagsToSnapshot Whether to copy tags to the snapshot when a snapshot is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(java.lang.Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getDbClusterName}
         * @param dbClusterName An optional identifier for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterName(java.lang.String dbClusterName) {
            this.dbClusterName = dbClusterName;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getDeletionProtection}
         * @param deletionProtection Specifies whether this cluster can be deleted.
         *                           If deletionProtection is
         *                           enabled, the cluster cannot be deleted unless it is modified and
         *                           deletionProtection is disabled. deletionProtection protects clusters from
         *                           being accidentally deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getEnablePerformanceInsights}
         * @param enablePerformanceInsights A value that indicates whether to enable Performance Insights for the instances in the DB Cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceInsights(java.lang.Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getEngineVersion}
         * @param engineVersion What version of the database to start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(java.lang.String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getExportAuditLogsToCloudWatch}
         * @param exportAuditLogsToCloudWatch Whether the audit logs should be exported to CloudWatch.
         *                                    Note that you also have to configure the audit log export in the Cluster's Parameter Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportAuditLogsToCloudWatch(java.lang.Boolean exportAuditLogsToCloudWatch) {
            this.exportAuditLogsToCloudWatch = exportAuditLogsToCloudWatch;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getExportProfilerLogsToCloudWatch}
         * @param exportProfilerLogsToCloudWatch Whether the profiler logs should be exported to CloudWatch.
         *                                       Note that you also have to configure the profiler log export in the Cluster's Parameter Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportProfilerLogsToCloudWatch(java.lang.Boolean exportProfilerLogsToCloudWatch) {
            this.exportProfilerLogsToCloudWatch = exportProfilerLogsToCloudWatch;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getInstanceIdentifierBase}
         * @param instanceIdentifierBase Base identifier for instances.
         *                               Every replica is named by appending the replica number to this string, 1-based.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceIdentifierBase(java.lang.String instanceIdentifierBase) {
            this.instanceIdentifierBase = instanceIdentifierBase;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getInstanceRemovalPolicy}
         * @param instanceRemovalPolicy The removal policy to apply to the cluster's instances.
         *                              Cannot be set to <code>SNAPSHOT</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRemovalPolicy(software.amazon.awscdk.RemovalPolicy instanceRemovalPolicy) {
            this.instanceRemovalPolicy = instanceRemovalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getInstances}
         * @param instances Number of DocDB compute instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instances(java.lang.Number instances) {
            this.instances = instances;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getKmsKey}
         * @param kmsKey The KMS key for storage encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getParameterGroup}
         * @param parameterGroup The DB parameter group to associate with the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterGroup(software.amazon.awscdk.services.docdb.IClusterParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getPort}
         * @param port The port the DocumentDB cluster will listen on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow A weekly time range in which maintenance should preferably execute.
         *                                   Must be at least 30 minutes long.
         *                                   <p>
         *                                   Example: 'tue:04:17-tue:04:47'
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getRemovalPolicy}
         * @param removalPolicy The removal policy to apply when the cluster and its instances are removed or replaced during a stack update, or when the stack is deleted.
         *                      This
         *                      removal policy also applies to the implicit security group created for the
         *                      cluster if one is not supplied as a parameter.
         *                      <p>
         *                      When set to <code>SNAPSHOT</code>, the removal policy for the instances and the security group
         *                      will default to <code>DESTROY</code> as those resources do not support the policy.
         *                      <p>
         *                      Use the <code>instanceRemovalPolicy</code> and <code>securityGroupRemovalPolicy</code> to change the behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getSecurityGroup}
         * @param securityGroup Security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getSecurityGroupRemovalPolicy}
         * @param securityGroupRemovalPolicy The removal policy to apply to the cluster's security group.
         *                                   Cannot be set to <code>SNAPSHOT</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupRemovalPolicy(software.amazon.awscdk.RemovalPolicy securityGroupRemovalPolicy) {
            this.securityGroupRemovalPolicy = securityGroupRemovalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getStorageEncrypted}
         * @param storageEncrypted Whether to enable storage encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(java.lang.Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterProps#getVpcSubnets}
         * @param vpcSubnets Where to place the instances within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DatabaseClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseClusterProps {
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.services.docdb.Login masterUser;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.services.docdb.BackupProps backup;
        private final software.amazon.awscdk.services.rds.CaCertificate caCertificate;
        private final software.amazon.awscdk.services.logs.RetentionDays cloudWatchLogsRetention;
        private final software.amazon.awscdk.services.iam.IRole cloudWatchLogsRetentionRole;
        private final java.lang.Boolean copyTagsToSnapshot;
        private final java.lang.String dbClusterName;
        private final java.lang.Boolean deletionProtection;
        private final java.lang.Boolean enablePerformanceInsights;
        private final java.lang.String engineVersion;
        private final java.lang.Boolean exportAuditLogsToCloudWatch;
        private final java.lang.Boolean exportProfilerLogsToCloudWatch;
        private final java.lang.String instanceIdentifierBase;
        private final software.amazon.awscdk.RemovalPolicy instanceRemovalPolicy;
        private final java.lang.Number instances;
        private final software.amazon.awscdk.services.kms.IKey kmsKey;
        private final software.amazon.awscdk.services.docdb.IClusterParameterGroup parameterGroup;
        private final java.lang.Number port;
        private final java.lang.String preferredMaintenanceWindow;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.RemovalPolicy securityGroupRemovalPolicy;
        private final java.lang.Boolean storageEncrypted;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.masterUser = software.amazon.jsii.Kernel.get(this, "masterUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.docdb.Login.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.backup = software.amazon.jsii.Kernel.get(this, "backup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.docdb.BackupProps.class));
            this.caCertificate = software.amazon.jsii.Kernel.get(this, "caCertificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CaCertificate.class));
            this.cloudWatchLogsRetention = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
            this.cloudWatchLogsRetentionRole = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsRetentionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.copyTagsToSnapshot = software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.dbClusterName = software.amazon.jsii.Kernel.get(this, "dbClusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enablePerformanceInsights = software.amazon.jsii.Kernel.get(this, "enablePerformanceInsights", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.exportAuditLogsToCloudWatch = software.amazon.jsii.Kernel.get(this, "exportAuditLogsToCloudWatch", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.exportProfilerLogsToCloudWatch = software.amazon.jsii.Kernel.get(this, "exportProfilerLogsToCloudWatch", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.instanceIdentifierBase = software.amazon.jsii.Kernel.get(this, "instanceIdentifierBase", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceRemovalPolicy = software.amazon.jsii.Kernel.get(this, "instanceRemovalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.instances = software.amazon.jsii.Kernel.get(this, "instances", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.parameterGroup = software.amazon.jsii.Kernel.get(this, "parameterGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.docdb.IClusterParameterGroup.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.securityGroupRemovalPolicy = software.amazon.jsii.Kernel.get(this, "securityGroupRemovalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.storageEncrypted = software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.masterUser = java.util.Objects.requireNonNull(builder.masterUser, "masterUser is required");
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.backup = builder.backup;
            this.caCertificate = builder.caCertificate;
            this.cloudWatchLogsRetention = builder.cloudWatchLogsRetention;
            this.cloudWatchLogsRetentionRole = builder.cloudWatchLogsRetentionRole;
            this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
            this.dbClusterName = builder.dbClusterName;
            this.deletionProtection = builder.deletionProtection;
            this.enablePerformanceInsights = builder.enablePerformanceInsights;
            this.engineVersion = builder.engineVersion;
            this.exportAuditLogsToCloudWatch = builder.exportAuditLogsToCloudWatch;
            this.exportProfilerLogsToCloudWatch = builder.exportProfilerLogsToCloudWatch;
            this.instanceIdentifierBase = builder.instanceIdentifierBase;
            this.instanceRemovalPolicy = builder.instanceRemovalPolicy;
            this.instances = builder.instances;
            this.kmsKey = builder.kmsKey;
            this.parameterGroup = builder.parameterGroup;
            this.port = builder.port;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.removalPolicy = builder.removalPolicy;
            this.securityGroup = builder.securityGroup;
            this.securityGroupRemovalPolicy = builder.securityGroupRemovalPolicy;
            this.storageEncrypted = builder.storageEncrypted;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final software.amazon.awscdk.services.docdb.Login getMasterUser() {
            return this.masterUser;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.docdb.BackupProps getBackup() {
            return this.backup;
        }

        @Override
        public final software.amazon.awscdk.services.rds.CaCertificate getCaCertificate() {
            return this.caCertificate;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getCloudWatchLogsRetention() {
            return this.cloudWatchLogsRetention;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getCloudWatchLogsRetentionRole() {
            return this.cloudWatchLogsRetentionRole;
        }

        @Override
        public final java.lang.Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final java.lang.String getDbClusterName() {
            return this.dbClusterName;
        }

        @Override
        public final java.lang.Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final java.lang.Boolean getEnablePerformanceInsights() {
            return this.enablePerformanceInsights;
        }

        @Override
        public final java.lang.String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final java.lang.Boolean getExportAuditLogsToCloudWatch() {
            return this.exportAuditLogsToCloudWatch;
        }

        @Override
        public final java.lang.Boolean getExportProfilerLogsToCloudWatch() {
            return this.exportProfilerLogsToCloudWatch;
        }

        @Override
        public final java.lang.String getInstanceIdentifierBase() {
            return this.instanceIdentifierBase;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getInstanceRemovalPolicy() {
            return this.instanceRemovalPolicy;
        }

        @Override
        public final java.lang.Number getInstances() {
            return this.instances;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final software.amazon.awscdk.services.docdb.IClusterParameterGroup getParameterGroup() {
            return this.parameterGroup;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getSecurityGroupRemovalPolicy() {
            return this.securityGroupRemovalPolicy;
        }

        @Override
        public final java.lang.Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            data.set("masterUser", om.valueToTree(this.getMasterUser()));
            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getBackup() != null) {
                data.set("backup", om.valueToTree(this.getBackup()));
            }
            if (this.getCaCertificate() != null) {
                data.set("caCertificate", om.valueToTree(this.getCaCertificate()));
            }
            if (this.getCloudWatchLogsRetention() != null) {
                data.set("cloudWatchLogsRetention", om.valueToTree(this.getCloudWatchLogsRetention()));
            }
            if (this.getCloudWatchLogsRetentionRole() != null) {
                data.set("cloudWatchLogsRetentionRole", om.valueToTree(this.getCloudWatchLogsRetentionRole()));
            }
            if (this.getCopyTagsToSnapshot() != null) {
                data.set("copyTagsToSnapshot", om.valueToTree(this.getCopyTagsToSnapshot()));
            }
            if (this.getDbClusterName() != null) {
                data.set("dbClusterName", om.valueToTree(this.getDbClusterName()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getEnablePerformanceInsights() != null) {
                data.set("enablePerformanceInsights", om.valueToTree(this.getEnablePerformanceInsights()));
            }
            if (this.getEngineVersion() != null) {
                data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
            }
            if (this.getExportAuditLogsToCloudWatch() != null) {
                data.set("exportAuditLogsToCloudWatch", om.valueToTree(this.getExportAuditLogsToCloudWatch()));
            }
            if (this.getExportProfilerLogsToCloudWatch() != null) {
                data.set("exportProfilerLogsToCloudWatch", om.valueToTree(this.getExportProfilerLogsToCloudWatch()));
            }
            if (this.getInstanceIdentifierBase() != null) {
                data.set("instanceIdentifierBase", om.valueToTree(this.getInstanceIdentifierBase()));
            }
            if (this.getInstanceRemovalPolicy() != null) {
                data.set("instanceRemovalPolicy", om.valueToTree(this.getInstanceRemovalPolicy()));
            }
            if (this.getInstances() != null) {
                data.set("instances", om.valueToTree(this.getInstances()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getParameterGroup() != null) {
                data.set("parameterGroup", om.valueToTree(this.getParameterGroup()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getSecurityGroupRemovalPolicy() != null) {
                data.set("securityGroupRemovalPolicy", om.valueToTree(this.getSecurityGroupRemovalPolicy()));
            }
            if (this.getStorageEncrypted() != null) {
                data.set("storageEncrypted", om.valueToTree(this.getStorageEncrypted()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_docdb.DatabaseClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseClusterProps.Jsii$Proxy that = (DatabaseClusterProps.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (!masterUser.equals(that.masterUser)) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.backup != null ? !this.backup.equals(that.backup) : that.backup != null) return false;
            if (this.caCertificate != null ? !this.caCertificate.equals(that.caCertificate) : that.caCertificate != null) return false;
            if (this.cloudWatchLogsRetention != null ? !this.cloudWatchLogsRetention.equals(that.cloudWatchLogsRetention) : that.cloudWatchLogsRetention != null) return false;
            if (this.cloudWatchLogsRetentionRole != null ? !this.cloudWatchLogsRetentionRole.equals(that.cloudWatchLogsRetentionRole) : that.cloudWatchLogsRetentionRole != null) return false;
            if (this.copyTagsToSnapshot != null ? !this.copyTagsToSnapshot.equals(that.copyTagsToSnapshot) : that.copyTagsToSnapshot != null) return false;
            if (this.dbClusterName != null ? !this.dbClusterName.equals(that.dbClusterName) : that.dbClusterName != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.enablePerformanceInsights != null ? !this.enablePerformanceInsights.equals(that.enablePerformanceInsights) : that.enablePerformanceInsights != null) return false;
            if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
            if (this.exportAuditLogsToCloudWatch != null ? !this.exportAuditLogsToCloudWatch.equals(that.exportAuditLogsToCloudWatch) : that.exportAuditLogsToCloudWatch != null) return false;
            if (this.exportProfilerLogsToCloudWatch != null ? !this.exportProfilerLogsToCloudWatch.equals(that.exportProfilerLogsToCloudWatch) : that.exportProfilerLogsToCloudWatch != null) return false;
            if (this.instanceIdentifierBase != null ? !this.instanceIdentifierBase.equals(that.instanceIdentifierBase) : that.instanceIdentifierBase != null) return false;
            if (this.instanceRemovalPolicy != null ? !this.instanceRemovalPolicy.equals(that.instanceRemovalPolicy) : that.instanceRemovalPolicy != null) return false;
            if (this.instances != null ? !this.instances.equals(that.instances) : that.instances != null) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            if (this.parameterGroup != null ? !this.parameterGroup.equals(that.parameterGroup) : that.parameterGroup != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.securityGroupRemovalPolicy != null ? !this.securityGroupRemovalPolicy.equals(that.securityGroupRemovalPolicy) : that.securityGroupRemovalPolicy != null) return false;
            if (this.storageEncrypted != null ? !this.storageEncrypted.equals(that.storageEncrypted) : that.storageEncrypted != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.masterUser.hashCode());
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.backup != null ? this.backup.hashCode() : 0);
            result = 31 * result + (this.caCertificate != null ? this.caCertificate.hashCode() : 0);
            result = 31 * result + (this.cloudWatchLogsRetention != null ? this.cloudWatchLogsRetention.hashCode() : 0);
            result = 31 * result + (this.cloudWatchLogsRetentionRole != null ? this.cloudWatchLogsRetentionRole.hashCode() : 0);
            result = 31 * result + (this.copyTagsToSnapshot != null ? this.copyTagsToSnapshot.hashCode() : 0);
            result = 31 * result + (this.dbClusterName != null ? this.dbClusterName.hashCode() : 0);
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.enablePerformanceInsights != null ? this.enablePerformanceInsights.hashCode() : 0);
            result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
            result = 31 * result + (this.exportAuditLogsToCloudWatch != null ? this.exportAuditLogsToCloudWatch.hashCode() : 0);
            result = 31 * result + (this.exportProfilerLogsToCloudWatch != null ? this.exportProfilerLogsToCloudWatch.hashCode() : 0);
            result = 31 * result + (this.instanceIdentifierBase != null ? this.instanceIdentifierBase.hashCode() : 0);
            result = 31 * result + (this.instanceRemovalPolicy != null ? this.instanceRemovalPolicy.hashCode() : 0);
            result = 31 * result + (this.instances != null ? this.instances.hashCode() : 0);
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.parameterGroup != null ? this.parameterGroup.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.securityGroupRemovalPolicy != null ? this.securityGroupRemovalPolicy.hashCode() : 0);
            result = 31 * result + (this.storageEncrypted != null ? this.storageEncrypted.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
