package software.amazon.awscdk.services.dynamodb;

/**
 * Properties for a secondary index.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dynamodb.*;
 * SecondaryIndexProps secondaryIndexProps = SecondaryIndexProps.builder()
 *         .indexName("indexName")
 *         // the properties below are optional
 *         .nonKeyAttributes(List.of("nonKeyAttributes"))
 *         .projectionType(ProjectionType.KEYS_ONLY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:32.189Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.SecondaryIndexProps")
@software.amazon.jsii.Jsii.Proxy(SecondaryIndexProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SecondaryIndexProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the secondary index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIndexName();

    /**
     * The non-key attributes that are projected into the secondary index.
     * <p>
     * Default: - No additional attributes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNonKeyAttributes() {
        return null;
    }

    /**
     * The set of attributes that are projected into the secondary index.
     * <p>
     * Default: ALL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.ProjectionType getProjectionType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SecondaryIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecondaryIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SecondaryIndexProps> {
        java.lang.String indexName;
        java.util.List<java.lang.String> nonKeyAttributes;
        software.amazon.awscdk.services.dynamodb.ProjectionType projectionType;

        /**
         * Sets the value of {@link SecondaryIndexProps#getIndexName}
         * @param indexName The name of the secondary index. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexName(java.lang.String indexName) {
            this.indexName = indexName;
            return this;
        }

        /**
         * Sets the value of {@link SecondaryIndexProps#getNonKeyAttributes}
         * @param nonKeyAttributes The non-key attributes that are projected into the secondary index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nonKeyAttributes(java.util.List<java.lang.String> nonKeyAttributes) {
            this.nonKeyAttributes = nonKeyAttributes;
            return this;
        }

        /**
         * Sets the value of {@link SecondaryIndexProps#getProjectionType}
         * @param projectionType The set of attributes that are projected into the secondary index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectionType(software.amazon.awscdk.services.dynamodb.ProjectionType projectionType) {
            this.projectionType = projectionType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecondaryIndexProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SecondaryIndexProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SecondaryIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecondaryIndexProps {
        private final java.lang.String indexName;
        private final java.util.List<java.lang.String> nonKeyAttributes;
        private final software.amazon.awscdk.services.dynamodb.ProjectionType projectionType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nonKeyAttributes = software.amazon.jsii.Kernel.get(this, "nonKeyAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.projectionType = software.amazon.jsii.Kernel.get(this, "projectionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ProjectionType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
            this.nonKeyAttributes = builder.nonKeyAttributes;
            this.projectionType = builder.projectionType;
        }

        @Override
        public final java.lang.String getIndexName() {
            return this.indexName;
        }

        @Override
        public final java.util.List<java.lang.String> getNonKeyAttributes() {
            return this.nonKeyAttributes;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.ProjectionType getProjectionType() {
            return this.projectionType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("indexName", om.valueToTree(this.getIndexName()));
            if (this.getNonKeyAttributes() != null) {
                data.set("nonKeyAttributes", om.valueToTree(this.getNonKeyAttributes()));
            }
            if (this.getProjectionType() != null) {
                data.set("projectionType", om.valueToTree(this.getProjectionType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.SecondaryIndexProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecondaryIndexProps.Jsii$Proxy that = (SecondaryIndexProps.Jsii$Proxy) o;

            if (!indexName.equals(that.indexName)) return false;
            if (this.nonKeyAttributes != null ? !this.nonKeyAttributes.equals(that.nonKeyAttributes) : that.nonKeyAttributes != null) return false;
            return this.projectionType != null ? this.projectionType.equals(that.projectionType) : that.projectionType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.indexName.hashCode();
            result = 31 * result + (this.nonKeyAttributes != null ? this.nonKeyAttributes.hashCode() : 0);
            result = 31 * result + (this.projectionType != null ? this.projectionType.hashCode() : 0);
            return result;
        }
    }
}
