package software.amazon.awscdk.services.ec2;

/**
 * Supported EBS volume types for blockDevices.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Instance instance = Instance.Builder.create(this, "Instance")
 *         .instanceType(InstanceType.of(InstanceClass.M5, InstanceSize.XLARGE))
 *         .machineImage(new AmazonLinuxImage())
 *         .vpc(vpc)
 *         .hibernationEnabled(true)
 *         .blockDevices(List.of(BlockDevice.builder()
 *                 .deviceName("/dev/xvda")
 *                 .volume(BlockDeviceVolume.ebs(30, EbsDeviceOptions.builder()
 *                         .volumeType(EbsDeviceVolumeType.GP3)
 *                         .encrypted(true)
 *                         .deleteOnTermination(true)
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:32.757Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.EbsDeviceVolumeType")
public enum EbsDeviceVolumeType {
    /**
     * Magnetic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * Provisioned IOPS SSD - IO1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO1,
    /**
     * Provisioned IOPS SSD - IO2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO2,
    /**
     * General Purpose SSD - GP2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GP2,
    /**
     * General Purpose SSD - GP3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GP3,
    /**
     * Throughput Optimized HDD.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ST1,
    /**
     * Cold HDD.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SC1,
}
