package software.amazon.awscdk.services.ec2;

/**
 * Result of selecting a subset of subnets from a VPC.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc = Vpc.Builder.create(this, "TheVPC")
 *         .ipAddresses(IpAddresses.cidr("10.0.0.0/16"))
 *         .build();
 * // Iterate the private subnets
 * SelectedSubnets selection = vpc.selectSubnets(SubnetSelection.builder()
 *         .subnetType(SubnetType.PRIVATE_WITH_EGRESS)
 *         .build());
 * for (Object subnet : selection.getSubnets()) {
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:32.887Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.SelectedSubnets")
@software.amazon.jsii.Jsii.Proxy(SelectedSubnets.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SelectedSubnets extends software.amazon.jsii.JsiiSerializable {

    /**
     * The respective AZs of each subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAvailabilityZones();

    /**
     * Whether any of the given subnets are from the VPC's public subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getHasPublic();

    /**
     * Dependency representing internet connectivity for these subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.constructs.IDependable getInternetConnectivityEstablished();

    /**
     * The subnet IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

    /**
     * Selected subnet objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets();

    /**
     * The subnet selection is not actually real yet.
     * <p>
     * If this value is true, don't validate anything about the subnets. The count
     * or identities are not known yet, and the validation will most likely fail
     * which will prevent a successful lookup.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIsPendingLookup() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SelectedSubnets}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SelectedSubnets}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SelectedSubnets> {
        java.util.List<java.lang.String> availabilityZones;
        java.lang.Boolean hasPublic;
        software.constructs.IDependable internetConnectivityEstablished;
        java.util.List<java.lang.String> subnetIds;
        java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets;
        java.lang.Boolean isPendingLookup;

        /**
         * Sets the value of {@link SelectedSubnets#getAvailabilityZones}
         * @param availabilityZones The respective AZs of each subnet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * Sets the value of {@link SelectedSubnets#getHasPublic}
         * @param hasPublic Whether any of the given subnets are from the VPC's public subnets. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hasPublic(java.lang.Boolean hasPublic) {
            this.hasPublic = hasPublic;
            return this;
        }

        /**
         * Sets the value of {@link SelectedSubnets#getInternetConnectivityEstablished}
         * @param internetConnectivityEstablished Dependency representing internet connectivity for these subnets. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetConnectivityEstablished(software.constructs.IDependable internetConnectivityEstablished) {
            this.internetConnectivityEstablished = internetConnectivityEstablished;
            return this;
        }

        /**
         * Sets the value of {@link SelectedSubnets#getSubnetIds}
         * @param subnetIds The subnet IDs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of {@link SelectedSubnets#getSubnets}
         * @param subnets Selected subnet objects. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder subnets(java.util.List<? extends software.amazon.awscdk.services.ec2.ISubnet> subnets) {
            this.subnets = (java.util.List<software.amazon.awscdk.services.ec2.ISubnet>)subnets;
            return this;
        }

        /**
         * Sets the value of {@link SelectedSubnets#getIsPendingLookup}
         * @param isPendingLookup The subnet selection is not actually real yet.
         *                        If this value is true, don't validate anything about the subnets. The count
         *                        or identities are not known yet, and the validation will most likely fail
         *                        which will prevent a successful lookup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isPendingLookup(java.lang.Boolean isPendingLookup) {
            this.isPendingLookup = isPendingLookup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SelectedSubnets}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SelectedSubnets build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SelectedSubnets}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SelectedSubnets {
        private final java.util.List<java.lang.String> availabilityZones;
        private final java.lang.Boolean hasPublic;
        private final software.constructs.IDependable internetConnectivityEstablished;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets;
        private final java.lang.Boolean isPendingLookup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZones = software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.hasPublic = software.amazon.jsii.Kernel.get(this, "hasPublic", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.internetConnectivityEstablished = software.amazon.jsii.Kernel.get(this, "internetConnectivityEstablished", software.amazon.jsii.NativeType.forClass(software.constructs.IDependable.class));
            this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class)));
            this.isPendingLookup = software.amazon.jsii.Kernel.get(this, "isPendingLookup", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZones = java.util.Objects.requireNonNull(builder.availabilityZones, "availabilityZones is required");
            this.hasPublic = java.util.Objects.requireNonNull(builder.hasPublic, "hasPublic is required");
            this.internetConnectivityEstablished = java.util.Objects.requireNonNull(builder.internetConnectivityEstablished, "internetConnectivityEstablished is required");
            this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
            this.subnets = (java.util.List<software.amazon.awscdk.services.ec2.ISubnet>)java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
            this.isPendingLookup = builder.isPendingLookup;
        }

        @Override
        public final java.util.List<java.lang.String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final java.lang.Boolean getHasPublic() {
            return this.hasPublic;
        }

        @Override
        public final software.constructs.IDependable getInternetConnectivityEstablished() {
            return this.internetConnectivityEstablished;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets() {
            return this.subnets;
        }

        @Override
        public final java.lang.Boolean getIsPendingLookup() {
            return this.isPendingLookup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
            data.set("hasPublic", om.valueToTree(this.getHasPublic()));
            data.set("internetConnectivityEstablished", om.valueToTree(this.getInternetConnectivityEstablished()));
            data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            data.set("subnets", om.valueToTree(this.getSubnets()));
            if (this.getIsPendingLookup() != null) {
                data.set("isPendingLookup", om.valueToTree(this.getIsPendingLookup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.SelectedSubnets"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SelectedSubnets.Jsii$Proxy that = (SelectedSubnets.Jsii$Proxy) o;

            if (!availabilityZones.equals(that.availabilityZones)) return false;
            if (!hasPublic.equals(that.hasPublic)) return false;
            if (!internetConnectivityEstablished.equals(that.internetConnectivityEstablished)) return false;
            if (!subnetIds.equals(that.subnetIds)) return false;
            if (!subnets.equals(that.subnets)) return false;
            return this.isPendingLookup != null ? this.isPendingLookup.equals(that.isPendingLookup) : that.isPendingLookup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.availabilityZones.hashCode();
            result = 31 * result + (this.hasPublic.hashCode());
            result = 31 * result + (this.internetConnectivityEstablished.hashCode());
            result = 31 * result + (this.subnetIds.hashCode());
            result = 31 * result + (this.subnets.hashCode());
            result = 31 * result + (this.isPendingLookup != null ? this.isPendingLookup.hashCode() : 0);
            return result;
        }
    }
}
