package software.amazon.awscdk.services.ecr.assets;

/**
 * An asset that represents a Docker image.
 * <p>
 * The image will loaded from an existing tarball and uploaded to an ECR repository.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecr.assets.TarballImageAsset;
 * TarballImageAsset asset = TarballImageAsset.Builder.create(this, "MyBuildImage")
 *         .tarballFile("local-image.tar")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:32.992Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr_assets.TarballImageAsset")
public class TarballImageAsset extends software.constructs.Construct {

    protected TarballImageAsset(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TarballImageAsset(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public TarballImageAsset(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.TarballImageAssetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A hash of this asset, which is available at construction time.
     * <p>
     * As this is a plain string, it
     * can be used in construct IDs in order to enforce creation of a new resource when the content
     * hash has changed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssetHash() {
        return software.amazon.jsii.Kernel.get(this, "assetHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The tag of this asset when it is uploaded to ECR.
     * <p>
     * The tag may differ from the assetHash if a stack synthesizer adds a dockerTagPrefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImageTag() {
        return software.amazon.jsii.Kernel.get(this, "imageTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The full URI of the image (including a tag).
     * <p>
     * Use this reference to pull
     * the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImageUri() {
        return software.amazon.jsii.Kernel.get(this, "imageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The full URI of the image (including a tag).
     * <p>
     * Use this reference to pull
     * the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageUri(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "imageUri", java.util.Objects.requireNonNull(value, "imageUri is required"));
    }

    /**
     * Repository where the image is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository getRepository() {
        return software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.IRepository.class));
    }

    /**
     * Repository where the image is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository value) {
        software.amazon.jsii.Kernel.set(this, "repository", java.util.Objects.requireNonNull(value, "repository is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecr.assets.TarballImageAsset}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecr.assets.TarballImageAsset> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecr.assets.TarballImageAssetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecr.assets.TarballImageAssetProps.Builder();
        }

        /**
         * Absolute path to the tarball.
         * <p>
         * It is recommended to to use the script running directory (e.g. <code>__dirname</code>
         * in Node.js projects or dirname of <code>__file__</code> in Python) if your tarball
         * is located as a resource inside your project.
         * <p>
         * @return {@code this}
         * @param tarballFile Absolute path to the tarball. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tarballFile(final java.lang.String tarballFile) {
            this.props.tarballFile(tarballFile);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecr.assets.TarballImageAsset}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecr.assets.TarballImageAsset build() {
            return new software.amazon.awscdk.services.ecr.assets.TarballImageAsset(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
