package software.amazon.awscdk.services.ecs;

/**
 * Construct an Bottlerocket image from the latest AMI published in SSM.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * cluster.addCapacity("bottlerocket-asg", AddCapacityOptions.builder()
 *         .minCapacity(2)
 *         .instanceType(new InstanceType("c5.large"))
 *         .machineImage(new BottleRocketImage())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:33.044Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.BottleRocketImage")
public class BottleRocketImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IMachineImage {

    protected BottleRocketImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BottleRocketImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the BottleRocketImage class.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BottleRocketImage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.BottleRocketImageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     * Constructs a new instance of the BottleRocketImage class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BottleRocketImage() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Return whether the given object is a BottleRocketImage.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isBottleRocketImage(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.BottleRocketImage.class, "isBottleRocketImage", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Return the correct image.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MachineImageConfig getImage(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "getImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.MachineImageConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.BottleRocketImage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.BottleRocketImage> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.ecs.BottleRocketImageProps.Builder props;

        private Builder() {
        }

        /**
         * The CPU architecture.
         * <p>
         * Default: - x86_64
         * <p>
         * @return {@code this}
         * @param architecture The CPU architecture. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder architecture(final software.amazon.awscdk.services.ec2.InstanceArchitecture architecture) {
            this.props().architecture(architecture);
            return this;
        }

        /**
         * Whether the AMI ID is cached to be stable between deployments.
         * <p>
         * By default, the newest image is used on each deployment. This will cause
         * instances to be replaced whenever a new version is released, and may cause
         * downtime if there aren't enough running instances in the AutoScalingGroup
         * to reschedule the tasks on.
         * <p>
         * If set to true, the AMI ID will be cached in <code>cdk.context.json</code> and the
         * same value will be used on future runs. Your instances will not be replaced
         * but your AMI version will grow old over time. To refresh the AMI lookup,
         * you will have to evict the value from the cache using the <code>cdk context</code>
         * command. See https://docs.aws.amazon.com/cdk/latest/guide/context.html for
         * more information.
         * <p>
         * Can not be set to <code>true</code> in environment-agnostic stacks.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param cachedInContext Whether the AMI ID is cached to be stable between deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachedInContext(final java.lang.Boolean cachedInContext) {
            this.props().cachedInContext(cachedInContext);
            return this;
        }

        /**
         * The Amazon ECS variant to use.
         * <p>
         * Default: - BottlerocketEcsVariant.AWS_ECS_1
         * <p>
         * @return {@code this}
         * @param variant The Amazon ECS variant to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variant(final software.amazon.awscdk.services.ecs.BottlerocketEcsVariant variant) {
            this.props().variant(variant);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.BottleRocketImage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.BottleRocketImage build() {
            return new software.amazon.awscdk.services.ecs.BottleRocketImage(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.BottleRocketImageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.BottleRocketImageProps.Builder();
            }
            return this.props;
        }
    }
}
