package software.amazon.awscdk.services.ecs;

/**
 * Configuration for a credential specification (CredSpec) used for a ECS container.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * CredentialSpecConfig credentialSpecConfig = CredentialSpecConfig.builder()
 *         .location("location")
 *         .typePrefix("typePrefix")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:33.193Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CredentialSpecConfig")
@software.amazon.jsii.Jsii.Proxy(CredentialSpecConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CredentialSpecConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Location of the CredSpec file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLocation();

    /**
     * Prefix used for the CredSpec string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTypePrefix();

    /**
     * @return a {@link Builder} of {@link CredentialSpecConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CredentialSpecConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CredentialSpecConfig> {
        java.lang.String location;
        java.lang.String typePrefix;

        /**
         * Sets the value of {@link CredentialSpecConfig#getLocation}
         * @param location Location of the CredSpec file. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder location(java.lang.String location) {
            this.location = location;
            return this;
        }

        /**
         * Sets the value of {@link CredentialSpecConfig#getTypePrefix}
         * @param typePrefix Prefix used for the CredSpec string. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typePrefix(java.lang.String typePrefix) {
            this.typePrefix = typePrefix;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CredentialSpecConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CredentialSpecConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CredentialSpecConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CredentialSpecConfig {
        private final java.lang.String location;
        private final java.lang.String typePrefix;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.typePrefix = software.amazon.jsii.Kernel.get(this, "typePrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.location = java.util.Objects.requireNonNull(builder.location, "location is required");
            this.typePrefix = java.util.Objects.requireNonNull(builder.typePrefix, "typePrefix is required");
        }

        @Override
        public final java.lang.String getLocation() {
            return this.location;
        }

        @Override
        public final java.lang.String getTypePrefix() {
            return this.typePrefix;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("location", om.valueToTree(this.getLocation()));
            data.set("typePrefix", om.valueToTree(this.getTypePrefix()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CredentialSpecConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CredentialSpecConfig.Jsii$Proxy that = (CredentialSpecConfig.Jsii$Proxy) o;

            if (!location.equals(that.location)) return false;
            return this.typePrefix.equals(that.typePrefix);
        }

        @Override
        public final int hashCode() {
            int result = this.location.hashCode();
            result = 31 * result + (this.typePrefix.hashCode());
            return result;
        }
    }
}
