package software.amazon.awscdk.services.ecs;

/**
 * The details of a task definition run on an External cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ExternalTaskDefinition externalTaskDefinition = new ExternalTaskDefinition(this, "TaskDef");
 * ContainerDefinition container = externalTaskDefinition.addContainer("WebContainer", ContainerDefinitionOptions.builder()
 *         // Use an image from DockerHub
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .memoryLimitMiB(1024)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:33.212Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ExternalTaskDefinition")
public class ExternalTaskDefinition extends software.amazon.awscdk.services.ecs.TaskDefinition implements software.amazon.awscdk.services.ecs.IExternalTaskDefinition {

    protected ExternalTaskDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ExternalTaskDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the ExternalTaskDefinition class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ExternalTaskDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ExternalTaskDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Constructs a new instance of the ExternalTaskDefinition class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ExternalTaskDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Imports a task definition from the specified task definition ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param externalTaskDefinitionArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IExternalTaskDefinition fromEc2TaskDefinitionArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String externalTaskDefinitionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.ExternalTaskDefinition.class, "fromEc2TaskDefinitionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IExternalTaskDefinition.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(externalTaskDefinitionArn, "externalTaskDefinitionArn is required") });
    }

    /**
     * Imports an existing External task definition from its attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IExternalTaskDefinition fromExternalTaskDefinitionAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ExternalTaskDefinitionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.ExternalTaskDefinition.class, "fromExternalTaskDefinitionAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IExternalTaskDefinition.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Overriden method to throw error as interface accelerators are not supported for external tasks.
     * <p>
     * @param _inferenceAccelerator This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addInferenceAccelerator(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.InferenceAccelerator _inferenceAccelerator) {
        software.amazon.jsii.Kernel.call(this, "addInferenceAccelerator", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(_inferenceAccelerator, "_inferenceAccelerator is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.ExternalTaskDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.ExternalTaskDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecs.ExternalTaskDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of the IAM task execution role that grants the ECS agent permission to call AWS APIs on your behalf.
         * <p>
         * The role will be used to retrieve container images from ECR and create CloudWatch log groups.
         * <p>
         * Default: - An execution role will be automatically created if you use ECR images in your task definition.
         * <p>
         * @return {@code this}
         * @param executionRole The name of the IAM task execution role that grants the ECS agent permission to call AWS APIs on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(final software.amazon.awscdk.services.iam.IRole executionRole) {
            this.props().executionRole(executionRole);
            return this;
        }

        /**
         * The name of a family that this task definition is registered to.
         * <p>
         * A family groups multiple versions of a task definition.
         * <p>
         * Default: - Automatically generated name.
         * <p>
         * @return {@code this}
         * @param family The name of a family that this task definition is registered to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(final java.lang.String family) {
            this.props().family(family);
            return this;
        }

        /**
         * The configuration details for the App Mesh proxy.
         * <p>
         * Default: - No proxy configuration.
         * <p>
         * @return {@code this}
         * @param proxyConfiguration The configuration details for the App Mesh proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyConfiguration(final software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration) {
            this.props().proxyConfiguration(proxyConfiguration);
            return this;
        }

        /**
         * The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf.
         * <p>
         * Default: - A task role is automatically created for you.
         * <p>
         * @return {@code this}
         * @param taskRole The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskRole(final software.amazon.awscdk.services.iam.IRole taskRole) {
            this.props().taskRole(taskRole);
            return this;
        }

        /**
         * The list of volume definitions for the task.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide//task_definition_parameters.html#volumes">Task Definition Parameter Volumes</a>.
         * <p>
         * Default: - No volumes are passed to the Docker daemon on a container instance.
         * <p>
         * @return {@code this}
         * @param volumes The list of volume definitions for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<? extends software.amazon.awscdk.services.ecs.Volume> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        /**
         * The networking mode to use for the containers in the task.
         * <p>
         * With ECS Anywhere, supported modes are bridge, host and none.
         * <p>
         * Default: NetworkMode.BRIDGE
         * <p>
         * @return {@code this}
         * @param networkMode The networking mode to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkMode(final software.amazon.awscdk.services.ecs.NetworkMode networkMode) {
            this.props().networkMode(networkMode);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.ExternalTaskDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.ExternalTaskDefinition build() {
            return new software.amazon.awscdk.services.ecs.ExternalTaskDefinition(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.ExternalTaskDefinitionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.ExternalTaskDefinitionProps.Builder();
            }
            return this.props;
        }
    }
}
