package software.amazon.awscdk.services.ecs;

/**
 * The properties for enabling target tracking scaling based on a custom CloudWatch metric.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * import software.amazon.awscdk.services.ecs.*;
 * Metric metric;
 * TrackCustomMetricProps trackCustomMetricProps = TrackCustomMetricProps.builder()
 *         .metric(metric)
 *         .targetValue(123)
 *         // the properties below are optional
 *         .disableScaleIn(false)
 *         .policyName("policyName")
 *         .scaleInCooldown(Duration.minutes(30))
 *         .scaleOutCooldown(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:33.318Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.TrackCustomMetricProps")
@software.amazon.jsii.Jsii.Proxy(TrackCustomMetricProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TrackCustomMetricProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.applicationautoscaling.BaseTargetTrackingProps {

    /**
     * The custom CloudWatch metric to track.
     * <p>
     * The metric must represent utilization; that is, you will always get the following behavior:
     * <p>
     * <ul>
     * <li>metric &gt; targetValue =&gt; scale out</li>
     * <li>metric &lt; targetValue =&gt; scale in</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric getMetric();

    /**
     * The target value for the custom CloudWatch metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getTargetValue();

    /**
     * @return a {@link Builder} of {@link TrackCustomMetricProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TrackCustomMetricProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TrackCustomMetricProps> {
        software.amazon.awscdk.services.cloudwatch.IMetric metric;
        java.lang.Number targetValue;
        java.lang.Boolean disableScaleIn;
        java.lang.String policyName;
        software.amazon.awscdk.Duration scaleInCooldown;
        software.amazon.awscdk.Duration scaleOutCooldown;

        /**
         * Sets the value of {@link TrackCustomMetricProps#getMetric}
         * @param metric The custom CloudWatch metric to track. This parameter is required.
         *               The metric must represent utilization; that is, you will always get the following behavior:
         *               <p>
         *               <ul>
         *               <li>metric &gt; targetValue =&gt; scale out</li>
         *               <li>metric &lt; targetValue =&gt; scale in</li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metric(software.amazon.awscdk.services.cloudwatch.IMetric metric) {
            this.metric = metric;
            return this;
        }

        /**
         * Sets the value of {@link TrackCustomMetricProps#getTargetValue}
         * @param targetValue The target value for the custom CloudWatch metric. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetValue(java.lang.Number targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        /**
         * Sets the value of {@link TrackCustomMetricProps#getDisableScaleIn}
         * @param disableScaleIn Indicates whether scale in by the target tracking policy is disabled.
         *                       If the value is true, scale in is disabled and the target tracking policy
         *                       won't remove capacity from the scalable resource. Otherwise, scale in is
         *                       enabled and the target tracking policy can remove capacity from the
         *                       scalable resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableScaleIn(java.lang.Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        /**
         * Sets the value of {@link TrackCustomMetricProps#getPolicyName}
         * @param policyName A name for the scaling policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(java.lang.String policyName) {
            this.policyName = policyName;
            return this;
        }

        /**
         * Sets the value of {@link TrackCustomMetricProps#getScaleInCooldown}
         * @param scaleInCooldown Period after a scale in activity completes before another scale in activity can start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleInCooldown(software.amazon.awscdk.Duration scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
            return this;
        }

        /**
         * Sets the value of {@link TrackCustomMetricProps#getScaleOutCooldown}
         * @param scaleOutCooldown Period after a scale out activity completes before another scale out activity can start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleOutCooldown(software.amazon.awscdk.Duration scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TrackCustomMetricProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TrackCustomMetricProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TrackCustomMetricProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrackCustomMetricProps {
        private final software.amazon.awscdk.services.cloudwatch.IMetric metric;
        private final java.lang.Number targetValue;
        private final java.lang.Boolean disableScaleIn;
        private final java.lang.String policyName;
        private final software.amazon.awscdk.Duration scaleInCooldown;
        private final software.amazon.awscdk.Duration scaleOutCooldown;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metric = software.amazon.jsii.Kernel.get(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class));
            this.targetValue = software.amazon.jsii.Kernel.get(this, "targetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.disableScaleIn = software.amazon.jsii.Kernel.get(this, "disableScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.policyName = software.amazon.jsii.Kernel.get(this, "policyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scaleInCooldown = software.amazon.jsii.Kernel.get(this, "scaleInCooldown", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.scaleOutCooldown = software.amazon.jsii.Kernel.get(this, "scaleOutCooldown", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metric = java.util.Objects.requireNonNull(builder.metric, "metric is required");
            this.targetValue = java.util.Objects.requireNonNull(builder.targetValue, "targetValue is required");
            this.disableScaleIn = builder.disableScaleIn;
            this.policyName = builder.policyName;
            this.scaleInCooldown = builder.scaleInCooldown;
            this.scaleOutCooldown = builder.scaleOutCooldown;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.IMetric getMetric() {
            return this.metric;
        }

        @Override
        public final java.lang.Number getTargetValue() {
            return this.targetValue;
        }

        @Override
        public final java.lang.Boolean getDisableScaleIn() {
            return this.disableScaleIn;
        }

        @Override
        public final java.lang.String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final software.amazon.awscdk.Duration getScaleInCooldown() {
            return this.scaleInCooldown;
        }

        @Override
        public final software.amazon.awscdk.Duration getScaleOutCooldown() {
            return this.scaleOutCooldown;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("metric", om.valueToTree(this.getMetric()));
            data.set("targetValue", om.valueToTree(this.getTargetValue()));
            if (this.getDisableScaleIn() != null) {
                data.set("disableScaleIn", om.valueToTree(this.getDisableScaleIn()));
            }
            if (this.getPolicyName() != null) {
                data.set("policyName", om.valueToTree(this.getPolicyName()));
            }
            if (this.getScaleInCooldown() != null) {
                data.set("scaleInCooldown", om.valueToTree(this.getScaleInCooldown()));
            }
            if (this.getScaleOutCooldown() != null) {
                data.set("scaleOutCooldown", om.valueToTree(this.getScaleOutCooldown()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.TrackCustomMetricProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TrackCustomMetricProps.Jsii$Proxy that = (TrackCustomMetricProps.Jsii$Proxy) o;

            if (!metric.equals(that.metric)) return false;
            if (!targetValue.equals(that.targetValue)) return false;
            if (this.disableScaleIn != null ? !this.disableScaleIn.equals(that.disableScaleIn) : that.disableScaleIn != null) return false;
            if (this.policyName != null ? !this.policyName.equals(that.policyName) : that.policyName != null) return false;
            if (this.scaleInCooldown != null ? !this.scaleInCooldown.equals(that.scaleInCooldown) : that.scaleInCooldown != null) return false;
            return this.scaleOutCooldown != null ? this.scaleOutCooldown.equals(that.scaleOutCooldown) : that.scaleOutCooldown == null;
        }

        @Override
        public final int hashCode() {
            int result = this.metric.hashCode();
            result = 31 * result + (this.targetValue.hashCode());
            result = 31 * result + (this.disableScaleIn != null ? this.disableScaleIn.hashCode() : 0);
            result = 31 * result + (this.policyName != null ? this.policyName.hashCode() : 0);
            result = 31 * result + (this.scaleInCooldown != null ? this.scaleInCooldown.hashCode() : 0);
            result = 31 * result + (this.scaleOutCooldown != null ? this.scaleOutCooldown.hashCode() : 0);
            return result;
        }
    }
}
