package software.amazon.awscdk.services.elasticloadbalancingv2.targets;

/**
 * An EC2 instance that is the target for load balancing.
 * <p>
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can connect to the instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.targets.*;
 * InstanceIdTarget instanceIdTarget = new InstanceIdTarget("instanceId", 123);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:33.889Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2_targets.InstanceIdTarget")
public class InstanceIdTarget extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget, software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget {

    protected InstanceIdTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InstanceIdTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create a new Instance target.
     * <p>
     * @param instanceId Instance ID of the instance to register to. This parameter is required.
     * @param port Override the default port for the target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InstanceIdTarget(final @org.jetbrains.annotations.NotNull java.lang.String instanceId, final @org.jetbrains.annotations.Nullable java.lang.Number port) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(instanceId, "instanceId is required"), port });
    }

    /**
     * Create a new Instance target.
     * <p>
     * @param instanceId Instance ID of the instance to register to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InstanceIdTarget(final @org.jetbrains.annotations.NotNull java.lang.String instanceId) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(instanceId, "instanceId is required") });
    }

    /**
     * Register this instance target with a load balancer.
     * <p>
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     * <p>
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToApplicationTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup targetGroup) {
        return software.amazon.jsii.Kernel.call(this, "attachToApplicationTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }

    /**
     * Register this instance target with a load balancer.
     * <p>
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     * <p>
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToNetworkTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup targetGroup) {
        return software.amazon.jsii.Kernel.call(this, "attachToNetworkTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }
}
