package software.amazon.awscdk.services.emrserverless;

/**
 * Properties for defining a <code>CfnApplication</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.emrserverless.*;
 * ConfigurationObjectProperty configurationObjectProperty_;
 * CfnApplicationProps cfnApplicationProps = CfnApplicationProps.builder()
 *         .releaseLabel("releaseLabel")
 *         .type("type")
 *         // the properties below are optional
 *         .architecture("architecture")
 *         .autoStartConfiguration(AutoStartConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .autoStopConfiguration(AutoStopConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .idleTimeoutMinutes(123)
 *                 .build())
 *         .imageConfiguration(ImageConfigurationInputProperty.builder()
 *                 .imageUri("imageUri")
 *                 .build())
 *         .initialCapacity(List.of(InitialCapacityConfigKeyValuePairProperty.builder()
 *                 .key("key")
 *                 .value(InitialCapacityConfigProperty.builder()
 *                         .workerConfiguration(WorkerConfigurationProperty.builder()
 *                                 .cpu("cpu")
 *                                 .memory("memory")
 *                                 // the properties below are optional
 *                                 .disk("disk")
 *                                 .diskType("diskType")
 *                                 .build())
 *                         .workerCount(123)
 *                         .build())
 *                 .build()))
 *         .maximumCapacity(MaximumAllowedResourcesProperty.builder()
 *                 .cpu("cpu")
 *                 .memory("memory")
 *                 // the properties below are optional
 *                 .disk("disk")
 *                 .build())
 *         .monitoringConfiguration(MonitoringConfigurationProperty.builder()
 *                 .cloudWatchLoggingConfiguration(CloudWatchLoggingConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .encryptionKeyArn("encryptionKeyArn")
 *                         .logGroupName("logGroupName")
 *                         .logStreamNamePrefix("logStreamNamePrefix")
 *                         .logTypeMap(List.of(LogTypeMapKeyValuePairProperty.builder()
 *                                 .key("key")
 *                                 .value(List.of("value"))
 *                                 .build()))
 *                         .build())
 *                 .managedPersistenceMonitoringConfiguration(ManagedPersistenceMonitoringConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .encryptionKeyArn("encryptionKeyArn")
 *                         .build())
 *                 .s3MonitoringConfiguration(S3MonitoringConfigurationProperty.builder()
 *                         .encryptionKeyArn("encryptionKeyArn")
 *                         .logUri("logUri")
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .runtimeConfiguration(List.of(ConfigurationObjectProperty.builder()
 *                 .classification("classification")
 *                 // the properties below are optional
 *                 .configurations(List.of(configurationObjectProperty_))
 *                 .properties(Map.of(
 *                         "propertiesKey", "properties"))
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .workerTypeSpecifications(Map.of(
 *                 "workerTypeSpecificationsKey", WorkerTypeSpecificationInputProperty.builder()
 *                         .imageConfiguration(ImageConfigurationInputProperty.builder()
 *                                 .imageUri("imageUri")
 *                                 .build())
 *                         .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:34.059Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplicationProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The EMR release associated with the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-releaselabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-releaselabel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReleaseLabel();

    /**
     * The type of application, such as Spark or Hive.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The CPU architecture of an application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-architecture">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-architecture</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getArchitecture() {
        return null;
    }

    /**
     * The configuration for an application to automatically start on job submission.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-autostartconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-autostartconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoStartConfiguration() {
        return null;
    }

    /**
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-autostopconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-autostopconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoStopConfiguration() {
        return null;
    }

    /**
     * The image configuration applied to all worker types.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-imageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-imageconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getImageConfiguration() {
        return null;
    }

    /**
     * The initial capacity of the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-initialcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-initialcapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInitialCapacity() {
        return null;
    }

    /**
     * The maximum capacity of the application.
     * <p>
     * This is cumulative across all workers at any given point in time during the lifespan of the application is created. No new resources will be created once any one of the defined limits is hit.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-maximumcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-maximumcapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMaximumCapacity() {
        return null;
    }

    /**
     * A configuration specification to be used when provisioning an application.
     * <p>
     * A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-monitoringconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-monitoringconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMonitoringConfiguration() {
        return null;
    }

    /**
     * The name of the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The network configuration for customer VPC connectivity for the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-networkconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
        return null;
    }

    /**
     * The <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">Configuration</a> specifications of an application. Each configuration consists of a classification and properties. You use this parameter when creating or updating an application. To see the runtimeConfiguration object of an application, run the <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_GetApplication.html">GetApplication</a> API operation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-runtimeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-runtimeconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRuntimeConfiguration() {
        return null;
    }

    /**
     * The tags assigned to the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The specification applied to each worker type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-workertypespecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-workertypespecifications</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWorkerTypeSpecifications() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationProps> {
        java.lang.String releaseLabel;
        java.lang.String type;
        java.lang.String architecture;
        java.lang.Object autoStartConfiguration;
        java.lang.Object autoStopConfiguration;
        java.lang.Object imageConfiguration;
        java.lang.Object initialCapacity;
        java.lang.Object maximumCapacity;
        java.lang.Object monitoringConfiguration;
        java.lang.String name;
        java.lang.Object networkConfiguration;
        java.lang.Object runtimeConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object workerTypeSpecifications;

        /**
         * Sets the value of {@link CfnApplicationProps#getReleaseLabel}
         * @param releaseLabel The EMR release associated with the application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder releaseLabel(java.lang.String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getType}
         * @param type The type of application, such as Spark or Hive. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getArchitecture}
         * @param architecture The CPU architecture of an application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder architecture(java.lang.String architecture) {
            this.architecture = architecture;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getAutoStartConfiguration}
         * @param autoStartConfiguration The configuration for an application to automatically start on job submission.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoStartConfiguration(software.amazon.awscdk.IResolvable autoStartConfiguration) {
            this.autoStartConfiguration = autoStartConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getAutoStartConfiguration}
         * @param autoStartConfiguration The configuration for an application to automatically start on job submission.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoStartConfiguration(software.amazon.awscdk.services.emrserverless.CfnApplication.AutoStartConfigurationProperty autoStartConfiguration) {
            this.autoStartConfiguration = autoStartConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getAutoStopConfiguration}
         * @param autoStopConfiguration The configuration for an application to automatically stop after a certain amount of time being idle.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoStopConfiguration(software.amazon.awscdk.IResolvable autoStopConfiguration) {
            this.autoStopConfiguration = autoStopConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getAutoStopConfiguration}
         * @param autoStopConfiguration The configuration for an application to automatically stop after a certain amount of time being idle.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoStopConfiguration(software.amazon.awscdk.services.emrserverless.CfnApplication.AutoStopConfigurationProperty autoStopConfiguration) {
            this.autoStopConfiguration = autoStopConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getImageConfiguration}
         * @param imageConfiguration The image configuration applied to all worker types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageConfiguration(software.amazon.awscdk.IResolvable imageConfiguration) {
            this.imageConfiguration = imageConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getImageConfiguration}
         * @param imageConfiguration The image configuration applied to all worker types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageConfiguration(software.amazon.awscdk.services.emrserverless.CfnApplication.ImageConfigurationInputProperty imageConfiguration) {
            this.imageConfiguration = imageConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getInitialCapacity}
         * @param initialCapacity The initial capacity of the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialCapacity(software.amazon.awscdk.IResolvable initialCapacity) {
            this.initialCapacity = initialCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getInitialCapacity}
         * @param initialCapacity The initial capacity of the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialCapacity(java.util.List<? extends java.lang.Object> initialCapacity) {
            this.initialCapacity = initialCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getMaximumCapacity}
         * @param maximumCapacity The maximum capacity of the application.
         *                        This is cumulative across all workers at any given point in time during the lifespan of the application is created. No new resources will be created once any one of the defined limits is hit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumCapacity(software.amazon.awscdk.IResolvable maximumCapacity) {
            this.maximumCapacity = maximumCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getMaximumCapacity}
         * @param maximumCapacity The maximum capacity of the application.
         *                        This is cumulative across all workers at any given point in time during the lifespan of the application is created. No new resources will be created once any one of the defined limits is hit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumCapacity(software.amazon.awscdk.services.emrserverless.CfnApplication.MaximumAllowedResourcesProperty maximumCapacity) {
            this.maximumCapacity = maximumCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getMonitoringConfiguration}
         * @param monitoringConfiguration A configuration specification to be used when provisioning an application.
         *                                A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringConfiguration(software.amazon.awscdk.IResolvable monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getMonitoringConfiguration}
         * @param monitoringConfiguration A configuration specification to be used when provisioning an application.
         *                                A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringConfiguration(software.amazon.awscdk.services.emrserverless.CfnApplication.MonitoringConfigurationProperty monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getName}
         * @param name The name of the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getNetworkConfiguration}
         * @param networkConfiguration The network configuration for customer VPC connectivity for the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(software.amazon.awscdk.IResolvable networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getNetworkConfiguration}
         * @param networkConfiguration The network configuration for customer VPC connectivity for the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(software.amazon.awscdk.services.emrserverless.CfnApplication.NetworkConfigurationProperty networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getRuntimeConfiguration}
         * @param runtimeConfiguration The <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">Configuration</a> specifications of an application. Each configuration consists of a classification and properties. You use this parameter when creating or updating an application. To see the runtimeConfiguration object of an application, run the <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_GetApplication.html">GetApplication</a> API operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeConfiguration(software.amazon.awscdk.IResolvable runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getRuntimeConfiguration}
         * @param runtimeConfiguration The <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">Configuration</a> specifications of an application. Each configuration consists of a classification and properties. You use this parameter when creating or updating an application. To see the runtimeConfiguration object of an application, run the <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_GetApplication.html">GetApplication</a> API operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeConfiguration(java.util.List<? extends java.lang.Object> runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getTags}
         * @param tags The tags assigned to the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getWorkerTypeSpecifications}
         * @param workerTypeSpecifications The specification applied to each worker type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workerTypeSpecifications(software.amazon.awscdk.IResolvable workerTypeSpecifications) {
            this.workerTypeSpecifications = workerTypeSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getWorkerTypeSpecifications}
         * @param workerTypeSpecifications The specification applied to each worker type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workerTypeSpecifications(java.util.Map<java.lang.String, ? extends java.lang.Object> workerTypeSpecifications) {
            this.workerTypeSpecifications = workerTypeSpecifications;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationProps {
        private final java.lang.String releaseLabel;
        private final java.lang.String type;
        private final java.lang.String architecture;
        private final java.lang.Object autoStartConfiguration;
        private final java.lang.Object autoStopConfiguration;
        private final java.lang.Object imageConfiguration;
        private final java.lang.Object initialCapacity;
        private final java.lang.Object maximumCapacity;
        private final java.lang.Object monitoringConfiguration;
        private final java.lang.String name;
        private final java.lang.Object networkConfiguration;
        private final java.lang.Object runtimeConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object workerTypeSpecifications;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.releaseLabel = software.amazon.jsii.Kernel.get(this, "releaseLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.architecture = software.amazon.jsii.Kernel.get(this, "architecture", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoStartConfiguration = software.amazon.jsii.Kernel.get(this, "autoStartConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.autoStopConfiguration = software.amazon.jsii.Kernel.get(this, "autoStopConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.imageConfiguration = software.amazon.jsii.Kernel.get(this, "imageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.initialCapacity = software.amazon.jsii.Kernel.get(this, "initialCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maximumCapacity = software.amazon.jsii.Kernel.get(this, "maximumCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.monitoringConfiguration = software.amazon.jsii.Kernel.get(this, "monitoringConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkConfiguration = software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.runtimeConfiguration = software.amazon.jsii.Kernel.get(this, "runtimeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.workerTypeSpecifications = software.amazon.jsii.Kernel.get(this, "workerTypeSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.releaseLabel = java.util.Objects.requireNonNull(builder.releaseLabel, "releaseLabel is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.architecture = builder.architecture;
            this.autoStartConfiguration = builder.autoStartConfiguration;
            this.autoStopConfiguration = builder.autoStopConfiguration;
            this.imageConfiguration = builder.imageConfiguration;
            this.initialCapacity = builder.initialCapacity;
            this.maximumCapacity = builder.maximumCapacity;
            this.monitoringConfiguration = builder.monitoringConfiguration;
            this.name = builder.name;
            this.networkConfiguration = builder.networkConfiguration;
            this.runtimeConfiguration = builder.runtimeConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.workerTypeSpecifications = builder.workerTypeSpecifications;
        }

        @Override
        public final java.lang.String getReleaseLabel() {
            return this.releaseLabel;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final java.lang.Object getAutoStartConfiguration() {
            return this.autoStartConfiguration;
        }

        @Override
        public final java.lang.Object getAutoStopConfiguration() {
            return this.autoStopConfiguration;
        }

        @Override
        public final java.lang.Object getImageConfiguration() {
            return this.imageConfiguration;
        }

        @Override
        public final java.lang.Object getInitialCapacity() {
            return this.initialCapacity;
        }

        @Override
        public final java.lang.Object getMaximumCapacity() {
            return this.maximumCapacity;
        }

        @Override
        public final java.lang.Object getMonitoringConfiguration() {
            return this.monitoringConfiguration;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getNetworkConfiguration() {
            return this.networkConfiguration;
        }

        @Override
        public final java.lang.Object getRuntimeConfiguration() {
            return this.runtimeConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getWorkerTypeSpecifications() {
            return this.workerTypeSpecifications;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("releaseLabel", om.valueToTree(this.getReleaseLabel()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getArchitecture() != null) {
                data.set("architecture", om.valueToTree(this.getArchitecture()));
            }
            if (this.getAutoStartConfiguration() != null) {
                data.set("autoStartConfiguration", om.valueToTree(this.getAutoStartConfiguration()));
            }
            if (this.getAutoStopConfiguration() != null) {
                data.set("autoStopConfiguration", om.valueToTree(this.getAutoStopConfiguration()));
            }
            if (this.getImageConfiguration() != null) {
                data.set("imageConfiguration", om.valueToTree(this.getImageConfiguration()));
            }
            if (this.getInitialCapacity() != null) {
                data.set("initialCapacity", om.valueToTree(this.getInitialCapacity()));
            }
            if (this.getMaximumCapacity() != null) {
                data.set("maximumCapacity", om.valueToTree(this.getMaximumCapacity()));
            }
            if (this.getMonitoringConfiguration() != null) {
                data.set("monitoringConfiguration", om.valueToTree(this.getMonitoringConfiguration()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getNetworkConfiguration() != null) {
                data.set("networkConfiguration", om.valueToTree(this.getNetworkConfiguration()));
            }
            if (this.getRuntimeConfiguration() != null) {
                data.set("runtimeConfiguration", om.valueToTree(this.getRuntimeConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWorkerTypeSpecifications() != null) {
                data.set("workerTypeSpecifications", om.valueToTree(this.getWorkerTypeSpecifications()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplicationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationProps.Jsii$Proxy that = (CfnApplicationProps.Jsii$Proxy) o;

            if (!releaseLabel.equals(that.releaseLabel)) return false;
            if (!type.equals(that.type)) return false;
            if (this.architecture != null ? !this.architecture.equals(that.architecture) : that.architecture != null) return false;
            if (this.autoStartConfiguration != null ? !this.autoStartConfiguration.equals(that.autoStartConfiguration) : that.autoStartConfiguration != null) return false;
            if (this.autoStopConfiguration != null ? !this.autoStopConfiguration.equals(that.autoStopConfiguration) : that.autoStopConfiguration != null) return false;
            if (this.imageConfiguration != null ? !this.imageConfiguration.equals(that.imageConfiguration) : that.imageConfiguration != null) return false;
            if (this.initialCapacity != null ? !this.initialCapacity.equals(that.initialCapacity) : that.initialCapacity != null) return false;
            if (this.maximumCapacity != null ? !this.maximumCapacity.equals(that.maximumCapacity) : that.maximumCapacity != null) return false;
            if (this.monitoringConfiguration != null ? !this.monitoringConfiguration.equals(that.monitoringConfiguration) : that.monitoringConfiguration != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.networkConfiguration != null ? !this.networkConfiguration.equals(that.networkConfiguration) : that.networkConfiguration != null) return false;
            if (this.runtimeConfiguration != null ? !this.runtimeConfiguration.equals(that.runtimeConfiguration) : that.runtimeConfiguration != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.workerTypeSpecifications != null ? this.workerTypeSpecifications.equals(that.workerTypeSpecifications) : that.workerTypeSpecifications == null;
        }

        @Override
        public final int hashCode() {
            int result = this.releaseLabel.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.architecture != null ? this.architecture.hashCode() : 0);
            result = 31 * result + (this.autoStartConfiguration != null ? this.autoStartConfiguration.hashCode() : 0);
            result = 31 * result + (this.autoStopConfiguration != null ? this.autoStopConfiguration.hashCode() : 0);
            result = 31 * result + (this.imageConfiguration != null ? this.imageConfiguration.hashCode() : 0);
            result = 31 * result + (this.initialCapacity != null ? this.initialCapacity.hashCode() : 0);
            result = 31 * result + (this.maximumCapacity != null ? this.maximumCapacity.hashCode() : 0);
            result = 31 * result + (this.monitoringConfiguration != null ? this.monitoringConfiguration.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.networkConfiguration != null ? this.networkConfiguration.hashCode() : 0);
            result = 31 * result + (this.runtimeConfiguration != null ? this.runtimeConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.workerTypeSpecifications != null ? this.workerTypeSpecifications.hashCode() : 0);
            return result;
        }
    }
}
