package software.amazon.awscdk.services.entityresolution;

/**
 * Properties for defining a <code>CfnMatchingWorkflow</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.entityresolution.*;
 * CfnMatchingWorkflowProps cfnMatchingWorkflowProps = CfnMatchingWorkflowProps.builder()
 *         .inputSourceConfig(List.of(InputSourceProperty.builder()
 *                 .inputSourceArn("inputSourceArn")
 *                 .schemaArn("schemaArn")
 *                 // the properties below are optional
 *                 .applyNormalization(false)
 *                 .build()))
 *         .outputSourceConfig(List.of(OutputSourceProperty.builder()
 *                 .output(List.of(OutputAttributeProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .hashed(false)
 *                         .build()))
 *                 .outputS3Path("outputS3Path")
 *                 // the properties below are optional
 *                 .applyNormalization(false)
 *                 .kmsArn("kmsArn")
 *                 .build()))
 *         .resolutionTechniques(ResolutionTechniquesProperty.builder()
 *                 .providerProperties(ProviderPropertiesProperty.builder()
 *                         .providerServiceArn("providerServiceArn")
 *                         // the properties below are optional
 *                         .intermediateSourceConfiguration(IntermediateSourceConfigurationProperty.builder()
 *                                 .intermediateS3Path("intermediateS3Path")
 *                                 .build())
 *                         .providerConfiguration(Map.of(
 *                                 "providerConfigurationKey", "providerConfiguration"))
 *                         .build())
 *                 .resolutionType("resolutionType")
 *                 .ruleBasedProperties(RuleBasedPropertiesProperty.builder()
 *                         .attributeMatchingModel("attributeMatchingModel")
 *                         .rules(List.of(RuleProperty.builder()
 *                                 .matchingKeys(List.of("matchingKeys"))
 *                                 .ruleName("ruleName")
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .roleArn("roleArn")
 *         .workflowName("workflowName")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:34.088Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflowProps")
@software.amazon.jsii.Jsii.Proxy(CfnMatchingWorkflowProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMatchingWorkflowProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-inputsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-inputsourceconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getInputSourceConfig();

    /**
     * A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> , <code>ApplyNormalization</code> , and <code>Output</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-outputsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-outputsourceconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getOutputSourceConfig();

    /**
     * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-resolutiontechniques">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-resolutiontechniques</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getResolutionTechniques();

    /**
     * The Amazon Resource Name (ARN) of the IAM role.
     * <p>
     * AWS Entity Resolution assumes this role to create resources on your behalf as part of workflow execution.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The name of the workflow.
     * <p>
     * There can't be multiple <code>MatchingWorkflows</code> with the same name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-workflowname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-workflowname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkflowName();

    /**
     * A description of the workflow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-matchingworkflow.html#cfn-entityresolution-matchingworkflow-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMatchingWorkflowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMatchingWorkflowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMatchingWorkflowProps> {
        java.lang.Object inputSourceConfig;
        java.lang.Object outputSourceConfig;
        java.lang.Object resolutionTechniques;
        java.lang.String roleArn;
        java.lang.String workflowName;
        java.lang.String description;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnMatchingWorkflowProps#getInputSourceConfig}
         * @param inputSourceConfig A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSourceConfig(software.amazon.awscdk.IResolvable inputSourceConfig) {
            this.inputSourceConfig = inputSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchingWorkflowProps#getInputSourceConfig}
         * @param inputSourceConfig A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSourceConfig(java.util.List<? extends java.lang.Object> inputSourceConfig) {
            this.inputSourceConfig = inputSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchingWorkflowProps#getOutputSourceConfig}
         * @param outputSourceConfig A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> , <code>ApplyNormalization</code> , and <code>Output</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputSourceConfig(software.amazon.awscdk.IResolvable outputSourceConfig) {
            this.outputSourceConfig = outputSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchingWorkflowProps#getOutputSourceConfig}
         * @param outputSourceConfig A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> , <code>ApplyNormalization</code> , and <code>Output</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputSourceConfig(java.util.List<? extends java.lang.Object> outputSourceConfig) {
            this.outputSourceConfig = outputSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchingWorkflowProps#getResolutionTechniques}
         * @param resolutionTechniques An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resolutionTechniques(software.amazon.awscdk.IResolvable resolutionTechniques) {
            this.resolutionTechniques = resolutionTechniques;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchingWorkflowProps#getResolutionTechniques}
         * @param resolutionTechniques An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resolutionTechniques(software.amazon.awscdk.services.entityresolution.CfnMatchingWorkflow.ResolutionTechniquesProperty resolutionTechniques) {
            this.resolutionTechniques = resolutionTechniques;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchingWorkflowProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role. This parameter is required.
         *                AWS Entity Resolution assumes this role to create resources on your behalf as part of workflow execution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchingWorkflowProps#getWorkflowName}
         * @param workflowName The name of the workflow. This parameter is required.
         *                     There can't be multiple <code>MatchingWorkflows</code> with the same name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflowName(java.lang.String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchingWorkflowProps#getDescription}
         * @param description A description of the workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnMatchingWorkflowProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMatchingWorkflowProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMatchingWorkflowProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMatchingWorkflowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMatchingWorkflowProps {
        private final java.lang.Object inputSourceConfig;
        private final java.lang.Object outputSourceConfig;
        private final java.lang.Object resolutionTechniques;
        private final java.lang.String roleArn;
        private final java.lang.String workflowName;
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.inputSourceConfig = software.amazon.jsii.Kernel.get(this, "inputSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.outputSourceConfig = software.amazon.jsii.Kernel.get(this, "outputSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resolutionTechniques = software.amazon.jsii.Kernel.get(this, "resolutionTechniques", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workflowName = software.amazon.jsii.Kernel.get(this, "workflowName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.inputSourceConfig = java.util.Objects.requireNonNull(builder.inputSourceConfig, "inputSourceConfig is required");
            this.outputSourceConfig = java.util.Objects.requireNonNull(builder.outputSourceConfig, "outputSourceConfig is required");
            this.resolutionTechniques = java.util.Objects.requireNonNull(builder.resolutionTechniques, "resolutionTechniques is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.workflowName = java.util.Objects.requireNonNull(builder.workflowName, "workflowName is required");
            this.description = builder.description;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getInputSourceConfig() {
            return this.inputSourceConfig;
        }

        @Override
        public final java.lang.Object getOutputSourceConfig() {
            return this.outputSourceConfig;
        }

        @Override
        public final java.lang.Object getResolutionTechniques() {
            return this.resolutionTechniques;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getWorkflowName() {
            return this.workflowName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("inputSourceConfig", om.valueToTree(this.getInputSourceConfig()));
            data.set("outputSourceConfig", om.valueToTree(this.getOutputSourceConfig()));
            data.set("resolutionTechniques", om.valueToTree(this.getResolutionTechniques()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            data.set("workflowName", om.valueToTree(this.getWorkflowName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnMatchingWorkflowProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMatchingWorkflowProps.Jsii$Proxy that = (CfnMatchingWorkflowProps.Jsii$Proxy) o;

            if (!inputSourceConfig.equals(that.inputSourceConfig)) return false;
            if (!outputSourceConfig.equals(that.outputSourceConfig)) return false;
            if (!resolutionTechniques.equals(that.resolutionTechniques)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (!workflowName.equals(that.workflowName)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.inputSourceConfig.hashCode();
            result = 31 * result + (this.outputSourceConfig.hashCode());
            result = 31 * result + (this.resolutionTechniques.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.workflowName.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
