package software.amazon.awscdk.services.events.targets;

/**
 * Use an AWS Batch Job / Queue as an event rule target.
 * <p>
 * Most likely the code will look something like this:
 * <code>new BatchJob(jobQueue.jobQueueArn, jobQueue, jobDefinition.jobDefinitionArn, jobDefinition)</code>
 * <p>
 * In the future this API will be improved to be fully typed
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.batch.*;
 * import software.amazon.awscdk.services.ecs.ContainerImage;
 * Vpc vpc;
 * FargateComputeEnvironment computeEnvironment = FargateComputeEnvironment.Builder.create(this, "ComputeEnv")
 *         .vpc(vpc)
 *         .build();
 * JobQueue jobQueue = JobQueue.Builder.create(this, "JobQueue")
 *         .priority(1)
 *         .computeEnvironments(List.of(OrderedComputeEnvironment.builder()
 *                 .computeEnvironment(computeEnvironment)
 *                 .order(1)
 *                 .build()))
 *         .build();
 * EcsJobDefinition jobDefinition = EcsJobDefinition.Builder.create(this, "MyJob")
 *         .container(EcsEc2ContainerDefinition.Builder.create(this, "Container")
 *                 .image(ContainerImage.fromRegistry("test-repo"))
 *                 .memory(Size.mebibytes(2048))
 *                 .cpu(256)
 *                 .build())
 *         .build();
 * Queue queue = new Queue(this, "Queue");
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.hours(1)))
 *         .build();
 * rule.addTarget(BatchJob.Builder.create(jobQueue.getJobQueueArn(), jobQueue, jobDefinition.getJobDefinitionArn(), jobDefinition)
 *         .deadLetterQueue(queue)
 *         .event(RuleTargetInput.fromObject(Map.of("SomeParam", "SomeValue")))
 *         .retryAttempts(2)
 *         .maxEventAge(Duration.hours(2))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:34.205Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.BatchJob")
public class BatchJob extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected BatchJob(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BatchJob(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param jobQueueArn The JobQueue arn. This parameter is required.
     * @param jobQueueScope The JobQueue Resource. This parameter is required.
     * @param jobDefinitionArn The jobDefinition arn. This parameter is required.
     * @param jobDefinitionScope The JobQueue Resource. This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BatchJob(final @org.jetbrains.annotations.NotNull java.lang.String jobQueueArn, final @org.jetbrains.annotations.NotNull software.constructs.IConstruct jobQueueScope, final @org.jetbrains.annotations.NotNull java.lang.String jobDefinitionArn, final @org.jetbrains.annotations.NotNull software.constructs.IConstruct jobDefinitionScope, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.targets.BatchJobProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(jobQueueArn, "jobQueueArn is required"), java.util.Objects.requireNonNull(jobQueueScope, "jobQueueScope is required"), java.util.Objects.requireNonNull(jobDefinitionArn, "jobDefinitionArn is required"), java.util.Objects.requireNonNull(jobDefinitionScope, "jobDefinitionScope is required"), props });
    }

    /**
     * @param jobQueueArn The JobQueue arn. This parameter is required.
     * @param jobQueueScope The JobQueue Resource. This parameter is required.
     * @param jobDefinitionArn The jobDefinition arn. This parameter is required.
     * @param jobDefinitionScope The JobQueue Resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BatchJob(final @org.jetbrains.annotations.NotNull java.lang.String jobQueueArn, final @org.jetbrains.annotations.NotNull software.constructs.IConstruct jobQueueScope, final @org.jetbrains.annotations.NotNull java.lang.String jobDefinitionArn, final @org.jetbrains.annotations.NotNull software.constructs.IConstruct jobDefinitionScope) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(jobQueueArn, "jobQueueArn is required"), java.util.Objects.requireNonNull(jobQueueScope, "jobQueueScope is required"), java.util.Objects.requireNonNull(jobDefinitionArn, "jobDefinitionArn is required"), java.util.Objects.requireNonNull(jobDefinitionScope, "jobDefinitionScope is required") });
    }

    /**
     * Returns a RuleTarget that can be used to trigger queue this batch job as a result from an EventBridge event.
     * <p>
     * @param rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule, final @org.jetbrains.annotations.Nullable java.lang.String _id) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required"), _id });
    }

    /**
     * Returns a RuleTarget that can be used to trigger queue this batch job as a result from an EventBridge event.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.BatchJob}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.targets.BatchJob> {
        /**
         * @return a new instance of {@link Builder}.
         * @param jobQueueArn The JobQueue arn. This parameter is required.
         * @param jobQueueScope The JobQueue Resource. This parameter is required.
         * @param jobDefinitionArn The jobDefinition arn. This parameter is required.
         * @param jobDefinitionScope The JobQueue Resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String jobQueueArn, final software.constructs.IConstruct jobQueueScope, final java.lang.String jobDefinitionArn, final software.constructs.IConstruct jobDefinitionScope) {
            return new Builder(jobQueueArn, jobQueueScope, jobDefinitionArn, jobDefinitionScope);
        }

        private final java.lang.String jobQueueArn;
        private final software.constructs.IConstruct jobQueueScope;
        private final java.lang.String jobDefinitionArn;
        private final software.constructs.IConstruct jobDefinitionScope;
        private software.amazon.awscdk.services.events.targets.BatchJobProps.Builder props;

        private Builder(final java.lang.String jobQueueArn, final software.constructs.IConstruct jobQueueScope, final java.lang.String jobDefinitionArn, final software.constructs.IConstruct jobDefinitionScope) {
            this.jobQueueArn = jobQueueArn;
            this.jobQueueScope = jobQueueScope;
            this.jobDefinitionArn = jobDefinitionArn;
            this.jobDefinitionScope = jobDefinitionScope;
        }

        /**
         * The SQS queue to be used as deadLetterQueue. Check out the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations">considerations for using a dead-letter queue</a>.
         * <p>
         * The events not successfully delivered are automatically retried for a specified period of time,
         * depending on the retry policy of the target.
         * If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * <p>
         * Default: - no dead-letter queue
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. Check out the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations">considerations for using a dead-letter queue</a>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * The maximum age of a request that Lambda sends to a function for processing.
         * <p>
         * Minimum value of 60.
         * Maximum value of 86400.
         * <p>
         * Default: Duration.hours(24)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(final software.amazon.awscdk.Duration maxEventAge) {
            this.props().maxEventAge(maxEventAge);
            return this;
        }

        /**
         * The maximum number of times to retry when the function returns an error.
         * <p>
         * Minimum value of 0.
         * Maximum value of 185.
         * <p>
         * Default: 185
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        /**
         * The number of times to attempt to retry, if the job fails.
         * <p>
         * Valid values are 1–10.
         * <p>
         * Default: no retryStrategy is set
         * <p>
         * @return {@code this}
         * @param attempts The number of times to attempt to retry, if the job fails. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attempts(final java.lang.Number attempts) {
            this.props().attempts(attempts);
            return this;
        }

        /**
         * The event to send to the Lambda.
         * <p>
         * This will be the payload sent to the Lambda Function.
         * <p>
         * Default: the entire EventBridge event
         * <p>
         * @return {@code this}
         * @param event The event to send to the Lambda. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder event(final software.amazon.awscdk.services.events.RuleTargetInput event) {
            this.props().event(event);
            return this;
        }

        /**
         * The name of the submitted job.
         * <p>
         * Default: - Automatically generated
         * <p>
         * @return {@code this}
         * @param jobName The name of the submitted job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobName(final java.lang.String jobName) {
            this.props().jobName(jobName);
            return this;
        }

        /**
         * The size of the array, if this is an array batch job.
         * <p>
         * Valid values are integers between 2 and 10,000.
         * <p>
         * Default: no arrayProperties are set
         * <p>
         * @return {@code this}
         * @param size The size of the array, if this is an array batch job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder size(final java.lang.Number size) {
            this.props().size(size);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.events.targets.BatchJob}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.targets.BatchJob build() {
            return new software.amazon.awscdk.services.events.targets.BatchJob(
                this.jobQueueArn,
                this.jobQueueScope,
                this.jobDefinitionArn,
                this.jobDefinitionScope,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.targets.BatchJobProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.targets.BatchJobProps.Builder();
            }
            return this.props;
        }
    }
}
