package software.amazon.awscdk.services.globalaccelerator;

/**
 * Untyped endpoint implementation.
 * <p>
 * Prefer using the classes in the <code>aws-globalaccelerator-endpoints</code> package instead,
 * as they accept typed constructs. You can use this class if you want to use an
 * endpoint type that does not have an appropriate class in that package yet.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.globalaccelerator.*;
 * RawEndpoint rawEndpoint = RawEndpoint.Builder.create()
 *         .endpointId("endpointId")
 *         // the properties below are optional
 *         .preserveClientIp(false)
 *         .region("region")
 *         .weight(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:34.520Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_globalaccelerator.RawEndpoint")
public class RawEndpoint extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.globalaccelerator.IEndpoint {

    protected RawEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RawEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RawEndpoint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.RawEndpointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Render the endpoint to an endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object renderEndpointConfiguration() {
        return software.amazon.jsii.Kernel.call(this, "renderEndpointConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The region where the endpoint is located.
     * <p>
     * If the region cannot be determined, <code>undefined</code> is returned
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.globalaccelerator.RawEndpoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.globalaccelerator.RawEndpoint> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.globalaccelerator.RawEndpointProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.globalaccelerator.RawEndpointProps.Builder();
        }

        /**
         * Identifier of the endpoint.
         * <p>
         * Load balancer ARN, instance ID or EIP allocation ID.
         * <p>
         * @return {@code this}
         * @param endpointId Identifier of the endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointId(final java.lang.String endpointId) {
            this.props.endpointId(endpointId);
            return this;
        }

        /**
         * Forward the client IP address.
         * <p>
         * GlobalAccelerator will create Network Interfaces in your VPC in order
         * to preserve the client IP address.
         * <p>
         * Only applies to Application Load Balancers and EC2 instances.
         * <p>
         * Client IP address preservation is supported only in specific AWS Regions.
         * See the GlobalAccelerator Developer Guide for a list.
         * <p>
         * Default: true if possible and available
         * <p>
         * @return {@code this}
         * @param preserveClientIp Forward the client IP address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveClientIp(final java.lang.Boolean preserveClientIp) {
            this.props.preserveClientIp(preserveClientIp);
            return this;
        }

        /**
         * The region where this endpoint is located.
         * <p>
         * Default: - Unknown what region this endpoint is located
         * <p>
         * @return {@code this}
         * @param region The region where this endpoint is located. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * Endpoint weight across all endpoints in the group.
         * <p>
         * Must be a value between 0 and 255.
         * <p>
         * Default: 128
         * <p>
         * @return {@code this}
         * @param weight Endpoint weight across all endpoints in the group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder weight(final java.lang.Number weight) {
            this.props.weight(weight);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.globalaccelerator.RawEndpoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.globalaccelerator.RawEndpoint build() {
            return new software.amazon.awscdk.services.globalaccelerator.RawEndpoint(
                this.props.build()
            );
        }
    }
}
