package software.amazon.awscdk.services.iam;

/**
 * A principal representing all AWS identities in all accounts.
 * <p>
 * Some services behave differently when you specify <code>Principal: '*'</code>
 * or <code>Principal: { AWS: "*" }</code> in their resource policy.
 * <p>
 * <code>AnyPrincipal</code> renders to <code>Principal: { AWS: "*" }</code>. This is correct
 * most of the time, but in cases where you need the other principal,
 * use <code>StarPrincipal</code> instead.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic topic = new Topic(this, "Topic");
 * TopicPolicy topicPolicy = TopicPolicy.Builder.create(this, "TopicPolicy")
 *         .topics(List.of(topic))
 *         .build();
 * topicPolicy.document.addStatements(PolicyStatement.Builder.create()
 *         .actions(List.of("sns:Subscribe"))
 *         .principals(List.of(new AnyPrincipal()))
 *         .resources(List.of(topic.getTopicArn()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:34.841Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.AnyPrincipal")
public class AnyPrincipal extends software.amazon.awscdk.services.iam.ArnPrincipal {

    protected AnyPrincipal(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AnyPrincipal(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AnyPrincipal() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Returns a string representation of an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
