package software.amazon.awscdk.services.imagebuilder;

/**
 * Properties for defining a <code>CfnImagePipeline</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.imagebuilder.*;
 * CfnImagePipelineProps cfnImagePipelineProps = CfnImagePipelineProps.builder()
 *         .infrastructureConfigurationArn("infrastructureConfigurationArn")
 *         .name("name")
 *         // the properties below are optional
 *         .containerRecipeArn("containerRecipeArn")
 *         .description("description")
 *         .distributionConfigurationArn("distributionConfigurationArn")
 *         .enhancedImageMetadataEnabled(false)
 *         .executionRole("executionRole")
 *         .imageRecipeArn("imageRecipeArn")
 *         .imageScanningConfiguration(ImageScanningConfigurationProperty.builder()
 *                 .ecrConfiguration(EcrConfigurationProperty.builder()
 *                         .containerTags(List.of("containerTags"))
 *                         .repositoryName("repositoryName")
 *                         .build())
 *                 .imageScanningEnabled(false)
 *                 .build())
 *         .imageTestsConfiguration(ImageTestsConfigurationProperty.builder()
 *                 .imageTestsEnabled(false)
 *                 .timeoutMinutes(123)
 *                 .build())
 *         .schedule(ScheduleProperty.builder()
 *                 .pipelineExecutionStartCondition("pipelineExecutionStartCondition")
 *                 .scheduleExpression("scheduleExpression")
 *                 .build())
 *         .status("status")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .workflows(List.of(WorkflowConfigurationProperty.builder()
 *                 .onFailure("onFailure")
 *                 .parallelGroup("parallelGroup")
 *                 .parameters(List.of(WorkflowParameterProperty.builder()
 *                         .name("name")
 *                         .value(List.of("value"))
 *                         .build()))
 *                 .workflowArn("workflowArn")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:34.995Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnImagePipelineProps")
@software.amazon.jsii.Jsii.Proxy(CfnImagePipelineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnImagePipelineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-infrastructureconfigurationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-infrastructureconfigurationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInfrastructureConfigurationArn();

    /**
     * The name of the image pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-containerrecipearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-containerrecipearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContainerRecipeArn() {
        return null;
    }

    /**
     * The description of this image pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the distribution configuration associated with this image pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-distributionconfigurationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-distributionconfigurationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDistributionConfigurationArn() {
        return null;
    }

    /**
     * Collects additional information about the image being created, including the operating system (OS) version and package list.
     * <p>
     * This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-enhancedimagemetadataenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-enhancedimagemetadataenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnhancedImageMetadataEnabled() {
        return null;
    }

    /**
     * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to perform workflow actions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-executionrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRole() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the image recipe associated with this image pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-imagerecipearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-imagerecipearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageRecipeArn() {
        return null;
    }

    /**
     * Contains settings for vulnerability scans.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-imagescanningconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-imagescanningconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getImageScanningConfiguration() {
        return null;
    }

    /**
     * The configuration of the image tests that run after image creation to ensure the quality of the image that was created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-imagetestsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-imagetestsconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getImageTestsConfiguration() {
        return null;
    }

    /**
     * The schedule of the image pipeline.
     * <p>
     * A schedule configures how often and when a pipeline automatically creates a new image.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-schedule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return null;
    }

    /**
     * The status of the image pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-status</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return null;
    }

    /**
     * The tags of this image pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * Contains the workflows that run for the image pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-workflows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-workflows</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWorkflows() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnImagePipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnImagePipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnImagePipelineProps> {
        java.lang.String infrastructureConfigurationArn;
        java.lang.String name;
        java.lang.String containerRecipeArn;
        java.lang.String description;
        java.lang.String distributionConfigurationArn;
        java.lang.Object enhancedImageMetadataEnabled;
        java.lang.String executionRole;
        java.lang.String imageRecipeArn;
        java.lang.Object imageScanningConfiguration;
        java.lang.Object imageTestsConfiguration;
        java.lang.Object schedule;
        java.lang.String status;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Object workflows;

        /**
         * Sets the value of {@link CfnImagePipelineProps#getInfrastructureConfigurationArn}
         * @param infrastructureConfigurationArn The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder infrastructureConfigurationArn(java.lang.String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getName}
         * @param name The name of the image pipeline. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getContainerRecipeArn}
         * @param containerRecipeArn The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerRecipeArn(java.lang.String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getDescription}
         * @param description The description of this image pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getDistributionConfigurationArn}
         * @param distributionConfigurationArn The Amazon Resource Name (ARN) of the distribution configuration associated with this image pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionConfigurationArn(java.lang.String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getEnhancedImageMetadataEnabled}
         * @param enhancedImageMetadataEnabled Collects additional information about the image being created, including the operating system (OS) version and package list.
         *                                     This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedImageMetadataEnabled(java.lang.Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getEnhancedImageMetadataEnabled}
         * @param enhancedImageMetadataEnabled Collects additional information about the image being created, including the operating system (OS) version and package list.
         *                                     This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedImageMetadataEnabled(software.amazon.awscdk.IResolvable enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getExecutionRole}
         * @param executionRole The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to perform workflow actions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(java.lang.String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getImageRecipeArn}
         * @param imageRecipeArn The Amazon Resource Name (ARN) of the image recipe associated with this image pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageRecipeArn(java.lang.String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getImageScanningConfiguration}
         * @param imageScanningConfiguration Contains settings for vulnerability scans.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageScanningConfiguration(software.amazon.awscdk.IResolvable imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getImageScanningConfiguration}
         * @param imageScanningConfiguration Contains settings for vulnerability scans.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageScanningConfiguration(software.amazon.awscdk.services.imagebuilder.CfnImagePipeline.ImageScanningConfigurationProperty imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getImageTestsConfiguration}
         * @param imageTestsConfiguration The configuration of the image tests that run after image creation to ensure the quality of the image that was created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTestsConfiguration(software.amazon.awscdk.IResolvable imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getImageTestsConfiguration}
         * @param imageTestsConfiguration The configuration of the image tests that run after image creation to ensure the quality of the image that was created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTestsConfiguration(software.amazon.awscdk.services.imagebuilder.CfnImagePipeline.ImageTestsConfigurationProperty imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getSchedule}
         * @param schedule The schedule of the image pipeline.
         *                 A schedule configures how often and when a pipeline automatically creates a new image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.IResolvable schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getSchedule}
         * @param schedule The schedule of the image pipeline.
         *                 A schedule configures how often and when a pipeline automatically creates a new image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.imagebuilder.CfnImagePipeline.ScheduleProperty schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getStatus}
         * @param status The status of the image pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getTags}
         * @param tags The tags of this image pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getWorkflows}
         * @param workflows Contains the workflows that run for the image pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflows(software.amazon.awscdk.IResolvable workflows) {
            this.workflows = workflows;
            return this;
        }

        /**
         * Sets the value of {@link CfnImagePipelineProps#getWorkflows}
         * @param workflows Contains the workflows that run for the image pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflows(java.util.List<? extends java.lang.Object> workflows) {
            this.workflows = workflows;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnImagePipelineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnImagePipelineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnImagePipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnImagePipelineProps {
        private final java.lang.String infrastructureConfigurationArn;
        private final java.lang.String name;
        private final java.lang.String containerRecipeArn;
        private final java.lang.String description;
        private final java.lang.String distributionConfigurationArn;
        private final java.lang.Object enhancedImageMetadataEnabled;
        private final java.lang.String executionRole;
        private final java.lang.String imageRecipeArn;
        private final java.lang.Object imageScanningConfiguration;
        private final java.lang.Object imageTestsConfiguration;
        private final java.lang.Object schedule;
        private final java.lang.String status;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Object workflows;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.infrastructureConfigurationArn = software.amazon.jsii.Kernel.get(this, "infrastructureConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.containerRecipeArn = software.amazon.jsii.Kernel.get(this, "containerRecipeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.distributionConfigurationArn = software.amazon.jsii.Kernel.get(this, "distributionConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enhancedImageMetadataEnabled = software.amazon.jsii.Kernel.get(this, "enhancedImageMetadataEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageRecipeArn = software.amazon.jsii.Kernel.get(this, "imageRecipeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageScanningConfiguration = software.amazon.jsii.Kernel.get(this, "imageScanningConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.imageTestsConfiguration = software.amazon.jsii.Kernel.get(this, "imageTestsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.workflows = software.amazon.jsii.Kernel.get(this, "workflows", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.infrastructureConfigurationArn = java.util.Objects.requireNonNull(builder.infrastructureConfigurationArn, "infrastructureConfigurationArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.containerRecipeArn = builder.containerRecipeArn;
            this.description = builder.description;
            this.distributionConfigurationArn = builder.distributionConfigurationArn;
            this.enhancedImageMetadataEnabled = builder.enhancedImageMetadataEnabled;
            this.executionRole = builder.executionRole;
            this.imageRecipeArn = builder.imageRecipeArn;
            this.imageScanningConfiguration = builder.imageScanningConfiguration;
            this.imageTestsConfiguration = builder.imageTestsConfiguration;
            this.schedule = builder.schedule;
            this.status = builder.status;
            this.tags = builder.tags;
            this.workflows = builder.workflows;
        }

        @Override
        public final java.lang.String getInfrastructureConfigurationArn() {
            return this.infrastructureConfigurationArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getContainerRecipeArn() {
            return this.containerRecipeArn;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDistributionConfigurationArn() {
            return this.distributionConfigurationArn;
        }

        @Override
        public final java.lang.Object getEnhancedImageMetadataEnabled() {
            return this.enhancedImageMetadataEnabled;
        }

        @Override
        public final java.lang.String getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final java.lang.String getImageRecipeArn() {
            return this.imageRecipeArn;
        }

        @Override
        public final java.lang.Object getImageScanningConfiguration() {
            return this.imageScanningConfiguration;
        }

        @Override
        public final java.lang.Object getImageTestsConfiguration() {
            return this.imageTestsConfiguration;
        }

        @Override
        public final java.lang.Object getSchedule() {
            return this.schedule;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getWorkflows() {
            return this.workflows;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("infrastructureConfigurationArn", om.valueToTree(this.getInfrastructureConfigurationArn()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getContainerRecipeArn() != null) {
                data.set("containerRecipeArn", om.valueToTree(this.getContainerRecipeArn()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDistributionConfigurationArn() != null) {
                data.set("distributionConfigurationArn", om.valueToTree(this.getDistributionConfigurationArn()));
            }
            if (this.getEnhancedImageMetadataEnabled() != null) {
                data.set("enhancedImageMetadataEnabled", om.valueToTree(this.getEnhancedImageMetadataEnabled()));
            }
            if (this.getExecutionRole() != null) {
                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            }
            if (this.getImageRecipeArn() != null) {
                data.set("imageRecipeArn", om.valueToTree(this.getImageRecipeArn()));
            }
            if (this.getImageScanningConfiguration() != null) {
                data.set("imageScanningConfiguration", om.valueToTree(this.getImageScanningConfiguration()));
            }
            if (this.getImageTestsConfiguration() != null) {
                data.set("imageTestsConfiguration", om.valueToTree(this.getImageTestsConfiguration()));
            }
            if (this.getSchedule() != null) {
                data.set("schedule", om.valueToTree(this.getSchedule()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWorkflows() != null) {
                data.set("workflows", om.valueToTree(this.getWorkflows()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnImagePipelineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnImagePipelineProps.Jsii$Proxy that = (CfnImagePipelineProps.Jsii$Proxy) o;

            if (!infrastructureConfigurationArn.equals(that.infrastructureConfigurationArn)) return false;
            if (!name.equals(that.name)) return false;
            if (this.containerRecipeArn != null ? !this.containerRecipeArn.equals(that.containerRecipeArn) : that.containerRecipeArn != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.distributionConfigurationArn != null ? !this.distributionConfigurationArn.equals(that.distributionConfigurationArn) : that.distributionConfigurationArn != null) return false;
            if (this.enhancedImageMetadataEnabled != null ? !this.enhancedImageMetadataEnabled.equals(that.enhancedImageMetadataEnabled) : that.enhancedImageMetadataEnabled != null) return false;
            if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) return false;
            if (this.imageRecipeArn != null ? !this.imageRecipeArn.equals(that.imageRecipeArn) : that.imageRecipeArn != null) return false;
            if (this.imageScanningConfiguration != null ? !this.imageScanningConfiguration.equals(that.imageScanningConfiguration) : that.imageScanningConfiguration != null) return false;
            if (this.imageTestsConfiguration != null ? !this.imageTestsConfiguration.equals(that.imageTestsConfiguration) : that.imageTestsConfiguration != null) return false;
            if (this.schedule != null ? !this.schedule.equals(that.schedule) : that.schedule != null) return false;
            if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.workflows != null ? this.workflows.equals(that.workflows) : that.workflows == null;
        }

        @Override
        public final int hashCode() {
            int result = this.infrastructureConfigurationArn.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.containerRecipeArn != null ? this.containerRecipeArn.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.distributionConfigurationArn != null ? this.distributionConfigurationArn.hashCode() : 0);
            result = 31 * result + (this.enhancedImageMetadataEnabled != null ? this.enhancedImageMetadataEnabled.hashCode() : 0);
            result = 31 * result + (this.executionRole != null ? this.executionRole.hashCode() : 0);
            result = 31 * result + (this.imageRecipeArn != null ? this.imageRecipeArn.hashCode() : 0);
            result = 31 * result + (this.imageScanningConfiguration != null ? this.imageScanningConfiguration.hashCode() : 0);
            result = 31 * result + (this.imageTestsConfiguration != null ? this.imageTestsConfiguration.hashCode() : 0);
            result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.workflows != null ? this.workflows.hashCode() : 0);
            return result;
        }
    }
}
