package software.amazon.awscdk.services.lightsail;

/**
 * Properties for defining a <code>CfnInstance</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * CfnInstanceProps cfnInstanceProps = CfnInstanceProps.builder()
 *         .blueprintId("blueprintId")
 *         .bundleId("bundleId")
 *         .instanceName("instanceName")
 *         // the properties below are optional
 *         .addOns(List.of(AddOnProperty.builder()
 *                 .addOnType("addOnType")
 *                 // the properties below are optional
 *                 .autoSnapshotAddOnRequest(AutoSnapshotAddOnProperty.builder()
 *                         .snapshotTimeOfDay("snapshotTimeOfDay")
 *                         .build())
 *                 .status("status")
 *                 .build()))
 *         .availabilityZone("availabilityZone")
 *         .hardware(HardwareProperty.builder()
 *                 .cpuCount(123)
 *                 .disks(List.of(DiskProperty.builder()
 *                         .diskName("diskName")
 *                         .path("path")
 *                         // the properties below are optional
 *                         .attachedTo("attachedTo")
 *                         .attachmentState("attachmentState")
 *                         .iops(123)
 *                         .isSystemDisk(false)
 *                         .sizeInGb("sizeInGb")
 *                         .build()))
 *                 .ramSizeInGb(123)
 *                 .build())
 *         .keyPairName("keyPairName")
 *         .location(LocationProperty.builder()
 *                 .availabilityZone("availabilityZone")
 *                 .regionName("regionName")
 *                 .build())
 *         .networking(NetworkingProperty.builder()
 *                 .ports(List.of(PortProperty.builder()
 *                         .accessDirection("accessDirection")
 *                         .accessFrom("accessFrom")
 *                         .accessType("accessType")
 *                         .cidrListAliases(List.of("cidrListAliases"))
 *                         .cidrs(List.of("cidrs"))
 *                         .commonName("commonName")
 *                         .fromPort(123)
 *                         .ipv6Cidrs(List.of("ipv6Cidrs"))
 *                         .protocol("protocol")
 *                         .toPort(123)
 *                         .build()))
 *                 // the properties below are optional
 *                 .monthlyTransfer(MonthlyTransferProperty.builder()
 *                         .gbPerMonthAllocated("gbPerMonthAllocated")
 *                         .build())
 *                 .build())
 *         .state(StateProperty.builder()
 *                 .code(123)
 *                 .name("name")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .userData("userData")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:36.318Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnInstanceProps")
@software.amazon.jsii.Jsii.Proxy(CfnInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The blueprint ID for the instance (for example, <code>os_amlinux_2016_03</code> ).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-blueprintid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-blueprintid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBlueprintId();

    /**
     * The bundle ID for the instance (for example, <code>micro_1_0</code> ).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-bundleid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-bundleid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBundleId();

    /**
     * The name of the instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-instancename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-instancename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceName();

    /**
     * An array of add-ons for the instance.
     * <p>
     * <blockquote>
     * <p>
     * If the instance has an add-on enabled when performing a delete instance request, the add-on is automatically disabled before the instance is deleted.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-addons">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-addons</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAddOns() {
        return null;
    }

    /**
     * The Availability Zone for the instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-availabilityzone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * The hardware properties for the instance, such as the vCPU count, attached disks, and amount of RAM.
     * <p>
     * <blockquote>
     * <p>
     * The instance restarts when performing an attach disk or detach disk request. This resets the public IP address of your instance if a static IP isn't attached to it.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-hardware">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-hardware</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHardware() {
        return null;
    }

    /**
     * The name of the key pair to use for the instance.
     * <p>
     * If no key pair name is specified, the Regional Lightsail default key pair is used.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-keypairname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-keypairname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyPairName() {
        return null;
    }

    /**
     * The location for the instance, such as the AWS Region and Availability Zone.
     * <p>
     * <blockquote>
     * <p>
     * The <code>Location</code> property is read-only and should not be specified in a create instance or update instance request.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-location</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLocation() {
        return null;
    }

    /**
     * The public ports and the monthly amount of data transfer allocated for the instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-networking">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-networking</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworking() {
        return null;
    }

    /**
     * The status code and the state (for example, <code>running</code> ) of the instance.
     * <p>
     * <blockquote>
     * <p>
     * The <code>State</code> property is read-only and should not be specified in a create instance or update instance request.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-state</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getState() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The optional launch script for the instance.
     * <p>
     * Specify a launch script to configure an instance with additional user data. For example, you might want to specify <code>apt-get -y update</code> as a launch script.
     * <p>
     * <blockquote>
     * <p>
     * Depending on the blueprint of your instance, the command to get software on your instance varies. Amazon Linux and CentOS use <code>yum</code> , Debian and Ubuntu use <code>apt-get</code> , and FreeBSD uses <code>pkg</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-userdata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-instance.html#cfn-lightsail-instance-userdata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserData() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInstanceProps> {
        java.lang.String blueprintId;
        java.lang.String bundleId;
        java.lang.String instanceName;
        java.lang.Object addOns;
        java.lang.String availabilityZone;
        java.lang.Object hardware;
        java.lang.String keyPairName;
        java.lang.Object location;
        java.lang.Object networking;
        java.lang.Object state;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String userData;

        /**
         * Sets the value of {@link CfnInstanceProps#getBlueprintId}
         * @param blueprintId The blueprint ID for the instance (for example, <code>os_amlinux_2016_03</code> ). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blueprintId(java.lang.String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getBundleId}
         * @param bundleId The bundle ID for the instance (for example, <code>micro_1_0</code> ). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundleId(java.lang.String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getInstanceName}
         * @param instanceName The name of the instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceName(java.lang.String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getAddOns}
         * @param addOns An array of add-ons for the instance.
         *               <blockquote>
         *               <p>
         *               If the instance has an add-on enabled when performing a delete instance request, the add-on is automatically disabled before the instance is deleted.
         *               <p>
         *               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addOns(software.amazon.awscdk.IResolvable addOns) {
            this.addOns = addOns;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getAddOns}
         * @param addOns An array of add-ons for the instance.
         *               <blockquote>
         *               <p>
         *               If the instance has an add-on enabled when performing a delete instance request, the add-on is automatically disabled before the instance is deleted.
         *               <p>
         *               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addOns(java.util.List<? extends java.lang.Object> addOns) {
            this.addOns = addOns;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getAvailabilityZone}
         * @param availabilityZone The Availability Zone for the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getHardware}
         * @param hardware The hardware properties for the instance, such as the vCPU count, attached disks, and amount of RAM.
         *                 <blockquote>
         *                 <p>
         *                 The instance restarts when performing an attach disk or detach disk request. This resets the public IP address of your instance if a static IP isn't attached to it.
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hardware(software.amazon.awscdk.IResolvable hardware) {
            this.hardware = hardware;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getHardware}
         * @param hardware The hardware properties for the instance, such as the vCPU count, attached disks, and amount of RAM.
         *                 <blockquote>
         *                 <p>
         *                 The instance restarts when performing an attach disk or detach disk request. This resets the public IP address of your instance if a static IP isn't attached to it.
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hardware(software.amazon.awscdk.services.lightsail.CfnInstance.HardwareProperty hardware) {
            this.hardware = hardware;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getKeyPairName}
         * @param keyPairName The name of the key pair to use for the instance.
         *                    If no key pair name is specified, the Regional Lightsail default key pair is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPairName(java.lang.String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getLocation}
         * @param location The location for the instance, such as the AWS Region and Availability Zone.
         *                 <blockquote>
         *                 <p>
         *                 The <code>Location</code> property is read-only and should not be specified in a create instance or update instance request.
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder location(software.amazon.awscdk.IResolvable location) {
            this.location = location;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getLocation}
         * @param location The location for the instance, such as the AWS Region and Availability Zone.
         *                 <blockquote>
         *                 <p>
         *                 The <code>Location</code> property is read-only and should not be specified in a create instance or update instance request.
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder location(software.amazon.awscdk.services.lightsail.CfnInstance.LocationProperty location) {
            this.location = location;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getNetworking}
         * @param networking The public ports and the monthly amount of data transfer allocated for the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networking(software.amazon.awscdk.IResolvable networking) {
            this.networking = networking;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getNetworking}
         * @param networking The public ports and the monthly amount of data transfer allocated for the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networking(software.amazon.awscdk.services.lightsail.CfnInstance.NetworkingProperty networking) {
            this.networking = networking;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getState}
         * @param state The status code and the state (for example, <code>running</code> ) of the instance.
         *              <blockquote>
         *              <p>
         *              The <code>State</code> property is read-only and should not be specified in a create instance or update instance request.
         *              <p>
         *              </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(software.amazon.awscdk.IResolvable state) {
            this.state = state;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getState}
         * @param state The status code and the state (for example, <code>running</code> ) of the instance.
         *              <blockquote>
         *              <p>
         *              The <code>State</code> property is read-only and should not be specified in a create instance or update instance request.
         *              <p>
         *              </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(software.amazon.awscdk.services.lightsail.CfnInstance.StateProperty state) {
            this.state = state;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
         *             <p>
         *             <blockquote>
         *             <p>
         *             The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getUserData}
         * @param userData The optional launch script for the instance.
         *                 Specify a launch script to configure an instance with additional user data. For example, you might want to specify <code>apt-get -y update</code> as a launch script.
         *                 <p>
         *                 <blockquote>
         *                 <p>
         *                 Depending on the blueprint of your instance, the command to get software on your instance varies. Amazon Linux and CentOS use <code>yum</code> , Debian and Ubuntu use <code>apt-get</code> , and FreeBSD uses <code>pkg</code> .
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(java.lang.String userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInstanceProps {
        private final java.lang.String blueprintId;
        private final java.lang.String bundleId;
        private final java.lang.String instanceName;
        private final java.lang.Object addOns;
        private final java.lang.String availabilityZone;
        private final java.lang.Object hardware;
        private final java.lang.String keyPairName;
        private final java.lang.Object location;
        private final java.lang.Object networking;
        private final java.lang.Object state;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String userData;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.blueprintId = software.amazon.jsii.Kernel.get(this, "blueprintId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bundleId = software.amazon.jsii.Kernel.get(this, "bundleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceName = software.amazon.jsii.Kernel.get(this, "instanceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.addOns = software.amazon.jsii.Kernel.get(this, "addOns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hardware = software.amazon.jsii.Kernel.get(this, "hardware", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.keyPairName = software.amazon.jsii.Kernel.get(this, "keyPairName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.networking = software.amazon.jsii.Kernel.get(this, "networking", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.blueprintId = java.util.Objects.requireNonNull(builder.blueprintId, "blueprintId is required");
            this.bundleId = java.util.Objects.requireNonNull(builder.bundleId, "bundleId is required");
            this.instanceName = java.util.Objects.requireNonNull(builder.instanceName, "instanceName is required");
            this.addOns = builder.addOns;
            this.availabilityZone = builder.availabilityZone;
            this.hardware = builder.hardware;
            this.keyPairName = builder.keyPairName;
            this.location = builder.location;
            this.networking = builder.networking;
            this.state = builder.state;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.userData = builder.userData;
        }

        @Override
        public final java.lang.String getBlueprintId() {
            return this.blueprintId;
        }

        @Override
        public final java.lang.String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final java.lang.String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final java.lang.Object getAddOns() {
            return this.addOns;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.Object getHardware() {
            return this.hardware;
        }

        @Override
        public final java.lang.String getKeyPairName() {
            return this.keyPairName;
        }

        @Override
        public final java.lang.Object getLocation() {
            return this.location;
        }

        @Override
        public final java.lang.Object getNetworking() {
            return this.networking;
        }

        @Override
        public final java.lang.Object getState() {
            return this.state;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getUserData() {
            return this.userData;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("blueprintId", om.valueToTree(this.getBlueprintId()));
            data.set("bundleId", om.valueToTree(this.getBundleId()));
            data.set("instanceName", om.valueToTree(this.getInstanceName()));
            if (this.getAddOns() != null) {
                data.set("addOns", om.valueToTree(this.getAddOns()));
            }
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getHardware() != null) {
                data.set("hardware", om.valueToTree(this.getHardware()));
            }
            if (this.getKeyPairName() != null) {
                data.set("keyPairName", om.valueToTree(this.getKeyPairName()));
            }
            if (this.getLocation() != null) {
                data.set("location", om.valueToTree(this.getLocation()));
            }
            if (this.getNetworking() != null) {
                data.set("networking", om.valueToTree(this.getNetworking()));
            }
            if (this.getState() != null) {
                data.set("state", om.valueToTree(this.getState()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUserData() != null) {
                data.set("userData", om.valueToTree(this.getUserData()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInstanceProps.Jsii$Proxy that = (CfnInstanceProps.Jsii$Proxy) o;

            if (!blueprintId.equals(that.blueprintId)) return false;
            if (!bundleId.equals(that.bundleId)) return false;
            if (!instanceName.equals(that.instanceName)) return false;
            if (this.addOns != null ? !this.addOns.equals(that.addOns) : that.addOns != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.hardware != null ? !this.hardware.equals(that.hardware) : that.hardware != null) return false;
            if (this.keyPairName != null ? !this.keyPairName.equals(that.keyPairName) : that.keyPairName != null) return false;
            if (this.location != null ? !this.location.equals(that.location) : that.location != null) return false;
            if (this.networking != null ? !this.networking.equals(that.networking) : that.networking != null) return false;
            if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.userData != null ? this.userData.equals(that.userData) : that.userData == null;
        }

        @Override
        public final int hashCode() {
            int result = this.blueprintId.hashCode();
            result = 31 * result + (this.bundleId.hashCode());
            result = 31 * result + (this.instanceName.hashCode());
            result = 31 * result + (this.addOns != null ? this.addOns.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.hardware != null ? this.hardware.hashCode() : 0);
            result = 31 * result + (this.keyPairName != null ? this.keyPairName.hashCode() : 0);
            result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
            result = 31 * result + (this.networking != null ? this.networking.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
            return result;
        }
    }
}
