package software.amazon.awscdk.services.logs;

/**
 * A new Subscription on a CloudWatch log group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.destinations.*;
 * Function fn;
 * LogGroup logGroup;
 * SubscriptionFilter.Builder.create(this, "Subscription")
 *         .logGroup(logGroup)
 *         .destination(new LambdaDestination(fn))
 *         .filterPattern(FilterPattern.allTerms("ERROR", "MainThread"))
 *         .filterName("ErrorInMainThread")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:36.422Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.SubscriptionFilter")
public class SubscriptionFilter extends software.amazon.awscdk.Resource {

    protected SubscriptionFilter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SubscriptionFilter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SubscriptionFilter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.SubscriptionFilterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.SubscriptionFilter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.SubscriptionFilter> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.logs.SubscriptionFilterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.logs.SubscriptionFilterProps.Builder();
        }

        /**
         * The destination to send the filtered events to.
         * <p>
         * For example, a Kinesis stream or a Lambda function.
         * <p>
         * @return {@code this}
         * @param destination The destination to send the filtered events to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(final software.amazon.awscdk.services.logs.ILogSubscriptionDestination destination) {
            this.props.destination(destination);
            return this;
        }

        /**
         * Log events matching this pattern will be sent to the destination.
         * <p>
         * @return {@code this}
         * @param filterPattern Log events matching this pattern will be sent to the destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPattern(final software.amazon.awscdk.services.logs.IFilterPattern filterPattern) {
            this.props.filterPattern(filterPattern);
            return this;
        }

        /**
         * The method used to distribute log data to the destination.
         * <p>
         * This property can only be used with KinesisDestination.
         * <p>
         * Default: Distribution.BY_LOG_STREAM
         * <p>
         * @return {@code this}
         * @param distribution The method used to distribute log data to the destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distribution(final software.amazon.awscdk.services.logs.Distribution distribution) {
            this.props.distribution(distribution);
            return this;
        }

        /**
         * The name of the subscription filter.
         * <p>
         * Default: Automatically generated
         * <p>
         * @return {@code this}
         * @param filterName The name of the subscription filter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterName(final java.lang.String filterName) {
            this.props.filterName(filterName);
            return this;
        }

        /**
         * The log group to create the subscription on.
         * <p>
         * @return {@code this}
         * @param logGroup The log group to create the subscription on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroup(final software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.props.logGroup(logGroup);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.logs.SubscriptionFilter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.SubscriptionFilter build() {
            return new software.amazon.awscdk.services.logs.SubscriptionFilter(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
