package software.amazon.awscdk.services.macie;

/**
 * The <code>AWS::Macie::AllowList</code> resource specifies an allow list.
 * <p>
 * In Amazon Macie , an allow list defines specific text or a text pattern for Macie to ignore when it inspects data sources for sensitive data. If data matches text or a text pattern in an allow list, Macie doesn’t report the data in sensitive data findings or sensitive data discovery results, even if the data matches the criteria of a custom data identifier or a managed data identifier. You can create and use allow lists in all the AWS Regions where Macie is currently available except the Asia Pacific (Osaka) Region.
 * <p>
 * Macie supports two types of allow lists:
 * <p>
 * <ul>
 * <li><em>Predefined text</em> - For this type of list ( <code>S3WordsList</code> ), you create a line-delimited plaintext file that lists specific text to ignore, and you store the file in an Amazon Simple Storage Service ( Amazon S3 ) bucket. You then configure settings for Macie to access the list in the bucket.</li>
 * </ul>
 * <p>
 * This type of list typically contains specific words, phrases, and other kinds of character sequences that aren’t sensitive, aren't likely to change, and don’t necessarily adhere to a common pattern. If you use this type of list, Macie doesn't report occurrences of text that exactly match a complete entry in the list. Macie treats each entry in the list as a string literal value. Matches aren't case sensitive.
 * <p>
 * <ul>
 * <li><em>Regular expression</em> - For this type of list ( <code>Regex</code> ), you specify a regular expression that defines a text pattern to ignore. Unlike an allow list with predefined text, you store the regex and all other list settings in Macie .</li>
 * </ul>
 * <p>
 * This type of list is helpful if you want to specify text that isn’t sensitive but varies or is likely to change while also adhering to a common pattern. If you use this type of list, Macie doesn't report occurrences of text that completely match the pattern defined by the list.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/allow-lists.html">Defining sensitive data exceptions with allow lists</a> in the <em>Amazon Macie User Guide</em> .
 * <p>
 * An <code>AWS::Macie::Session</code> resource must exist for an AWS account before you can create an <code>AWS::Macie::AllowList</code> resource for the account. Use a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn attribute</a> to ensure that an <code>AWS::Macie::Session</code> resource is created before other Macie resources are created for an account. For example, <code>"DependsOn": "Session"</code> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.macie.*;
 * CfnAllowList cfnAllowList = CfnAllowList.Builder.create(this, "MyCfnAllowList")
 *         .criteria(CriteriaProperty.builder()
 *                 .regex("regex")
 *                 .s3WordsList(S3WordsListProperty.builder()
 *                         .bucketName("bucketName")
 *                         .objectKey("objectKey")
 *                         .build())
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-allowlist.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-allowlist.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:36.465Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_macie.CfnAllowList")
public class CfnAllowList extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnAllowList(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAllowList(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.macie.CfnAllowList.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAllowList(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.macie.CfnAllowListProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the allow list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the allow list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current status of the allow list, which indicates whether Amazon Macie can access and use the list's criteria.
     * <p>
     * If the list's criteria specify a regular expression ( <code>Regex</code> ), this value is typically <code>OK</code> . Macie can compile the expression. If the list's criteria specify an Amazon S3 object ( <code>S3WordsList</code> ), possible values are:
     * <p>
     * <ul>
     * <li><code>OK</code> - Macie can retrieve and parse the contents of the object.</li>
     * <li><code>S3_OBJECT_ACCESS_DENIED</code> - Macie isn't allowed to access the object or the object is encrypted with a customer managed AWS KMS key that Macie isn't allowed to use. Check the bucket policy and other permissions settings for the bucket and the object. If the object is encrypted, also ensure that it's encrypted with a key that Macie is allowed to use.</li>
     * <li><code>S3_OBJECT_EMPTY</code> - Macie can retrieve the object but the object doesn't contain any content. Ensure that the object contains the correct entries. Also ensure that the list's criteria specify the correct bucket and object names.</li>
     * <li><code>S3_OBJECT_NOT_FOUND</code> - The object doesn't exist in Amazon S3 . Ensure that the list's criteria specify the correct bucket and object names.</li>
     * <li><code>S3_OBJECT_OVERSIZE</code> - Macie can retrieve the object. However, the object contains too many entries or its storage size exceeds the quota for an allow list. Try breaking the list into multiple files and ensure that each file doesn't exceed any quotas. Then configure list settings in Macie for each file.</li>
     * <li><code>S3_THROTTLED</code> - Amazon S3 throttled the request to retrieve the object. Wait a few minutes and then try again.</li>
     * <li><code>S3_USER_ACCESS_DENIED</code> - Amazon S3 denied the request to retrieve the object. If the specified object exists, you're not allowed to access it or it's encrypted with an AWS KMS key that you're not allowed to use. Work with your AWS administrator to ensure that the list's criteria specify the correct bucket and object names, and you have read access to the bucket and the object. If the object is encrypted, also ensure that it's encrypted with a key that you're allowed to use.</li>
     * <li><code>UNKNOWN_ERROR</code> - A transient or internal error occurred when Macie attempted to retrieve or parse the object. Wait a few minutes and then try again. A list can also have this status if it's encrypted with a key that Amazon S3 and Macie can't access or use.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/allow-lists-options.html">Allow list options and requirements</a> in the <em>Amazon Macie User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The criteria that specify the text or text pattern to ignore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getCriteria() {
        return software.amazon.jsii.Kernel.get(this, "criteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The criteria that specify the text or text pattern to ignore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCriteria(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "criteria", java.util.Objects.requireNonNull(value, "criteria is required"));
    }

    /**
     * The criteria that specify the text or text pattern to ignore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCriteria(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.macie.CfnAllowList.CriteriaProperty value) {
        software.amazon.jsii.Kernel.set(this, "criteria", java.util.Objects.requireNonNull(value, "criteria is required"));
    }

    /**
     * A custom name for the allow list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A custom name for the allow list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * A custom description of the allow list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A custom description of the allow list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * An array of key-value pairs to apply to the allow list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to the allow list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Specifies the criteria for an allow list, which is a list that defines specific text or a text pattern to ignore when inspecting data sources for sensitive data.
     * <p>
     * The criteria can be:
     * <p>
     * <ul>
     * <li>The location and name of an Amazon Simple Storage Service ( Amazon S3 ) object that lists specific, predefined text to ignore ( <code>S3WordsList</code> ), or</li>
     * <li>A regular expression ( <code>Regex</code> ) that defines a text pattern to ignore.</li>
     * </ul>
     * <p>
     * The criteria must specify either an S3 object or a regular expression. It can't specify both.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.macie.*;
     * CriteriaProperty criteriaProperty = CriteriaProperty.builder()
     *         .regex("regex")
     *         .s3WordsList(S3WordsListProperty.builder()
     *                 .bucketName("bucketName")
     *                 .objectKey("objectKey")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-macie-allowlist-criteria.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-macie-allowlist-criteria.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_macie.CfnAllowList.CriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(CriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The regular expression ( <em>regex</em> ) that defines the text pattern to ignore.
         * <p>
         * The expression can contain 1-512 characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-macie-allowlist-criteria.html#cfn-macie-allowlist-criteria-regex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-macie-allowlist-criteria.html#cfn-macie-allowlist-criteria-regex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegex() {
            return null;
        }

        /**
         * The location and name of an Amazon S3 object that lists specific text to ignore.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-macie-allowlist-criteria.html#cfn-macie-allowlist-criteria-s3wordslist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-macie-allowlist-criteria.html#cfn-macie-allowlist-criteria-s3wordslist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3WordsList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CriteriaProperty> {
            java.lang.String regex;
            java.lang.Object s3WordsList;

            /**
             * Sets the value of {@link CriteriaProperty#getRegex}
             * @param regex The regular expression ( <em>regex</em> ) that defines the text pattern to ignore.
             *              The expression can contain 1-512 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regex(java.lang.String regex) {
                this.regex = regex;
                return this;
            }

            /**
             * Sets the value of {@link CriteriaProperty#getS3WordsList}
             * @param s3WordsList The location and name of an Amazon S3 object that lists specific text to ignore.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3WordsList(software.amazon.awscdk.IResolvable s3WordsList) {
                this.s3WordsList = s3WordsList;
                return this;
            }

            /**
             * Sets the value of {@link CriteriaProperty#getS3WordsList}
             * @param s3WordsList The location and name of an Amazon S3 object that lists specific text to ignore.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3WordsList(software.amazon.awscdk.services.macie.CfnAllowList.S3WordsListProperty s3WordsList) {
                this.s3WordsList = s3WordsList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CriteriaProperty {
            private final java.lang.String regex;
            private final java.lang.Object s3WordsList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.regex = software.amazon.jsii.Kernel.get(this, "regex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3WordsList = software.amazon.jsii.Kernel.get(this, "s3WordsList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.regex = builder.regex;
                this.s3WordsList = builder.s3WordsList;
            }

            @Override
            public final java.lang.String getRegex() {
                return this.regex;
            }

            @Override
            public final java.lang.Object getS3WordsList() {
                return this.s3WordsList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRegex() != null) {
                    data.set("regex", om.valueToTree(this.getRegex()));
                }
                if (this.getS3WordsList() != null) {
                    data.set("s3WordsList", om.valueToTree(this.getS3WordsList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_macie.CfnAllowList.CriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CriteriaProperty.Jsii$Proxy that = (CriteriaProperty.Jsii$Proxy) o;

                if (this.regex != null ? !this.regex.equals(that.regex) : that.regex != null) return false;
                return this.s3WordsList != null ? this.s3WordsList.equals(that.s3WordsList) : that.s3WordsList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.regex != null ? this.regex.hashCode() : 0;
                result = 31 * result + (this.s3WordsList != null ? this.s3WordsList.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the location and name of an Amazon Simple Storage Service ( Amazon S3 ) object that lists specific, predefined text to ignore when inspecting data sources for sensitive data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.macie.*;
     * S3WordsListProperty s3WordsListProperty = S3WordsListProperty.builder()
     *         .bucketName("bucketName")
     *         .objectKey("objectKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-macie-allowlist-s3wordslist.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-macie-allowlist-s3wordslist.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_macie.CfnAllowList.S3WordsListProperty")
    @software.amazon.jsii.Jsii.Proxy(S3WordsListProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3WordsListProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The full name of the S3 bucket that contains the object.
         * <p>
         * This value correlates to the <code>Name</code> field of a bucket's properties in Amazon S3 .
         * <p>
         * This value is case sensitive. In addition, don't use wildcard characters or specify partial values for the name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-macie-allowlist-s3wordslist.html#cfn-macie-allowlist-s3wordslist-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-macie-allowlist-s3wordslist.html#cfn-macie-allowlist-s3wordslist-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The full name of the S3 object.
         * <p>
         * This value correlates to the <code>Key</code> field of an object's properties in Amazon S3 . If the name includes a path, include the complete path. For example, <code>AllowLists/Macie/MyList.txt</code> .
         * <p>
         * This value is case sensitive. In addition, don't use wildcard characters or specify partial values for the name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-macie-allowlist-s3wordslist.html#cfn-macie-allowlist-s3wordslist-objectkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-macie-allowlist-s3wordslist.html#cfn-macie-allowlist-s3wordslist-objectkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObjectKey();

        /**
         * @return a {@link Builder} of {@link S3WordsListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3WordsListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3WordsListProperty> {
            java.lang.String bucketName;
            java.lang.String objectKey;

            /**
             * Sets the value of {@link S3WordsListProperty#getBucketName}
             * @param bucketName The full name of the S3 bucket that contains the object. This parameter is required.
             *                   This value correlates to the <code>Name</code> field of a bucket's properties in Amazon S3 .
             *                   <p>
             *                   This value is case sensitive. In addition, don't use wildcard characters or specify partial values for the name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3WordsListProperty#getObjectKey}
             * @param objectKey The full name of the S3 object. This parameter is required.
             *                  This value correlates to the <code>Key</code> field of an object's properties in Amazon S3 . If the name includes a path, include the complete path. For example, <code>AllowLists/Macie/MyList.txt</code> .
             *                  <p>
             *                  This value is case sensitive. In addition, don't use wildcard characters or specify partial values for the name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectKey(java.lang.String objectKey) {
                this.objectKey = objectKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3WordsListProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3WordsListProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3WordsListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3WordsListProperty {
            private final java.lang.String bucketName;
            private final java.lang.String objectKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.objectKey = software.amazon.jsii.Kernel.get(this, "objectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.objectKey = java.util.Objects.requireNonNull(builder.objectKey, "objectKey is required");
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getObjectKey() {
                return this.objectKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                data.set("objectKey", om.valueToTree(this.getObjectKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_macie.CfnAllowList.S3WordsListProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3WordsListProperty.Jsii$Proxy that = (S3WordsListProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                return this.objectKey.equals(that.objectKey);
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.objectKey.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.macie.CfnAllowList}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.macie.CfnAllowList> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.macie.CfnAllowListProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.macie.CfnAllowListProps.Builder();
        }

        /**
         * The criteria that specify the text or text pattern to ignore.
         * <p>
         * The criteria can be the location and name of an Amazon S3 object that lists specific text to ignore ( <code>S3WordsList</code> ), or a regular expression ( <code>Regex</code> ) that defines a text pattern to ignore.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-allowlist.html#cfn-macie-allowlist-criteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-allowlist.html#cfn-macie-allowlist-criteria</a>
         * @param criteria The criteria that specify the text or text pattern to ignore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder criteria(final software.amazon.awscdk.IResolvable criteria) {
            this.props.criteria(criteria);
            return this;
        }
        /**
         * The criteria that specify the text or text pattern to ignore.
         * <p>
         * The criteria can be the location and name of an Amazon S3 object that lists specific text to ignore ( <code>S3WordsList</code> ), or a regular expression ( <code>Regex</code> ) that defines a text pattern to ignore.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-allowlist.html#cfn-macie-allowlist-criteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-allowlist.html#cfn-macie-allowlist-criteria</a>
         * @param criteria The criteria that specify the text or text pattern to ignore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder criteria(final software.amazon.awscdk.services.macie.CfnAllowList.CriteriaProperty criteria) {
            this.props.criteria(criteria);
            return this;
        }

        /**
         * A custom name for the allow list.
         * <p>
         * The name can contain 1-128 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-allowlist.html#cfn-macie-allowlist-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-allowlist.html#cfn-macie-allowlist-name</a>
         * @param name A custom name for the allow list. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A custom description of the allow list.
         * <p>
         * The description can contain 1-512 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-allowlist.html#cfn-macie-allowlist-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-allowlist.html#cfn-macie-allowlist-description</a>
         * @param description A custom description of the allow list. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * An array of key-value pairs to apply to the allow list.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-allowlist.html#cfn-macie-allowlist-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-macie-allowlist.html#cfn-macie-allowlist-tags</a>
         * @param tags An array of key-value pairs to apply to the allow list. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.macie.CfnAllowList}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.macie.CfnAllowList build() {
            return new software.amazon.awscdk.services.macie.CfnAllowList(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
