package software.amazon.awscdk.services.neptunegraph;

/**
 * Properties for defining a <code>CfnGraph</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.neptunegraph.*;
 * CfnGraphProps cfnGraphProps = CfnGraphProps.builder()
 *         .provisionedMemory(123)
 *         // the properties below are optional
 *         .deletionProtection(false)
 *         .graphName("graphName")
 *         .publicConnectivity(false)
 *         .replicaCount(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vectorSearchConfiguration(VectorSearchConfigurationProperty.builder()
 *                 .vectorSearchDimension(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:36.942Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_neptunegraph.CfnGraphProps")
@software.amazon.jsii.Jsii.Proxy(CfnGraphProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGraphProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
     * <p>
     * Min = 128
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-provisionedmemory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-provisionedmemory</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getProvisionedMemory();

    /**
     * A value that indicates whether the graph has deletion protection enabled.
     * <p>
     * The graph can't be deleted when deletion protection is enabled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-deletionprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-deletionprotection</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return null;
    }

    /**
     * The graph name. For example: <code>my-graph-1</code> .
     * <p>
     * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens.
     * <p>
     * If you don't specify a graph name, a unique graph name is generated for you using the prefix <code>graph-for</code> , followed by a combination of <code>Stack Name</code> and a <code>UUID</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-graphname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-graphname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGraphName() {
        return null;
    }

    /**
     * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated.
     * <p>
     * When the graph is publicly available, its domain name system (DNS) endpoint resolves to the public IP address from the internet. When the graph isn't publicly available, you need to create a <code>PrivateGraphEndpoint</code> in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.
     * <p>
     * Default: If not specified, the default value is false.
     * <p>
     * <blockquote>
     * <p>
     * If enabling public connectivity for the first time, there will be a delay while it is enabled.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-publicconnectivity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-publicconnectivity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPublicConnectivity() {
        return null;
    }

    /**
     * The number of replicas in other AZs.
     * <p>
     * Default: If not specified, the default value is 1.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-replicacount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-replicacount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getReplicaCount() {
        return null;
    }

    /**
     * Adds metadata tags to the new graph.
     * <p>
     * These tags can also be used with cost allocation reporting, or used in a Condition statement in an IAM policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Specifies the number of dimensions for vector embeddings that will be loaded into the graph.
     * <p>
     * The value is specified as <code>dimension=</code> value. Max = 65,535
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-vectorsearchconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-neptunegraph-graph.html#cfn-neptunegraph-graph-vectorsearchconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVectorSearchConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGraphProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGraphProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGraphProps> {
        java.lang.Number provisionedMemory;
        java.lang.Object deletionProtection;
        java.lang.String graphName;
        java.lang.Object publicConnectivity;
        java.lang.Number replicaCount;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object vectorSearchConfiguration;

        /**
         * Sets the value of {@link CfnGraphProps#getProvisionedMemory}
         * @param provisionedMemory The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. This parameter is required.
         *                          Min = 128
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedMemory(java.lang.Number provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphProps#getDeletionProtection}
         * @param deletionProtection A value that indicates whether the graph has deletion protection enabled.
         *                           The graph can't be deleted when deletion protection is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphProps#getDeletionProtection}
         * @param deletionProtection A value that indicates whether the graph has deletion protection enabled.
         *                           The graph can't be deleted when deletion protection is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(software.amazon.awscdk.IResolvable deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphProps#getGraphName}
         * @param graphName The graph name. For example: <code>my-graph-1</code> .
         *                  The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens.
         *                  <p>
         *                  If you don't specify a graph name, a unique graph name is generated for you using the prefix <code>graph-for</code> , followed by a combination of <code>Stack Name</code> and a <code>UUID</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder graphName(java.lang.String graphName) {
            this.graphName = graphName;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphProps#getPublicConnectivity}
         * @param publicConnectivity Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated.
         *                           When the graph is publicly available, its domain name system (DNS) endpoint resolves to the public IP address from the internet. When the graph isn't publicly available, you need to create a <code>PrivateGraphEndpoint</code> in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.
         *                           <p>
         *                           Default: If not specified, the default value is false.
         *                           <p>
         *                           <blockquote>
         *                           <p>
         *                           If enabling public connectivity for the first time, there will be a delay while it is enabled.
         *                           <p>
         *                           </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicConnectivity(java.lang.Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphProps#getPublicConnectivity}
         * @param publicConnectivity Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated.
         *                           When the graph is publicly available, its domain name system (DNS) endpoint resolves to the public IP address from the internet. When the graph isn't publicly available, you need to create a <code>PrivateGraphEndpoint</code> in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.
         *                           <p>
         *                           Default: If not specified, the default value is false.
         *                           <p>
         *                           <blockquote>
         *                           <p>
         *                           If enabling public connectivity for the first time, there will be a delay while it is enabled.
         *                           <p>
         *                           </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicConnectivity(software.amazon.awscdk.IResolvable publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphProps#getReplicaCount}
         * @param replicaCount The number of replicas in other AZs.
         *                     Default: If not specified, the default value is 1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicaCount(java.lang.Number replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphProps#getTags}
         * @param tags Adds metadata tags to the new graph.
         *             These tags can also be used with cost allocation reporting, or used in a Condition statement in an IAM policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphProps#getVectorSearchConfiguration}
         * @param vectorSearchConfiguration Specifies the number of dimensions for vector embeddings that will be loaded into the graph.
         *                                  The value is specified as <code>dimension=</code> value. Max = 65,535
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorSearchConfiguration(software.amazon.awscdk.IResolvable vectorSearchConfiguration) {
            this.vectorSearchConfiguration = vectorSearchConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphProps#getVectorSearchConfiguration}
         * @param vectorSearchConfiguration Specifies the number of dimensions for vector embeddings that will be loaded into the graph.
         *                                  The value is specified as <code>dimension=</code> value. Max = 65,535
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorSearchConfiguration(software.amazon.awscdk.services.neptunegraph.CfnGraph.VectorSearchConfigurationProperty vectorSearchConfiguration) {
            this.vectorSearchConfiguration = vectorSearchConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGraphProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGraphProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGraphProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGraphProps {
        private final java.lang.Number provisionedMemory;
        private final java.lang.Object deletionProtection;
        private final java.lang.String graphName;
        private final java.lang.Object publicConnectivity;
        private final java.lang.Number replicaCount;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object vectorSearchConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.provisionedMemory = software.amazon.jsii.Kernel.get(this, "provisionedMemory", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.graphName = software.amazon.jsii.Kernel.get(this, "graphName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publicConnectivity = software.amazon.jsii.Kernel.get(this, "publicConnectivity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.replicaCount = software.amazon.jsii.Kernel.get(this, "replicaCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.vectorSearchConfiguration = software.amazon.jsii.Kernel.get(this, "vectorSearchConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.provisionedMemory = java.util.Objects.requireNonNull(builder.provisionedMemory, "provisionedMemory is required");
            this.deletionProtection = builder.deletionProtection;
            this.graphName = builder.graphName;
            this.publicConnectivity = builder.publicConnectivity;
            this.replicaCount = builder.replicaCount;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.vectorSearchConfiguration = builder.vectorSearchConfiguration;
        }

        @Override
        public final java.lang.Number getProvisionedMemory() {
            return this.provisionedMemory;
        }

        @Override
        public final java.lang.Object getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final java.lang.String getGraphName() {
            return this.graphName;
        }

        @Override
        public final java.lang.Object getPublicConnectivity() {
            return this.publicConnectivity;
        }

        @Override
        public final java.lang.Number getReplicaCount() {
            return this.replicaCount;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getVectorSearchConfiguration() {
            return this.vectorSearchConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("provisionedMemory", om.valueToTree(this.getProvisionedMemory()));
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getGraphName() != null) {
                data.set("graphName", om.valueToTree(this.getGraphName()));
            }
            if (this.getPublicConnectivity() != null) {
                data.set("publicConnectivity", om.valueToTree(this.getPublicConnectivity()));
            }
            if (this.getReplicaCount() != null) {
                data.set("replicaCount", om.valueToTree(this.getReplicaCount()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVectorSearchConfiguration() != null) {
                data.set("vectorSearchConfiguration", om.valueToTree(this.getVectorSearchConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_neptunegraph.CfnGraphProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGraphProps.Jsii$Proxy that = (CfnGraphProps.Jsii$Proxy) o;

            if (!provisionedMemory.equals(that.provisionedMemory)) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.graphName != null ? !this.graphName.equals(that.graphName) : that.graphName != null) return false;
            if (this.publicConnectivity != null ? !this.publicConnectivity.equals(that.publicConnectivity) : that.publicConnectivity != null) return false;
            if (this.replicaCount != null ? !this.replicaCount.equals(that.replicaCount) : that.replicaCount != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vectorSearchConfiguration != null ? this.vectorSearchConfiguration.equals(that.vectorSearchConfiguration) : that.vectorSearchConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.provisionedMemory.hashCode();
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.graphName != null ? this.graphName.hashCode() : 0);
            result = 31 * result + (this.publicConnectivity != null ? this.publicConnectivity.hashCode() : 0);
            result = 31 * result + (this.replicaCount != null ? this.replicaCount.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vectorSearchConfiguration != null ? this.vectorSearchConfiguration.hashCode() : 0);
            return result;
        }
    }
}
