package software.amazon.awscdk.services.opsworks;

/**
 * Properties for defining a <code>CfnStack</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opsworks.*;
 * Object customJson;
 * CfnStackProps cfnStackProps = CfnStackProps.builder()
 *         .defaultInstanceProfileArn("defaultInstanceProfileArn")
 *         .name("name")
 *         .serviceRoleArn("serviceRoleArn")
 *         // the properties below are optional
 *         .agentVersion("agentVersion")
 *         .attributes(Map.of(
 *                 "attributesKey", "attributes"))
 *         .chefConfiguration(ChefConfigurationProperty.builder()
 *                 .berkshelfVersion("berkshelfVersion")
 *                 .manageBerkshelf(false)
 *                 .build())
 *         .cloneAppIds(List.of("cloneAppIds"))
 *         .clonePermissions(false)
 *         .configurationManager(StackConfigurationManagerProperty.builder()
 *                 .name("name")
 *                 .version("version")
 *                 .build())
 *         .customCookbooksSource(SourceProperty.builder()
 *                 .password("password")
 *                 .revision("revision")
 *                 .sshKey("sshKey")
 *                 .type("type")
 *                 .url("url")
 *                 .username("username")
 *                 .build())
 *         .customJson(customJson)
 *         .defaultAvailabilityZone("defaultAvailabilityZone")
 *         .defaultOs("defaultOs")
 *         .defaultRootDeviceType("defaultRootDeviceType")
 *         .defaultSshKeyName("defaultSshKeyName")
 *         .defaultSubnetId("defaultSubnetId")
 *         .ecsClusterArn("ecsClusterArn")
 *         .elasticIps(List.of(ElasticIpProperty.builder()
 *                 .ip("ip")
 *                 // the properties below are optional
 *                 .name("name")
 *                 .build()))
 *         .hostnameTheme("hostnameTheme")
 *         .rdsDbInstances(List.of(RdsDbInstanceProperty.builder()
 *                 .dbPassword("dbPassword")
 *                 .dbUser("dbUser")
 *                 .rdsDbInstanceArn("rdsDbInstanceArn")
 *                 .build()))
 *         .sourceStackId("sourceStackId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .useCustomCookbooks(false)
 *         .useOpsworksSecurityGroups(false)
 *         .vpcId("vpcId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:37.208Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnStackProps")
@software.amazon.jsii.Jsii.Proxy(CfnStackProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStackProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances.
     * <p>
     * For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultinstanceprofilearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultinstanceprofilearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDefaultInstanceProfileArn();

    /**
     * The stack name.
     * <p>
     * Stack names can be a maximum of 64 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The stack's IAM role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf.
     * <p>
     * You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-servicerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-servicerolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceRoleArn();

    /**
     * The default AWS OpsWorks Stacks agent version. You have the following options:.
     * <p>
     * <ul>
     * <li>Auto-update - Set this parameter to <code>LATEST</code> . AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.</li>
     * <li>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks installs that version on the stack's instances.</li>
     * </ul>
     * <p>
     * The default setting is the most recent release of the agent. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code> . AgentVersion cannot be set to Chef 12.2.
     * <p>
     * <blockquote>
     * <p>
     * You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-agentversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-agentversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAgentVersion() {
        return null;
    }

    /**
     * One or more user-defined key-value pairs to be added to the stack attributes.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-attributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-attributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
        return null;
    }

    /**
     * A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-chefconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-chefconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getChefConfiguration() {
        return null;
    }

    /**
     * If you're cloning an AWS OpsWorks stack, a list of AWS OpsWorks application stack IDs from the source stack to include in the cloned stack.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-cloneappids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-cloneappids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCloneAppIds() {
        return null;
    }

    /**
     * If you're cloning an AWS OpsWorks stack, indicates whether to clone the source stack's permissions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-clonepermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-clonepermissions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getClonePermissions() {
        return null;
    }

    /**
     * The configuration manager.
     * <p>
     * When you create a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-configurationmanager">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-configurationmanager</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationManager() {
        return null;
    }

    /**
     * Contains the information required to retrieve an app or cookbook from a repository.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-customcookbookssource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-customcookbookssource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomCookbooksSource() {
        return null;
    }

    /**
     * A string that contains user-defined, custom JSON.
     * <p>
     * It can be used to override the corresponding default stack configuration attribute values or to pass data to recipes. The string should be in the following format:
     * <p>
     * <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
     * <p>
     * For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-customjson">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-customjson</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomJson() {
        return null;
    }

    /**
     * The stack's default Availability Zone, which must be in the specified region.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a> . If you also specify a value for <code>DefaultSubnetId</code> , the subnet must be in the same zone. For more information, see the <code>VpcId</code> parameter description.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultavailabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultavailabilityzone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultAvailabilityZone() {
        return null;
    }

    /**
     * The stack's default operating system, which is installed on every instance unless you specify a different operating system when you create the instance.
     * <p>
     * You can specify one of the following.
     * <p>
     * <ul>
     * <li>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2</code> , <code>Amazon Linux 2018.03</code> , <code>Amazon Linux 2017.09</code> , <code>Amazon Linux 2017.03</code> , <code>Amazon Linux 2016.09</code> , <code>Amazon Linux 2016.03</code> , <code>Amazon Linux 2015.09</code> , or <code>Amazon Linux 2015.03</code> .</li>
     * <li>A supported Ubuntu operating system, such as <code>Ubuntu 18.04 LTS</code> , <code>Ubuntu 16.04 LTS</code> , <code>Ubuntu 14.04 LTS</code> , or <code>Ubuntu 12.04 LTS</code> .</li>
     * <li><code>CentOS Linux 7</code></li>
     * <li><code>Red Hat Enterprise Linux 7</code></li>
     * <li>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code> , <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code> , <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code> , or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code> .</li>
     * <li>A custom AMI: <code>Custom</code> . You specify the custom AMI you want to use when you create instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a> .</li>
     * </ul>
     * <p>
     * The default option is the current Amazon Linux version. Not all operating systems are supported with all versions of Chef. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultos">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultos</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultOs() {
        return null;
    }

    /**
     * The default root device type.
     * <p>
     * This value is the default for all instances in the stack, but you can override it when you create an instance. The default option is <code>instance-store</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultrootdevicetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultrootdevicetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultRootDeviceType() {
        return null;
    }

    /**
     * A default Amazon EC2 key pair name.
     * <p>
     * The default value is none. If you specify a key pair name, AWS OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html">Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html">Managing SSH Access</a> . You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html">create an instance</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultsshkeyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultsshkeyname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultSshKeyName() {
        return null;
    }

    /**
     * The stack's default subnet ID.
     * <p>
     * All instances are launched into this subnet unless you specify another subnet ID when you create the instance. This parameter is required if you specify a value for the <code>VpcId</code> parameter. If you also specify a value for <code>DefaultAvailabilityZone</code> , the subnet must be in that zone.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultsubnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultsubnetid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultSubnetId() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Elastic Container Service ( Amazon ECS ) cluster to register with the AWS OpsWorks stack.
     * <p>
     * <blockquote>
     * <p>
     * If you specify a cluster that's registered with another AWS OpsWorks stack, AWS CloudFormation deregisters the existing association before registering the cluster.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-ecsclusterarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-ecsclusterarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEcsClusterArn() {
        return null;
    }

    /**
     * A list of Elastic IP addresses to register with the AWS OpsWorks stack.
     * <p>
     * <blockquote>
     * <p>
     * If you specify an IP address that's registered with another AWS OpsWorks stack, AWS CloudFormation deregisters the existing association before registering the IP address.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-elasticips">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-elasticips</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getElasticIps() {
        return null;
    }

    /**
     * The stack's host name theme, with spaces replaced by underscores.
     * <p>
     * The theme is used to generate host names for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code> , which creates host names by appending integers to the layer's short name. The other themes are:
     * <p>
     * <ul>
     * <li><code>Baked_Goods</code></li>
     * <li><code>Clouds</code></li>
     * <li><code>Europe_Cities</code></li>
     * <li><code>Fruits</code></li>
     * <li><code>Greek_Deities_and_Titans</code></li>
     * <li><code>Legendary_creatures_from_Japan</code></li>
     * <li><code>Planets_and_Moons</code></li>
     * <li><code>Roman_Deities</code></li>
     * <li><code>Scottish_Islands</code></li>
     * <li><code>US_Cities</code></li>
     * <li><code>Wild_Cats</code></li>
     * </ul>
     * <p>
     * To obtain a generated host name, call <code>GetHostNameSuggestion</code> , which returns a host name based on the current theme.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-hostnametheme">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-hostnametheme</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHostnameTheme() {
        return null;
    }

    /**
     * The Amazon Relational Database Service ( Amazon RDS ) database instance to register with the AWS OpsWorks stack.
     * <p>
     * <blockquote>
     * <p>
     * If you specify a database instance that's registered with another AWS OpsWorks stack, AWS CloudFormation deregisters the existing association before registering the database instance.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-rdsdbinstances">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-rdsdbinstances</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRdsDbInstances() {
        return null;
    }

    /**
     * If you're cloning an AWS OpsWorks stack, the stack ID of the source AWS OpsWorks stack to clone.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-sourcestackid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-sourcestackid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceStackId() {
        return null;
    }

    /**
     * A map that contains tag keys and tag values that are attached to a stack or layer.
     * <p>
     * <ul>
     * <li>The key cannot be empty.</li>
     * <li>The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code></li>
     * <li>The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code></li>
     * <li>Leading and trailing white spaces are trimmed from both the key and value.</li>
     * <li>A maximum of 40 tags is allowed for any resource.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Whether the stack uses custom cookbooks.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-usecustomcookbooks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-usecustomcookbooks</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUseCustomCookbooks() {
        return null;
    }

    /**
     * Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.
     * <p>
     * AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
     * <p>
     * <ul>
     * <li>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.</li>
     * <li>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-useopsworkssecuritygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-useopsworkssecuritygroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUseOpsworksSecurityGroups() {
        return null;
    }

    /**
     * The ID of the VPC that the stack is to be launched into.
     * <p>
     * The VPC must be in the stack's region. All instances are launched into this VPC. You cannot change the ID later.
     * <p>
     * <ul>
     * <li>If your account supports EC2-Classic, the default value is <code>no VPC</code> .</li>
     * <li>If your account does not support EC2-Classic, the default value is the default VPC for the specified region.</li>
     * </ul>
     * <p>
     * If the VPC ID corresponds to a default VPC and you have specified either the <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively.
     * <p>
     * If you specify a nondefault VPC ID, note the following:
     * <p>
     * <ul>
     * <li>It must belong to a VPC in your account that is in the specified region.</li>
     * <li>You must specify a value for <code>DefaultSubnetId</code> .</li>
     * </ul>
     * <p>
     * For more information about how to use AWS OpsWorks Stacks with a VPC, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a VPC</a> . For more information about default VPC and EC2-Classic, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-vpcid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStackProps> {
        java.lang.String defaultInstanceProfileArn;
        java.lang.String name;
        java.lang.String serviceRoleArn;
        java.lang.String agentVersion;
        java.lang.Object attributes;
        java.lang.Object chefConfiguration;
        java.util.List<java.lang.String> cloneAppIds;
        java.lang.Object clonePermissions;
        java.lang.Object configurationManager;
        java.lang.Object customCookbooksSource;
        java.lang.Object customJson;
        java.lang.String defaultAvailabilityZone;
        java.lang.String defaultOs;
        java.lang.String defaultRootDeviceType;
        java.lang.String defaultSshKeyName;
        java.lang.String defaultSubnetId;
        java.lang.String ecsClusterArn;
        java.lang.Object elasticIps;
        java.lang.String hostnameTheme;
        java.lang.Object rdsDbInstances;
        java.lang.String sourceStackId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object useCustomCookbooks;
        java.lang.Object useOpsworksSecurityGroups;
        java.lang.String vpcId;

        /**
         * Sets the value of {@link CfnStackProps#getDefaultInstanceProfileArn}
         * @param defaultInstanceProfileArn The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances. This parameter is required.
         *                                  For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultInstanceProfileArn(java.lang.String defaultInstanceProfileArn) {
            this.defaultInstanceProfileArn = defaultInstanceProfileArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getName}
         * @param name The stack name. This parameter is required.
         *             Stack names can be a maximum of 64 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getServiceRoleArn}
         * @param serviceRoleArn The stack's IAM role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf. This parameter is required.
         *                       You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRoleArn(java.lang.String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getAgentVersion}
         * @param agentVersion The default AWS OpsWorks Stacks agent version. You have the following options:.
         *                     <ul>
         *                     <li>Auto-update - Set this parameter to <code>LATEST</code> . AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.</li>
         *                     <li>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks installs that version on the stack's instances.</li>
         *                     </ul>
         *                     <p>
         *                     The default setting is the most recent release of the agent. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code> . AgentVersion cannot be set to Chef 12.2.
         *                     <p>
         *                     <blockquote>
         *                     <p>
         *                     You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentVersion(java.lang.String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getAttributes}
         * @param attributes One or more user-defined key-value pairs to be added to the stack attributes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(software.amazon.awscdk.IResolvable attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getAttributes}
         * @param attributes One or more user-defined key-value pairs to be added to the stack attributes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(java.util.Map<java.lang.String, java.lang.String> attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getChefConfiguration}
         * @param chefConfiguration A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chefConfiguration(software.amazon.awscdk.IResolvable chefConfiguration) {
            this.chefConfiguration = chefConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getChefConfiguration}
         * @param chefConfiguration A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chefConfiguration(software.amazon.awscdk.services.opsworks.CfnStack.ChefConfigurationProperty chefConfiguration) {
            this.chefConfiguration = chefConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getCloneAppIds}
         * @param cloneAppIds If you're cloning an AWS OpsWorks stack, a list of AWS OpsWorks application stack IDs from the source stack to include in the cloned stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloneAppIds(java.util.List<java.lang.String> cloneAppIds) {
            this.cloneAppIds = cloneAppIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getClonePermissions}
         * @param clonePermissions If you're cloning an AWS OpsWorks stack, indicates whether to clone the source stack's permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clonePermissions(java.lang.Boolean clonePermissions) {
            this.clonePermissions = clonePermissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getClonePermissions}
         * @param clonePermissions If you're cloning an AWS OpsWorks stack, indicates whether to clone the source stack's permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clonePermissions(software.amazon.awscdk.IResolvable clonePermissions) {
            this.clonePermissions = clonePermissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getConfigurationManager}
         * @param configurationManager The configuration manager.
         *                             When you create a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationManager(software.amazon.awscdk.IResolvable configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getConfigurationManager}
         * @param configurationManager The configuration manager.
         *                             When you create a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationManager(software.amazon.awscdk.services.opsworks.CfnStack.StackConfigurationManagerProperty configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getCustomCookbooksSource}
         * @param customCookbooksSource Contains the information required to retrieve an app or cookbook from a repository.
         *                              For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customCookbooksSource(software.amazon.awscdk.IResolvable customCookbooksSource) {
            this.customCookbooksSource = customCookbooksSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getCustomCookbooksSource}
         * @param customCookbooksSource Contains the information required to retrieve an app or cookbook from a repository.
         *                              For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customCookbooksSource(software.amazon.awscdk.services.opsworks.CfnStack.SourceProperty customCookbooksSource) {
            this.customCookbooksSource = customCookbooksSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getCustomJson}
         * @param customJson A string that contains user-defined, custom JSON.
         *                   It can be used to override the corresponding default stack configuration attribute values or to pass data to recipes. The string should be in the following format:
         *                   <p>
         *                   <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
         *                   <p>
         *                   For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customJson(java.lang.Object customJson) {
            this.customJson = customJson;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getDefaultAvailabilityZone}
         * @param defaultAvailabilityZone The stack's default Availability Zone, which must be in the specified region.
         *                                For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a> . If you also specify a value for <code>DefaultSubnetId</code> , the subnet must be in the same zone. For more information, see the <code>VpcId</code> parameter description.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAvailabilityZone(java.lang.String defaultAvailabilityZone) {
            this.defaultAvailabilityZone = defaultAvailabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getDefaultOs}
         * @param defaultOs The stack's default operating system, which is installed on every instance unless you specify a different operating system when you create the instance.
         *                  You can specify one of the following.
         *                  <p>
         *                  <ul>
         *                  <li>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2</code> , <code>Amazon Linux 2018.03</code> , <code>Amazon Linux 2017.09</code> , <code>Amazon Linux 2017.03</code> , <code>Amazon Linux 2016.09</code> , <code>Amazon Linux 2016.03</code> , <code>Amazon Linux 2015.09</code> , or <code>Amazon Linux 2015.03</code> .</li>
         *                  <li>A supported Ubuntu operating system, such as <code>Ubuntu 18.04 LTS</code> , <code>Ubuntu 16.04 LTS</code> , <code>Ubuntu 14.04 LTS</code> , or <code>Ubuntu 12.04 LTS</code> .</li>
         *                  <li><code>CentOS Linux 7</code></li>
         *                  <li><code>Red Hat Enterprise Linux 7</code></li>
         *                  <li>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code> , <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code> , <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code> , or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code> .</li>
         *                  <li>A custom AMI: <code>Custom</code> . You specify the custom AMI you want to use when you create instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a> .</li>
         *                  </ul>
         *                  <p>
         *                  The default option is the current Amazon Linux version. Not all operating systems are supported with all versions of Chef. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultOs(java.lang.String defaultOs) {
            this.defaultOs = defaultOs;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getDefaultRootDeviceType}
         * @param defaultRootDeviceType The default root device type.
         *                              This value is the default for all instances in the stack, but you can override it when you create an instance. The default option is <code>instance-store</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRootDeviceType(java.lang.String defaultRootDeviceType) {
            this.defaultRootDeviceType = defaultRootDeviceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getDefaultSshKeyName}
         * @param defaultSshKeyName A default Amazon EC2 key pair name.
         *                          The default value is none. If you specify a key pair name, AWS OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html">Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html">Managing SSH Access</a> . You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html">create an instance</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSshKeyName(java.lang.String defaultSshKeyName) {
            this.defaultSshKeyName = defaultSshKeyName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getDefaultSubnetId}
         * @param defaultSubnetId The stack's default subnet ID.
         *                        All instances are launched into this subnet unless you specify another subnet ID when you create the instance. This parameter is required if you specify a value for the <code>VpcId</code> parameter. If you also specify a value for <code>DefaultAvailabilityZone</code> , the subnet must be in that zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSubnetId(java.lang.String defaultSubnetId) {
            this.defaultSubnetId = defaultSubnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getEcsClusterArn}
         * @param ecsClusterArn The Amazon Resource Name (ARN) of the Amazon Elastic Container Service ( Amazon ECS ) cluster to register with the AWS OpsWorks stack.
         *                      <blockquote>
         *                      <p>
         *                      If you specify a cluster that's registered with another AWS OpsWorks stack, AWS CloudFormation deregisters the existing association before registering the cluster.
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecsClusterArn(java.lang.String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getElasticIps}
         * @param elasticIps A list of Elastic IP addresses to register with the AWS OpsWorks stack.
         *                   <blockquote>
         *                   <p>
         *                   If you specify an IP address that's registered with another AWS OpsWorks stack, AWS CloudFormation deregisters the existing association before registering the IP address.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticIps(software.amazon.awscdk.IResolvable elasticIps) {
            this.elasticIps = elasticIps;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getElasticIps}
         * @param elasticIps A list of Elastic IP addresses to register with the AWS OpsWorks stack.
         *                   <blockquote>
         *                   <p>
         *                   If you specify an IP address that's registered with another AWS OpsWorks stack, AWS CloudFormation deregisters the existing association before registering the IP address.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticIps(java.util.List<? extends java.lang.Object> elasticIps) {
            this.elasticIps = elasticIps;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getHostnameTheme}
         * @param hostnameTheme The stack's host name theme, with spaces replaced by underscores.
         *                      The theme is used to generate host names for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code> , which creates host names by appending integers to the layer's short name. The other themes are:
         *                      <p>
         *                      <ul>
         *                      <li><code>Baked_Goods</code></li>
         *                      <li><code>Clouds</code></li>
         *                      <li><code>Europe_Cities</code></li>
         *                      <li><code>Fruits</code></li>
         *                      <li><code>Greek_Deities_and_Titans</code></li>
         *                      <li><code>Legendary_creatures_from_Japan</code></li>
         *                      <li><code>Planets_and_Moons</code></li>
         *                      <li><code>Roman_Deities</code></li>
         *                      <li><code>Scottish_Islands</code></li>
         *                      <li><code>US_Cities</code></li>
         *                      <li><code>Wild_Cats</code></li>
         *                      </ul>
         *                      <p>
         *                      To obtain a generated host name, call <code>GetHostNameSuggestion</code> , which returns a host name based on the current theme.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostnameTheme(java.lang.String hostnameTheme) {
            this.hostnameTheme = hostnameTheme;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getRdsDbInstances}
         * @param rdsDbInstances The Amazon Relational Database Service ( Amazon RDS ) database instance to register with the AWS OpsWorks stack.
         *                       <blockquote>
         *                       <p>
         *                       If you specify a database instance that's registered with another AWS OpsWorks stack, AWS CloudFormation deregisters the existing association before registering the database instance.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rdsDbInstances(software.amazon.awscdk.IResolvable rdsDbInstances) {
            this.rdsDbInstances = rdsDbInstances;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getRdsDbInstances}
         * @param rdsDbInstances The Amazon Relational Database Service ( Amazon RDS ) database instance to register with the AWS OpsWorks stack.
         *                       <blockquote>
         *                       <p>
         *                       If you specify a database instance that's registered with another AWS OpsWorks stack, AWS CloudFormation deregisters the existing association before registering the database instance.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rdsDbInstances(java.util.List<? extends java.lang.Object> rdsDbInstances) {
            this.rdsDbInstances = rdsDbInstances;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getSourceStackId}
         * @param sourceStackId If you're cloning an AWS OpsWorks stack, the stack ID of the source AWS OpsWorks stack to clone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceStackId(java.lang.String sourceStackId) {
            this.sourceStackId = sourceStackId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getTags}
         * @param tags A map that contains tag keys and tag values that are attached to a stack or layer.
         *             <ul>
         *             <li>The key cannot be empty.</li>
         *             <li>The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code></li>
         *             <li>The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code></li>
         *             <li>Leading and trailing white spaces are trimmed from both the key and value.</li>
         *             <li>A maximum of 40 tags is allowed for any resource.</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getUseCustomCookbooks}
         * @param useCustomCookbooks Whether the stack uses custom cookbooks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useCustomCookbooks(java.lang.Boolean useCustomCookbooks) {
            this.useCustomCookbooks = useCustomCookbooks;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getUseCustomCookbooks}
         * @param useCustomCookbooks Whether the stack uses custom cookbooks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useCustomCookbooks(software.amazon.awscdk.IResolvable useCustomCookbooks) {
            this.useCustomCookbooks = useCustomCookbooks;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getUseOpsworksSecurityGroups}
         * @param useOpsworksSecurityGroups Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.
         *                                  AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
         *                                  <p>
         *                                  <ul>
         *                                  <li>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.</li>
         *                                  <li>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.</li>
         *                                  </ul>
         *                                  <p>
         *                                  For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useOpsworksSecurityGroups(java.lang.Boolean useOpsworksSecurityGroups) {
            this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getUseOpsworksSecurityGroups}
         * @param useOpsworksSecurityGroups Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.
         *                                  AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
         *                                  <p>
         *                                  <ul>
         *                                  <li>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.</li>
         *                                  <li>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.</li>
         *                                  </ul>
         *                                  <p>
         *                                  For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useOpsworksSecurityGroups(software.amazon.awscdk.IResolvable useOpsworksSecurityGroups) {
            this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getVpcId}
         * @param vpcId The ID of the VPC that the stack is to be launched into.
         *              The VPC must be in the stack's region. All instances are launched into this VPC. You cannot change the ID later.
         *              <p>
         *              <ul>
         *              <li>If your account supports EC2-Classic, the default value is <code>no VPC</code> .</li>
         *              <li>If your account does not support EC2-Classic, the default value is the default VPC for the specified region.</li>
         *              </ul>
         *              <p>
         *              If the VPC ID corresponds to a default VPC and you have specified either the <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively.
         *              <p>
         *              If you specify a nondefault VPC ID, note the following:
         *              <p>
         *              <ul>
         *              <li>It must belong to a VPC in your account that is in the specified region.</li>
         *              <li>You must specify a value for <code>DefaultSubnetId</code> .</li>
         *              </ul>
         *              <p>
         *              For more information about how to use AWS OpsWorks Stacks with a VPC, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a VPC</a> . For more information about default VPC and EC2-Classic, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStackProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStackProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStackProps {
        private final java.lang.String defaultInstanceProfileArn;
        private final java.lang.String name;
        private final java.lang.String serviceRoleArn;
        private final java.lang.String agentVersion;
        private final java.lang.Object attributes;
        private final java.lang.Object chefConfiguration;
        private final java.util.List<java.lang.String> cloneAppIds;
        private final java.lang.Object clonePermissions;
        private final java.lang.Object configurationManager;
        private final java.lang.Object customCookbooksSource;
        private final java.lang.Object customJson;
        private final java.lang.String defaultAvailabilityZone;
        private final java.lang.String defaultOs;
        private final java.lang.String defaultRootDeviceType;
        private final java.lang.String defaultSshKeyName;
        private final java.lang.String defaultSubnetId;
        private final java.lang.String ecsClusterArn;
        private final java.lang.Object elasticIps;
        private final java.lang.String hostnameTheme;
        private final java.lang.Object rdsDbInstances;
        private final java.lang.String sourceStackId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object useCustomCookbooks;
        private final java.lang.Object useOpsworksSecurityGroups;
        private final java.lang.String vpcId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultInstanceProfileArn = software.amazon.jsii.Kernel.get(this, "defaultInstanceProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceRoleArn = software.amazon.jsii.Kernel.get(this, "serviceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.agentVersion = software.amazon.jsii.Kernel.get(this, "agentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.chefConfiguration = software.amazon.jsii.Kernel.get(this, "chefConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cloneAppIds = software.amazon.jsii.Kernel.get(this, "cloneAppIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.clonePermissions = software.amazon.jsii.Kernel.get(this, "clonePermissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.configurationManager = software.amazon.jsii.Kernel.get(this, "configurationManager", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customCookbooksSource = software.amazon.jsii.Kernel.get(this, "customCookbooksSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customJson = software.amazon.jsii.Kernel.get(this, "customJson", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.defaultAvailabilityZone = software.amazon.jsii.Kernel.get(this, "defaultAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultOs = software.amazon.jsii.Kernel.get(this, "defaultOs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultRootDeviceType = software.amazon.jsii.Kernel.get(this, "defaultRootDeviceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultSshKeyName = software.amazon.jsii.Kernel.get(this, "defaultSshKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultSubnetId = software.amazon.jsii.Kernel.get(this, "defaultSubnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ecsClusterArn = software.amazon.jsii.Kernel.get(this, "ecsClusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.elasticIps = software.amazon.jsii.Kernel.get(this, "elasticIps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.hostnameTheme = software.amazon.jsii.Kernel.get(this, "hostnameTheme", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rdsDbInstances = software.amazon.jsii.Kernel.get(this, "rdsDbInstances", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceStackId = software.amazon.jsii.Kernel.get(this, "sourceStackId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.useCustomCookbooks = software.amazon.jsii.Kernel.get(this, "useCustomCookbooks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.useOpsworksSecurityGroups = software.amazon.jsii.Kernel.get(this, "useOpsworksSecurityGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultInstanceProfileArn = java.util.Objects.requireNonNull(builder.defaultInstanceProfileArn, "defaultInstanceProfileArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.serviceRoleArn = java.util.Objects.requireNonNull(builder.serviceRoleArn, "serviceRoleArn is required");
            this.agentVersion = builder.agentVersion;
            this.attributes = builder.attributes;
            this.chefConfiguration = builder.chefConfiguration;
            this.cloneAppIds = builder.cloneAppIds;
            this.clonePermissions = builder.clonePermissions;
            this.configurationManager = builder.configurationManager;
            this.customCookbooksSource = builder.customCookbooksSource;
            this.customJson = builder.customJson;
            this.defaultAvailabilityZone = builder.defaultAvailabilityZone;
            this.defaultOs = builder.defaultOs;
            this.defaultRootDeviceType = builder.defaultRootDeviceType;
            this.defaultSshKeyName = builder.defaultSshKeyName;
            this.defaultSubnetId = builder.defaultSubnetId;
            this.ecsClusterArn = builder.ecsClusterArn;
            this.elasticIps = builder.elasticIps;
            this.hostnameTheme = builder.hostnameTheme;
            this.rdsDbInstances = builder.rdsDbInstances;
            this.sourceStackId = builder.sourceStackId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.useCustomCookbooks = builder.useCustomCookbooks;
            this.useOpsworksSecurityGroups = builder.useOpsworksSecurityGroups;
            this.vpcId = builder.vpcId;
        }

        @Override
        public final java.lang.String getDefaultInstanceProfileArn() {
            return this.defaultInstanceProfileArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final java.lang.String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        public final java.lang.Object getAttributes() {
            return this.attributes;
        }

        @Override
        public final java.lang.Object getChefConfiguration() {
            return this.chefConfiguration;
        }

        @Override
        public final java.util.List<java.lang.String> getCloneAppIds() {
            return this.cloneAppIds;
        }

        @Override
        public final java.lang.Object getClonePermissions() {
            return this.clonePermissions;
        }

        @Override
        public final java.lang.Object getConfigurationManager() {
            return this.configurationManager;
        }

        @Override
        public final java.lang.Object getCustomCookbooksSource() {
            return this.customCookbooksSource;
        }

        @Override
        public final java.lang.Object getCustomJson() {
            return this.customJson;
        }

        @Override
        public final java.lang.String getDefaultAvailabilityZone() {
            return this.defaultAvailabilityZone;
        }

        @Override
        public final java.lang.String getDefaultOs() {
            return this.defaultOs;
        }

        @Override
        public final java.lang.String getDefaultRootDeviceType() {
            return this.defaultRootDeviceType;
        }

        @Override
        public final java.lang.String getDefaultSshKeyName() {
            return this.defaultSshKeyName;
        }

        @Override
        public final java.lang.String getDefaultSubnetId() {
            return this.defaultSubnetId;
        }

        @Override
        public final java.lang.String getEcsClusterArn() {
            return this.ecsClusterArn;
        }

        @Override
        public final java.lang.Object getElasticIps() {
            return this.elasticIps;
        }

        @Override
        public final java.lang.String getHostnameTheme() {
            return this.hostnameTheme;
        }

        @Override
        public final java.lang.Object getRdsDbInstances() {
            return this.rdsDbInstances;
        }

        @Override
        public final java.lang.String getSourceStackId() {
            return this.sourceStackId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getUseCustomCookbooks() {
            return this.useCustomCookbooks;
        }

        @Override
        public final java.lang.Object getUseOpsworksSecurityGroups() {
            return this.useOpsworksSecurityGroups;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("defaultInstanceProfileArn", om.valueToTree(this.getDefaultInstanceProfileArn()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("serviceRoleArn", om.valueToTree(this.getServiceRoleArn()));
            if (this.getAgentVersion() != null) {
                data.set("agentVersion", om.valueToTree(this.getAgentVersion()));
            }
            if (this.getAttributes() != null) {
                data.set("attributes", om.valueToTree(this.getAttributes()));
            }
            if (this.getChefConfiguration() != null) {
                data.set("chefConfiguration", om.valueToTree(this.getChefConfiguration()));
            }
            if (this.getCloneAppIds() != null) {
                data.set("cloneAppIds", om.valueToTree(this.getCloneAppIds()));
            }
            if (this.getClonePermissions() != null) {
                data.set("clonePermissions", om.valueToTree(this.getClonePermissions()));
            }
            if (this.getConfigurationManager() != null) {
                data.set("configurationManager", om.valueToTree(this.getConfigurationManager()));
            }
            if (this.getCustomCookbooksSource() != null) {
                data.set("customCookbooksSource", om.valueToTree(this.getCustomCookbooksSource()));
            }
            if (this.getCustomJson() != null) {
                data.set("customJson", om.valueToTree(this.getCustomJson()));
            }
            if (this.getDefaultAvailabilityZone() != null) {
                data.set("defaultAvailabilityZone", om.valueToTree(this.getDefaultAvailabilityZone()));
            }
            if (this.getDefaultOs() != null) {
                data.set("defaultOs", om.valueToTree(this.getDefaultOs()));
            }
            if (this.getDefaultRootDeviceType() != null) {
                data.set("defaultRootDeviceType", om.valueToTree(this.getDefaultRootDeviceType()));
            }
            if (this.getDefaultSshKeyName() != null) {
                data.set("defaultSshKeyName", om.valueToTree(this.getDefaultSshKeyName()));
            }
            if (this.getDefaultSubnetId() != null) {
                data.set("defaultSubnetId", om.valueToTree(this.getDefaultSubnetId()));
            }
            if (this.getEcsClusterArn() != null) {
                data.set("ecsClusterArn", om.valueToTree(this.getEcsClusterArn()));
            }
            if (this.getElasticIps() != null) {
                data.set("elasticIps", om.valueToTree(this.getElasticIps()));
            }
            if (this.getHostnameTheme() != null) {
                data.set("hostnameTheme", om.valueToTree(this.getHostnameTheme()));
            }
            if (this.getRdsDbInstances() != null) {
                data.set("rdsDbInstances", om.valueToTree(this.getRdsDbInstances()));
            }
            if (this.getSourceStackId() != null) {
                data.set("sourceStackId", om.valueToTree(this.getSourceStackId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUseCustomCookbooks() != null) {
                data.set("useCustomCookbooks", om.valueToTree(this.getUseCustomCookbooks()));
            }
            if (this.getUseOpsworksSecurityGroups() != null) {
                data.set("useOpsworksSecurityGroups", om.valueToTree(this.getUseOpsworksSecurityGroups()));
            }
            if (this.getVpcId() != null) {
                data.set("vpcId", om.valueToTree(this.getVpcId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnStackProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStackProps.Jsii$Proxy that = (CfnStackProps.Jsii$Proxy) o;

            if (!defaultInstanceProfileArn.equals(that.defaultInstanceProfileArn)) return false;
            if (!name.equals(that.name)) return false;
            if (!serviceRoleArn.equals(that.serviceRoleArn)) return false;
            if (this.agentVersion != null ? !this.agentVersion.equals(that.agentVersion) : that.agentVersion != null) return false;
            if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) return false;
            if (this.chefConfiguration != null ? !this.chefConfiguration.equals(that.chefConfiguration) : that.chefConfiguration != null) return false;
            if (this.cloneAppIds != null ? !this.cloneAppIds.equals(that.cloneAppIds) : that.cloneAppIds != null) return false;
            if (this.clonePermissions != null ? !this.clonePermissions.equals(that.clonePermissions) : that.clonePermissions != null) return false;
            if (this.configurationManager != null ? !this.configurationManager.equals(that.configurationManager) : that.configurationManager != null) return false;
            if (this.customCookbooksSource != null ? !this.customCookbooksSource.equals(that.customCookbooksSource) : that.customCookbooksSource != null) return false;
            if (this.customJson != null ? !this.customJson.equals(that.customJson) : that.customJson != null) return false;
            if (this.defaultAvailabilityZone != null ? !this.defaultAvailabilityZone.equals(that.defaultAvailabilityZone) : that.defaultAvailabilityZone != null) return false;
            if (this.defaultOs != null ? !this.defaultOs.equals(that.defaultOs) : that.defaultOs != null) return false;
            if (this.defaultRootDeviceType != null ? !this.defaultRootDeviceType.equals(that.defaultRootDeviceType) : that.defaultRootDeviceType != null) return false;
            if (this.defaultSshKeyName != null ? !this.defaultSshKeyName.equals(that.defaultSshKeyName) : that.defaultSshKeyName != null) return false;
            if (this.defaultSubnetId != null ? !this.defaultSubnetId.equals(that.defaultSubnetId) : that.defaultSubnetId != null) return false;
            if (this.ecsClusterArn != null ? !this.ecsClusterArn.equals(that.ecsClusterArn) : that.ecsClusterArn != null) return false;
            if (this.elasticIps != null ? !this.elasticIps.equals(that.elasticIps) : that.elasticIps != null) return false;
            if (this.hostnameTheme != null ? !this.hostnameTheme.equals(that.hostnameTheme) : that.hostnameTheme != null) return false;
            if (this.rdsDbInstances != null ? !this.rdsDbInstances.equals(that.rdsDbInstances) : that.rdsDbInstances != null) return false;
            if (this.sourceStackId != null ? !this.sourceStackId.equals(that.sourceStackId) : that.sourceStackId != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.useCustomCookbooks != null ? !this.useCustomCookbooks.equals(that.useCustomCookbooks) : that.useCustomCookbooks != null) return false;
            if (this.useOpsworksSecurityGroups != null ? !this.useOpsworksSecurityGroups.equals(that.useOpsworksSecurityGroups) : that.useOpsworksSecurityGroups != null) return false;
            return this.vpcId != null ? this.vpcId.equals(that.vpcId) : that.vpcId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.defaultInstanceProfileArn.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.serviceRoleArn.hashCode());
            result = 31 * result + (this.agentVersion != null ? this.agentVersion.hashCode() : 0);
            result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
            result = 31 * result + (this.chefConfiguration != null ? this.chefConfiguration.hashCode() : 0);
            result = 31 * result + (this.cloneAppIds != null ? this.cloneAppIds.hashCode() : 0);
            result = 31 * result + (this.clonePermissions != null ? this.clonePermissions.hashCode() : 0);
            result = 31 * result + (this.configurationManager != null ? this.configurationManager.hashCode() : 0);
            result = 31 * result + (this.customCookbooksSource != null ? this.customCookbooksSource.hashCode() : 0);
            result = 31 * result + (this.customJson != null ? this.customJson.hashCode() : 0);
            result = 31 * result + (this.defaultAvailabilityZone != null ? this.defaultAvailabilityZone.hashCode() : 0);
            result = 31 * result + (this.defaultOs != null ? this.defaultOs.hashCode() : 0);
            result = 31 * result + (this.defaultRootDeviceType != null ? this.defaultRootDeviceType.hashCode() : 0);
            result = 31 * result + (this.defaultSshKeyName != null ? this.defaultSshKeyName.hashCode() : 0);
            result = 31 * result + (this.defaultSubnetId != null ? this.defaultSubnetId.hashCode() : 0);
            result = 31 * result + (this.ecsClusterArn != null ? this.ecsClusterArn.hashCode() : 0);
            result = 31 * result + (this.elasticIps != null ? this.elasticIps.hashCode() : 0);
            result = 31 * result + (this.hostnameTheme != null ? this.hostnameTheme.hashCode() : 0);
            result = 31 * result + (this.rdsDbInstances != null ? this.rdsDbInstances.hashCode() : 0);
            result = 31 * result + (this.sourceStackId != null ? this.sourceStackId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.useCustomCookbooks != null ? this.useCustomCookbooks.hashCode() : 0);
            result = 31 * result + (this.useOpsworksSecurityGroups != null ? this.useOpsworksSecurityGroups.hashCode() : 0);
            result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
            return result;
        }
    }
}
