package software.amazon.awscdk.services.sagemaker;

/**
 * Creates a <code>Domain</code> .
 * <p>
 * A domain consists of an associated Amazon Elastic File System volume, a list of authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC) configurations. Users within a domain can share notebook files and other artifacts with each other.
 * <p>
 * <em>EFS storage</em>
 * <p>
 * When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.
 * <p>
 * SageMaker uses the AWS Key Management Service ( AWS KMS) to encrypt the EFS volume attached to the domain with an AWS managed key by default. For more control, you can specify a customer managed key. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html">Protect Data at Rest Using Encryption</a> .
 * <p>
 * <em>VPC configuration</em>
 * <p>
 * All traffic between the domain and the Amazon EFS volume is through the specified VPC and subnets. For other traffic, you can specify the <code>AppNetworkAccessType</code> parameter. <code>AppNetworkAccessType</code> corresponds to the network access type that you choose when you onboard to the domain. The following options are available:
 * <p>
 * <ul>
 * <li><code>PublicInternetOnly</code> - Non-EFS traffic goes through a VPC managed by Amazon SageMaker, which allows internet access. This is the default value.</li>
 * <li><code>VpcOnly</code> - All traffic is through the specified VPC and subnets. Internet access is disabled by default. To allow internet access, you must specify a NAT gateway.</li>
 * </ul>
 * <p>
 * When internet access is disabled, you won't be able to run a Amazon SageMaker Studio notebook or to train or host models unless your VPC has an interface endpoint to the SageMaker API and runtime or a NAT gateway and your security groups allow outbound connections.
 * <p>
 * <blockquote>
 * <p>
 * NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a Amazon SageMaker Studio app successfully.
 * <p>
 * </blockquote>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html">Connect Amazon SageMaker Studio Notebooks to Resources in a VPC</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnDomain cfnDomain = CfnDomain.Builder.create(this, "MyCfnDomain")
 *         .authMode("authMode")
 *         .defaultUserSettings(UserSettingsProperty.builder()
 *                 .executionRole("executionRole")
 *                 // the properties below are optional
 *                 .codeEditorAppSettings(CodeEditorAppSettingsProperty.builder()
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .customFileSystemConfigs(List.of(CustomFileSystemConfigProperty.builder()
 *                         .efsFileSystemConfig(EFSFileSystemConfigProperty.builder()
 *                                 .fileSystemId("fileSystemId")
 *                                 // the properties below are optional
 *                                 .fileSystemPath("fileSystemPath")
 *                                 .build())
 *                         .build()))
 *                 .customPosixUserConfig(CustomPosixUserConfigProperty.builder()
 *                         .gid(123)
 *                         .uid(123)
 *                         .build())
 *                 .defaultLandingUri("defaultLandingUri")
 *                 .jupyterLabAppSettings(JupyterLabAppSettingsProperty.builder()
 *                         .codeRepositories(List.of(CodeRepositoryProperty.builder()
 *                                 .repositoryUrl("repositoryUrl")
 *                                 .build()))
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .jupyterServerAppSettings(JupyterServerAppSettingsProperty.builder()
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .kernelGatewayAppSettings(KernelGatewayAppSettingsProperty.builder()
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .rSessionAppSettings(RSessionAppSettingsProperty.builder()
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .rStudioServerProAppSettings(RStudioServerProAppSettingsProperty.builder()
 *                         .accessStatus("accessStatus")
 *                         .userGroup("userGroup")
 *                         .build())
 *                 .securityGroups(List.of("securityGroups"))
 *                 .sharingSettings(SharingSettingsProperty.builder()
 *                         .notebookOutputOption("notebookOutputOption")
 *                         .s3KmsKeyId("s3KmsKeyId")
 *                         .s3OutputPath("s3OutputPath")
 *                         .build())
 *                 .spaceStorageSettings(DefaultSpaceStorageSettingsProperty.builder()
 *                         .defaultEbsStorageSettings(DefaultEbsStorageSettingsProperty.builder()
 *                                 .defaultEbsVolumeSizeInGb(123)
 *                                 .maximumEbsVolumeSizeInGb(123)
 *                                 .build())
 *                         .build())
 *                 .studioWebPortal("studioWebPortal")
 *                 .build())
 *         .domainName("domainName")
 *         .subnetIds(List.of("subnetIds"))
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .appNetworkAccessType("appNetworkAccessType")
 *         .appSecurityGroupManagement("appSecurityGroupManagement")
 *         .defaultSpaceSettings(DefaultSpaceSettingsProperty.builder()
 *                 .executionRole("executionRole")
 *                 // the properties below are optional
 *                 .customFileSystemConfigs(List.of(CustomFileSystemConfigProperty.builder()
 *                         .efsFileSystemConfig(EFSFileSystemConfigProperty.builder()
 *                                 .fileSystemId("fileSystemId")
 *                                 // the properties below are optional
 *                                 .fileSystemPath("fileSystemPath")
 *                                 .build())
 *                         .build()))
 *                 .customPosixUserConfig(CustomPosixUserConfigProperty.builder()
 *                         .gid(123)
 *                         .uid(123)
 *                         .build())
 *                 .jupyterLabAppSettings(JupyterLabAppSettingsProperty.builder()
 *                         .codeRepositories(List.of(CodeRepositoryProperty.builder()
 *                                 .repositoryUrl("repositoryUrl")
 *                                 .build()))
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
 *                         .build())
 *                 .jupyterServerAppSettings(JupyterServerAppSettingsProperty.builder()
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .kernelGatewayAppSettings(KernelGatewayAppSettingsProperty.builder()
 *                         .customImages(List.of(CustomImageProperty.builder()
 *                                 .appImageConfigName("appImageConfigName")
 *                                 .imageName("imageName")
 *                                 // the properties below are optional
 *                                 .imageVersionNumber(123)
 *                                 .build()))
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .build())
 *                 .securityGroups(List.of("securityGroups"))
 *                 .spaceStorageSettings(DefaultSpaceStorageSettingsProperty.builder()
 *                         .defaultEbsStorageSettings(DefaultEbsStorageSettingsProperty.builder()
 *                                 .defaultEbsVolumeSizeInGb(123)
 *                                 .maximumEbsVolumeSizeInGb(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .domainSettings(DomainSettingsProperty.builder()
 *                 .dockerSettings(DockerSettingsProperty.builder()
 *                         .enableDockerAccess("enableDockerAccess")
 *                         .vpcOnlyTrustedAccounts(List.of("vpcOnlyTrustedAccounts"))
 *                         .build())
 *                 .rStudioServerProDomainSettings(RStudioServerProDomainSettingsProperty.builder()
 *                         .domainExecutionRoleArn("domainExecutionRoleArn")
 *                         // the properties below are optional
 *                         .defaultResourceSpec(ResourceSpecProperty.builder()
 *                                 .instanceType("instanceType")
 *                                 .lifecycleConfigArn("lifecycleConfigArn")
 *                                 .sageMakerImageArn("sageMakerImageArn")
 *                                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
 *                                 .build())
 *                         .rStudioConnectUrl("rStudioConnectUrl")
 *                         .rStudioPackageManagerUrl("rStudioPackageManagerUrl")
 *                         .build())
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:40.298Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain")
public class CfnDomain extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDomain(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDomain(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnDomain.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDomain(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnDomainProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the Domain, such as <code>arn:aws:sagemaker:us-west-2:account-id:domain/my-domain-name</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Domain ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainId() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the Amazon Elastic File System (EFS) managed by this Domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrHomeEfsFileSystemId() {
        return software.amazon.jsii.Kernel.get(this, "attrHomeEfsFileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the security group that authorizes traffic between the <code>RSessionGateway</code> apps and the <code>RStudioServerPro</code> app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSecurityGroupIdForDomainBoundary() {
        return software.amazon.jsii.Kernel.get(this, "attrSecurityGroupIdForDomainBoundary", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the application managed by SageMaker in IAM Identity Center.
     * <p>
     * This value is only returned for domains created after October 1, 2023.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSingleSignOnApplicationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSingleSignOnApplicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IAM Identity Center managed application instance ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSingleSignOnManagedApplicationInstanceId() {
        return software.amazon.jsii.Kernel.get(this, "attrSingleSignOnManagedApplicationInstanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL for the Domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The mode of authentication that members use to access the Domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthMode() {
        return software.amazon.jsii.Kernel.get(this, "authMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The mode of authentication that members use to access the Domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthMode(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authMode", java.util.Objects.requireNonNull(value, "authMode is required"));
    }

    /**
     * The default user settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDefaultUserSettings() {
        return software.amazon.jsii.Kernel.get(this, "defaultUserSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The default user settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultUserSettings(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "defaultUserSettings", java.util.Objects.requireNonNull(value, "defaultUserSettings is required"));
    }

    /**
     * The default user settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultUserSettings(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnDomain.UserSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "defaultUserSettings", java.util.Objects.requireNonNull(value, "defaultUserSettings is required"));
    }

    /**
     * The domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
    }

    /**
     * The VPC subnets that Studio uses for communication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The VPC subnets that Studio uses for communication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnetIds(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "subnetIds", java.util.Objects.requireNonNull(value, "subnetIds is required"));
    }

    /**
     * The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcId() {
        return software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcId", java.util.Objects.requireNonNull(value, "vpcId is required"));
    }

    /**
     * Specifies the VPC used for non-EFS traffic.
     * <p>
     * The default value is <code>PublicInternetOnly</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAppNetworkAccessType() {
        return software.amazon.jsii.Kernel.get(this, "appNetworkAccessType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the VPC used for non-EFS traffic.
     * <p>
     * The default value is <code>PublicInternetOnly</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppNetworkAccessType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "appNetworkAccessType", value);
    }

    /**
     * The entity that creates and manages the required security groups for inter-app communication in <code>VpcOnly</code> mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAppSecurityGroupManagement() {
        return software.amazon.jsii.Kernel.get(this, "appSecurityGroupManagement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The entity that creates and manages the required security groups for inter-app communication in <code>VpcOnly</code> mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppSecurityGroupManagement(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "appSecurityGroupManagement", value);
    }

    /**
     * A collection of settings that apply to spaces created in the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefaultSpaceSettings() {
        return software.amazon.jsii.Kernel.get(this, "defaultSpaceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A collection of settings that apply to spaces created in the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultSpaceSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "defaultSpaceSettings", value);
    }

    /**
     * A collection of settings that apply to spaces created in the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultSpaceSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnDomain.DefaultSpaceSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "defaultSpaceSettings", value);
    }

    /**
     * A collection of settings that apply to the <code>SageMaker Domain</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDomainSettings() {
        return software.amazon.jsii.Kernel.get(this, "domainSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A collection of settings that apply to the <code>SageMaker Domain</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "domainSettings", value);
    }

    /**
     * A collection of settings that apply to the <code>SageMaker Domain</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnDomain.DomainSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "domainSettings", value);
    }

    /**
     * SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * Tags to associated with the Domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Tags to associated with the Domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The Code Editor application settings.
     * <p>
     * For more information about Code Editor, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/code-editor.html">Get started with Code Editor in Amazon SageMaker</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CodeEditorAppSettingsProperty codeEditorAppSettingsProperty = CodeEditorAppSettingsProperty.builder()
     *         .customImages(List.of(CustomImageProperty.builder()
     *                 .appImageConfigName("appImageConfigName")
     *                 .imageName("imageName")
     *                 // the properties below are optional
     *                 .imageVersionNumber(123)
     *                 .build()))
     *         .defaultResourceSpec(ResourceSpecProperty.builder()
     *                 .instanceType("instanceType")
     *                 .lifecycleConfigArn("lifecycleConfigArn")
     *                 .sageMakerImageArn("sageMakerImageArn")
     *                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                 .build())
     *         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-codeeditorappsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-codeeditorappsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.CodeEditorAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeEditorAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeEditorAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of custom SageMaker images that are configured to run as a Code Editor app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-codeeditorappsettings.html#cfn-sagemaker-domain-codeeditorappsettings-customimages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-codeeditorappsettings.html#cfn-sagemaker-domain-codeeditorappsettings-customimages</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomImages() {
            return null;
        }

        /**
         * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the Code Editor app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-codeeditorappsettings.html#cfn-sagemaker-domain-codeeditorappsettings-defaultresourcespec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-codeeditorappsettings.html#cfn-sagemaker-domain-codeeditorappsettings-defaultresourcespec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceSpec() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the Code Editor application lifecycle configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-codeeditorappsettings.html#cfn-sagemaker-domain-codeeditorappsettings-lifecycleconfigarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-codeeditorappsettings.html#cfn-sagemaker-domain-codeeditorappsettings-lifecycleconfigarns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLifecycleConfigArns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CodeEditorAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeEditorAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeEditorAppSettingsProperty> {
            java.lang.Object customImages;
            java.lang.Object defaultResourceSpec;
            java.util.List<java.lang.String> lifecycleConfigArns;

            /**
             * Sets the value of {@link CodeEditorAppSettingsProperty#getCustomImages}
             * @param customImages A list of custom SageMaker images that are configured to run as a Code Editor app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customImages(software.amazon.awscdk.IResolvable customImages) {
                this.customImages = customImages;
                return this;
            }

            /**
             * Sets the value of {@link CodeEditorAppSettingsProperty#getCustomImages}
             * @param customImages A list of custom SageMaker images that are configured to run as a Code Editor app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customImages(java.util.List<? extends java.lang.Object> customImages) {
                this.customImages = customImages;
                return this;
            }

            /**
             * Sets the value of {@link CodeEditorAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the Code Editor app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link CodeEditorAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the Code Editor app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.services.sagemaker.CfnDomain.ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link CodeEditorAppSettingsProperty#getLifecycleConfigArns}
             * @param lifecycleConfigArns The Amazon Resource Name (ARN) of the Code Editor application lifecycle configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lifecycleConfigArns(java.util.List<java.lang.String> lifecycleConfigArns) {
                this.lifecycleConfigArns = lifecycleConfigArns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeEditorAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeEditorAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CodeEditorAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeEditorAppSettingsProperty {
            private final java.lang.Object customImages;
            private final java.lang.Object defaultResourceSpec;
            private final java.util.List<java.lang.String> lifecycleConfigArns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customImages = software.amazon.jsii.Kernel.get(this, "customImages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultResourceSpec = software.amazon.jsii.Kernel.get(this, "defaultResourceSpec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lifecycleConfigArns = software.amazon.jsii.Kernel.get(this, "lifecycleConfigArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customImages = builder.customImages;
                this.defaultResourceSpec = builder.defaultResourceSpec;
                this.lifecycleConfigArns = builder.lifecycleConfigArns;
            }

            @Override
            public final java.lang.Object getCustomImages() {
                return this.customImages;
            }

            @Override
            public final java.lang.Object getDefaultResourceSpec() {
                return this.defaultResourceSpec;
            }

            @Override
            public final java.util.List<java.lang.String> getLifecycleConfigArns() {
                return this.lifecycleConfigArns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomImages() != null) {
                    data.set("customImages", om.valueToTree(this.getCustomImages()));
                }
                if (this.getDefaultResourceSpec() != null) {
                    data.set("defaultResourceSpec", om.valueToTree(this.getDefaultResourceSpec()));
                }
                if (this.getLifecycleConfigArns() != null) {
                    data.set("lifecycleConfigArns", om.valueToTree(this.getLifecycleConfigArns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.CodeEditorAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeEditorAppSettingsProperty.Jsii$Proxy that = (CodeEditorAppSettingsProperty.Jsii$Proxy) o;

                if (this.customImages != null ? !this.customImages.equals(that.customImages) : that.customImages != null) return false;
                if (this.defaultResourceSpec != null ? !this.defaultResourceSpec.equals(that.defaultResourceSpec) : that.defaultResourceSpec != null) return false;
                return this.lifecycleConfigArns != null ? this.lifecycleConfigArns.equals(that.lifecycleConfigArns) : that.lifecycleConfigArns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customImages != null ? this.customImages.hashCode() : 0;
                result = 31 * result + (this.defaultResourceSpec != null ? this.defaultResourceSpec.hashCode() : 0);
                result = 31 * result + (this.lifecycleConfigArns != null ? this.lifecycleConfigArns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A Git repository that SageMaker automatically displays to users for cloning in the JupyterServer application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CodeRepositoryProperty codeRepositoryProperty = CodeRepositoryProperty.builder()
     *         .repositoryUrl("repositoryUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-coderepository.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-coderepository.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.CodeRepositoryProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeRepositoryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeRepositoryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URL of the Git repository.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-coderepository.html#cfn-sagemaker-domain-coderepository-repositoryurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-coderepository.html#cfn-sagemaker-domain-coderepository-repositoryurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRepositoryUrl();

        /**
         * @return a {@link Builder} of {@link CodeRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeRepositoryProperty> {
            java.lang.String repositoryUrl;

            /**
             * Sets the value of {@link CodeRepositoryProperty#getRepositoryUrl}
             * @param repositoryUrl The URL of the Git repository. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositoryUrl(java.lang.String repositoryUrl) {
                this.repositoryUrl = repositoryUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeRepositoryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeRepositoryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CodeRepositoryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeRepositoryProperty {
            private final java.lang.String repositoryUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.repositoryUrl = software.amazon.jsii.Kernel.get(this, "repositoryUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.repositoryUrl = java.util.Objects.requireNonNull(builder.repositoryUrl, "repositoryUrl is required");
            }

            @Override
            public final java.lang.String getRepositoryUrl() {
                return this.repositoryUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("repositoryUrl", om.valueToTree(this.getRepositoryUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.CodeRepositoryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeRepositoryProperty.Jsii$Proxy that = (CodeRepositoryProperty.Jsii$Proxy) o;

                return this.repositoryUrl.equals(that.repositoryUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.repositoryUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * The settings for assigning a custom file system to a user profile or space for an Amazon SageMaker Domain.
     * <p>
     * Permitted users can access this file system in Amazon SageMaker Studio.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CustomFileSystemConfigProperty customFileSystemConfigProperty = CustomFileSystemConfigProperty.builder()
     *         .efsFileSystemConfig(EFSFileSystemConfigProperty.builder()
     *                 .fileSystemId("fileSystemId")
     *                 // the properties below are optional
     *                 .fileSystemPath("fileSystemPath")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customfilesystemconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customfilesystemconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.CustomFileSystemConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomFileSystemConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomFileSystemConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The settings for a custom Amazon EFS file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customfilesystemconfig.html#cfn-sagemaker-domain-customfilesystemconfig-efsfilesystemconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customfilesystemconfig.html#cfn-sagemaker-domain-customfilesystemconfig-efsfilesystemconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEfsFileSystemConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomFileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomFileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomFileSystemConfigProperty> {
            java.lang.Object efsFileSystemConfig;

            /**
             * Sets the value of {@link CustomFileSystemConfigProperty#getEfsFileSystemConfig}
             * @param efsFileSystemConfig The settings for a custom Amazon EFS file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efsFileSystemConfig(software.amazon.awscdk.IResolvable efsFileSystemConfig) {
                this.efsFileSystemConfig = efsFileSystemConfig;
                return this;
            }

            /**
             * Sets the value of {@link CustomFileSystemConfigProperty#getEfsFileSystemConfig}
             * @param efsFileSystemConfig The settings for a custom Amazon EFS file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efsFileSystemConfig(software.amazon.awscdk.services.sagemaker.CfnDomain.EFSFileSystemConfigProperty efsFileSystemConfig) {
                this.efsFileSystemConfig = efsFileSystemConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomFileSystemConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomFileSystemConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomFileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomFileSystemConfigProperty {
            private final java.lang.Object efsFileSystemConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.efsFileSystemConfig = software.amazon.jsii.Kernel.get(this, "efsFileSystemConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.efsFileSystemConfig = builder.efsFileSystemConfig;
            }

            @Override
            public final java.lang.Object getEfsFileSystemConfig() {
                return this.efsFileSystemConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEfsFileSystemConfig() != null) {
                    data.set("efsFileSystemConfig", om.valueToTree(this.getEfsFileSystemConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.CustomFileSystemConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomFileSystemConfigProperty.Jsii$Proxy that = (CustomFileSystemConfigProperty.Jsii$Proxy) o;

                return this.efsFileSystemConfig != null ? this.efsFileSystemConfig.equals(that.efsFileSystemConfig) : that.efsFileSystemConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.efsFileSystemConfig != null ? this.efsFileSystemConfig.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A custom SageMaker image.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker image</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CustomImageProperty customImageProperty = CustomImageProperty.builder()
     *         .appImageConfigName("appImageConfigName")
     *         .imageName("imageName")
     *         // the properties below are optional
     *         .imageVersionNumber(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.CustomImageProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomImageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomImageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the AppImageConfig.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-appimageconfigname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-appimageconfigname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAppImageConfigName();

        /**
         * The name of the CustomImage.
         * <p>
         * Must be unique to your account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-imagename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-imagename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageName();

        /**
         * The version number of the CustomImage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-imageversionnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-imageversionnumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getImageVersionNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomImageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomImageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomImageProperty> {
            java.lang.String appImageConfigName;
            java.lang.String imageName;
            java.lang.Number imageVersionNumber;

            /**
             * Sets the value of {@link CustomImageProperty#getAppImageConfigName}
             * @param appImageConfigName The name of the AppImageConfig. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appImageConfigName(java.lang.String appImageConfigName) {
                this.appImageConfigName = appImageConfigName;
                return this;
            }

            /**
             * Sets the value of {@link CustomImageProperty#getImageName}
             * @param imageName The name of the CustomImage. This parameter is required.
             *                  Must be unique to your account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageName(java.lang.String imageName) {
                this.imageName = imageName;
                return this;
            }

            /**
             * Sets the value of {@link CustomImageProperty#getImageVersionNumber}
             * @param imageVersionNumber The version number of the CustomImage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageVersionNumber(java.lang.Number imageVersionNumber) {
                this.imageVersionNumber = imageVersionNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomImageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomImageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomImageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomImageProperty {
            private final java.lang.String appImageConfigName;
            private final java.lang.String imageName;
            private final java.lang.Number imageVersionNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appImageConfigName = software.amazon.jsii.Kernel.get(this, "appImageConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageName = software.amazon.jsii.Kernel.get(this, "imageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageVersionNumber = software.amazon.jsii.Kernel.get(this, "imageVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appImageConfigName = java.util.Objects.requireNonNull(builder.appImageConfigName, "appImageConfigName is required");
                this.imageName = java.util.Objects.requireNonNull(builder.imageName, "imageName is required");
                this.imageVersionNumber = builder.imageVersionNumber;
            }

            @Override
            public final java.lang.String getAppImageConfigName() {
                return this.appImageConfigName;
            }

            @Override
            public final java.lang.String getImageName() {
                return this.imageName;
            }

            @Override
            public final java.lang.Number getImageVersionNumber() {
                return this.imageVersionNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("appImageConfigName", om.valueToTree(this.getAppImageConfigName()));
                data.set("imageName", om.valueToTree(this.getImageName()));
                if (this.getImageVersionNumber() != null) {
                    data.set("imageVersionNumber", om.valueToTree(this.getImageVersionNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.CustomImageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomImageProperty.Jsii$Proxy that = (CustomImageProperty.Jsii$Proxy) o;

                if (!appImageConfigName.equals(that.appImageConfigName)) return false;
                if (!imageName.equals(that.imageName)) return false;
                return this.imageVersionNumber != null ? this.imageVersionNumber.equals(that.imageVersionNumber) : that.imageVersionNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appImageConfigName.hashCode();
                result = 31 * result + (this.imageName.hashCode());
                result = 31 * result + (this.imageVersionNumber != null ? this.imageVersionNumber.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details about the POSIX identity that is used for file system operations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CustomPosixUserConfigProperty customPosixUserConfigProperty = CustomPosixUserConfigProperty.builder()
     *         .gid(123)
     *         .uid(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customposixuserconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customposixuserconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.CustomPosixUserConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomPosixUserConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomPosixUserConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The POSIX group ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customposixuserconfig.html#cfn-sagemaker-domain-customposixuserconfig-gid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customposixuserconfig.html#cfn-sagemaker-domain-customposixuserconfig-gid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getGid();

        /**
         * The POSIX user ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customposixuserconfig.html#cfn-sagemaker-domain-customposixuserconfig-uid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customposixuserconfig.html#cfn-sagemaker-domain-customposixuserconfig-uid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getUid();

        /**
         * @return a {@link Builder} of {@link CustomPosixUserConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomPosixUserConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomPosixUserConfigProperty> {
            java.lang.Number gid;
            java.lang.Number uid;

            /**
             * Sets the value of {@link CustomPosixUserConfigProperty#getGid}
             * @param gid The POSIX group ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gid(java.lang.Number gid) {
                this.gid = gid;
                return this;
            }

            /**
             * Sets the value of {@link CustomPosixUserConfigProperty#getUid}
             * @param uid The POSIX user ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uid(java.lang.Number uid) {
                this.uid = uid;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomPosixUserConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomPosixUserConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomPosixUserConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomPosixUserConfigProperty {
            private final java.lang.Number gid;
            private final java.lang.Number uid;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.gid = software.amazon.jsii.Kernel.get(this, "gid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.uid = software.amazon.jsii.Kernel.get(this, "uid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.gid = java.util.Objects.requireNonNull(builder.gid, "gid is required");
                this.uid = java.util.Objects.requireNonNull(builder.uid, "uid is required");
            }

            @Override
            public final java.lang.Number getGid() {
                return this.gid;
            }

            @Override
            public final java.lang.Number getUid() {
                return this.uid;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("gid", om.valueToTree(this.getGid()));
                data.set("uid", om.valueToTree(this.getUid()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.CustomPosixUserConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomPosixUserConfigProperty.Jsii$Proxy that = (CustomPosixUserConfigProperty.Jsii$Proxy) o;

                if (!gid.equals(that.gid)) return false;
                return this.uid.equals(that.uid);
            }

            @Override
            public final int hashCode() {
                int result = this.gid.hashCode();
                result = 31 * result + (this.uid.hashCode());
                return result;
            }
        }
    }
    /**
     * A collection of default EBS storage settings that apply to spaces created within a domain or user profile.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DefaultEbsStorageSettingsProperty defaultEbsStorageSettingsProperty = DefaultEbsStorageSettingsProperty.builder()
     *         .defaultEbsVolumeSizeInGb(123)
     *         .maximumEbsVolumeSizeInGb(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultebsstoragesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultebsstoragesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.DefaultEbsStorageSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultEbsStorageSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultEbsStorageSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default size of the EBS storage volume for a space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultebsstoragesettings.html#cfn-sagemaker-domain-defaultebsstoragesettings-defaultebsvolumesizeingb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultebsstoragesettings.html#cfn-sagemaker-domain-defaultebsstoragesettings-defaultebsvolumesizeingb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDefaultEbsVolumeSizeInGb();

        /**
         * The maximum size of the EBS storage volume for a space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultebsstoragesettings.html#cfn-sagemaker-domain-defaultebsstoragesettings-maximumebsvolumesizeingb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultebsstoragesettings.html#cfn-sagemaker-domain-defaultebsstoragesettings-maximumebsvolumesizeingb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaximumEbsVolumeSizeInGb();

        /**
         * @return a {@link Builder} of {@link DefaultEbsStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultEbsStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultEbsStorageSettingsProperty> {
            java.lang.Number defaultEbsVolumeSizeInGb;
            java.lang.Number maximumEbsVolumeSizeInGb;

            /**
             * Sets the value of {@link DefaultEbsStorageSettingsProperty#getDefaultEbsVolumeSizeInGb}
             * @param defaultEbsVolumeSizeInGb The default size of the EBS storage volume for a space. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultEbsVolumeSizeInGb(java.lang.Number defaultEbsVolumeSizeInGb) {
                this.defaultEbsVolumeSizeInGb = defaultEbsVolumeSizeInGb;
                return this;
            }

            /**
             * Sets the value of {@link DefaultEbsStorageSettingsProperty#getMaximumEbsVolumeSizeInGb}
             * @param maximumEbsVolumeSizeInGb The maximum size of the EBS storage volume for a space. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumEbsVolumeSizeInGb(java.lang.Number maximumEbsVolumeSizeInGb) {
                this.maximumEbsVolumeSizeInGb = maximumEbsVolumeSizeInGb;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultEbsStorageSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultEbsStorageSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultEbsStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultEbsStorageSettingsProperty {
            private final java.lang.Number defaultEbsVolumeSizeInGb;
            private final java.lang.Number maximumEbsVolumeSizeInGb;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultEbsVolumeSizeInGb = software.amazon.jsii.Kernel.get(this, "defaultEbsVolumeSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumEbsVolumeSizeInGb = software.amazon.jsii.Kernel.get(this, "maximumEbsVolumeSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultEbsVolumeSizeInGb = java.util.Objects.requireNonNull(builder.defaultEbsVolumeSizeInGb, "defaultEbsVolumeSizeInGb is required");
                this.maximumEbsVolumeSizeInGb = java.util.Objects.requireNonNull(builder.maximumEbsVolumeSizeInGb, "maximumEbsVolumeSizeInGb is required");
            }

            @Override
            public final java.lang.Number getDefaultEbsVolumeSizeInGb() {
                return this.defaultEbsVolumeSizeInGb;
            }

            @Override
            public final java.lang.Number getMaximumEbsVolumeSizeInGb() {
                return this.maximumEbsVolumeSizeInGb;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultEbsVolumeSizeInGb", om.valueToTree(this.getDefaultEbsVolumeSizeInGb()));
                data.set("maximumEbsVolumeSizeInGb", om.valueToTree(this.getMaximumEbsVolumeSizeInGb()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.DefaultEbsStorageSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultEbsStorageSettingsProperty.Jsii$Proxy that = (DefaultEbsStorageSettingsProperty.Jsii$Proxy) o;

                if (!defaultEbsVolumeSizeInGb.equals(that.defaultEbsVolumeSizeInGb)) return false;
                return this.maximumEbsVolumeSizeInGb.equals(that.maximumEbsVolumeSizeInGb);
            }

            @Override
            public final int hashCode() {
                int result = this.defaultEbsVolumeSizeInGb.hashCode();
                result = 31 * result + (this.maximumEbsVolumeSizeInGb.hashCode());
                return result;
            }
        }
    }
    /**
     * A collection of settings that apply to spaces created in the domain.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DefaultSpaceSettingsProperty defaultSpaceSettingsProperty = DefaultSpaceSettingsProperty.builder()
     *         .executionRole("executionRole")
     *         // the properties below are optional
     *         .customFileSystemConfigs(List.of(CustomFileSystemConfigProperty.builder()
     *                 .efsFileSystemConfig(EFSFileSystemConfigProperty.builder()
     *                         .fileSystemId("fileSystemId")
     *                         // the properties below are optional
     *                         .fileSystemPath("fileSystemPath")
     *                         .build())
     *                 .build()))
     *         .customPosixUserConfig(CustomPosixUserConfigProperty.builder()
     *                 .gid(123)
     *                 .uid(123)
     *                 .build())
     *         .jupyterLabAppSettings(JupyterLabAppSettingsProperty.builder()
     *                 .codeRepositories(List.of(CodeRepositoryProperty.builder()
     *                         .repositoryUrl("repositoryUrl")
     *                         .build()))
     *                 .customImages(List.of(CustomImageProperty.builder()
     *                         .appImageConfigName("appImageConfigName")
     *                         .imageName("imageName")
     *                         // the properties below are optional
     *                         .imageVersionNumber(123)
     *                         .build()))
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .lifecycleConfigArn("lifecycleConfigArn")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .lifecycleConfigArns(List.of("lifecycleConfigArns"))
     *                 .build())
     *         .jupyterServerAppSettings(JupyterServerAppSettingsProperty.builder()
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .lifecycleConfigArn("lifecycleConfigArn")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .build())
     *         .kernelGatewayAppSettings(KernelGatewayAppSettingsProperty.builder()
     *                 .customImages(List.of(CustomImageProperty.builder()
     *                         .appImageConfigName("appImageConfigName")
     *                         .imageName("imageName")
     *                         // the properties below are optional
     *                         .imageVersionNumber(123)
     *                         .build()))
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .lifecycleConfigArn("lifecycleConfigArn")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .build())
     *         .securityGroups(List.of("securityGroups"))
     *         .spaceStorageSettings(DefaultSpaceStorageSettingsProperty.builder()
     *                 .defaultEbsStorageSettings(DefaultEbsStorageSettingsProperty.builder()
     *                         .defaultEbsVolumeSizeInGb(123)
     *                         .maximumEbsVolumeSizeInGb(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.DefaultSpaceSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultSpaceSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultSpaceSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the execution role for the space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-executionrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExecutionRole();

        /**
         * The settings for assigning a custom file system to a domain.
         * <p>
         * Permitted users can access this file system in Amazon SageMaker Studio.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-customfilesystemconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-customfilesystemconfigs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomFileSystemConfigs() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-customposixuserconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-customposixuserconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomPosixUserConfig() {
            return null;
        }

        /**
         * The JupyterLab app settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-jupyterlabappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-jupyterlabappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJupyterLabAppSettings() {
            return null;
        }

        /**
         * The JupyterServer app settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-jupyterserverappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-jupyterserverappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJupyterServerAppSettings() {
            return null;
        }

        /**
         * The KernelGateway app settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-kernelgatewayappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-kernelgatewayappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKernelGatewayAppSettings() {
            return null;
        }

        /**
         * The security group IDs for the Amazon VPC that the space uses for communication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-securitygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-securitygroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
            return null;
        }

        /**
         * Default storage settings for a space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-spacestoragesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacesettings.html#cfn-sagemaker-domain-defaultspacesettings-spacestoragesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSpaceStorageSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefaultSpaceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultSpaceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultSpaceSettingsProperty> {
            java.lang.String executionRole;
            java.lang.Object customFileSystemConfigs;
            java.lang.Object customPosixUserConfig;
            java.lang.Object jupyterLabAppSettings;
            java.lang.Object jupyterServerAppSettings;
            java.lang.Object kernelGatewayAppSettings;
            java.util.List<java.lang.String> securityGroups;
            java.lang.Object spaceStorageSettings;

            /**
             * Sets the value of {@link DefaultSpaceSettingsProperty#getExecutionRole}
             * @param executionRole The ARN of the execution role for the space. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRole(java.lang.String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            /**
             * Sets the value of {@link DefaultSpaceSettingsProperty#getCustomFileSystemConfigs}
             * @param customFileSystemConfigs The settings for assigning a custom file system to a domain.
             *                                Permitted users can access this file system in Amazon SageMaker Studio.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customFileSystemConfigs(software.amazon.awscdk.IResolvable customFileSystemConfigs) {
                this.customFileSystemConfigs = customFileSystemConfigs;
                return this;
            }

            /**
             * Sets the value of {@link DefaultSpaceSettingsProperty#getCustomFileSystemConfigs}
             * @param customFileSystemConfigs The settings for assigning a custom file system to a domain.
             *                                Permitted users can access this file system in Amazon SageMaker Studio.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customFileSystemConfigs(java.util.List<? extends java.lang.Object> customFileSystemConfigs) {
                this.customFileSystemConfigs = customFileSystemConfigs;
                return this;
            }

            /**
             * Sets the value of {@link DefaultSpaceSettingsProperty#getCustomPosixUserConfig}
             * @param customPosixUserConfig the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPosixUserConfig(software.amazon.awscdk.IResolvable customPosixUserConfig) {
                this.customPosixUserConfig = customPosixUserConfig;
                return this;
            }

            /**
             * Sets the value of {@link DefaultSpaceSettingsProperty#getCustomPosixUserConfig}
             * @param customPosixUserConfig the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPosixUserConfig(software.amazon.awscdk.services.sagemaker.CfnDomain.CustomPosixUserConfigProperty customPosixUserConfig) {
                this.customPosixUserConfig = customPosixUserConfig;
                return this;
            }

            /**
             * Sets the value of {@link DefaultSpaceSettingsProperty#getJupyterLabAppSettings}
             * @param jupyterLabAppSettings The JupyterLab app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterLabAppSettings(software.amazon.awscdk.IResolvable jupyterLabAppSettings) {
                this.jupyterLabAppSettings = jupyterLabAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link DefaultSpaceSettingsProperty#getJupyterLabAppSettings}
             * @param jupyterLabAppSettings The JupyterLab app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterLabAppSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.JupyterLabAppSettingsProperty jupyterLabAppSettings) {
                this.jupyterLabAppSettings = jupyterLabAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link DefaultSpaceSettingsProperty#getJupyterServerAppSettings}
             * @param jupyterServerAppSettings The JupyterServer app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterServerAppSettings(software.amazon.awscdk.IResolvable jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link DefaultSpaceSettingsProperty#getJupyterServerAppSettings}
             * @param jupyterServerAppSettings The JupyterServer app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterServerAppSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.JupyterServerAppSettingsProperty jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link DefaultSpaceSettingsProperty#getKernelGatewayAppSettings}
             * @param kernelGatewayAppSettings The KernelGateway app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kernelGatewayAppSettings(software.amazon.awscdk.IResolvable kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link DefaultSpaceSettingsProperty#getKernelGatewayAppSettings}
             * @param kernelGatewayAppSettings The KernelGateway app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kernelGatewayAppSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.KernelGatewayAppSettingsProperty kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link DefaultSpaceSettingsProperty#getSecurityGroups}
             * @param securityGroups The security group IDs for the Amazon VPC that the space uses for communication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Sets the value of {@link DefaultSpaceSettingsProperty#getSpaceStorageSettings}
             * @param spaceStorageSettings Default storage settings for a space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spaceStorageSettings(software.amazon.awscdk.IResolvable spaceStorageSettings) {
                this.spaceStorageSettings = spaceStorageSettings;
                return this;
            }

            /**
             * Sets the value of {@link DefaultSpaceSettingsProperty#getSpaceStorageSettings}
             * @param spaceStorageSettings Default storage settings for a space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spaceStorageSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.DefaultSpaceStorageSettingsProperty spaceStorageSettings) {
                this.spaceStorageSettings = spaceStorageSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultSpaceSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultSpaceSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultSpaceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultSpaceSettingsProperty {
            private final java.lang.String executionRole;
            private final java.lang.Object customFileSystemConfigs;
            private final java.lang.Object customPosixUserConfig;
            private final java.lang.Object jupyterLabAppSettings;
            private final java.lang.Object jupyterServerAppSettings;
            private final java.lang.Object kernelGatewayAppSettings;
            private final java.util.List<java.lang.String> securityGroups;
            private final java.lang.Object spaceStorageSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customFileSystemConfigs = software.amazon.jsii.Kernel.get(this, "customFileSystemConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customPosixUserConfig = software.amazon.jsii.Kernel.get(this, "customPosixUserConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jupyterLabAppSettings = software.amazon.jsii.Kernel.get(this, "jupyterLabAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jupyterServerAppSettings = software.amazon.jsii.Kernel.get(this, "jupyterServerAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kernelGatewayAppSettings = software.amazon.jsii.Kernel.get(this, "kernelGatewayAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.spaceStorageSettings = software.amazon.jsii.Kernel.get(this, "spaceStorageSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.executionRole = java.util.Objects.requireNonNull(builder.executionRole, "executionRole is required");
                this.customFileSystemConfigs = builder.customFileSystemConfigs;
                this.customPosixUserConfig = builder.customPosixUserConfig;
                this.jupyterLabAppSettings = builder.jupyterLabAppSettings;
                this.jupyterServerAppSettings = builder.jupyterServerAppSettings;
                this.kernelGatewayAppSettings = builder.kernelGatewayAppSettings;
                this.securityGroups = builder.securityGroups;
                this.spaceStorageSettings = builder.spaceStorageSettings;
            }

            @Override
            public final java.lang.String getExecutionRole() {
                return this.executionRole;
            }

            @Override
            public final java.lang.Object getCustomFileSystemConfigs() {
                return this.customFileSystemConfigs;
            }

            @Override
            public final java.lang.Object getCustomPosixUserConfig() {
                return this.customPosixUserConfig;
            }

            @Override
            public final java.lang.Object getJupyterLabAppSettings() {
                return this.jupyterLabAppSettings;
            }

            @Override
            public final java.lang.Object getJupyterServerAppSettings() {
                return this.jupyterServerAppSettings;
            }

            @Override
            public final java.lang.Object getKernelGatewayAppSettings() {
                return this.kernelGatewayAppSettings;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            public final java.lang.Object getSpaceStorageSettings() {
                return this.spaceStorageSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
                if (this.getCustomFileSystemConfigs() != null) {
                    data.set("customFileSystemConfigs", om.valueToTree(this.getCustomFileSystemConfigs()));
                }
                if (this.getCustomPosixUserConfig() != null) {
                    data.set("customPosixUserConfig", om.valueToTree(this.getCustomPosixUserConfig()));
                }
                if (this.getJupyterLabAppSettings() != null) {
                    data.set("jupyterLabAppSettings", om.valueToTree(this.getJupyterLabAppSettings()));
                }
                if (this.getJupyterServerAppSettings() != null) {
                    data.set("jupyterServerAppSettings", om.valueToTree(this.getJupyterServerAppSettings()));
                }
                if (this.getKernelGatewayAppSettings() != null) {
                    data.set("kernelGatewayAppSettings", om.valueToTree(this.getKernelGatewayAppSettings()));
                }
                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }
                if (this.getSpaceStorageSettings() != null) {
                    data.set("spaceStorageSettings", om.valueToTree(this.getSpaceStorageSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.DefaultSpaceSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultSpaceSettingsProperty.Jsii$Proxy that = (DefaultSpaceSettingsProperty.Jsii$Proxy) o;

                if (!executionRole.equals(that.executionRole)) return false;
                if (this.customFileSystemConfigs != null ? !this.customFileSystemConfigs.equals(that.customFileSystemConfigs) : that.customFileSystemConfigs != null) return false;
                if (this.customPosixUserConfig != null ? !this.customPosixUserConfig.equals(that.customPosixUserConfig) : that.customPosixUserConfig != null) return false;
                if (this.jupyterLabAppSettings != null ? !this.jupyterLabAppSettings.equals(that.jupyterLabAppSettings) : that.jupyterLabAppSettings != null) return false;
                if (this.jupyterServerAppSettings != null ? !this.jupyterServerAppSettings.equals(that.jupyterServerAppSettings) : that.jupyterServerAppSettings != null) return false;
                if (this.kernelGatewayAppSettings != null ? !this.kernelGatewayAppSettings.equals(that.kernelGatewayAppSettings) : that.kernelGatewayAppSettings != null) return false;
                if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
                return this.spaceStorageSettings != null ? this.spaceStorageSettings.equals(that.spaceStorageSettings) : that.spaceStorageSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.executionRole.hashCode();
                result = 31 * result + (this.customFileSystemConfigs != null ? this.customFileSystemConfigs.hashCode() : 0);
                result = 31 * result + (this.customPosixUserConfig != null ? this.customPosixUserConfig.hashCode() : 0);
                result = 31 * result + (this.jupyterLabAppSettings != null ? this.jupyterLabAppSettings.hashCode() : 0);
                result = 31 * result + (this.jupyterServerAppSettings != null ? this.jupyterServerAppSettings.hashCode() : 0);
                result = 31 * result + (this.kernelGatewayAppSettings != null ? this.kernelGatewayAppSettings.hashCode() : 0);
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                result = 31 * result + (this.spaceStorageSettings != null ? this.spaceStorageSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The default storage settings for a space.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DefaultSpaceStorageSettingsProperty defaultSpaceStorageSettingsProperty = DefaultSpaceStorageSettingsProperty.builder()
     *         .defaultEbsStorageSettings(DefaultEbsStorageSettingsProperty.builder()
     *                 .defaultEbsVolumeSizeInGb(123)
     *                 .maximumEbsVolumeSizeInGb(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacestoragesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacestoragesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.DefaultSpaceStorageSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultSpaceStorageSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultSpaceStorageSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default EBS storage settings for a space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacestoragesettings.html#cfn-sagemaker-domain-defaultspacestoragesettings-defaultebsstoragesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-defaultspacestoragesettings.html#cfn-sagemaker-domain-defaultspacestoragesettings-defaultebsstoragesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultEbsStorageSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefaultSpaceStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultSpaceStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultSpaceStorageSettingsProperty> {
            java.lang.Object defaultEbsStorageSettings;

            /**
             * Sets the value of {@link DefaultSpaceStorageSettingsProperty#getDefaultEbsStorageSettings}
             * @param defaultEbsStorageSettings The default EBS storage settings for a space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultEbsStorageSettings(software.amazon.awscdk.IResolvable defaultEbsStorageSettings) {
                this.defaultEbsStorageSettings = defaultEbsStorageSettings;
                return this;
            }

            /**
             * Sets the value of {@link DefaultSpaceStorageSettingsProperty#getDefaultEbsStorageSettings}
             * @param defaultEbsStorageSettings The default EBS storage settings for a space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultEbsStorageSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.DefaultEbsStorageSettingsProperty defaultEbsStorageSettings) {
                this.defaultEbsStorageSettings = defaultEbsStorageSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultSpaceStorageSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultSpaceStorageSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultSpaceStorageSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultSpaceStorageSettingsProperty {
            private final java.lang.Object defaultEbsStorageSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultEbsStorageSettings = software.amazon.jsii.Kernel.get(this, "defaultEbsStorageSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultEbsStorageSettings = builder.defaultEbsStorageSettings;
            }

            @Override
            public final java.lang.Object getDefaultEbsStorageSettings() {
                return this.defaultEbsStorageSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultEbsStorageSettings() != null) {
                    data.set("defaultEbsStorageSettings", om.valueToTree(this.getDefaultEbsStorageSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.DefaultSpaceStorageSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultSpaceStorageSettingsProperty.Jsii$Proxy that = (DefaultSpaceStorageSettingsProperty.Jsii$Proxy) o;

                return this.defaultEbsStorageSettings != null ? this.defaultEbsStorageSettings.equals(that.defaultEbsStorageSettings) : that.defaultEbsStorageSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultEbsStorageSettings != null ? this.defaultEbsStorageSettings.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A collection of settings that configure the domain's Docker interaction.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DockerSettingsProperty dockerSettingsProperty = DockerSettingsProperty.builder()
     *         .enableDockerAccess("enableDockerAccess")
     *         .vpcOnlyTrustedAccounts(List.of("vpcOnlyTrustedAccounts"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-dockersettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-dockersettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.DockerSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DockerSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DockerSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the domain can access Docker.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-dockersettings.html#cfn-sagemaker-domain-dockersettings-enabledockeraccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-dockersettings.html#cfn-sagemaker-domain-dockersettings-enabledockeraccess</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEnableDockerAccess() {
            return null;
        }

        /**
         * The list of AWS accounts that are trusted when the domain is created in VPC-only mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-dockersettings.html#cfn-sagemaker-domain-dockersettings-vpconlytrustedaccounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-dockersettings.html#cfn-sagemaker-domain-dockersettings-vpconlytrustedaccounts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcOnlyTrustedAccounts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DockerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DockerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DockerSettingsProperty> {
            java.lang.String enableDockerAccess;
            java.util.List<java.lang.String> vpcOnlyTrustedAccounts;

            /**
             * Sets the value of {@link DockerSettingsProperty#getEnableDockerAccess}
             * @param enableDockerAccess Indicates whether the domain can access Docker.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableDockerAccess(java.lang.String enableDockerAccess) {
                this.enableDockerAccess = enableDockerAccess;
                return this;
            }

            /**
             * Sets the value of {@link DockerSettingsProperty#getVpcOnlyTrustedAccounts}
             * @param vpcOnlyTrustedAccounts The list of AWS accounts that are trusted when the domain is created in VPC-only mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcOnlyTrustedAccounts(java.util.List<java.lang.String> vpcOnlyTrustedAccounts) {
                this.vpcOnlyTrustedAccounts = vpcOnlyTrustedAccounts;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DockerSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DockerSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DockerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DockerSettingsProperty {
            private final java.lang.String enableDockerAccess;
            private final java.util.List<java.lang.String> vpcOnlyTrustedAccounts;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableDockerAccess = software.amazon.jsii.Kernel.get(this, "enableDockerAccess", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcOnlyTrustedAccounts = software.amazon.jsii.Kernel.get(this, "vpcOnlyTrustedAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableDockerAccess = builder.enableDockerAccess;
                this.vpcOnlyTrustedAccounts = builder.vpcOnlyTrustedAccounts;
            }

            @Override
            public final java.lang.String getEnableDockerAccess() {
                return this.enableDockerAccess;
            }

            @Override
            public final java.util.List<java.lang.String> getVpcOnlyTrustedAccounts() {
                return this.vpcOnlyTrustedAccounts;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableDockerAccess() != null) {
                    data.set("enableDockerAccess", om.valueToTree(this.getEnableDockerAccess()));
                }
                if (this.getVpcOnlyTrustedAccounts() != null) {
                    data.set("vpcOnlyTrustedAccounts", om.valueToTree(this.getVpcOnlyTrustedAccounts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.DockerSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DockerSettingsProperty.Jsii$Proxy that = (DockerSettingsProperty.Jsii$Proxy) o;

                if (this.enableDockerAccess != null ? !this.enableDockerAccess.equals(that.enableDockerAccess) : that.enableDockerAccess != null) return false;
                return this.vpcOnlyTrustedAccounts != null ? this.vpcOnlyTrustedAccounts.equals(that.vpcOnlyTrustedAccounts) : that.vpcOnlyTrustedAccounts == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableDockerAccess != null ? this.enableDockerAccess.hashCode() : 0;
                result = 31 * result + (this.vpcOnlyTrustedAccounts != null ? this.vpcOnlyTrustedAccounts.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A collection of settings that apply to the <code>SageMaker Domain</code> .
     * <p>
     * These settings are specified through the <code>CreateDomain</code> API call.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DomainSettingsProperty domainSettingsProperty = DomainSettingsProperty.builder()
     *         .dockerSettings(DockerSettingsProperty.builder()
     *                 .enableDockerAccess("enableDockerAccess")
     *                 .vpcOnlyTrustedAccounts(List.of("vpcOnlyTrustedAccounts"))
     *                 .build())
     *         .rStudioServerProDomainSettings(RStudioServerProDomainSettingsProperty.builder()
     *                 .domainExecutionRoleArn("domainExecutionRoleArn")
     *                 // the properties below are optional
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .lifecycleConfigArn("lifecycleConfigArn")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .rStudioConnectUrl("rStudioConnectUrl")
     *                 .rStudioPackageManagerUrl("rStudioPackageManagerUrl")
     *                 .build())
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.DomainSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DomainSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DomainSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A collection of settings that configure the domain's Docker interaction.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html#cfn-sagemaker-domain-domainsettings-dockersettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html#cfn-sagemaker-domain-domainsettings-dockersettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDockerSettings() {
            return null;
        }

        /**
         * A collection of settings that configure the <code>RStudioServerPro</code> Domain-level app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html#cfn-sagemaker-domain-domainsettings-rstudioserverprodomainsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html#cfn-sagemaker-domain-domainsettings-rstudioserverprodomainsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRStudioServerProDomainSettings() {
            return null;
        }

        /**
         * The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for communication between Domain-level apps and user apps.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html#cfn-sagemaker-domain-domainsettings-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html#cfn-sagemaker-domain-domainsettings-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DomainSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DomainSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DomainSettingsProperty> {
            java.lang.Object dockerSettings;
            java.lang.Object rStudioServerProDomainSettings;
            java.util.List<java.lang.String> securityGroupIds;

            /**
             * Sets the value of {@link DomainSettingsProperty#getDockerSettings}
             * @param dockerSettings A collection of settings that configure the domain's Docker interaction.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dockerSettings(software.amazon.awscdk.IResolvable dockerSettings) {
                this.dockerSettings = dockerSettings;
                return this;
            }

            /**
             * Sets the value of {@link DomainSettingsProperty#getDockerSettings}
             * @param dockerSettings A collection of settings that configure the domain's Docker interaction.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dockerSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.DockerSettingsProperty dockerSettings) {
                this.dockerSettings = dockerSettings;
                return this;
            }

            /**
             * Sets the value of {@link DomainSettingsProperty#getRStudioServerProDomainSettings}
             * @param rStudioServerProDomainSettings A collection of settings that configure the <code>RStudioServerPro</code> Domain-level app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rStudioServerProDomainSettings(software.amazon.awscdk.IResolvable rStudioServerProDomainSettings) {
                this.rStudioServerProDomainSettings = rStudioServerProDomainSettings;
                return this;
            }

            /**
             * Sets the value of {@link DomainSettingsProperty#getRStudioServerProDomainSettings}
             * @param rStudioServerProDomainSettings A collection of settings that configure the <code>RStudioServerPro</code> Domain-level app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rStudioServerProDomainSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty rStudioServerProDomainSettings) {
                this.rStudioServerProDomainSettings = rStudioServerProDomainSettings;
                return this;
            }

            /**
             * Sets the value of {@link DomainSettingsProperty#getSecurityGroupIds}
             * @param securityGroupIds The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for communication between Domain-level apps and user apps.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DomainSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DomainSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DomainSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainSettingsProperty {
            private final java.lang.Object dockerSettings;
            private final java.lang.Object rStudioServerProDomainSettings;
            private final java.util.List<java.lang.String> securityGroupIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dockerSettings = software.amazon.jsii.Kernel.get(this, "dockerSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rStudioServerProDomainSettings = software.amazon.jsii.Kernel.get(this, "rStudioServerProDomainSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dockerSettings = builder.dockerSettings;
                this.rStudioServerProDomainSettings = builder.rStudioServerProDomainSettings;
                this.securityGroupIds = builder.securityGroupIds;
            }

            @Override
            public final java.lang.Object getDockerSettings() {
                return this.dockerSettings;
            }

            @Override
            public final java.lang.Object getRStudioServerProDomainSettings() {
                return this.rStudioServerProDomainSettings;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDockerSettings() != null) {
                    data.set("dockerSettings", om.valueToTree(this.getDockerSettings()));
                }
                if (this.getRStudioServerProDomainSettings() != null) {
                    data.set("rStudioServerProDomainSettings", om.valueToTree(this.getRStudioServerProDomainSettings()));
                }
                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.DomainSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DomainSettingsProperty.Jsii$Proxy that = (DomainSettingsProperty.Jsii$Proxy) o;

                if (this.dockerSettings != null ? !this.dockerSettings.equals(that.dockerSettings) : that.dockerSettings != null) return false;
                if (this.rStudioServerProDomainSettings != null ? !this.rStudioServerProDomainSettings.equals(that.rStudioServerProDomainSettings) : that.rStudioServerProDomainSettings != null) return false;
                return this.securityGroupIds != null ? this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dockerSettings != null ? this.dockerSettings.hashCode() : 0;
                result = 31 * result + (this.rStudioServerProDomainSettings != null ? this.rStudioServerProDomainSettings.hashCode() : 0);
                result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for assigning a custom Amazon EFS file system to a user profile or space for an Amazon SageMaker Domain.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * EFSFileSystemConfigProperty eFSFileSystemConfigProperty = EFSFileSystemConfigProperty.builder()
     *         .fileSystemId("fileSystemId")
     *         // the properties below are optional
     *         .fileSystemPath("fileSystemPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-efsfilesystemconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-efsfilesystemconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.EFSFileSystemConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EFSFileSystemConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EFSFileSystemConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of your Amazon EFS file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-efsfilesystemconfig.html#cfn-sagemaker-domain-efsfilesystemconfig-filesystemid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-efsfilesystemconfig.html#cfn-sagemaker-domain-efsfilesystemconfig-filesystemid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId();

        /**
         * The path to the file system directory that is accessible in Amazon SageMaker Studio.
         * <p>
         * Permitted users can access only this directory and below.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-efsfilesystemconfig.html#cfn-sagemaker-domain-efsfilesystemconfig-filesystempath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-efsfilesystemconfig.html#cfn-sagemaker-domain-efsfilesystemconfig-filesystempath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFileSystemPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EFSFileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EFSFileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EFSFileSystemConfigProperty> {
            java.lang.String fileSystemId;
            java.lang.String fileSystemPath;

            /**
             * Sets the value of {@link EFSFileSystemConfigProperty#getFileSystemId}
             * @param fileSystemId The ID of your Amazon EFS file system. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileSystemId(java.lang.String fileSystemId) {
                this.fileSystemId = fileSystemId;
                return this;
            }

            /**
             * Sets the value of {@link EFSFileSystemConfigProperty#getFileSystemPath}
             * @param fileSystemPath The path to the file system directory that is accessible in Amazon SageMaker Studio.
             *                       Permitted users can access only this directory and below.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileSystemPath(java.lang.String fileSystemPath) {
                this.fileSystemPath = fileSystemPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EFSFileSystemConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EFSFileSystemConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EFSFileSystemConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EFSFileSystemConfigProperty {
            private final java.lang.String fileSystemId;
            private final java.lang.String fileSystemPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fileSystemId = software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fileSystemPath = software.amazon.jsii.Kernel.get(this, "fileSystemPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fileSystemId = java.util.Objects.requireNonNull(builder.fileSystemId, "fileSystemId is required");
                this.fileSystemPath = builder.fileSystemPath;
            }

            @Override
            public final java.lang.String getFileSystemId() {
                return this.fileSystemId;
            }

            @Override
            public final java.lang.String getFileSystemPath() {
                return this.fileSystemPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fileSystemId", om.valueToTree(this.getFileSystemId()));
                if (this.getFileSystemPath() != null) {
                    data.set("fileSystemPath", om.valueToTree(this.getFileSystemPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.EFSFileSystemConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EFSFileSystemConfigProperty.Jsii$Proxy that = (EFSFileSystemConfigProperty.Jsii$Proxy) o;

                if (!fileSystemId.equals(that.fileSystemId)) return false;
                return this.fileSystemPath != null ? this.fileSystemPath.equals(that.fileSystemPath) : that.fileSystemPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fileSystemId.hashCode();
                result = 31 * result + (this.fileSystemPath != null ? this.fileSystemPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for the JupyterLab application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * JupyterLabAppSettingsProperty jupyterLabAppSettingsProperty = JupyterLabAppSettingsProperty.builder()
     *         .codeRepositories(List.of(CodeRepositoryProperty.builder()
     *                 .repositoryUrl("repositoryUrl")
     *                 .build()))
     *         .customImages(List.of(CustomImageProperty.builder()
     *                 .appImageConfigName("appImageConfigName")
     *                 .imageName("imageName")
     *                 // the properties below are optional
     *                 .imageVersionNumber(123)
     *                 .build()))
     *         .defaultResourceSpec(ResourceSpecProperty.builder()
     *                 .instanceType("instanceType")
     *                 .lifecycleConfigArn("lifecycleConfigArn")
     *                 .sageMakerImageArn("sageMakerImageArn")
     *                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                 .build())
     *         .lifecycleConfigArns(List.of("lifecycleConfigArns"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterlabappsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterlabappsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.JupyterLabAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(JupyterLabAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JupyterLabAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterlabappsettings.html#cfn-sagemaker-domain-jupyterlabappsettings-coderepositories">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterlabappsettings.html#cfn-sagemaker-domain-jupyterlabappsettings-coderepositories</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeRepositories() {
            return null;
        }

        /**
         * A list of custom SageMaker images that are configured to run as a JupyterLab app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterlabappsettings.html#cfn-sagemaker-domain-jupyterlabappsettings-customimages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterlabappsettings.html#cfn-sagemaker-domain-jupyterlabappsettings-customimages</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomImages() {
            return null;
        }

        /**
         * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterLab app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterlabappsettings.html#cfn-sagemaker-domain-jupyterlabappsettings-defaultresourcespec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterlabappsettings.html#cfn-sagemaker-domain-jupyterlabappsettings-defaultresourcespec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceSpec() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the lifecycle configurations attached to the user profile or domain.
         * <p>
         * To remove a lifecycle config, you must set <code>LifecycleConfigArns</code> to an empty list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterlabappsettings.html#cfn-sagemaker-domain-jupyterlabappsettings-lifecycleconfigarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterlabappsettings.html#cfn-sagemaker-domain-jupyterlabappsettings-lifecycleconfigarns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLifecycleConfigArns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JupyterLabAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JupyterLabAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JupyterLabAppSettingsProperty> {
            java.lang.Object codeRepositories;
            java.lang.Object customImages;
            java.lang.Object defaultResourceSpec;
            java.util.List<java.lang.String> lifecycleConfigArns;

            /**
             * Sets the value of {@link JupyterLabAppSettingsProperty#getCodeRepositories}
             * @param codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeRepositories(software.amazon.awscdk.IResolvable codeRepositories) {
                this.codeRepositories = codeRepositories;
                return this;
            }

            /**
             * Sets the value of {@link JupyterLabAppSettingsProperty#getCodeRepositories}
             * @param codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterLab application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeRepositories(java.util.List<? extends java.lang.Object> codeRepositories) {
                this.codeRepositories = codeRepositories;
                return this;
            }

            /**
             * Sets the value of {@link JupyterLabAppSettingsProperty#getCustomImages}
             * @param customImages A list of custom SageMaker images that are configured to run as a JupyterLab app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customImages(software.amazon.awscdk.IResolvable customImages) {
                this.customImages = customImages;
                return this;
            }

            /**
             * Sets the value of {@link JupyterLabAppSettingsProperty#getCustomImages}
             * @param customImages A list of custom SageMaker images that are configured to run as a JupyterLab app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customImages(java.util.List<? extends java.lang.Object> customImages) {
                this.customImages = customImages;
                return this;
            }

            /**
             * Sets the value of {@link JupyterLabAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterLab app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link JupyterLabAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterLab app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.services.sagemaker.CfnDomain.ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link JupyterLabAppSettingsProperty#getLifecycleConfigArns}
             * @param lifecycleConfigArns The Amazon Resource Name (ARN) of the lifecycle configurations attached to the user profile or domain.
             *                            To remove a lifecycle config, you must set <code>LifecycleConfigArns</code> to an empty list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lifecycleConfigArns(java.util.List<java.lang.String> lifecycleConfigArns) {
                this.lifecycleConfigArns = lifecycleConfigArns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JupyterLabAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JupyterLabAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JupyterLabAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JupyterLabAppSettingsProperty {
            private final java.lang.Object codeRepositories;
            private final java.lang.Object customImages;
            private final java.lang.Object defaultResourceSpec;
            private final java.util.List<java.lang.String> lifecycleConfigArns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.codeRepositories = software.amazon.jsii.Kernel.get(this, "codeRepositories", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customImages = software.amazon.jsii.Kernel.get(this, "customImages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultResourceSpec = software.amazon.jsii.Kernel.get(this, "defaultResourceSpec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lifecycleConfigArns = software.amazon.jsii.Kernel.get(this, "lifecycleConfigArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.codeRepositories = builder.codeRepositories;
                this.customImages = builder.customImages;
                this.defaultResourceSpec = builder.defaultResourceSpec;
                this.lifecycleConfigArns = builder.lifecycleConfigArns;
            }

            @Override
            public final java.lang.Object getCodeRepositories() {
                return this.codeRepositories;
            }

            @Override
            public final java.lang.Object getCustomImages() {
                return this.customImages;
            }

            @Override
            public final java.lang.Object getDefaultResourceSpec() {
                return this.defaultResourceSpec;
            }

            @Override
            public final java.util.List<java.lang.String> getLifecycleConfigArns() {
                return this.lifecycleConfigArns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCodeRepositories() != null) {
                    data.set("codeRepositories", om.valueToTree(this.getCodeRepositories()));
                }
                if (this.getCustomImages() != null) {
                    data.set("customImages", om.valueToTree(this.getCustomImages()));
                }
                if (this.getDefaultResourceSpec() != null) {
                    data.set("defaultResourceSpec", om.valueToTree(this.getDefaultResourceSpec()));
                }
                if (this.getLifecycleConfigArns() != null) {
                    data.set("lifecycleConfigArns", om.valueToTree(this.getLifecycleConfigArns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.JupyterLabAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JupyterLabAppSettingsProperty.Jsii$Proxy that = (JupyterLabAppSettingsProperty.Jsii$Proxy) o;

                if (this.codeRepositories != null ? !this.codeRepositories.equals(that.codeRepositories) : that.codeRepositories != null) return false;
                if (this.customImages != null ? !this.customImages.equals(that.customImages) : that.customImages != null) return false;
                if (this.defaultResourceSpec != null ? !this.defaultResourceSpec.equals(that.defaultResourceSpec) : that.defaultResourceSpec != null) return false;
                return this.lifecycleConfigArns != null ? this.lifecycleConfigArns.equals(that.lifecycleConfigArns) : that.lifecycleConfigArns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.codeRepositories != null ? this.codeRepositories.hashCode() : 0;
                result = 31 * result + (this.customImages != null ? this.customImages.hashCode() : 0);
                result = 31 * result + (this.defaultResourceSpec != null ? this.defaultResourceSpec.hashCode() : 0);
                result = 31 * result + (this.lifecycleConfigArns != null ? this.lifecycleConfigArns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The JupyterServer app settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * JupyterServerAppSettingsProperty jupyterServerAppSettingsProperty = JupyterServerAppSettingsProperty.builder()
     *         .defaultResourceSpec(ResourceSpecProperty.builder()
     *                 .instanceType("instanceType")
     *                 .lifecycleConfigArn("lifecycleConfigArn")
     *                 .sageMakerImageArn("sageMakerImageArn")
     *                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterserverappsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterserverappsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.JupyterServerAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(JupyterServerAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JupyterServerAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterserverappsettings.html#cfn-sagemaker-domain-jupyterserverappsettings-defaultresourcespec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterserverappsettings.html#cfn-sagemaker-domain-jupyterserverappsettings-defaultresourcespec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceSpec() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JupyterServerAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JupyterServerAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JupyterServerAppSettingsProperty> {
            java.lang.Object defaultResourceSpec;

            /**
             * Sets the value of {@link JupyterServerAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link JupyterServerAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.services.sagemaker.CfnDomain.ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JupyterServerAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JupyterServerAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JupyterServerAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JupyterServerAppSettingsProperty {
            private final java.lang.Object defaultResourceSpec;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultResourceSpec = software.amazon.jsii.Kernel.get(this, "defaultResourceSpec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultResourceSpec = builder.defaultResourceSpec;
            }

            @Override
            public final java.lang.Object getDefaultResourceSpec() {
                return this.defaultResourceSpec;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultResourceSpec() != null) {
                    data.set("defaultResourceSpec", om.valueToTree(this.getDefaultResourceSpec()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.JupyterServerAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JupyterServerAppSettingsProperty.Jsii$Proxy that = (JupyterServerAppSettingsProperty.Jsii$Proxy) o;

                return this.defaultResourceSpec != null ? this.defaultResourceSpec.equals(that.defaultResourceSpec) : that.defaultResourceSpec == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultResourceSpec != null ? this.defaultResourceSpec.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The KernelGateway app settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * KernelGatewayAppSettingsProperty kernelGatewayAppSettingsProperty = KernelGatewayAppSettingsProperty.builder()
     *         .customImages(List.of(CustomImageProperty.builder()
     *                 .appImageConfigName("appImageConfigName")
     *                 .imageName("imageName")
     *                 // the properties below are optional
     *                 .imageVersionNumber(123)
     *                 .build()))
     *         .defaultResourceSpec(ResourceSpecProperty.builder()
     *                 .instanceType("instanceType")
     *                 .lifecycleConfigArn("lifecycleConfigArn")
     *                 .sageMakerImageArn("sageMakerImageArn")
     *                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.KernelGatewayAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(KernelGatewayAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KernelGatewayAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of custom SageMaker images that are configured to run as a KernelGateway app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html#cfn-sagemaker-domain-kernelgatewayappsettings-customimages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html#cfn-sagemaker-domain-kernelgatewayappsettings-customimages</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomImages() {
            return null;
        }

        /**
         * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
         * <p>
         * <blockquote>
         * <p>
         * The Amazon SageMaker Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS CLI or AWS CloudFormation and the instance type parameter value is not passed.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html#cfn-sagemaker-domain-kernelgatewayappsettings-defaultresourcespec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html#cfn-sagemaker-domain-kernelgatewayappsettings-defaultresourcespec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceSpec() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KernelGatewayAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KernelGatewayAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KernelGatewayAppSettingsProperty> {
            java.lang.Object customImages;
            java.lang.Object defaultResourceSpec;

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getCustomImages}
             * @param customImages A list of custom SageMaker images that are configured to run as a KernelGateway app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customImages(software.amazon.awscdk.IResolvable customImages) {
                this.customImages = customImages;
                return this;
            }

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getCustomImages}
             * @param customImages A list of custom SageMaker images that are configured to run as a KernelGateway app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customImages(java.util.List<? extends java.lang.Object> customImages) {
                this.customImages = customImages;
                return this;
            }

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
             *                            <blockquote>
             *                            <p>
             *                            The Amazon SageMaker Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS CLI or AWS CloudFormation and the instance type parameter value is not passed.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link KernelGatewayAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.
             *                            <blockquote>
             *                            <p>
             *                            The Amazon SageMaker Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS CLI or AWS CloudFormation and the instance type parameter value is not passed.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.services.sagemaker.CfnDomain.ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KernelGatewayAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KernelGatewayAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KernelGatewayAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KernelGatewayAppSettingsProperty {
            private final java.lang.Object customImages;
            private final java.lang.Object defaultResourceSpec;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customImages = software.amazon.jsii.Kernel.get(this, "customImages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultResourceSpec = software.amazon.jsii.Kernel.get(this, "defaultResourceSpec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customImages = builder.customImages;
                this.defaultResourceSpec = builder.defaultResourceSpec;
            }

            @Override
            public final java.lang.Object getCustomImages() {
                return this.customImages;
            }

            @Override
            public final java.lang.Object getDefaultResourceSpec() {
                return this.defaultResourceSpec;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomImages() != null) {
                    data.set("customImages", om.valueToTree(this.getCustomImages()));
                }
                if (this.getDefaultResourceSpec() != null) {
                    data.set("defaultResourceSpec", om.valueToTree(this.getDefaultResourceSpec()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.KernelGatewayAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KernelGatewayAppSettingsProperty.Jsii$Proxy that = (KernelGatewayAppSettingsProperty.Jsii$Proxy) o;

                if (this.customImages != null ? !this.customImages.equals(that.customImages) : that.customImages != null) return false;
                return this.defaultResourceSpec != null ? this.defaultResourceSpec.equals(that.defaultResourceSpec) : that.defaultResourceSpec == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customImages != null ? this.customImages.hashCode() : 0;
                result = 31 * result + (this.defaultResourceSpec != null ? this.defaultResourceSpec.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A collection of settings that apply to an <code>RSessionGateway</code> app.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * RSessionAppSettingsProperty rSessionAppSettingsProperty = RSessionAppSettingsProperty.builder()
     *         .customImages(List.of(CustomImageProperty.builder()
     *                 .appImageConfigName("appImageConfigName")
     *                 .imageName("imageName")
     *                 // the properties below are optional
     *                 .imageVersionNumber(123)
     *                 .build()))
     *         .defaultResourceSpec(ResourceSpecProperty.builder()
     *                 .instanceType("instanceType")
     *                 .lifecycleConfigArn("lifecycleConfigArn")
     *                 .sageMakerImageArn("sageMakerImageArn")
     *                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rsessionappsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rsessionappsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.RSessionAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(RSessionAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RSessionAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of custom SageMaker images that are configured to run as a RSession app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rsessionappsettings.html#cfn-sagemaker-domain-rsessionappsettings-customimages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rsessionappsettings.html#cfn-sagemaker-domain-rsessionappsettings-customimages</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomImages() {
            return null;
        }

        /**
         * Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rsessionappsettings.html#cfn-sagemaker-domain-rsessionappsettings-defaultresourcespec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rsessionappsettings.html#cfn-sagemaker-domain-rsessionappsettings-defaultresourcespec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceSpec() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RSessionAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RSessionAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RSessionAppSettingsProperty> {
            java.lang.Object customImages;
            java.lang.Object defaultResourceSpec;

            /**
             * Sets the value of {@link RSessionAppSettingsProperty#getCustomImages}
             * @param customImages A list of custom SageMaker images that are configured to run as a RSession app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customImages(software.amazon.awscdk.IResolvable customImages) {
                this.customImages = customImages;
                return this;
            }

            /**
             * Sets the value of {@link RSessionAppSettingsProperty#getCustomImages}
             * @param customImages A list of custom SageMaker images that are configured to run as a RSession app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customImages(java.util.List<? extends java.lang.Object> customImages) {
                this.customImages = customImages;
                return this;
            }

            /**
             * Sets the value of {@link RSessionAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link RSessionAppSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.services.sagemaker.CfnDomain.ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RSessionAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RSessionAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RSessionAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RSessionAppSettingsProperty {
            private final java.lang.Object customImages;
            private final java.lang.Object defaultResourceSpec;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customImages = software.amazon.jsii.Kernel.get(this, "customImages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultResourceSpec = software.amazon.jsii.Kernel.get(this, "defaultResourceSpec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customImages = builder.customImages;
                this.defaultResourceSpec = builder.defaultResourceSpec;
            }

            @Override
            public final java.lang.Object getCustomImages() {
                return this.customImages;
            }

            @Override
            public final java.lang.Object getDefaultResourceSpec() {
                return this.defaultResourceSpec;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomImages() != null) {
                    data.set("customImages", om.valueToTree(this.getCustomImages()));
                }
                if (this.getDefaultResourceSpec() != null) {
                    data.set("defaultResourceSpec", om.valueToTree(this.getDefaultResourceSpec()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.RSessionAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RSessionAppSettingsProperty.Jsii$Proxy that = (RSessionAppSettingsProperty.Jsii$Proxy) o;

                if (this.customImages != null ? !this.customImages.equals(that.customImages) : that.customImages != null) return false;
                return this.defaultResourceSpec != null ? this.defaultResourceSpec.equals(that.defaultResourceSpec) : that.defaultResourceSpec == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customImages != null ? this.customImages.hashCode() : 0;
                result = 31 * result + (this.defaultResourceSpec != null ? this.defaultResourceSpec.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * RStudioServerProAppSettingsProperty rStudioServerProAppSettingsProperty = RStudioServerProAppSettingsProperty.builder()
     *         .accessStatus("accessStatus")
     *         .userGroup("userGroup")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverproappsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverproappsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.RStudioServerProAppSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(RStudioServerProAppSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RStudioServerProAppSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the current user has access to the <code>RStudioServerPro</code> app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverproappsettings.html#cfn-sagemaker-domain-rstudioserverproappsettings-accessstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverproappsettings.html#cfn-sagemaker-domain-rstudioserverproappsettings-accessstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessStatus() {
            return null;
        }

        /**
         * The level of permissions that the user has within the <code>RStudioServerPro</code> app.
         * <p>
         * This value defaults to <code>User</code>. The <code>Admin</code> value allows the user access to the RStudio Administrative Dashboard.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverproappsettings.html#cfn-sagemaker-domain-rstudioserverproappsettings-usergroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverproappsettings.html#cfn-sagemaker-domain-rstudioserverproappsettings-usergroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserGroup() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RStudioServerProAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RStudioServerProAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RStudioServerProAppSettingsProperty> {
            java.lang.String accessStatus;
            java.lang.String userGroup;

            /**
             * Sets the value of {@link RStudioServerProAppSettingsProperty#getAccessStatus}
             * @param accessStatus Indicates whether the current user has access to the <code>RStudioServerPro</code> app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessStatus(java.lang.String accessStatus) {
                this.accessStatus = accessStatus;
                return this;
            }

            /**
             * Sets the value of {@link RStudioServerProAppSettingsProperty#getUserGroup}
             * @param userGroup The level of permissions that the user has within the <code>RStudioServerPro</code> app.
             *                  This value defaults to <code>User</code>. The <code>Admin</code> value allows the user access to the RStudio Administrative Dashboard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userGroup(java.lang.String userGroup) {
                this.userGroup = userGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RStudioServerProAppSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RStudioServerProAppSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RStudioServerProAppSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RStudioServerProAppSettingsProperty {
            private final java.lang.String accessStatus;
            private final java.lang.String userGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessStatus = software.amazon.jsii.Kernel.get(this, "accessStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userGroup = software.amazon.jsii.Kernel.get(this, "userGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessStatus = builder.accessStatus;
                this.userGroup = builder.userGroup;
            }

            @Override
            public final java.lang.String getAccessStatus() {
                return this.accessStatus;
            }

            @Override
            public final java.lang.String getUserGroup() {
                return this.userGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessStatus() != null) {
                    data.set("accessStatus", om.valueToTree(this.getAccessStatus()));
                }
                if (this.getUserGroup() != null) {
                    data.set("userGroup", om.valueToTree(this.getUserGroup()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.RStudioServerProAppSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RStudioServerProAppSettingsProperty.Jsii$Proxy that = (RStudioServerProAppSettingsProperty.Jsii$Proxy) o;

                if (this.accessStatus != null ? !this.accessStatus.equals(that.accessStatus) : that.accessStatus != null) return false;
                return this.userGroup != null ? this.userGroup.equals(that.userGroup) : that.userGroup == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessStatus != null ? this.accessStatus.hashCode() : 0;
                result = 31 * result + (this.userGroup != null ? this.userGroup.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A collection of settings that configure the <code>RStudioServerPro</code> Domain-level app.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * RStudioServerProDomainSettingsProperty rStudioServerProDomainSettingsProperty = RStudioServerProDomainSettingsProperty.builder()
     *         .domainExecutionRoleArn("domainExecutionRoleArn")
     *         // the properties below are optional
     *         .defaultResourceSpec(ResourceSpecProperty.builder()
     *                 .instanceType("instanceType")
     *                 .lifecycleConfigArn("lifecycleConfigArn")
     *                 .sageMakerImageArn("sageMakerImageArn")
     *                 .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                 .build())
     *         .rStudioConnectUrl("rStudioConnectUrl")
     *         .rStudioPackageManagerUrl("rStudioPackageManagerUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(RStudioServerProDomainSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RStudioServerProDomainSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the execution role for the <code>RStudioServerPro</code> Domain-level app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-domainexecutionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-domainexecutionrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomainExecutionRoleArn();

        /**
         * A collection that defines the default <code>InstanceType</code> , <code>SageMakerImageArn</code> , and <code>SageMakerImageVersionArn</code> for the Domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-defaultresourcespec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-defaultresourcespec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResourceSpec() {
            return null;
        }

        /**
         * A URL pointing to an RStudio Connect server.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-rstudioconnecturl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-rstudioconnecturl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRStudioConnectUrl() {
            return null;
        }

        /**
         * A URL pointing to an RStudio Package Manager server.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-rstudiopackagemanagerurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-rstudiopackagemanagerurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRStudioPackageManagerUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RStudioServerProDomainSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RStudioServerProDomainSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RStudioServerProDomainSettingsProperty> {
            java.lang.String domainExecutionRoleArn;
            java.lang.Object defaultResourceSpec;
            java.lang.String rStudioConnectUrl;
            java.lang.String rStudioPackageManagerUrl;

            /**
             * Sets the value of {@link RStudioServerProDomainSettingsProperty#getDomainExecutionRoleArn}
             * @param domainExecutionRoleArn The ARN of the execution role for the <code>RStudioServerPro</code> Domain-level app. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainExecutionRoleArn(java.lang.String domainExecutionRoleArn) {
                this.domainExecutionRoleArn = domainExecutionRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link RStudioServerProDomainSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec A collection that defines the default <code>InstanceType</code> , <code>SageMakerImageArn</code> , and <code>SageMakerImageVersionArn</code> for the Domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link RStudioServerProDomainSettingsProperty#getDefaultResourceSpec}
             * @param defaultResourceSpec A collection that defines the default <code>InstanceType</code> , <code>SageMakerImageArn</code> , and <code>SageMakerImageVersionArn</code> for the Domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultResourceSpec(software.amazon.awscdk.services.sagemaker.CfnDomain.ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            /**
             * Sets the value of {@link RStudioServerProDomainSettingsProperty#getRStudioConnectUrl}
             * @param rStudioConnectUrl A URL pointing to an RStudio Connect server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rStudioConnectUrl(java.lang.String rStudioConnectUrl) {
                this.rStudioConnectUrl = rStudioConnectUrl;
                return this;
            }

            /**
             * Sets the value of {@link RStudioServerProDomainSettingsProperty#getRStudioPackageManagerUrl}
             * @param rStudioPackageManagerUrl A URL pointing to an RStudio Package Manager server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rStudioPackageManagerUrl(java.lang.String rStudioPackageManagerUrl) {
                this.rStudioPackageManagerUrl = rStudioPackageManagerUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RStudioServerProDomainSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RStudioServerProDomainSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RStudioServerProDomainSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RStudioServerProDomainSettingsProperty {
            private final java.lang.String domainExecutionRoleArn;
            private final java.lang.Object defaultResourceSpec;
            private final java.lang.String rStudioConnectUrl;
            private final java.lang.String rStudioPackageManagerUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainExecutionRoleArn = software.amazon.jsii.Kernel.get(this, "domainExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultResourceSpec = software.amazon.jsii.Kernel.get(this, "defaultResourceSpec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rStudioConnectUrl = software.amazon.jsii.Kernel.get(this, "rStudioConnectUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rStudioPackageManagerUrl = software.amazon.jsii.Kernel.get(this, "rStudioPackageManagerUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainExecutionRoleArn = java.util.Objects.requireNonNull(builder.domainExecutionRoleArn, "domainExecutionRoleArn is required");
                this.defaultResourceSpec = builder.defaultResourceSpec;
                this.rStudioConnectUrl = builder.rStudioConnectUrl;
                this.rStudioPackageManagerUrl = builder.rStudioPackageManagerUrl;
            }

            @Override
            public final java.lang.String getDomainExecutionRoleArn() {
                return this.domainExecutionRoleArn;
            }

            @Override
            public final java.lang.Object getDefaultResourceSpec() {
                return this.defaultResourceSpec;
            }

            @Override
            public final java.lang.String getRStudioConnectUrl() {
                return this.rStudioConnectUrl;
            }

            @Override
            public final java.lang.String getRStudioPackageManagerUrl() {
                return this.rStudioPackageManagerUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("domainExecutionRoleArn", om.valueToTree(this.getDomainExecutionRoleArn()));
                if (this.getDefaultResourceSpec() != null) {
                    data.set("defaultResourceSpec", om.valueToTree(this.getDefaultResourceSpec()));
                }
                if (this.getRStudioConnectUrl() != null) {
                    data.set("rStudioConnectUrl", om.valueToTree(this.getRStudioConnectUrl()));
                }
                if (this.getRStudioPackageManagerUrl() != null) {
                    data.set("rStudioPackageManagerUrl", om.valueToTree(this.getRStudioPackageManagerUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RStudioServerProDomainSettingsProperty.Jsii$Proxy that = (RStudioServerProDomainSettingsProperty.Jsii$Proxy) o;

                if (!domainExecutionRoleArn.equals(that.domainExecutionRoleArn)) return false;
                if (this.defaultResourceSpec != null ? !this.defaultResourceSpec.equals(that.defaultResourceSpec) : that.defaultResourceSpec != null) return false;
                if (this.rStudioConnectUrl != null ? !this.rStudioConnectUrl.equals(that.rStudioConnectUrl) : that.rStudioConnectUrl != null) return false;
                return this.rStudioPackageManagerUrl != null ? this.rStudioPackageManagerUrl.equals(that.rStudioPackageManagerUrl) : that.rStudioPackageManagerUrl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.domainExecutionRoleArn.hashCode();
                result = 31 * result + (this.defaultResourceSpec != null ? this.defaultResourceSpec.hashCode() : 0);
                result = 31 * result + (this.rStudioConnectUrl != null ? this.rStudioConnectUrl.hashCode() : 0);
                result = 31 * result + (this.rStudioPackageManagerUrl != null ? this.rStudioPackageManagerUrl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ResourceSpecProperty resourceSpecProperty = ResourceSpecProperty.builder()
     *         .instanceType("instanceType")
     *         .lifecycleConfigArn("lifecycleConfigArn")
     *         .sageMakerImageArn("sageMakerImageArn")
     *         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.ResourceSpecProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceSpecProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceSpecProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The instance type that the image version runs on.
         * <p>
         * <blockquote>
         * <p>
         * <em>JupyterServer apps</em> only support the <code>system</code> value.
         * <p>
         * For <em>KernelGateway apps</em> , the <code>system</code> value is translated to <code>ml.t3.medium</code> . KernelGateway apps also support all other values for available instance types.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-lifecycleconfigarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-lifecycleconfigarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLifecycleConfigArn() {
            return null;
        }

        /**
         * The ARN of the SageMaker image that the image version belongs to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-sagemakerimagearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-sagemakerimagearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSageMakerImageArn() {
            return null;
        }

        /**
         * The ARN of the image version created on the instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-sagemakerimageversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-sagemakerimageversionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSageMakerImageVersionArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceSpecProperty> {
            java.lang.String instanceType;
            java.lang.String lifecycleConfigArn;
            java.lang.String sageMakerImageArn;
            java.lang.String sageMakerImageVersionArn;

            /**
             * Sets the value of {@link ResourceSpecProperty#getInstanceType}
             * @param instanceType The instance type that the image version runs on.
             *                     <blockquote>
             *                     <p>
             *                     <em>JupyterServer apps</em> only support the <code>system</code> value.
             *                     <p>
             *                     For <em>KernelGateway apps</em> , the <code>system</code> value is translated to <code>ml.t3.medium</code> . KernelGateway apps also support all other values for available instance types.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ResourceSpecProperty#getLifecycleConfigArn}
             * @param lifecycleConfigArn The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lifecycleConfigArn(java.lang.String lifecycleConfigArn) {
                this.lifecycleConfigArn = lifecycleConfigArn;
                return this;
            }

            /**
             * Sets the value of {@link ResourceSpecProperty#getSageMakerImageArn}
             * @param sageMakerImageArn The ARN of the SageMaker image that the image version belongs to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerImageArn(java.lang.String sageMakerImageArn) {
                this.sageMakerImageArn = sageMakerImageArn;
                return this;
            }

            /**
             * Sets the value of {@link ResourceSpecProperty#getSageMakerImageVersionArn}
             * @param sageMakerImageVersionArn The ARN of the image version created on the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerImageVersionArn(java.lang.String sageMakerImageVersionArn) {
                this.sageMakerImageVersionArn = sageMakerImageVersionArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceSpecProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceSpecProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceSpecProperty {
            private final java.lang.String instanceType;
            private final java.lang.String lifecycleConfigArn;
            private final java.lang.String sageMakerImageArn;
            private final java.lang.String sageMakerImageVersionArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lifecycleConfigArn = software.amazon.jsii.Kernel.get(this, "lifecycleConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sageMakerImageArn = software.amazon.jsii.Kernel.get(this, "sageMakerImageArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sageMakerImageVersionArn = software.amazon.jsii.Kernel.get(this, "sageMakerImageVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceType = builder.instanceType;
                this.lifecycleConfigArn = builder.lifecycleConfigArn;
                this.sageMakerImageArn = builder.sageMakerImageArn;
                this.sageMakerImageVersionArn = builder.sageMakerImageVersionArn;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getLifecycleConfigArn() {
                return this.lifecycleConfigArn;
            }

            @Override
            public final java.lang.String getSageMakerImageArn() {
                return this.sageMakerImageArn;
            }

            @Override
            public final java.lang.String getSageMakerImageVersionArn() {
                return this.sageMakerImageVersionArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getLifecycleConfigArn() != null) {
                    data.set("lifecycleConfigArn", om.valueToTree(this.getLifecycleConfigArn()));
                }
                if (this.getSageMakerImageArn() != null) {
                    data.set("sageMakerImageArn", om.valueToTree(this.getSageMakerImageArn()));
                }
                if (this.getSageMakerImageVersionArn() != null) {
                    data.set("sageMakerImageVersionArn", om.valueToTree(this.getSageMakerImageVersionArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.ResourceSpecProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceSpecProperty.Jsii$Proxy that = (ResourceSpecProperty.Jsii$Proxy) o;

                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.lifecycleConfigArn != null ? !this.lifecycleConfigArn.equals(that.lifecycleConfigArn) : that.lifecycleConfigArn != null) return false;
                if (this.sageMakerImageArn != null ? !this.sageMakerImageArn.equals(that.sageMakerImageArn) : that.sageMakerImageArn != null) return false;
                return this.sageMakerImageVersionArn != null ? this.sageMakerImageVersionArn.equals(that.sageMakerImageVersionArn) : that.sageMakerImageVersionArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceType != null ? this.instanceType.hashCode() : 0;
                result = 31 * result + (this.lifecycleConfigArn != null ? this.lifecycleConfigArn.hashCode() : 0);
                result = 31 * result + (this.sageMakerImageArn != null ? this.sageMakerImageArn.hashCode() : 0);
                result = 31 * result + (this.sageMakerImageVersionArn != null ? this.sageMakerImageVersionArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies options when sharing an Amazon SageMaker Studio notebook.
     * <p>
     * These settings are specified as part of <code>DefaultUserSettings</code> when the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html">CreateDomain</a> API is called, and as part of <code>UserSettings</code> when the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html">CreateUserProfile</a> API is called.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * SharingSettingsProperty sharingSettingsProperty = SharingSettingsProperty.builder()
     *         .notebookOutputOption("notebookOutputOption")
     *         .s3KmsKeyId("s3KmsKeyId")
     *         .s3OutputPath("s3OutputPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.SharingSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SharingSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SharingSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to include the notebook cell output when sharing the notebook.
         * <p>
         * The default is <code>Disabled</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-notebookoutputoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-notebookoutputoption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNotebookOutputOption() {
            return null;
        }

        /**
         * When <code>NotebookOutputOption</code> is <code>Allowed</code> , the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-s3kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-s3kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3KmsKeyId() {
            return null;
        }

        /**
         * When <code>NotebookOutputOption</code> is <code>Allowed</code> , the Amazon S3 bucket used to store the shared notebook snapshots.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-s3outputpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-s3outputpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3OutputPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SharingSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SharingSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SharingSettingsProperty> {
            java.lang.String notebookOutputOption;
            java.lang.String s3KmsKeyId;
            java.lang.String s3OutputPath;

            /**
             * Sets the value of {@link SharingSettingsProperty#getNotebookOutputOption}
             * @param notebookOutputOption Whether to include the notebook cell output when sharing the notebook.
             *                             The default is <code>Disabled</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notebookOutputOption(java.lang.String notebookOutputOption) {
                this.notebookOutputOption = notebookOutputOption;
                return this;
            }

            /**
             * Sets the value of {@link SharingSettingsProperty#getS3KmsKeyId}
             * @param s3KmsKeyId When <code>NotebookOutputOption</code> is <code>Allowed</code> , the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3KmsKeyId(java.lang.String s3KmsKeyId) {
                this.s3KmsKeyId = s3KmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link SharingSettingsProperty#getS3OutputPath}
             * @param s3OutputPath When <code>NotebookOutputOption</code> is <code>Allowed</code> , the Amazon S3 bucket used to store the shared notebook snapshots.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OutputPath(java.lang.String s3OutputPath) {
                this.s3OutputPath = s3OutputPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SharingSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SharingSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SharingSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SharingSettingsProperty {
            private final java.lang.String notebookOutputOption;
            private final java.lang.String s3KmsKeyId;
            private final java.lang.String s3OutputPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.notebookOutputOption = software.amazon.jsii.Kernel.get(this, "notebookOutputOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3KmsKeyId = software.amazon.jsii.Kernel.get(this, "s3KmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3OutputPath = software.amazon.jsii.Kernel.get(this, "s3OutputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.notebookOutputOption = builder.notebookOutputOption;
                this.s3KmsKeyId = builder.s3KmsKeyId;
                this.s3OutputPath = builder.s3OutputPath;
            }

            @Override
            public final java.lang.String getNotebookOutputOption() {
                return this.notebookOutputOption;
            }

            @Override
            public final java.lang.String getS3KmsKeyId() {
                return this.s3KmsKeyId;
            }

            @Override
            public final java.lang.String getS3OutputPath() {
                return this.s3OutputPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNotebookOutputOption() != null) {
                    data.set("notebookOutputOption", om.valueToTree(this.getNotebookOutputOption()));
                }
                if (this.getS3KmsKeyId() != null) {
                    data.set("s3KmsKeyId", om.valueToTree(this.getS3KmsKeyId()));
                }
                if (this.getS3OutputPath() != null) {
                    data.set("s3OutputPath", om.valueToTree(this.getS3OutputPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.SharingSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SharingSettingsProperty.Jsii$Proxy that = (SharingSettingsProperty.Jsii$Proxy) o;

                if (this.notebookOutputOption != null ? !this.notebookOutputOption.equals(that.notebookOutputOption) : that.notebookOutputOption != null) return false;
                if (this.s3KmsKeyId != null ? !this.s3KmsKeyId.equals(that.s3KmsKeyId) : that.s3KmsKeyId != null) return false;
                return this.s3OutputPath != null ? this.s3OutputPath.equals(that.s3OutputPath) : that.s3OutputPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.notebookOutputOption != null ? this.notebookOutputOption.hashCode() : 0;
                result = 31 * result + (this.s3KmsKeyId != null ? this.s3KmsKeyId.hashCode() : 0);
                result = 31 * result + (this.s3OutputPath != null ? this.s3OutputPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A collection of settings that apply to users of Amazon SageMaker Studio.
     * <p>
     * These settings are specified when the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html">CreateUserProfile</a> API is called, and as <code>DefaultUserSettings</code> when the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html">CreateDomain</a> API is called.
     * <p>
     * <code>SecurityGroups</code> is aggregated when specified in both calls. For all other settings in <code>UserSettings</code> , the values specified in <code>CreateUserProfile</code> take precedence over those specified in <code>CreateDomain</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * UserSettingsProperty userSettingsProperty = UserSettingsProperty.builder()
     *         .executionRole("executionRole")
     *         // the properties below are optional
     *         .codeEditorAppSettings(CodeEditorAppSettingsProperty.builder()
     *                 .customImages(List.of(CustomImageProperty.builder()
     *                         .appImageConfigName("appImageConfigName")
     *                         .imageName("imageName")
     *                         // the properties below are optional
     *                         .imageVersionNumber(123)
     *                         .build()))
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .lifecycleConfigArn("lifecycleConfigArn")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .lifecycleConfigArns(List.of("lifecycleConfigArns"))
     *                 .build())
     *         .customFileSystemConfigs(List.of(CustomFileSystemConfigProperty.builder()
     *                 .efsFileSystemConfig(EFSFileSystemConfigProperty.builder()
     *                         .fileSystemId("fileSystemId")
     *                         // the properties below are optional
     *                         .fileSystemPath("fileSystemPath")
     *                         .build())
     *                 .build()))
     *         .customPosixUserConfig(CustomPosixUserConfigProperty.builder()
     *                 .gid(123)
     *                 .uid(123)
     *                 .build())
     *         .defaultLandingUri("defaultLandingUri")
     *         .jupyterLabAppSettings(JupyterLabAppSettingsProperty.builder()
     *                 .codeRepositories(List.of(CodeRepositoryProperty.builder()
     *                         .repositoryUrl("repositoryUrl")
     *                         .build()))
     *                 .customImages(List.of(CustomImageProperty.builder()
     *                         .appImageConfigName("appImageConfigName")
     *                         .imageName("imageName")
     *                         // the properties below are optional
     *                         .imageVersionNumber(123)
     *                         .build()))
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .lifecycleConfigArn("lifecycleConfigArn")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .lifecycleConfigArns(List.of("lifecycleConfigArns"))
     *                 .build())
     *         .jupyterServerAppSettings(JupyterServerAppSettingsProperty.builder()
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .lifecycleConfigArn("lifecycleConfigArn")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .build())
     *         .kernelGatewayAppSettings(KernelGatewayAppSettingsProperty.builder()
     *                 .customImages(List.of(CustomImageProperty.builder()
     *                         .appImageConfigName("appImageConfigName")
     *                         .imageName("imageName")
     *                         // the properties below are optional
     *                         .imageVersionNumber(123)
     *                         .build()))
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .lifecycleConfigArn("lifecycleConfigArn")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .build())
     *         .rSessionAppSettings(RSessionAppSettingsProperty.builder()
     *                 .customImages(List.of(CustomImageProperty.builder()
     *                         .appImageConfigName("appImageConfigName")
     *                         .imageName("imageName")
     *                         // the properties below are optional
     *                         .imageVersionNumber(123)
     *                         .build()))
     *                 .defaultResourceSpec(ResourceSpecProperty.builder()
     *                         .instanceType("instanceType")
     *                         .lifecycleConfigArn("lifecycleConfigArn")
     *                         .sageMakerImageArn("sageMakerImageArn")
     *                         .sageMakerImageVersionArn("sageMakerImageVersionArn")
     *                         .build())
     *                 .build())
     *         .rStudioServerProAppSettings(RStudioServerProAppSettingsProperty.builder()
     *                 .accessStatus("accessStatus")
     *                 .userGroup("userGroup")
     *                 .build())
     *         .securityGroups(List.of("securityGroups"))
     *         .sharingSettings(SharingSettingsProperty.builder()
     *                 .notebookOutputOption("notebookOutputOption")
     *                 .s3KmsKeyId("s3KmsKeyId")
     *                 .s3OutputPath("s3OutputPath")
     *                 .build())
     *         .spaceStorageSettings(DefaultSpaceStorageSettingsProperty.builder()
     *                 .defaultEbsStorageSettings(DefaultEbsStorageSettingsProperty.builder()
     *                         .defaultEbsVolumeSizeInGb(123)
     *                         .maximumEbsVolumeSizeInGb(123)
     *                         .build())
     *                 .build())
     *         .studioWebPortal("studioWebPortal")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnDomain.UserSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(UserSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The execution role for the user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-executionrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExecutionRole();

        /**
         * The Code Editor application settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-codeeditorappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-codeeditorappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeEditorAppSettings() {
            return null;
        }

        /**
         * The settings for assigning a custom file system to a user profile.
         * <p>
         * Permitted users can access this file system in Amazon SageMaker Studio.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-customfilesystemconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-customfilesystemconfigs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomFileSystemConfigs() {
            return null;
        }

        /**
         * Details about the POSIX identity that is used for file system operations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-customposixuserconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-customposixuserconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomPosixUserConfig() {
            return null;
        }

        /**
         * The default experience that the user is directed to when accessing the domain. The supported values are:.
         * <p>
         * <ul>
         * <li><code>studio::</code> : Indicates that Studio is the default experience. This value can only be passed if <code>StudioWebPortal</code> is set to <code>ENABLED</code> .</li>
         * <li><code>app:JupyterServer:</code> : Indicates that Studio Classic is the default experience.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-defaultlandinguri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-defaultlandinguri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultLandingUri() {
            return null;
        }

        /**
         * The settings for the JupyterLab application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-jupyterlabappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-jupyterlabappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJupyterLabAppSettings() {
            return null;
        }

        /**
         * The Jupyter server's app settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-jupyterserverappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-jupyterserverappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJupyterServerAppSettings() {
            return null;
        }

        /**
         * The kernel gateway app settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-kernelgatewayappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-kernelgatewayappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKernelGatewayAppSettings() {
            return null;
        }

        /**
         * A collection of settings that configure the <code>RSessionGateway</code> app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-rsessionappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-rsessionappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRSessionAppSettings() {
            return null;
        }

        /**
         * A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-rstudioserverproappsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-rstudioserverproappsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRStudioServerProAppSettings() {
            return null;
        }

        /**
         * The security groups for the Amazon Virtual Private Cloud (VPC) that the domain uses for communication.
         * <p>
         * Optional when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to <code>PublicInternetOnly</code> .
         * <p>
         * Required when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to <code>VpcOnly</code> , unless specified as part of the <code>DefaultUserSettings</code> for the domain.
         * <p>
         * Amazon SageMaker adds a security group to allow NFS traffic from Amazon SageMaker Studio. Therefore, the number of security groups that you can specify is one less than the maximum number shown.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-securitygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-securitygroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
            return null;
        }

        /**
         * Specifies options for sharing Amazon SageMaker Studio notebooks.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-sharingsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-sharingsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSharingSettings() {
            return null;
        }

        /**
         * The storage settings for a space.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-spacestoragesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-spacestoragesettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSpaceStorageSettings() {
            return null;
        }

        /**
         * Whether the user can access Studio.
         * <p>
         * If this value is set to <code>DISABLED</code> , the user cannot access Studio, even if that is the default experience for the domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-studiowebportal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-studiowebportal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStudioWebPortal() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UserSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserSettingsProperty> {
            java.lang.String executionRole;
            java.lang.Object codeEditorAppSettings;
            java.lang.Object customFileSystemConfigs;
            java.lang.Object customPosixUserConfig;
            java.lang.String defaultLandingUri;
            java.lang.Object jupyterLabAppSettings;
            java.lang.Object jupyterServerAppSettings;
            java.lang.Object kernelGatewayAppSettings;
            java.lang.Object rSessionAppSettings;
            java.lang.Object rStudioServerProAppSettings;
            java.util.List<java.lang.String> securityGroups;
            java.lang.Object sharingSettings;
            java.lang.Object spaceStorageSettings;
            java.lang.String studioWebPortal;

            /**
             * Sets the value of {@link UserSettingsProperty#getExecutionRole}
             * @param executionRole The execution role for the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRole(java.lang.String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getCodeEditorAppSettings}
             * @param codeEditorAppSettings The Code Editor application settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeEditorAppSettings(software.amazon.awscdk.IResolvable codeEditorAppSettings) {
                this.codeEditorAppSettings = codeEditorAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getCodeEditorAppSettings}
             * @param codeEditorAppSettings The Code Editor application settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeEditorAppSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.CodeEditorAppSettingsProperty codeEditorAppSettings) {
                this.codeEditorAppSettings = codeEditorAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getCustomFileSystemConfigs}
             * @param customFileSystemConfigs The settings for assigning a custom file system to a user profile.
             *                                Permitted users can access this file system in Amazon SageMaker Studio.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customFileSystemConfigs(software.amazon.awscdk.IResolvable customFileSystemConfigs) {
                this.customFileSystemConfigs = customFileSystemConfigs;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getCustomFileSystemConfigs}
             * @param customFileSystemConfigs The settings for assigning a custom file system to a user profile.
             *                                Permitted users can access this file system in Amazon SageMaker Studio.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customFileSystemConfigs(java.util.List<? extends java.lang.Object> customFileSystemConfigs) {
                this.customFileSystemConfigs = customFileSystemConfigs;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getCustomPosixUserConfig}
             * @param customPosixUserConfig Details about the POSIX identity that is used for file system operations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPosixUserConfig(software.amazon.awscdk.IResolvable customPosixUserConfig) {
                this.customPosixUserConfig = customPosixUserConfig;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getCustomPosixUserConfig}
             * @param customPosixUserConfig Details about the POSIX identity that is used for file system operations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPosixUserConfig(software.amazon.awscdk.services.sagemaker.CfnDomain.CustomPosixUserConfigProperty customPosixUserConfig) {
                this.customPosixUserConfig = customPosixUserConfig;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getDefaultLandingUri}
             * @param defaultLandingUri The default experience that the user is directed to when accessing the domain. The supported values are:.
             *                          <ul>
             *                          <li><code>studio::</code> : Indicates that Studio is the default experience. This value can only be passed if <code>StudioWebPortal</code> is set to <code>ENABLED</code> .</li>
             *                          <li><code>app:JupyterServer:</code> : Indicates that Studio Classic is the default experience.</li>
             *                          </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultLandingUri(java.lang.String defaultLandingUri) {
                this.defaultLandingUri = defaultLandingUri;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getJupyterLabAppSettings}
             * @param jupyterLabAppSettings The settings for the JupyterLab application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterLabAppSettings(software.amazon.awscdk.IResolvable jupyterLabAppSettings) {
                this.jupyterLabAppSettings = jupyterLabAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getJupyterLabAppSettings}
             * @param jupyterLabAppSettings The settings for the JupyterLab application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterLabAppSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.JupyterLabAppSettingsProperty jupyterLabAppSettings) {
                this.jupyterLabAppSettings = jupyterLabAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getJupyterServerAppSettings}
             * @param jupyterServerAppSettings The Jupyter server's app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterServerAppSettings(software.amazon.awscdk.IResolvable jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getJupyterServerAppSettings}
             * @param jupyterServerAppSettings The Jupyter server's app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jupyterServerAppSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.JupyterServerAppSettingsProperty jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getKernelGatewayAppSettings}
             * @param kernelGatewayAppSettings The kernel gateway app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kernelGatewayAppSettings(software.amazon.awscdk.IResolvable kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getKernelGatewayAppSettings}
             * @param kernelGatewayAppSettings The kernel gateway app settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kernelGatewayAppSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.KernelGatewayAppSettingsProperty kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getRSessionAppSettings}
             * @param rSessionAppSettings A collection of settings that configure the <code>RSessionGateway</code> app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rSessionAppSettings(software.amazon.awscdk.IResolvable rSessionAppSettings) {
                this.rSessionAppSettings = rSessionAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getRSessionAppSettings}
             * @param rSessionAppSettings A collection of settings that configure the <code>RSessionGateway</code> app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rSessionAppSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.RSessionAppSettingsProperty rSessionAppSettings) {
                this.rSessionAppSettings = rSessionAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getRStudioServerProAppSettings}
             * @param rStudioServerProAppSettings A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rStudioServerProAppSettings(software.amazon.awscdk.IResolvable rStudioServerProAppSettings) {
                this.rStudioServerProAppSettings = rStudioServerProAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getRStudioServerProAppSettings}
             * @param rStudioServerProAppSettings A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rStudioServerProAppSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.RStudioServerProAppSettingsProperty rStudioServerProAppSettings) {
                this.rStudioServerProAppSettings = rStudioServerProAppSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getSecurityGroups}
             * @param securityGroups The security groups for the Amazon Virtual Private Cloud (VPC) that the domain uses for communication.
             *                       Optional when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to <code>PublicInternetOnly</code> .
             *                       <p>
             *                       Required when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to <code>VpcOnly</code> , unless specified as part of the <code>DefaultUserSettings</code> for the domain.
             *                       <p>
             *                       Amazon SageMaker adds a security group to allow NFS traffic from Amazon SageMaker Studio. Therefore, the number of security groups that you can specify is one less than the maximum number shown.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getSharingSettings}
             * @param sharingSettings Specifies options for sharing Amazon SageMaker Studio notebooks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sharingSettings(software.amazon.awscdk.IResolvable sharingSettings) {
                this.sharingSettings = sharingSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getSharingSettings}
             * @param sharingSettings Specifies options for sharing Amazon SageMaker Studio notebooks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sharingSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.SharingSettingsProperty sharingSettings) {
                this.sharingSettings = sharingSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getSpaceStorageSettings}
             * @param spaceStorageSettings The storage settings for a space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spaceStorageSettings(software.amazon.awscdk.IResolvable spaceStorageSettings) {
                this.spaceStorageSettings = spaceStorageSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getSpaceStorageSettings}
             * @param spaceStorageSettings The storage settings for a space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spaceStorageSettings(software.amazon.awscdk.services.sagemaker.CfnDomain.DefaultSpaceStorageSettingsProperty spaceStorageSettings) {
                this.spaceStorageSettings = spaceStorageSettings;
                return this;
            }

            /**
             * Sets the value of {@link UserSettingsProperty#getStudioWebPortal}
             * @param studioWebPortal Whether the user can access Studio.
             *                        If this value is set to <code>DISABLED</code> , the user cannot access Studio, even if that is the default experience for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder studioWebPortal(java.lang.String studioWebPortal) {
                this.studioWebPortal = studioWebPortal;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserSettingsProperty {
            private final java.lang.String executionRole;
            private final java.lang.Object codeEditorAppSettings;
            private final java.lang.Object customFileSystemConfigs;
            private final java.lang.Object customPosixUserConfig;
            private final java.lang.String defaultLandingUri;
            private final java.lang.Object jupyterLabAppSettings;
            private final java.lang.Object jupyterServerAppSettings;
            private final java.lang.Object kernelGatewayAppSettings;
            private final java.lang.Object rSessionAppSettings;
            private final java.lang.Object rStudioServerProAppSettings;
            private final java.util.List<java.lang.String> securityGroups;
            private final java.lang.Object sharingSettings;
            private final java.lang.Object spaceStorageSettings;
            private final java.lang.String studioWebPortal;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.codeEditorAppSettings = software.amazon.jsii.Kernel.get(this, "codeEditorAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customFileSystemConfigs = software.amazon.jsii.Kernel.get(this, "customFileSystemConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customPosixUserConfig = software.amazon.jsii.Kernel.get(this, "customPosixUserConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultLandingUri = software.amazon.jsii.Kernel.get(this, "defaultLandingUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.jupyterLabAppSettings = software.amazon.jsii.Kernel.get(this, "jupyterLabAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jupyterServerAppSettings = software.amazon.jsii.Kernel.get(this, "jupyterServerAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kernelGatewayAppSettings = software.amazon.jsii.Kernel.get(this, "kernelGatewayAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rSessionAppSettings = software.amazon.jsii.Kernel.get(this, "rSessionAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rStudioServerProAppSettings = software.amazon.jsii.Kernel.get(this, "rStudioServerProAppSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sharingSettings = software.amazon.jsii.Kernel.get(this, "sharingSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spaceStorageSettings = software.amazon.jsii.Kernel.get(this, "spaceStorageSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.studioWebPortal = software.amazon.jsii.Kernel.get(this, "studioWebPortal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.executionRole = java.util.Objects.requireNonNull(builder.executionRole, "executionRole is required");
                this.codeEditorAppSettings = builder.codeEditorAppSettings;
                this.customFileSystemConfigs = builder.customFileSystemConfigs;
                this.customPosixUserConfig = builder.customPosixUserConfig;
                this.defaultLandingUri = builder.defaultLandingUri;
                this.jupyterLabAppSettings = builder.jupyterLabAppSettings;
                this.jupyterServerAppSettings = builder.jupyterServerAppSettings;
                this.kernelGatewayAppSettings = builder.kernelGatewayAppSettings;
                this.rSessionAppSettings = builder.rSessionAppSettings;
                this.rStudioServerProAppSettings = builder.rStudioServerProAppSettings;
                this.securityGroups = builder.securityGroups;
                this.sharingSettings = builder.sharingSettings;
                this.spaceStorageSettings = builder.spaceStorageSettings;
                this.studioWebPortal = builder.studioWebPortal;
            }

            @Override
            public final java.lang.String getExecutionRole() {
                return this.executionRole;
            }

            @Override
            public final java.lang.Object getCodeEditorAppSettings() {
                return this.codeEditorAppSettings;
            }

            @Override
            public final java.lang.Object getCustomFileSystemConfigs() {
                return this.customFileSystemConfigs;
            }

            @Override
            public final java.lang.Object getCustomPosixUserConfig() {
                return this.customPosixUserConfig;
            }

            @Override
            public final java.lang.String getDefaultLandingUri() {
                return this.defaultLandingUri;
            }

            @Override
            public final java.lang.Object getJupyterLabAppSettings() {
                return this.jupyterLabAppSettings;
            }

            @Override
            public final java.lang.Object getJupyterServerAppSettings() {
                return this.jupyterServerAppSettings;
            }

            @Override
            public final java.lang.Object getKernelGatewayAppSettings() {
                return this.kernelGatewayAppSettings;
            }

            @Override
            public final java.lang.Object getRSessionAppSettings() {
                return this.rSessionAppSettings;
            }

            @Override
            public final java.lang.Object getRStudioServerProAppSettings() {
                return this.rStudioServerProAppSettings;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            public final java.lang.Object getSharingSettings() {
                return this.sharingSettings;
            }

            @Override
            public final java.lang.Object getSpaceStorageSettings() {
                return this.spaceStorageSettings;
            }

            @Override
            public final java.lang.String getStudioWebPortal() {
                return this.studioWebPortal;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
                if (this.getCodeEditorAppSettings() != null) {
                    data.set("codeEditorAppSettings", om.valueToTree(this.getCodeEditorAppSettings()));
                }
                if (this.getCustomFileSystemConfigs() != null) {
                    data.set("customFileSystemConfigs", om.valueToTree(this.getCustomFileSystemConfigs()));
                }
                if (this.getCustomPosixUserConfig() != null) {
                    data.set("customPosixUserConfig", om.valueToTree(this.getCustomPosixUserConfig()));
                }
                if (this.getDefaultLandingUri() != null) {
                    data.set("defaultLandingUri", om.valueToTree(this.getDefaultLandingUri()));
                }
                if (this.getJupyterLabAppSettings() != null) {
                    data.set("jupyterLabAppSettings", om.valueToTree(this.getJupyterLabAppSettings()));
                }
                if (this.getJupyterServerAppSettings() != null) {
                    data.set("jupyterServerAppSettings", om.valueToTree(this.getJupyterServerAppSettings()));
                }
                if (this.getKernelGatewayAppSettings() != null) {
                    data.set("kernelGatewayAppSettings", om.valueToTree(this.getKernelGatewayAppSettings()));
                }
                if (this.getRSessionAppSettings() != null) {
                    data.set("rSessionAppSettings", om.valueToTree(this.getRSessionAppSettings()));
                }
                if (this.getRStudioServerProAppSettings() != null) {
                    data.set("rStudioServerProAppSettings", om.valueToTree(this.getRStudioServerProAppSettings()));
                }
                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }
                if (this.getSharingSettings() != null) {
                    data.set("sharingSettings", om.valueToTree(this.getSharingSettings()));
                }
                if (this.getSpaceStorageSettings() != null) {
                    data.set("spaceStorageSettings", om.valueToTree(this.getSpaceStorageSettings()));
                }
                if (this.getStudioWebPortal() != null) {
                    data.set("studioWebPortal", om.valueToTree(this.getStudioWebPortal()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnDomain.UserSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserSettingsProperty.Jsii$Proxy that = (UserSettingsProperty.Jsii$Proxy) o;

                if (!executionRole.equals(that.executionRole)) return false;
                if (this.codeEditorAppSettings != null ? !this.codeEditorAppSettings.equals(that.codeEditorAppSettings) : that.codeEditorAppSettings != null) return false;
                if (this.customFileSystemConfigs != null ? !this.customFileSystemConfigs.equals(that.customFileSystemConfigs) : that.customFileSystemConfigs != null) return false;
                if (this.customPosixUserConfig != null ? !this.customPosixUserConfig.equals(that.customPosixUserConfig) : that.customPosixUserConfig != null) return false;
                if (this.defaultLandingUri != null ? !this.defaultLandingUri.equals(that.defaultLandingUri) : that.defaultLandingUri != null) return false;
                if (this.jupyterLabAppSettings != null ? !this.jupyterLabAppSettings.equals(that.jupyterLabAppSettings) : that.jupyterLabAppSettings != null) return false;
                if (this.jupyterServerAppSettings != null ? !this.jupyterServerAppSettings.equals(that.jupyterServerAppSettings) : that.jupyterServerAppSettings != null) return false;
                if (this.kernelGatewayAppSettings != null ? !this.kernelGatewayAppSettings.equals(that.kernelGatewayAppSettings) : that.kernelGatewayAppSettings != null) return false;
                if (this.rSessionAppSettings != null ? !this.rSessionAppSettings.equals(that.rSessionAppSettings) : that.rSessionAppSettings != null) return false;
                if (this.rStudioServerProAppSettings != null ? !this.rStudioServerProAppSettings.equals(that.rStudioServerProAppSettings) : that.rStudioServerProAppSettings != null) return false;
                if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
                if (this.sharingSettings != null ? !this.sharingSettings.equals(that.sharingSettings) : that.sharingSettings != null) return false;
                if (this.spaceStorageSettings != null ? !this.spaceStorageSettings.equals(that.spaceStorageSettings) : that.spaceStorageSettings != null) return false;
                return this.studioWebPortal != null ? this.studioWebPortal.equals(that.studioWebPortal) : that.studioWebPortal == null;
            }

            @Override
            public final int hashCode() {
                int result = this.executionRole.hashCode();
                result = 31 * result + (this.codeEditorAppSettings != null ? this.codeEditorAppSettings.hashCode() : 0);
                result = 31 * result + (this.customFileSystemConfigs != null ? this.customFileSystemConfigs.hashCode() : 0);
                result = 31 * result + (this.customPosixUserConfig != null ? this.customPosixUserConfig.hashCode() : 0);
                result = 31 * result + (this.defaultLandingUri != null ? this.defaultLandingUri.hashCode() : 0);
                result = 31 * result + (this.jupyterLabAppSettings != null ? this.jupyterLabAppSettings.hashCode() : 0);
                result = 31 * result + (this.jupyterServerAppSettings != null ? this.jupyterServerAppSettings.hashCode() : 0);
                result = 31 * result + (this.kernelGatewayAppSettings != null ? this.kernelGatewayAppSettings.hashCode() : 0);
                result = 31 * result + (this.rSessionAppSettings != null ? this.rSessionAppSettings.hashCode() : 0);
                result = 31 * result + (this.rStudioServerProAppSettings != null ? this.rStudioServerProAppSettings.hashCode() : 0);
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                result = 31 * result + (this.sharingSettings != null ? this.sharingSettings.hashCode() : 0);
                result = 31 * result + (this.spaceStorageSettings != null ? this.spaceStorageSettings.hashCode() : 0);
                result = 31 * result + (this.studioWebPortal != null ? this.studioWebPortal.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnDomain}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnDomain> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnDomainProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnDomainProps.Builder();
        }

        /**
         * The mode of authentication that members use to access the Domain.
         * <p>
         * <em>Valid Values</em> : <code>SSO | IAM</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-authmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-authmode</a>
         * @param authMode The mode of authentication that members use to access the Domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authMode(final java.lang.String authMode) {
            this.props.authMode(authMode);
            return this;
        }

        /**
         * The default user settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultusersettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultusersettings</a>
         * @param defaultUserSettings The default user settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultUserSettings(final software.amazon.awscdk.IResolvable defaultUserSettings) {
            this.props.defaultUserSettings(defaultUserSettings);
            return this;
        }
        /**
         * The default user settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultusersettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultusersettings</a>
         * @param defaultUserSettings The default user settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultUserSettings(final software.amazon.awscdk.services.sagemaker.CfnDomain.UserSettingsProperty defaultUserSettings) {
            this.props.defaultUserSettings(defaultUserSettings);
            return this;
        }

        /**
         * The domain name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainname</a>
         * @param domainName The domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * The VPC subnets that Studio uses for communication.
         * <p>
         * <em>Length Constraints</em> : Maximum length of 32.
         * <p>
         * <em>Array members</em> : Minimum number of 1 item. Maximum number of 16 items.
         * <p>
         * <em>Pattern</em> : <code>[-0-9a-zA-Z]+</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-subnetids</a>
         * @param subnetIds The VPC subnets that Studio uses for communication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(final java.util.List<java.lang.String> subnetIds) {
            this.props.subnetIds(subnetIds);
            return this;
        }

        /**
         * The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication.
         * <p>
         * <em>Length Constraints</em> : Maximum length of 32.
         * <p>
         * <em>Pattern</em> : <code>[-0-9a-zA-Z]+</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-vpcid</a>
         * @param vpcId The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(final java.lang.String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        /**
         * Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code> .
         * <p>
         * <ul>
         * <li><code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker , which allows direct internet access</li>
         * <li><code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets</li>
         * </ul>
         * <p>
         * <em>Valid Values</em> : <code>PublicInternetOnly | VpcOnly</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appnetworkaccesstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appnetworkaccesstype</a>
         * @param appNetworkAccessType Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appNetworkAccessType(final java.lang.String appNetworkAccessType) {
            this.props.appNetworkAccessType(appNetworkAccessType);
            return this;
        }

        /**
         * The entity that creates and manages the required security groups for inter-app communication in <code>VpcOnly</code> mode.
         * <p>
         * Required when <code>CreateDomain.AppNetworkAccessType</code> is <code>VpcOnly</code> and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided. If setting up the domain for use with RStudio, this value must be set to <code>Service</code> .
         * <p>
         * <em>Allowed Values</em> : <code>Service</code> | <code>Customer</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appsecuritygroupmanagement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appsecuritygroupmanagement</a>
         * @param appSecurityGroupManagement The entity that creates and manages the required security groups for inter-app communication in <code>VpcOnly</code> mode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appSecurityGroupManagement(final java.lang.String appSecurityGroupManagement) {
            this.props.appSecurityGroupManagement(appSecurityGroupManagement);
            return this;
        }

        /**
         * A collection of settings that apply to spaces created in the domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultspacesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultspacesettings</a>
         * @param defaultSpaceSettings A collection of settings that apply to spaces created in the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSpaceSettings(final software.amazon.awscdk.IResolvable defaultSpaceSettings) {
            this.props.defaultSpaceSettings(defaultSpaceSettings);
            return this;
        }
        /**
         * A collection of settings that apply to spaces created in the domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultspacesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultspacesettings</a>
         * @param defaultSpaceSettings A collection of settings that apply to spaces created in the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSpaceSettings(final software.amazon.awscdk.services.sagemaker.CfnDomain.DefaultSpaceSettingsProperty defaultSpaceSettings) {
            this.props.defaultSpaceSettings(defaultSpaceSettings);
            return this;
        }

        /**
         * A collection of settings that apply to the <code>SageMaker Domain</code> .
         * <p>
         * These settings are specified through the <code>CreateDomain</code> API call.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainsettings</a>
         * @param domainSettings A collection of settings that apply to the <code>SageMaker Domain</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainSettings(final software.amazon.awscdk.IResolvable domainSettings) {
            this.props.domainSettings(domainSettings);
            return this;
        }
        /**
         * A collection of settings that apply to the <code>SageMaker Domain</code> .
         * <p>
         * These settings are specified through the <code>CreateDomain</code> API call.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainsettings</a>
         * @param domainSettings A collection of settings that apply to the <code>SageMaker Domain</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainSettings(final software.amazon.awscdk.services.sagemaker.CfnDomain.DomainSettingsProperty domainSettings) {
            this.props.domainSettings(domainSettings);
            return this;
        }

        /**
         * SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default.
         * <p>
         * For more control, specify a customer managed CMK.
         * <p>
         * <em>Length Constraints</em> : Maximum length of 2048.
         * <p>
         * <em>Pattern</em> : <code>.*</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-kmskeyid</a>
         * @param kmsKeyId SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * Tags to associated with the Domain.
         * <p>
         * Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API.
         * <p>
         * Tags that you specify for the Domain are also added to all apps that are launched in the Domain.
         * <p>
         * <em>Array members</em> : Minimum number of 0 items. Maximum number of 50 items.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-tags</a>
         * @param tags Tags to associated with the Domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnDomain}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnDomain build() {
            return new software.amazon.awscdk.services.sagemaker.CfnDomain(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
