package software.amazon.awscdk.services.ses;

/**
 * A configuration set.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IDedicatedIpPool myPool;
 * ConfigurationSet.Builder.create(this, "ConfigurationSet")
 *         .customTrackingRedirectDomain("track.cdk.dev")
 *         .suppressionReasons(SuppressionReasons.COMPLAINTS_ONLY)
 *         .tlsPolicy(ConfigurationSetTlsPolicy.REQUIRE)
 *         .dedicatedIpPool(myPool)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:41.032Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.ConfigurationSet")
public class ConfigurationSet extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ses.IConfigurationSet {

    protected ConfigurationSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ConfigurationSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ConfigurationSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.ConfigurationSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ConfigurationSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Use an existing configuration set.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param configurationSetName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.IConfigurationSet fromConfigurationSetName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String configurationSetName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.ConfigurationSet.class, "fromConfigurationSetName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.IConfigurationSet.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(configurationSetName, "configurationSetName is required") });
    }

    /**
     * Adds an event destination to this configuration set.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.ConfigurationSetEventDestination addEventDestination(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.ConfigurationSetEventDestinationOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addEventDestination", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.ConfigurationSetEventDestination.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * The name of the configuration set.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConfigurationSetName() {
        return software.amazon.jsii.Kernel.get(this, "configurationSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.ConfigurationSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.ConfigurationSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ses.ConfigurationSetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A name for the configuration set.
         * <p>
         * Default: - a CloudFormation generated name
         * <p>
         * @return {@code this}
         * @param configurationSetName A name for the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSetName(final java.lang.String configurationSetName) {
            this.props().configurationSetName(configurationSetName);
            return this;
        }

        /**
         * The custom subdomain that is used to redirect email recipients to the Amazon SES event tracking domain.
         * <p>
         * Default: - use the default awstrack.me domain
         * <p>
         * @return {@code this}
         * @param customTrackingRedirectDomain The custom subdomain that is used to redirect email recipients to the Amazon SES event tracking domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customTrackingRedirectDomain(final java.lang.String customTrackingRedirectDomain) {
            this.props().customTrackingRedirectDomain(customTrackingRedirectDomain);
            return this;
        }

        /**
         * The dedicated IP pool to associate with the configuration set.
         * <p>
         * Default: - do not use a dedicated IP pool
         * <p>
         * @return {@code this}
         * @param dedicatedIpPool The dedicated IP pool to associate with the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dedicatedIpPool(final software.amazon.awscdk.services.ses.IDedicatedIpPool dedicatedIpPool) {
            this.props().dedicatedIpPool(dedicatedIpPool);
            return this;
        }

        /**
         * Whether to publish reputation metrics for the configuration set, such as bounce and complaint rates, to Amazon CloudWatch.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param reputationMetrics Whether to publish reputation metrics for the configuration set, such as bounce and complaint rates, to Amazon CloudWatch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reputationMetrics(final java.lang.Boolean reputationMetrics) {
            this.props().reputationMetrics(reputationMetrics);
            return this;
        }

        /**
         * Whether email sending is enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param sendingEnabled Whether email sending is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendingEnabled(final java.lang.Boolean sendingEnabled) {
            this.props().sendingEnabled(sendingEnabled);
            return this;
        }

        /**
         * The reasons for which recipient email addresses should be automatically added to your account's suppression list.
         * <p>
         * Default: - use account level settings
         * <p>
         * @return {@code this}
         * @param suppressionReasons The reasons for which recipient email addresses should be automatically added to your account's suppression list. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suppressionReasons(final software.amazon.awscdk.services.ses.SuppressionReasons suppressionReasons) {
            this.props().suppressionReasons(suppressionReasons);
            return this;
        }

        /**
         * Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).
         * <p>
         * Default: ConfigurationSetTlsPolicy.OPTIONAL
         * <p>
         * @return {@code this}
         * @param tlsPolicy Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsPolicy(final software.amazon.awscdk.services.ses.ConfigurationSetTlsPolicy tlsPolicy) {
            this.props().tlsPolicy(tlsPolicy);
            return this;
        }

        /**
         * The Virtual Deliverability Manager (VDM) options that apply to the configuration set.
         * <p>
         * Default: - VDM options not configured at the configuration set level. In this case, use account level settings. (To set the account level settings using CDK, use the `VdmAttributes` Construct.)
         * <p>
         * @return {@code this}
         * @param vdmOptions The Virtual Deliverability Manager (VDM) options that apply to the configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vdmOptions(final software.amazon.awscdk.services.ses.VdmOptions vdmOptions) {
            this.props().vdmOptions(vdmOptions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ses.ConfigurationSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.ConfigurationSet build() {
            return new software.amazon.awscdk.services.ses.ConfigurationSet(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ses.ConfigurationSetProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ses.ConfigurationSetProps.Builder();
            }
            return this.props;
        }
    }
}
