package software.amazon.awscdk.services.ses.actions;

/**
 * Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.ses.actions.*;
 * import software.amazon.awscdk.services.sns.*;
 * Function function_;
 * Topic topic;
 * Lambda lambda = Lambda.Builder.create()
 *         .function(function_)
 *         // the properties below are optional
 *         .invocationType(LambdaInvocationType.EVENT)
 *         .topic(topic)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:41.071Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses_actions.Lambda")
public class Lambda extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ses.IReceiptRuleAction {

    protected Lambda(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Lambda(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Lambda(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.actions.LambdaProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns the receipt rule action specification.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.ReceiptRuleActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.IReceiptRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.ReceiptRuleActionConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.actions.Lambda}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.actions.Lambda> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ses.actions.LambdaProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ses.actions.LambdaProps.Builder();
        }

        /**
         * The Lambda function to invoke.
         * <p>
         * @return {@code this}
         * @param function The Lambda function to invoke. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder function(final software.amazon.awscdk.services.lambda.IFunction function) {
            this.props.function(function);
            return this;
        }

        /**
         * The invocation type of the Lambda function.
         * <p>
         * Default: Event
         * <p>
         * @return {@code this}
         * @param invocationType The invocation type of the Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invocationType(final software.amazon.awscdk.services.ses.actions.LambdaInvocationType invocationType) {
            this.props.invocationType(invocationType);
            return this;
        }

        /**
         * The SNS topic to notify when the Lambda action is taken.
         * <p>
         * Default: no notification
         * <p>
         * @return {@code this}
         * @param topic The SNS topic to notify when the Lambda action is taken. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topic(final software.amazon.awscdk.services.sns.ITopic topic) {
            this.props.topic(topic);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ses.actions.Lambda}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.actions.Lambda build() {
            return new software.amazon.awscdk.services.ses.actions.Lambda(
                this.props.build()
            );
        }
    }
}
