package software.amazon.awscdk.services.sns;

/**
 * A new SNS topic.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesisfirehose.alpha.DeliveryStream;
 * DeliveryStream stream;
 * Topic topic = new Topic(this, "Topic");
 * Subscription.Builder.create(this, "Subscription")
 *         .topic(topic)
 *         .endpoint(stream.getDeliveryStreamArn())
 *         .protocol(SubscriptionProtocol.FIREHOSE)
 *         .subscriptionRoleArn("SAMPLE_ARN")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:41.145Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.Topic")
public class Topic extends software.amazon.awscdk.services.sns.TopicBase {

    protected Topic(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Topic(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Topic(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.TopicProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Topic(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing SNS topic provided an ARN.
     * <p>
     * @param scope The parent creating construct. This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param topicArn topic ARN (i.e. arn:aws:sns:us-east-2:444455556666:MyTopic). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic fromTopicArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String topicArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.sns.Topic.class, "fromTopicArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(topicArn, "topicArn is required") });
    }

    /**
     * Import an existing SNS topic provided a topic attributes.
     * <p>
     * @param scope The parent creating construct. This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param attrs the attributes of the topic to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic fromTopicAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.TopicAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.sns.Topic.class, "fromTopicAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Adds a delivery status logging configuration to the topic.
     * <p>
     * @param config This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLoggingConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.LoggingConfig config) {
        software.amazon.jsii.Kernel.call(this, "addLoggingConfig", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(config, "config is required") });
    }

    /**
     * Controls automatic creation of policy objects.
     * <p>
     * Set by subclasses.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getAutoCreatePolicy() {
        return software.amazon.jsii.Kernel.get(this, "autoCreatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Enables content-based deduplication for FIFO topics.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getContentBasedDeduplication() {
        return software.amazon.jsii.Kernel.get(this, "contentBasedDeduplication", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Whether this topic is an Amazon SNS FIFO queue.
     * <p>
     * If false, this is a standard topic.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getFifo() {
        return software.amazon.jsii.Kernel.get(this, "fifo", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The ARN of the topic.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTopicArn() {
        return software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the topic.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTopicName() {
        return software.amazon.jsii.Kernel.get(this, "topicName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sns.Topic}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sns.Topic> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.sns.TopicProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Enables content-based deduplication for FIFO topics.
         * <p>
         * Default: None
         * <p>
         * @return {@code this}
         * @param contentBasedDeduplication Enables content-based deduplication for FIFO topics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(final java.lang.Boolean contentBasedDeduplication) {
            this.props().contentBasedDeduplication(contentBasedDeduplication);
            return this;
        }

        /**
         * A developer-defined string that can be used to identify this SNS topic.
         * <p>
         * The display name must be maximum 100 characters long, including hyphens (-),
         * underscores (_), spaces, and tabs.
         * <p>
         * Default: None
         * <p>
         * @return {@code this}
         * @param displayName A developer-defined string that can be used to identify this SNS topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props().displayName(displayName);
            return this;
        }

        /**
         * Adds a statement to enforce encryption of data in transit when publishing to the topic.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-security-best-practices.html#enforce-encryption-data-in-transit.">https://docs.aws.amazon.com/sns/latest/dg/sns-security-best-practices.html#enforce-encryption-data-in-transit.</a>
         * @param enforceSsl Adds a statement to enforce encryption of data in transit when publishing to the topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enforceSsl(final java.lang.Boolean enforceSsl) {
            this.props().enforceSsl(enforceSsl);
            return this;
        }

        /**
         * Set to true to create a FIFO topic.
         * <p>
         * Default: None
         * <p>
         * @return {@code this}
         * @param fifo Set to true to create a FIFO topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifo(final java.lang.Boolean fifo) {
            this.props().fifo(fifo);
            return this;
        }

        /**
         * The list of delivery status logging configurations for the topic.
         * <p>
         * Default: None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-topic-attributes.html.">https://docs.aws.amazon.com/sns/latest/dg/sns-topic-attributes.html.</a>
         * @param loggingConfigs The list of delivery status logging configurations for the topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfigs(final java.util.List<? extends software.amazon.awscdk.services.sns.LoggingConfig> loggingConfigs) {
            this.props().loggingConfigs(loggingConfigs);
            return this;
        }

        /**
         * A KMS Key, either managed by this CDK app, or imported.
         * <p>
         * Default: None
         * <p>
         * @return {@code this}
         * @param masterKey A KMS Key, either managed by this CDK app, or imported. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterKey(final software.amazon.awscdk.services.kms.IKey masterKey) {
            this.props().masterKey(masterKey);
            return this;
        }

        /**
         * The number of days Amazon SNS retains messages.
         * <p>
         * It can only be set for FIFO topics.
         * <p>
         * Default: - do not archive messages
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/fifo-message-archiving-replay.html">https://docs.aws.amazon.com/sns/latest/dg/fifo-message-archiving-replay.html</a>
         * @param messageRetentionPeriodInDays The number of days Amazon SNS retains messages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageRetentionPeriodInDays(final java.lang.Number messageRetentionPeriodInDays) {
            this.props().messageRetentionPeriodInDays(messageRetentionPeriodInDays);
            return this;
        }

        /**
         * The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-verify-signature-of-message.html.">https://docs.aws.amazon.com/sns/latest/dg/sns-verify-signature-of-message.html.</a>
         * @param signatureVersion The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signatureVersion(final java.lang.String signatureVersion) {
            this.props().signatureVersion(signatureVersion);
            return this;
        }

        /**
         * A name for the topic.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique
         * physical ID and uses that ID for the topic name. For more information,
         * see Name Type.
         * <p>
         * Default: Generated name
         * <p>
         * @return {@code this}
         * @param topicName A name for the topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicName(final java.lang.String topicName) {
            this.props().topicName(topicName);
            return this;
        }

        /**
         * Tracing mode of an Amazon SNS topic.
         * <p>
         * Default: TracingConfig.PASS_THROUGH
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-active-tracing.html">https://docs.aws.amazon.com/sns/latest/dg/sns-active-tracing.html</a>
         * @param tracingConfig Tracing mode of an Amazon SNS topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingConfig(final software.amazon.awscdk.services.sns.TracingConfig tracingConfig) {
            this.props().tracingConfig(tracingConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sns.Topic}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sns.Topic build() {
            return new software.amazon.awscdk.services.sns.Topic(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.sns.TopicProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.sns.TopicProps.Builder();
            }
            return this.props;
        }
    }
}
