package software.amazon.awscdk.services.sns.subscriptions;

/**
 * Properties for a Lambda subscription.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function fn;
 * Topic myTopic = new Topic(this, "MyTopic");
 * // Lambda should receive only message matching the following conditions on attributes:
 * // color: 'red' or 'orange' or begins with 'bl'
 * // size: anything but 'small' or 'medium'
 * // price: between 100 and 200 or greater than 300
 * // store: attribute must be present
 * myTopic.addSubscription(LambdaSubscription.Builder.create(fn)
 *         .filterPolicy(Map.of(
 *                 "color", SubscriptionFilter.stringFilter(StringConditions.builder()
 *                         .allowlist(List.of("red", "orange"))
 *                         .matchPrefixes(List.of("bl"))
 *                         .matchSuffixes(List.of("ue"))
 *                         .build()),
 *                 "size", SubscriptionFilter.stringFilter(StringConditions.builder()
 *                         .denylist(List.of("small", "medium"))
 *                         .build()),
 *                 "price", SubscriptionFilter.numericFilter(NumericConditions.builder()
 *                         .between(BetweenCondition.builder().start(100).stop(200).build())
 *                         .greaterThan(300)
 *                         .build()),
 *                 "store", SubscriptionFilter.existsFilter()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:41.154Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns_subscriptions.LambdaSubscriptionProps")
@software.amazon.jsii.Jsii.Proxy(LambdaSubscriptionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LambdaSubscriptionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.sns.subscriptions.SubscriptionProps {

    /**
     * @return a {@link Builder} of {@link LambdaSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LambdaSubscriptionProps> {
        software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.FilterOrPolicy> filterPolicyWithMessageBody;

        /**
         * Sets the value of {@link LambdaSubscriptionProps#getDeadLetterQueue}
         * @param deadLetterQueue Queue to be used as dead letter queue.
         *                        If not passed no dead letter queue is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link LambdaSubscriptionProps#getFilterPolicy}
         * @param filterPolicy The filter policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder filterPolicy(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy) {
            this.filterPolicy = (java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter>)filterPolicy;
            return this;
        }

        /**
         * Sets the value of {@link LambdaSubscriptionProps#getFilterPolicyWithMessageBody}
         * @param filterPolicyWithMessageBody The filter policy that is applied on the message body.
         *                                    To apply a filter policy to the message attributes, use <code>filterPolicy</code>. A maximum of one of <code>filterPolicyWithMessageBody</code> and <code>filterPolicy</code> may be used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder filterPolicyWithMessageBody(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.FilterOrPolicy> filterPolicyWithMessageBody) {
            this.filterPolicyWithMessageBody = (java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.FilterOrPolicy>)filterPolicyWithMessageBody;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaSubscriptionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LambdaSubscriptionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LambdaSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaSubscriptionProps {
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.FilterOrPolicy> filterPolicyWithMessageBody;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deadLetterQueue = software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.filterPolicy = software.amazon.jsii.Kernel.get(this, "filterPolicy", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.SubscriptionFilter.class)));
            this.filterPolicyWithMessageBody = software.amazon.jsii.Kernel.get(this, "filterPolicyWithMessageBody", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.FilterOrPolicy.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deadLetterQueue = builder.deadLetterQueue;
            this.filterPolicy = (java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter>)builder.filterPolicy;
            this.filterPolicyWithMessageBody = (java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.FilterOrPolicy>)builder.filterPolicyWithMessageBody;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> getFilterPolicy() {
            return this.filterPolicy;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.FilterOrPolicy> getFilterPolicyWithMessageBody() {
            return this.filterPolicyWithMessageBody;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getFilterPolicy() != null) {
                data.set("filterPolicy", om.valueToTree(this.getFilterPolicy()));
            }
            if (this.getFilterPolicyWithMessageBody() != null) {
                data.set("filterPolicyWithMessageBody", om.valueToTree(this.getFilterPolicyWithMessageBody()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns_subscriptions.LambdaSubscriptionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaSubscriptionProps.Jsii$Proxy that = (LambdaSubscriptionProps.Jsii$Proxy) o;

            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.filterPolicy != null ? !this.filterPolicy.equals(that.filterPolicy) : that.filterPolicy != null) return false;
            return this.filterPolicyWithMessageBody != null ? this.filterPolicyWithMessageBody.equals(that.filterPolicyWithMessageBody) : that.filterPolicyWithMessageBody == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0;
            result = 31 * result + (this.filterPolicy != null ? this.filterPolicy.hashCode() : 0);
            result = 31 * result + (this.filterPolicyWithMessageBody != null ? this.filterPolicyWithMessageBody.hashCode() : 0);
            return result;
        }
    }
}
