package software.amazon.awscdk.services.stepfunctions;

/**
 * Base interface for Item Reader configuration properties the iterate over entries in a S3 file.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * // create a bucket
 * Bucket bucket = new Bucket(this, "Bucket");
 * DistributedMap distributedMap = DistributedMap.Builder.create(this, "Distributed Map State")
 *         .itemReader(S3JsonItemReader.Builder.create()
 *                 .bucket(bucket)
 *                 .key("my-key.json")
 *                 .build())
 *         .resultWriter(ResultWriter.Builder.create()
 *                 .bucket(bucket)
 *                 .prefix("my-prefix")
 *                 .build())
 *         .build();
 * distributedMap.itemProcessor(new Pass(this, "Pass State"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:41.406Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.S3FileItemReaderProps")
@software.amazon.jsii.Jsii.Proxy(S3FileItemReaderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface S3FileItemReaderProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.ItemReaderProps {

    /**
     * Key of file stored in S3 bucket containing an array to iterate over.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKey();

    /**
     * @return a {@link Builder} of {@link S3FileItemReaderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3FileItemReaderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<S3FileItemReaderProps> {
        java.lang.String key;
        software.amazon.awscdk.services.s3.IBucket bucket;
        java.lang.Number maxItems;

        /**
         * Sets the value of {@link S3FileItemReaderProps#getKey}
         * @param key Key of file stored in S3 bucket containing an array to iterate over. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link S3FileItemReaderProps#getBucket}
         * @param bucket S3 Bucket containing objects to iterate over or a file with a list to iterate over. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link S3FileItemReaderProps#getMaxItems}
         * @param maxItems Limits the number of items passed to the Distributed Map state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxItems(java.lang.Number maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3FileItemReaderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public S3FileItemReaderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link S3FileItemReaderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3FileItemReaderProps {
        private final java.lang.String key;
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final java.lang.Number maxItems;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.maxItems = software.amazon.jsii.Kernel.get(this, "maxItems", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
            this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
            this.maxItems = builder.maxItems;
        }

        @Override
        public final java.lang.String getKey() {
            return this.key;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.Number getMaxItems() {
            return this.maxItems;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("key", om.valueToTree(this.getKey()));
            data.set("bucket", om.valueToTree(this.getBucket()));
            if (this.getMaxItems() != null) {
                data.set("maxItems", om.valueToTree(this.getMaxItems()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.S3FileItemReaderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3FileItemReaderProps.Jsii$Proxy that = (S3FileItemReaderProps.Jsii$Proxy) o;

            if (!key.equals(that.key)) return false;
            if (!bucket.equals(that.bucket)) return false;
            return this.maxItems != null ? this.maxItems.equals(that.maxItems) : that.maxItems == null;
        }

        @Override
        public final int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.bucket.hashCode());
            result = 31 * result + (this.maxItems != null ? this.maxItems.hashCode() : 0);
            return result;
        }
    }
}
