package software.amazon.awscdk.services.stepfunctions;

/**
 * Two types of state machines are available in AWS Step Functions: EXPRESS AND STANDARD.
 * <p>
 * Default: STANDARD
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DistributedMap distributedMap = DistributedMap.Builder.create(this, "DistributedMap")
 *         .mapExecutionType(StateMachineType.EXPRESS)
 *         .build();
 * distributedMap.itemProcessor(new Pass(this, "Pass"), ProcessorConfig.builder()
 *         .mode(ProcessorMode.DISTRIBUTED)
 *         .executionType(ProcessorType.STANDARD)
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:41.414Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.StateMachineType")
public enum StateMachineType {
    /**
     * Express Workflows are ideal for high-volume, event processing workloads.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXPRESS,
    /**
     * Standard Workflows are ideal for long-running, durable, and auditable workflows.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
}
