package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Location where the Bedrock InvokeModel API response is written.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * BedrockInvokeModelOutputProps bedrockInvokeModelOutputProps = BedrockInvokeModelOutputProps.builder()
 *         .s3Location(Location.builder()
 *                 .bucketName("bucketName")
 *                 .objectKey("objectKey")
 *                 // the properties below are optional
 *                 .objectVersion("objectVersion")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-bedrock.html">https://docs.aws.amazon.com/step-functions/latest/dg/connect-bedrock.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:41.474Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.BedrockInvokeModelOutputProps")
@software.amazon.jsii.Jsii.Proxy(BedrockInvokeModelOutputProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BedrockInvokeModelOutputProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * S3 object where the Bedrock InvokeModel API response is written.
     * <p>
     * If you specify this field, the API response body is replaced with
     * a reference to the Amazon S3 location of the original output.
     * <p>
     * Default: - Response body is returned in the task result
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.Location getS3Location() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BedrockInvokeModelOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BedrockInvokeModelOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BedrockInvokeModelOutputProps> {
        software.amazon.awscdk.services.s3.Location s3Location;

        /**
         * Sets the value of {@link BedrockInvokeModelOutputProps#getS3Location}
         * @param s3Location S3 object where the Bedrock InvokeModel API response is written.
         *                   If you specify this field, the API response body is replaced with
         *                   a reference to the Amazon S3 location of the original output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Location(software.amazon.awscdk.services.s3.Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BedrockInvokeModelOutputProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BedrockInvokeModelOutputProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BedrockInvokeModelOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BedrockInvokeModelOutputProps {
        private final software.amazon.awscdk.services.s3.Location s3Location;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.s3Location = software.amazon.jsii.Kernel.get(this, "s3Location", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.Location.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.s3Location = builder.s3Location;
        }

        @Override
        public final software.amazon.awscdk.services.s3.Location getS3Location() {
            return this.s3Location;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getS3Location() != null) {
                data.set("s3Location", om.valueToTree(this.getS3Location()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.BedrockInvokeModelOutputProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BedrockInvokeModelOutputProps.Jsii$Proxy that = (BedrockInvokeModelOutputProps.Jsii$Proxy) o;

            return this.s3Location != null ? this.s3Location.equals(that.s3Location) : that.s3Location == null;
        }

        @Override
        public final int hashCode() {
            int result = this.s3Location != null ? this.s3Location.hashCode() : 0;
            return result;
        }
    }
}
