package software.amazon.awscdk.services.synthetics;

/**
 * Specify a test that the canary should run.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * Canary canary = Canary.Builder.create(this, "MyCanary")
 *         .schedule(Schedule.rate(Duration.minutes(5)))
 *         .test(Test.custom(CustomTestOptions.builder()
 *                 .code(Code.fromAsset(join(__dirname, "canary")))
 *                 .handler("index.handler")
 *                 .build()))
 *         .runtime(Runtime.SYNTHETICS_NODEJS_PUPPETEER_6_2)
 *         .memory(Size.mebibytes(1024))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:41.735Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.Test")
public class Test extends software.amazon.jsii.JsiiObject {

    protected Test(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Test(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Specify a custom test with your own code.
     * <p>
     * @return <code>Test</code> associated with the specified Code object
     * @param options The configuration options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.Test custom(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.CustomTestOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.synthetics.Test.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Test.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * The code that the canary should run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.synthetics.Code getCode() {
        return software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.synthetics.Code.class));
    }

    /**
     * The handler of the canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getHandler() {
        return software.amazon.jsii.Kernel.get(this, "handler", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
