package software.amazon.awscdk.services.transfer;

/**
 * Creates the connector, which captures the parameters for a connection for the AS2 or SFTP protocol.
 * <p>
 * For AS2, the connector is required for sending files to an externally hosted AS2 server. For SFTP, the connector is required when sending files to an SFTP server or receiving files from an SFTP server. For more details about connectors, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/configure-as2-connector.html">Configure AS2 connectors</a> and <a href="https://docs.aws.amazon.com/transfer/latest/userguide/configure-sftp-connector.html">Create SFTP connectors</a> .
 * <p>
 * <blockquote>
 * <p>
 * You must specify exactly one configuration object: either for AS2 ( <code>As2Config</code> ) or SFTP ( <code>SftpConfig</code> ).
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.transfer.*;
 * Object as2Config;
 * CfnConnector cfnConnector = CfnConnector.Builder.create(this, "MyCfnConnector")
 *         .accessRole("accessRole")
 *         .url("url")
 *         // the properties below are optional
 *         .as2Config(as2Config)
 *         .loggingRole("loggingRole")
 *         .securityPolicyName("securityPolicyName")
 *         .sftpConfig(SftpConfigProperty.builder()
 *                 .trustedHostKeys(List.of("trustedHostKeys"))
 *                 .userSecretId("userSecretId")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-08-19T23:46:41.774Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnConnector")
public class CfnConnector extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnConnector(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnector(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.transfer.CfnConnector.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConnector(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.transfer.CfnConnectorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Specifies the unique Amazon Resource Name (ARN) for the connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The service-assigned ID of the connector that is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConnectorId() {
        return software.amazon.jsii.Kernel.get(this, "attrConnectorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The list of egress IP addresses of this connector.
     * <p>
     * These IP addresses are assigned automatically when you create the connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrServiceManagedEgressIpAddresses() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrServiceManagedEgressIpAddresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Connectors are used to send files using either the AS2 or SFTP protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAccessRole() {
        return software.amazon.jsii.Kernel.get(this, "accessRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Connectors are used to send files using either the AS2 or SFTP protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "accessRole", java.util.Objects.requireNonNull(value, "accessRole is required"));
    }

    /**
     * The URL of the partner's AS2 or SFTP endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUrl() {
        return software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL of the partner's AS2 or SFTP endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUrl(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "url", java.util.Objects.requireNonNull(value, "url is required"));
    }

    /**
     * A structure that contains the parameters for an AS2 connector object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAs2Config() {
        return software.amazon.jsii.Kernel.get(this, "as2Config", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that contains the parameters for an AS2 connector object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAs2Config(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "as2Config", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a connector to turn on CloudWatch logging for Amazon S3 events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLoggingRole() {
        return software.amazon.jsii.Kernel.get(this, "loggingRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a connector to turn on CloudWatch logging for Amazon S3 events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "loggingRole", value);
    }

    /**
     * The text name of the security policy for the specified connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSecurityPolicyName() {
        return software.amazon.jsii.Kernel.get(this, "securityPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The text name of the security policy for the specified connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityPolicyName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "securityPolicyName", value);
    }

    /**
     * A structure that contains the parameters for an SFTP connector object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSftpConfig() {
        return software.amazon.jsii.Kernel.get(this, "sftpConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that contains the parameters for an SFTP connector object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSftpConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sftpConfig", value);
    }

    /**
     * A structure that contains the parameters for an SFTP connector object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSftpConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.transfer.CfnConnector.SftpConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "sftpConfig", value);
    }

    /**
     * Key-value pairs that can be used to group and search for connectors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Key-value pairs that can be used to group and search for connectors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A structure that contains the parameters for an AS2 connector object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * As2ConfigProperty as2ConfigProperty = As2ConfigProperty.builder()
     *         .basicAuthSecretId("basicAuthSecretId")
     *         .compression("compression")
     *         .encryptionAlgorithm("encryptionAlgorithm")
     *         .localProfileId("localProfileId")
     *         .mdnResponse("mdnResponse")
     *         .mdnSigningAlgorithm("mdnSigningAlgorithm")
     *         .messageSubject("messageSubject")
     *         .partnerProfileId("partnerProfileId")
     *         .signingAlgorithm("signingAlgorithm")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnConnector.As2ConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(As2ConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface As2ConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Provides Basic authentication support to the AS2 Connectors API.
         * <p>
         * To use Basic authentication, you must provide the name or Amazon Resource Name (ARN) of a secret in AWS Secrets Manager .
         * <p>
         * The default value for this parameter is <code>null</code> , which indicates that Basic authentication is not enabled for the connector.
         * <p>
         * If the connector should use Basic authentication, the secret needs to be in the following format:
         * <p>
         * <code>{ "Username": "user-name", "Password": "user-password" }</code>
         * <p>
         * Replace <code>user-name</code> and <code>user-password</code> with the credentials for the actual user that is being authenticated.
         * <p>
         * Note the following:
         * <p>
         * <ul>
         * <li>You are storing these credentials in Secrets Manager, <em>not passing them directly</em> into this API.</li>
         * <li>If you are using the API, SDKs, or CloudFormation to configure your connector, then you must create the secret before you can enable Basic authentication. However, if you are using the AWS management console, you can have the system create the secret for you.</li>
         * </ul>
         * <p>
         * If you have previously enabled Basic authentication for a connector, you can disable it by using the <code>UpdateConnector</code> API call. For example, if you are using the CLI, you can run the following command to remove Basic authentication:
         * <p>
         * <code>update-connector --connector-id my-connector-id --as2-config 'BasicAuthSecretId=""'</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-basicauthsecretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-basicauthsecretid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBasicAuthSecretId() {
            return null;
        }

        /**
         * Specifies whether the AS2 file is compressed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-compression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-compression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompression() {
            return null;
        }

        /**
         * The algorithm that is used to encrypt the file.
         * <p>
         * Note the following:
         * <p>
         * <ul>
         * <li>Do not use the <code>DES_EDE3_CBC</code> algorithm unless you must support a legacy client that requires it, as it is a weak encryption algorithm.</li>
         * <li>You can only specify <code>NONE</code> if the URL for your connector uses HTTPS. Using HTTPS ensures that no traffic is sent in clear text.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-encryptionalgorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-encryptionalgorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionAlgorithm() {
            return null;
        }

        /**
         * A unique identifier for the AS2 local profile.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-localprofileid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-localprofileid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocalProfileId() {
            return null;
        }

        /**
         * Used for outbound requests (from an AWS Transfer Family server to a partner AS2 server) to determine whether the partner response for transfers is synchronous or asynchronous.
         * <p>
         * Specify either of the following values:
         * <p>
         * <ul>
         * <li><code>SYNC</code> : The system expects a synchronous MDN response, confirming that the file was transferred successfully (or not).</li>
         * <li><code>NONE</code> : Specifies that no MDN response is required.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-mdnresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-mdnresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMdnResponse() {
            return null;
        }

        /**
         * The signing algorithm for the MDN response.
         * <p>
         * <blockquote>
         * <p>
         * If set to DEFAULT (or not set at all), the value for <code>SigningAlgorithm</code> is used.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-mdnsigningalgorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-mdnsigningalgorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMdnSigningAlgorithm() {
            return null;
        }

        /**
         * Used as the <code>Subject</code> HTTP header attribute in AS2 messages that are being sent with the connector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-messagesubject">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-messagesubject</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageSubject() {
            return null;
        }

        /**
         * A unique identifier for the partner profile for the connector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-partnerprofileid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-partnerprofileid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPartnerProfileId() {
            return null;
        }

        /**
         * The algorithm that is used to sign the AS2 messages sent with the connector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-signingalgorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-as2config.html#cfn-transfer-connector-as2config-signingalgorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSigningAlgorithm() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link As2ConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link As2ConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<As2ConfigProperty> {
            java.lang.String basicAuthSecretId;
            java.lang.String compression;
            java.lang.String encryptionAlgorithm;
            java.lang.String localProfileId;
            java.lang.String mdnResponse;
            java.lang.String mdnSigningAlgorithm;
            java.lang.String messageSubject;
            java.lang.String partnerProfileId;
            java.lang.String signingAlgorithm;

            /**
             * Sets the value of {@link As2ConfigProperty#getBasicAuthSecretId}
             * @param basicAuthSecretId Provides Basic authentication support to the AS2 Connectors API.
             *                          To use Basic authentication, you must provide the name or Amazon Resource Name (ARN) of a secret in AWS Secrets Manager .
             *                          <p>
             *                          The default value for this parameter is <code>null</code> , which indicates that Basic authentication is not enabled for the connector.
             *                          <p>
             *                          If the connector should use Basic authentication, the secret needs to be in the following format:
             *                          <p>
             *                          <code>{ "Username": "user-name", "Password": "user-password" }</code>
             *                          <p>
             *                          Replace <code>user-name</code> and <code>user-password</code> with the credentials for the actual user that is being authenticated.
             *                          <p>
             *                          Note the following:
             *                          <p>
             *                          <ul>
             *                          <li>You are storing these credentials in Secrets Manager, <em>not passing them directly</em> into this API.</li>
             *                          <li>If you are using the API, SDKs, or CloudFormation to configure your connector, then you must create the secret before you can enable Basic authentication. However, if you are using the AWS management console, you can have the system create the secret for you.</li>
             *                          </ul>
             *                          <p>
             *                          If you have previously enabled Basic authentication for a connector, you can disable it by using the <code>UpdateConnector</code> API call. For example, if you are using the CLI, you can run the following command to remove Basic authentication:
             *                          <p>
             *                          <code>update-connector --connector-id my-connector-id --as2-config 'BasicAuthSecretId=""'</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuthSecretId(java.lang.String basicAuthSecretId) {
                this.basicAuthSecretId = basicAuthSecretId;
                return this;
            }

            /**
             * Sets the value of {@link As2ConfigProperty#getCompression}
             * @param compression Specifies whether the AS2 file is compressed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compression(java.lang.String compression) {
                this.compression = compression;
                return this;
            }

            /**
             * Sets the value of {@link As2ConfigProperty#getEncryptionAlgorithm}
             * @param encryptionAlgorithm The algorithm that is used to encrypt the file.
             *                            Note the following:
             *                            <p>
             *                            <ul>
             *                            <li>Do not use the <code>DES_EDE3_CBC</code> algorithm unless you must support a legacy client that requires it, as it is a weak encryption algorithm.</li>
             *                            <li>You can only specify <code>NONE</code> if the URL for your connector uses HTTPS. Using HTTPS ensures that no traffic is sent in clear text.</li>
             *                            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionAlgorithm(java.lang.String encryptionAlgorithm) {
                this.encryptionAlgorithm = encryptionAlgorithm;
                return this;
            }

            /**
             * Sets the value of {@link As2ConfigProperty#getLocalProfileId}
             * @param localProfileId A unique identifier for the AS2 local profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localProfileId(java.lang.String localProfileId) {
                this.localProfileId = localProfileId;
                return this;
            }

            /**
             * Sets the value of {@link As2ConfigProperty#getMdnResponse}
             * @param mdnResponse Used for outbound requests (from an AWS Transfer Family server to a partner AS2 server) to determine whether the partner response for transfers is synchronous or asynchronous.
             *                    Specify either of the following values:
             *                    <p>
             *                    <ul>
             *                    <li><code>SYNC</code> : The system expects a synchronous MDN response, confirming that the file was transferred successfully (or not).</li>
             *                    <li><code>NONE</code> : Specifies that no MDN response is required.</li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mdnResponse(java.lang.String mdnResponse) {
                this.mdnResponse = mdnResponse;
                return this;
            }

            /**
             * Sets the value of {@link As2ConfigProperty#getMdnSigningAlgorithm}
             * @param mdnSigningAlgorithm The signing algorithm for the MDN response.
             *                            <blockquote>
             *                            <p>
             *                            If set to DEFAULT (or not set at all), the value for <code>SigningAlgorithm</code> is used.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mdnSigningAlgorithm(java.lang.String mdnSigningAlgorithm) {
                this.mdnSigningAlgorithm = mdnSigningAlgorithm;
                return this;
            }

            /**
             * Sets the value of {@link As2ConfigProperty#getMessageSubject}
             * @param messageSubject Used as the <code>Subject</code> HTTP header attribute in AS2 messages that are being sent with the connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageSubject(java.lang.String messageSubject) {
                this.messageSubject = messageSubject;
                return this;
            }

            /**
             * Sets the value of {@link As2ConfigProperty#getPartnerProfileId}
             * @param partnerProfileId A unique identifier for the partner profile for the connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partnerProfileId(java.lang.String partnerProfileId) {
                this.partnerProfileId = partnerProfileId;
                return this;
            }

            /**
             * Sets the value of {@link As2ConfigProperty#getSigningAlgorithm}
             * @param signingAlgorithm The algorithm that is used to sign the AS2 messages sent with the connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder signingAlgorithm(java.lang.String signingAlgorithm) {
                this.signingAlgorithm = signingAlgorithm;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link As2ConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public As2ConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link As2ConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements As2ConfigProperty {
            private final java.lang.String basicAuthSecretId;
            private final java.lang.String compression;
            private final java.lang.String encryptionAlgorithm;
            private final java.lang.String localProfileId;
            private final java.lang.String mdnResponse;
            private final java.lang.String mdnSigningAlgorithm;
            private final java.lang.String messageSubject;
            private final java.lang.String partnerProfileId;
            private final java.lang.String signingAlgorithm;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.basicAuthSecretId = software.amazon.jsii.Kernel.get(this, "basicAuthSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.compression = software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionAlgorithm = software.amazon.jsii.Kernel.get(this, "encryptionAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localProfileId = software.amazon.jsii.Kernel.get(this, "localProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mdnResponse = software.amazon.jsii.Kernel.get(this, "mdnResponse", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mdnSigningAlgorithm = software.amazon.jsii.Kernel.get(this, "mdnSigningAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.messageSubject = software.amazon.jsii.Kernel.get(this, "messageSubject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.partnerProfileId = software.amazon.jsii.Kernel.get(this, "partnerProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.signingAlgorithm = software.amazon.jsii.Kernel.get(this, "signingAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.basicAuthSecretId = builder.basicAuthSecretId;
                this.compression = builder.compression;
                this.encryptionAlgorithm = builder.encryptionAlgorithm;
                this.localProfileId = builder.localProfileId;
                this.mdnResponse = builder.mdnResponse;
                this.mdnSigningAlgorithm = builder.mdnSigningAlgorithm;
                this.messageSubject = builder.messageSubject;
                this.partnerProfileId = builder.partnerProfileId;
                this.signingAlgorithm = builder.signingAlgorithm;
            }

            @Override
            public final java.lang.String getBasicAuthSecretId() {
                return this.basicAuthSecretId;
            }

            @Override
            public final java.lang.String getCompression() {
                return this.compression;
            }

            @Override
            public final java.lang.String getEncryptionAlgorithm() {
                return this.encryptionAlgorithm;
            }

            @Override
            public final java.lang.String getLocalProfileId() {
                return this.localProfileId;
            }

            @Override
            public final java.lang.String getMdnResponse() {
                return this.mdnResponse;
            }

            @Override
            public final java.lang.String getMdnSigningAlgorithm() {
                return this.mdnSigningAlgorithm;
            }

            @Override
            public final java.lang.String getMessageSubject() {
                return this.messageSubject;
            }

            @Override
            public final java.lang.String getPartnerProfileId() {
                return this.partnerProfileId;
            }

            @Override
            public final java.lang.String getSigningAlgorithm() {
                return this.signingAlgorithm;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBasicAuthSecretId() != null) {
                    data.set("basicAuthSecretId", om.valueToTree(this.getBasicAuthSecretId()));
                }
                if (this.getCompression() != null) {
                    data.set("compression", om.valueToTree(this.getCompression()));
                }
                if (this.getEncryptionAlgorithm() != null) {
                    data.set("encryptionAlgorithm", om.valueToTree(this.getEncryptionAlgorithm()));
                }
                if (this.getLocalProfileId() != null) {
                    data.set("localProfileId", om.valueToTree(this.getLocalProfileId()));
                }
                if (this.getMdnResponse() != null) {
                    data.set("mdnResponse", om.valueToTree(this.getMdnResponse()));
                }
                if (this.getMdnSigningAlgorithm() != null) {
                    data.set("mdnSigningAlgorithm", om.valueToTree(this.getMdnSigningAlgorithm()));
                }
                if (this.getMessageSubject() != null) {
                    data.set("messageSubject", om.valueToTree(this.getMessageSubject()));
                }
                if (this.getPartnerProfileId() != null) {
                    data.set("partnerProfileId", om.valueToTree(this.getPartnerProfileId()));
                }
                if (this.getSigningAlgorithm() != null) {
                    data.set("signingAlgorithm", om.valueToTree(this.getSigningAlgorithm()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnConnector.As2ConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                As2ConfigProperty.Jsii$Proxy that = (As2ConfigProperty.Jsii$Proxy) o;

                if (this.basicAuthSecretId != null ? !this.basicAuthSecretId.equals(that.basicAuthSecretId) : that.basicAuthSecretId != null) return false;
                if (this.compression != null ? !this.compression.equals(that.compression) : that.compression != null) return false;
                if (this.encryptionAlgorithm != null ? !this.encryptionAlgorithm.equals(that.encryptionAlgorithm) : that.encryptionAlgorithm != null) return false;
                if (this.localProfileId != null ? !this.localProfileId.equals(that.localProfileId) : that.localProfileId != null) return false;
                if (this.mdnResponse != null ? !this.mdnResponse.equals(that.mdnResponse) : that.mdnResponse != null) return false;
                if (this.mdnSigningAlgorithm != null ? !this.mdnSigningAlgorithm.equals(that.mdnSigningAlgorithm) : that.mdnSigningAlgorithm != null) return false;
                if (this.messageSubject != null ? !this.messageSubject.equals(that.messageSubject) : that.messageSubject != null) return false;
                if (this.partnerProfileId != null ? !this.partnerProfileId.equals(that.partnerProfileId) : that.partnerProfileId != null) return false;
                return this.signingAlgorithm != null ? this.signingAlgorithm.equals(that.signingAlgorithm) : that.signingAlgorithm == null;
            }

            @Override
            public final int hashCode() {
                int result = this.basicAuthSecretId != null ? this.basicAuthSecretId.hashCode() : 0;
                result = 31 * result + (this.compression != null ? this.compression.hashCode() : 0);
                result = 31 * result + (this.encryptionAlgorithm != null ? this.encryptionAlgorithm.hashCode() : 0);
                result = 31 * result + (this.localProfileId != null ? this.localProfileId.hashCode() : 0);
                result = 31 * result + (this.mdnResponse != null ? this.mdnResponse.hashCode() : 0);
                result = 31 * result + (this.mdnSigningAlgorithm != null ? this.mdnSigningAlgorithm.hashCode() : 0);
                result = 31 * result + (this.messageSubject != null ? this.messageSubject.hashCode() : 0);
                result = 31 * result + (this.partnerProfileId != null ? this.partnerProfileId.hashCode() : 0);
                result = 31 * result + (this.signingAlgorithm != null ? this.signingAlgorithm.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that contains the parameters for an SFTP connector object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.transfer.*;
     * SftpConfigProperty sftpConfigProperty = SftpConfigProperty.builder()
     *         .trustedHostKeys(List.of("trustedHostKeys"))
     *         .userSecretId("userSecretId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-sftpconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-sftpconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_transfer.CfnConnector.SftpConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SftpConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SftpConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The public portion of the host key, or keys, that are used to identify the external server to which you are connecting.
         * <p>
         * You can use the <code>ssh-keyscan</code> command against the SFTP server to retrieve the necessary key.
         * <p>
         * The three standard SSH public key format elements are <code>&lt;key type&gt;</code> , <code>&lt;body base64&gt;</code> , and an optional <code>&lt;comment&gt;</code> , with spaces between each element. Specify only the <code>&lt;key type&gt;</code> and <code>&lt;body base64&gt;</code> : do not enter the <code>&lt;comment&gt;</code> portion of the key.
         * <p>
         * For the trusted host key, AWS Transfer Family accepts RSA and ECDSA keys.
         * <p>
         * <ul>
         * <li>For RSA keys, the <code>&lt;key type&gt;</code> string is <code>ssh-rsa</code> .</li>
         * <li>For ECDSA keys, the <code>&lt;key type&gt;</code> string is either <code>ecdsa-sha2-nistp256</code> , <code>ecdsa-sha2-nistp384</code> , or <code>ecdsa-sha2-nistp521</code> , depending on the size of the key you generated.</li>
         * </ul>
         * <p>
         * Run this command to retrieve the SFTP server host key, where your SFTP server name is <code>ftp.host.com</code> .
         * <p>
         * <code>ssh-keyscan ftp.host.com</code>
         * <p>
         * This prints the public host key to standard output.
         * <p>
         * <code>ftp.host.com ssh-rsa AAAAB3Nza...&lt;long-string-for-public-key</code>
         * <p>
         * Copy and paste this string into the <code>TrustedHostKeys</code> field for the <code>create-connector</code> command or into the <em>Trusted host keys</em> field in the console.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-sftpconfig.html#cfn-transfer-connector-sftpconfig-trustedhostkeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-sftpconfig.html#cfn-transfer-connector-sftpconfig-trustedhostkeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrustedHostKeys() {
            return null;
        }

        /**
         * The identifier for the secret (in AWS Secrets Manager) that contains the SFTP user's private key, password, or both.
         * <p>
         * The identifier must be the Amazon Resource Name (ARN) of the secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-sftpconfig.html#cfn-transfer-connector-sftpconfig-usersecretid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-connector-sftpconfig.html#cfn-transfer-connector-sftpconfig-usersecretid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SftpConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SftpConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SftpConfigProperty> {
            java.util.List<java.lang.String> trustedHostKeys;
            java.lang.String userSecretId;

            /**
             * Sets the value of {@link SftpConfigProperty#getTrustedHostKeys}
             * @param trustedHostKeys The public portion of the host key, or keys, that are used to identify the external server to which you are connecting.
             *                        You can use the <code>ssh-keyscan</code> command against the SFTP server to retrieve the necessary key.
             *                        <p>
             *                        The three standard SSH public key format elements are <code>&lt;key type&gt;</code> , <code>&lt;body base64&gt;</code> , and an optional <code>&lt;comment&gt;</code> , with spaces between each element. Specify only the <code>&lt;key type&gt;</code> and <code>&lt;body base64&gt;</code> : do not enter the <code>&lt;comment&gt;</code> portion of the key.
             *                        <p>
             *                        For the trusted host key, AWS Transfer Family accepts RSA and ECDSA keys.
             *                        <p>
             *                        <ul>
             *                        <li>For RSA keys, the <code>&lt;key type&gt;</code> string is <code>ssh-rsa</code> .</li>
             *                        <li>For ECDSA keys, the <code>&lt;key type&gt;</code> string is either <code>ecdsa-sha2-nistp256</code> , <code>ecdsa-sha2-nistp384</code> , or <code>ecdsa-sha2-nistp521</code> , depending on the size of the key you generated.</li>
             *                        </ul>
             *                        <p>
             *                        Run this command to retrieve the SFTP server host key, where your SFTP server name is <code>ftp.host.com</code> .
             *                        <p>
             *                        <code>ssh-keyscan ftp.host.com</code>
             *                        <p>
             *                        This prints the public host key to standard output.
             *                        <p>
             *                        <code>ftp.host.com ssh-rsa AAAAB3Nza...&lt;long-string-for-public-key</code>
             *                        <p>
             *                        Copy and paste this string into the <code>TrustedHostKeys</code> field for the <code>create-connector</code> command or into the <em>Trusted host keys</em> field in the console.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustedHostKeys(java.util.List<java.lang.String> trustedHostKeys) {
                this.trustedHostKeys = trustedHostKeys;
                return this;
            }

            /**
             * Sets the value of {@link SftpConfigProperty#getUserSecretId}
             * @param userSecretId The identifier for the secret (in AWS Secrets Manager) that contains the SFTP user's private key, password, or both.
             *                     The identifier must be the Amazon Resource Name (ARN) of the secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userSecretId(java.lang.String userSecretId) {
                this.userSecretId = userSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SftpConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SftpConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SftpConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SftpConfigProperty {
            private final java.util.List<java.lang.String> trustedHostKeys;
            private final java.lang.String userSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.trustedHostKeys = software.amazon.jsii.Kernel.get(this, "trustedHostKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.userSecretId = software.amazon.jsii.Kernel.get(this, "userSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.trustedHostKeys = builder.trustedHostKeys;
                this.userSecretId = builder.userSecretId;
            }

            @Override
            public final java.util.List<java.lang.String> getTrustedHostKeys() {
                return this.trustedHostKeys;
            }

            @Override
            public final java.lang.String getUserSecretId() {
                return this.userSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTrustedHostKeys() != null) {
                    data.set("trustedHostKeys", om.valueToTree(this.getTrustedHostKeys()));
                }
                if (this.getUserSecretId() != null) {
                    data.set("userSecretId", om.valueToTree(this.getUserSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_transfer.CfnConnector.SftpConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SftpConfigProperty.Jsii$Proxy that = (SftpConfigProperty.Jsii$Proxy) o;

                if (this.trustedHostKeys != null ? !this.trustedHostKeys.equals(that.trustedHostKeys) : that.trustedHostKeys != null) return false;
                return this.userSecretId != null ? this.userSecretId.equals(that.userSecretId) : that.userSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.trustedHostKeys != null ? this.trustedHostKeys.hashCode() : 0;
                result = 31 * result + (this.userSecretId != null ? this.userSecretId.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.transfer.CfnConnector}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.transfer.CfnConnector> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.transfer.CfnConnectorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.transfer.CfnConnectorProps.Builder();
        }

        /**
         * Connectors are used to send files using either the AS2 or SFTP protocol.
         * <p>
         * For the access role, provide the Amazon Resource Name (ARN) of the AWS Identity and Access Management role to use.
         * <p>
         * <em>For AS2 connectors</em>
         * <p>
         * With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths in the request parameter, <code>SendFilePaths</code> . We use the file’s parent directory (for example, for <code>--send-file-paths /bucket/dir/file.txt</code> , parent directory is <code>/bucket/dir/</code> ) to temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code> needs to provide read and write access to the parent directory of the file location used in the <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent directory of the files that you intend to send with <code>StartFileTransfer</code> .
         * <p>
         * If you are using Basic authentication for your AS2 connector, the access role requires the <code>secretsmanager:GetSecretValue</code> permission for the secret. If the secret is encrypted using a customer-managed key instead of the AWS managed key in Secrets Manager, then the role also needs the <code>kms:Decrypt</code> permission for that key.
         * <p>
         * <em>For SFTP connectors</em>
         * <p>
         * Make sure that the access role provides read and write access to the parent directory of the file location that's used in the <code>StartFileTransfer</code> request. Additionally, make sure that the role provides <code>secretsmanager:GetSecretValue</code> permission to AWS Secrets Manager .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-accessrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-accessrole</a>
         * @param accessRole Connectors are used to send files using either the AS2 or SFTP protocol. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessRole(final java.lang.String accessRole) {
            this.props.accessRole(accessRole);
            return this;
        }

        /**
         * The URL of the partner's AS2 or SFTP endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-url</a>
         * @param url The URL of the partner's AS2 or SFTP endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder url(final java.lang.String url) {
            this.props.url(url);
            return this;
        }

        /**
         * A structure that contains the parameters for an AS2 connector object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-as2config">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-as2config</a>
         * @param as2Config A structure that contains the parameters for an AS2 connector object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder as2Config(final java.lang.Object as2Config) {
            this.props.as2Config(as2Config);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a connector to turn on CloudWatch logging for Amazon S3 events.
         * <p>
         * When set, you can view connector activity in your CloudWatch logs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-loggingrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-loggingrole</a>
         * @param loggingRole The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a connector to turn on CloudWatch logging for Amazon S3 events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingRole(final java.lang.String loggingRole) {
            this.props.loggingRole(loggingRole);
            return this;
        }

        /**
         * The text name of the security policy for the specified connector.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-securitypolicyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-securitypolicyname</a>
         * @param securityPolicyName The text name of the security policy for the specified connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityPolicyName(final java.lang.String securityPolicyName) {
            this.props.securityPolicyName(securityPolicyName);
            return this;
        }

        /**
         * A structure that contains the parameters for an SFTP connector object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-sftpconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-sftpconfig</a>
         * @param sftpConfig A structure that contains the parameters for an SFTP connector object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sftpConfig(final software.amazon.awscdk.IResolvable sftpConfig) {
            this.props.sftpConfig(sftpConfig);
            return this;
        }
        /**
         * A structure that contains the parameters for an SFTP connector object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-sftpconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-sftpconfig</a>
         * @param sftpConfig A structure that contains the parameters for an SFTP connector object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sftpConfig(final software.amazon.awscdk.services.transfer.CfnConnector.SftpConfigProperty sftpConfig) {
            this.props.sftpConfig(sftpConfig);
            return this;
        }

        /**
         * Key-value pairs that can be used to group and search for connectors.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-connector.html#cfn-transfer-connector-tags</a>
         * @param tags Key-value pairs that can be used to group and search for connectors. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.transfer.CfnConnector}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.transfer.CfnConnector build() {
            return new software.amazon.awscdk.services.transfer.CfnConnector(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
