/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appconfig;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.appconfig.ActionPoint;
import software.amazon.awscdk.services.appconfig.ApplicationProps;
import software.amazon.awscdk.services.appconfig.EnvironmentOptions;
import software.amazon.awscdk.services.appconfig.ExtensibleBase;
import software.amazon.awscdk.services.appconfig.ExtensionOptions;
import software.amazon.awscdk.services.appconfig.HostedConfiguration;
import software.amazon.awscdk.services.appconfig.HostedConfigurationOptions;
import software.amazon.awscdk.services.appconfig.IApplication;
import software.amazon.awscdk.services.appconfig.IEnvironment;
import software.amazon.awscdk.services.appconfig.IEventDestination;
import software.amazon.awscdk.services.appconfig.IExtensible;
import software.amazon.awscdk.services.appconfig.IExtension;
import software.amazon.awscdk.services.appconfig.Platform;
import software.amazon.awscdk.services.appconfig.SourcedConfiguration;
import software.amazon.awscdk.services.appconfig.SourcedConfigurationOptions;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_appconfig.Application")
public class Application
extends Resource
implements IApplication,
IExtensible {
    protected Application(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Application(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Application(@NotNull Construct scope, @NotNull String id, @Nullable ApplicationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Application(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public static void addAgentToEcs(@NotNull TaskDefinition taskDef) {
        JsiiObject.jsiiStaticCall(Application.class, (String)"addAgentToEcs", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(taskDef, "taskDef is required")});
    }

    @NotNull
    public static IApplication fromApplicationArn(@NotNull Construct scope, @NotNull String id, @NotNull String applicationArn) {
        return (IApplication)JsiiObject.jsiiStaticCall(Application.class, (String)"fromApplicationArn", (NativeType)NativeType.forClass(IApplication.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(applicationArn, "applicationArn is required")});
    }

    @NotNull
    public static IApplication fromApplicationId(@NotNull Construct scope, @NotNull String id, @NotNull String applicationId) {
        return (IApplication)JsiiObject.jsiiStaticCall(Application.class, (String)"fromApplicationId", (NativeType)NativeType.forClass(IApplication.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(applicationId, "applicationId is required")});
    }

    @NotNull
    public static String getLambdaLayerVersionArn(@NotNull String region, @Nullable Platform platform) {
        return (String)JsiiObject.jsiiStaticCall(Application.class, (String)"getLambdaLayerVersionArn", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(region, "region is required"), platform});
    }

    @NotNull
    public static String getLambdaLayerVersionArn(@NotNull String region) {
        return (String)JsiiObject.jsiiStaticCall(Application.class, (String)"getLambdaLayerVersionArn", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(region, "region is required")});
    }

    @Override
    @NotNull
    public IEnvironment addEnvironment(@NotNull String id, @Nullable EnvironmentOptions options) {
        return (IEnvironment)Kernel.call((Object)this, (String)"addEnvironment", (NativeType)NativeType.forClass(IEnvironment.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public IEnvironment addEnvironment(@NotNull String id) {
        return (IEnvironment)Kernel.call((Object)this, (String)"addEnvironment", (NativeType)NativeType.forClass(IEnvironment.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void addExistingEnvironment(@NotNull IEnvironment environment) {
        Kernel.call((Object)this, (String)"addExistingEnvironment", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(environment, "environment is required")});
    }

    @Override
    public void addExtension(@NotNull IExtension extension) {
        Kernel.call((Object)this, (String)"addExtension", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(extension, "extension is required")});
    }

    @Override
    @NotNull
    public HostedConfiguration addHostedConfiguration(@NotNull String id, @NotNull HostedConfigurationOptions options) {
        return (HostedConfiguration)Kernel.call((Object)this, (String)"addHostedConfiguration", (NativeType)NativeType.forClass(HostedConfiguration.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public SourcedConfiguration addSourcedConfiguration(@NotNull String id, @NotNull SourcedConfigurationOptions options) {
        return (SourcedConfiguration)Kernel.call((Object)this, (String)"addSourcedConfiguration", (NativeType)NativeType.forClass(SourcedConfiguration.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public List<IEnvironment> environments() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"environments", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(IEnvironment.class)), (Object[])new Object[0]));
    }

    @Override
    public void on(@NotNull ActionPoint actionPoint, @NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"on", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(actionPoint, "actionPoint is required"), Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void on(@NotNull ActionPoint actionPoint, @NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"on", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(actionPoint, "actionPoint is required"), Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void onDeploymentBaking(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"onDeploymentBaking", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void onDeploymentBaking(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"onDeploymentBaking", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void onDeploymentComplete(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"onDeploymentComplete", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void onDeploymentComplete(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"onDeploymentComplete", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void onDeploymentRolledBack(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"onDeploymentRolledBack", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void onDeploymentRolledBack(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"onDeploymentRolledBack", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void onDeploymentStart(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"onDeploymentStart", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void onDeploymentStart(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"onDeploymentStart", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void onDeploymentStep(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"onDeploymentStep", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void onDeploymentStep(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"onDeploymentStep", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void preCreateHostedConfigurationVersion(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"preCreateHostedConfigurationVersion", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void preCreateHostedConfigurationVersion(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"preCreateHostedConfigurationVersion", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    public void preStartDeployment(@NotNull IEventDestination eventDestination, @Nullable ExtensionOptions options) {
        Kernel.call((Object)this, (String)"preStartDeployment", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required"), options});
    }

    @Override
    public void preStartDeployment(@NotNull IEventDestination eventDestination) {
        Kernel.call((Object)this, (String)"preStartDeployment", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(eventDestination, "eventDestination is required")});
    }

    @Override
    @NotNull
    public String getApplicationArn() {
        return (String)Kernel.get((Object)this, (String)"applicationArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getApplicationId() {
        return (String)Kernel.get((Object)this, (String)"applicationId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected ExtensibleBase getExtensible() {
        return (ExtensibleBase)Kernel.get((Object)this, (String)"extensible", (NativeType)NativeType.forClass(ExtensibleBase.class));
    }

    protected void setExtensible(@NotNull ExtensibleBase value) {
        Kernel.set((Object)this, (String)"extensible", (Object)Objects.requireNonNull(value, "extensible is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Application> {
        private final Construct scope;
        private final String id;
        private ApplicationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder applicationName(String applicationName) {
            this.props().applicationName(applicationName);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Application build() {
            return new Application(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private ApplicationProps.Builder props() {
            if (this.props == null) {
                this.props = new ApplicationProps.Builder();
            }
            return this.props;
        }
    }
}

