/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.apigateway.AwsIntegration;
import software.amazon.awscdk.services.apigateway.ConnectionType;
import software.amazon.awscdk.services.apigateway.ContentHandling;
import software.amazon.awscdk.services.apigateway.IVpcLink;
import software.amazon.awscdk.services.apigateway.IntegrationConfig;
import software.amazon.awscdk.services.apigateway.IntegrationResponse;
import software.amazon.awscdk.services.apigateway.Method;
import software.amazon.awscdk.services.apigateway.PassthroughBehavior;
import software.amazon.awscdk.services.apigateway.SagemakerIntegrationOptions;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.sagemaker.IEndpoint;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_apigateway.SagemakerIntegration")
public class SagemakerIntegration
extends AwsIntegration {
    protected SagemakerIntegration(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SagemakerIntegration(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SagemakerIntegration(@NotNull IEndpoint endpoint, @Nullable SagemakerIntegrationOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(endpoint, "endpoint is required"), options});
    }

    public SagemakerIntegration(@NotNull IEndpoint endpoint) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(endpoint, "endpoint is required")});
    }

    @Override
    @NotNull
    public IntegrationConfig bind(@NotNull Method method) {
        return (IntegrationConfig)Kernel.call((Object)((Object)this), (String)"bind", (NativeType)NativeType.forClass(IntegrationConfig.class), (Object[])new Object[]{Objects.requireNonNull(method, "method is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SagemakerIntegration> {
        private final IEndpoint endpoint;
        private SagemakerIntegrationOptions.Builder options;

        public static Builder create(IEndpoint endpoint) {
            return new Builder(endpoint);
        }

        private Builder(IEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        public Builder cacheKeyParameters(List<String> cacheKeyParameters) {
            this.options().cacheKeyParameters(cacheKeyParameters);
            return this;
        }

        public Builder cacheNamespace(String cacheNamespace) {
            this.options().cacheNamespace(cacheNamespace);
            return this;
        }

        public Builder connectionType(ConnectionType connectionType) {
            this.options().connectionType(connectionType);
            return this;
        }

        public Builder contentHandling(ContentHandling contentHandling) {
            this.options().contentHandling(contentHandling);
            return this;
        }

        public Builder credentialsPassthrough(Boolean credentialsPassthrough) {
            this.options().credentialsPassthrough(credentialsPassthrough);
            return this;
        }

        public Builder credentialsRole(IRole credentialsRole) {
            this.options().credentialsRole(credentialsRole);
            return this;
        }

        public Builder integrationResponses(List<? extends IntegrationResponse> integrationResponses) {
            this.options().integrationResponses(integrationResponses);
            return this;
        }

        public Builder passthroughBehavior(PassthroughBehavior passthroughBehavior) {
            this.options().passthroughBehavior(passthroughBehavior);
            return this;
        }

        public Builder requestParameters(Map<String, String> requestParameters) {
            this.options().requestParameters(requestParameters);
            return this;
        }

        public Builder requestTemplates(Map<String, String> requestTemplates) {
            this.options().requestTemplates(requestTemplates);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.options().timeout(timeout);
            return this;
        }

        public Builder vpcLink(IVpcLink vpcLink) {
            this.options().vpcLink(vpcLink);
            return this;
        }

        public SagemakerIntegration build() {
            return new SagemakerIntegration(this.endpoint, this.options != null ? this.options.build() : null);
        }

        private SagemakerIntegrationOptions.Builder options() {
            if (this.options == null) {
                this.options = new SagemakerIntegrationOptions.Builder();
            }
            return this.options;
        }
    }
}

