/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.accessanalyzer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.accessanalyzer.CfnAnalyzer;
import software.amazon.awscdk.services.accessanalyzer.CfnAnalyzerProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_accessanalyzer.CfnAnalyzer")
public class CfnAnalyzer
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnAnalyzer.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnAnalyzer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAnalyzer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnAnalyzer(@NotNull Construct scope, @NotNull String id, @NotNull CfnAnalyzerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getType() {
        return (String)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@NotNull String value) {
        Kernel.set((Object)this, (String)"type", (Object)Objects.requireNonNull(value, "type is required"));
    }

    @Nullable
    public Object getAnalyzerConfiguration() {
        return Kernel.get((Object)this, (String)"analyzerConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAnalyzerConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"analyzerConfiguration", (Object)value);
    }

    public void setAnalyzerConfiguration(@Nullable AnalyzerConfigurationProperty value) {
        Kernel.set((Object)this, (String)"analyzerConfiguration", (Object)value);
    }

    @Nullable
    public String getAnalyzerName() {
        return (String)Kernel.get((Object)this, (String)"analyzerName", (NativeType)NativeType.forClass(String.class));
    }

    public void setAnalyzerName(@Nullable String value) {
        Kernel.set((Object)this, (String)"analyzerName", (Object)value);
    }

    @Nullable
    public Object getArchiveRules() {
        return Kernel.get((Object)this, (String)"archiveRules", (NativeType)NativeType.forClass(Object.class));
    }

    public void setArchiveRules(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"archiveRules", (Object)value);
    }

    public void setArchiveRules(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ArchiveRuleProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.accessanalyzer.CfnAnalyzer.ArchiveRuleProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"archiveRules", value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_accessanalyzer.CfnAnalyzer.ArchiveRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ArchiveRuleProperty
    extends JsiiSerializable {
        @NotNull
        public Object getFilter();

        @NotNull
        public String getRuleName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ArchiveRuleProperty> {
            Object filter;
            String ruleName;

            public Builder filter(IResolvable filter) {
                this.filter = filter;
                return this;
            }

            public Builder filter(List<? extends Object> filter) {
                this.filter = filter;
                return this;
            }

            public Builder ruleName(String ruleName) {
                this.ruleName = ruleName;
                return this;
            }

            public ArchiveRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnAnalyzer> {
        private final Construct scope;
        private final String id;
        private final CfnAnalyzerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAnalyzerProps.Builder();
        }

        public Builder type(String type) {
            this.props.type(type);
            return this;
        }

        public Builder analyzerConfiguration(IResolvable analyzerConfiguration) {
            this.props.analyzerConfiguration(analyzerConfiguration);
            return this;
        }

        public Builder analyzerConfiguration(AnalyzerConfigurationProperty analyzerConfiguration) {
            this.props.analyzerConfiguration(analyzerConfiguration);
            return this;
        }

        public Builder analyzerName(String analyzerName) {
            this.props.analyzerName(analyzerName);
            return this;
        }

        public Builder archiveRules(IResolvable archiveRules) {
            this.props.archiveRules(archiveRules);
            return this;
        }

        public Builder archiveRules(List<? extends Object> archiveRules) {
            this.props.archiveRules(archiveRules);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnAnalyzer build() {
            return new CfnAnalyzer(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_accessanalyzer.CfnAnalyzer.UnusedAccessConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UnusedAccessConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getUnusedAccessAge() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UnusedAccessConfigurationProperty> {
            Number unusedAccessAge;

            public Builder unusedAccessAge(Number unusedAccessAge) {
                this.unusedAccessAge = unusedAccessAge;
                return this;
            }

            public UnusedAccessConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_accessanalyzer.CfnAnalyzer.FilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterProperty
    extends JsiiSerializable {
        @NotNull
        public String getProperty();

        @Nullable
        default public List<String> getContains() {
            return null;
        }

        @Nullable
        default public List<String> getEq() {
            return null;
        }

        @Nullable
        default public Object getExists() {
            return null;
        }

        @Nullable
        default public List<String> getNeq() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterProperty> {
            String property;
            List<String> contains;
            List<String> eq;
            Object exists;
            List<String> neq;

            public Builder property(String property) {
                this.property = property;
                return this;
            }

            public Builder contains(List<String> contains) {
                this.contains = contains;
                return this;
            }

            public Builder eq(List<String> eq) {
                this.eq = eq;
                return this;
            }

            public Builder exists(Boolean exists) {
                this.exists = exists;
                return this;
            }

            public Builder exists(IResolvable exists) {
                this.exists = exists;
                return this;
            }

            public Builder neq(List<String> neq) {
                this.neq = neq;
                return this;
            }

            public FilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_accessanalyzer.CfnAnalyzer.AnalyzerConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AnalyzerConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getUnusedAccessConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AnalyzerConfigurationProperty> {
            Object unusedAccessConfiguration;

            public Builder unusedAccessConfiguration(IResolvable unusedAccessConfiguration) {
                this.unusedAccessConfiguration = unusedAccessConfiguration;
                return this;
            }

            public Builder unusedAccessConfiguration(UnusedAccessConfigurationProperty unusedAccessConfiguration) {
                this.unusedAccessConfiguration = unusedAccessConfiguration;
                return this;
            }

            public AnalyzerConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

