/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.aps;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.aps.CfnScraper;
import software.amazon.awscdk.services.aps.CfnScraperProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_aps.CfnScraper")
public class CfnScraper
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnScraper.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnScraper(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnScraper(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnScraper(@NotNull Construct scope, @NotNull String id, @NotNull CfnScraperProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrRoleArn() {
        return (String)Kernel.get((Object)this, (String)"attrRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrScraperId() {
        return (String)Kernel.get((Object)this, (String)"attrScraperId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getDestination() {
        return Kernel.get((Object)this, (String)"destination", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDestination(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"destination", (Object)Objects.requireNonNull(value, "destination is required"));
    }

    public void setDestination(@NotNull DestinationProperty value) {
        Kernel.set((Object)this, (String)"destination", (Object)Objects.requireNonNull(value, "destination is required"));
    }

    @NotNull
    public Object getScrapeConfiguration() {
        return Kernel.get((Object)this, (String)"scrapeConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setScrapeConfiguration(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"scrapeConfiguration", (Object)Objects.requireNonNull(value, "scrapeConfiguration is required"));
    }

    public void setScrapeConfiguration(@NotNull ScrapeConfigurationProperty value) {
        Kernel.set((Object)this, (String)"scrapeConfiguration", (Object)Objects.requireNonNull(value, "scrapeConfiguration is required"));
    }

    @NotNull
    public Object getSource() {
        return Kernel.get((Object)this, (String)"source", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSource(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"source", (Object)Objects.requireNonNull(value, "source is required"));
    }

    public void setSource(@NotNull SourceProperty value) {
        Kernel.set((Object)this, (String)"source", (Object)Objects.requireNonNull(value, "source is required"));
    }

    @Nullable
    public String getAlias() {
        return (String)Kernel.get((Object)this, (String)"alias", (NativeType)NativeType.forClass(String.class));
    }

    public void setAlias(@Nullable String value) {
        Kernel.set((Object)this, (String)"alias", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnScraper> {
        private final Construct scope;
        private final String id;
        private final CfnScraperProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnScraperProps.Builder();
        }

        public Builder destination(IResolvable destination) {
            this.props.destination(destination);
            return this;
        }

        public Builder destination(DestinationProperty destination) {
            this.props.destination(destination);
            return this;
        }

        public Builder scrapeConfiguration(IResolvable scrapeConfiguration) {
            this.props.scrapeConfiguration(scrapeConfiguration);
            return this;
        }

        public Builder scrapeConfiguration(ScrapeConfigurationProperty scrapeConfiguration) {
            this.props.scrapeConfiguration(scrapeConfiguration);
            return this;
        }

        public Builder source(IResolvable source) {
            this.props.source(source);
            return this;
        }

        public Builder source(SourceProperty source) {
            this.props.source(source);
            return this;
        }

        public Builder alias(String alias) {
            this.props.alias(alias);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnScraper build() {
            return new CfnScraper(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_aps.CfnScraper.SourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEksConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceProperty> {
            Object eksConfiguration;

            public Builder eksConfiguration(IResolvable eksConfiguration) {
                this.eksConfiguration = eksConfiguration;
                return this;
            }

            public Builder eksConfiguration(EksConfigurationProperty eksConfiguration) {
                this.eksConfiguration = eksConfiguration;
                return this;
            }

            public SourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_aps.CfnScraper.ScrapeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScrapeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getConfigurationBlob();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScrapeConfigurationProperty> {
            String configurationBlob;

            public Builder configurationBlob(String configurationBlob) {
                this.configurationBlob = configurationBlob;
                return this;
            }

            public ScrapeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_aps.CfnScraper.EksConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EksConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getClusterArn();

        @NotNull
        public List<String> getSubnetIds();

        @Nullable
        default public List<String> getSecurityGroupIds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EksConfigurationProperty> {
            String clusterArn;
            List<String> subnetIds;
            List<String> securityGroupIds;

            public Builder clusterArn(String clusterArn) {
                this.clusterArn = clusterArn;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public EksConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_aps.CfnScraper.DestinationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DestinationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getAmpConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DestinationProperty> {
            Object ampConfiguration;

            public Builder ampConfiguration(IResolvable ampConfiguration) {
                this.ampConfiguration = ampConfiguration;
                return this;
            }

            public Builder ampConfiguration(AmpConfigurationProperty ampConfiguration) {
                this.ampConfiguration = ampConfiguration;
                return this;
            }

            public DestinationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_aps.CfnScraper.AmpConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AmpConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getWorkspaceArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AmpConfigurationProperty> {
            String workspaceArn;

            public Builder workspaceArn(String workspaceArn) {
                this.workspaceArn = workspaceArn;
                return this;
            }

            public AmpConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

