/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.lambda.EventSourceMappingProps;
import software.amazon.awscdk.services.lambda.IEventSourceDlq;
import software.amazon.awscdk.services.lambda.IEventSourceMapping;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.lambda.SourceAccessConfiguration;
import software.amazon.awscdk.services.lambda.StartingPosition;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lambda.EventSourceMapping")
public class EventSourceMapping
extends Resource
implements IEventSourceMapping {
    protected EventSourceMapping(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EventSourceMapping(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EventSourceMapping(@NotNull Construct scope, @NotNull String id, @NotNull EventSourceMappingProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IEventSourceMapping fromEventSourceMappingId(@NotNull Construct scope, @NotNull String id, @NotNull String eventSourceMappingId) {
        return (IEventSourceMapping)JsiiObject.jsiiStaticCall(EventSourceMapping.class, (String)"fromEventSourceMappingId", (NativeType)NativeType.forClass(IEventSourceMapping.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(eventSourceMappingId, "eventSourceMappingId is required")});
    }

    @Override
    @NotNull
    public String getEventSourceMappingArn() {
        return (String)Kernel.get((Object)this, (String)"eventSourceMappingArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getEventSourceMappingId() {
        return (String)Kernel.get((Object)this, (String)"eventSourceMappingId", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EventSourceMapping> {
        private final Construct scope;
        private final String id;
        private final EventSourceMappingProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new EventSourceMappingProps.Builder();
        }

        public Builder batchSize(Number batchSize) {
            this.props.batchSize(batchSize);
            return this;
        }

        public Builder bisectBatchOnError(Boolean bisectBatchOnError) {
            this.props.bisectBatchOnError(bisectBatchOnError);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        public Builder eventSourceArn(String eventSourceArn) {
            this.props.eventSourceArn(eventSourceArn);
            return this;
        }

        public Builder filterEncryption(IKey filterEncryption) {
            this.props.filterEncryption(filterEncryption);
            return this;
        }

        public Builder filters(List<? extends Map<String, ? extends Object>> filters) {
            this.props.filters(filters);
            return this;
        }

        public Builder kafkaBootstrapServers(List<String> kafkaBootstrapServers) {
            this.props.kafkaBootstrapServers(kafkaBootstrapServers);
            return this;
        }

        public Builder kafkaConsumerGroupId(String kafkaConsumerGroupId) {
            this.props.kafkaConsumerGroupId(kafkaConsumerGroupId);
            return this;
        }

        public Builder kafkaTopic(String kafkaTopic) {
            this.props.kafkaTopic(kafkaTopic);
            return this;
        }

        public Builder maxBatchingWindow(Duration maxBatchingWindow) {
            this.props.maxBatchingWindow(maxBatchingWindow);
            return this;
        }

        public Builder maxConcurrency(Number maxConcurrency) {
            this.props.maxConcurrency(maxConcurrency);
            return this;
        }

        public Builder maxRecordAge(Duration maxRecordAge) {
            this.props.maxRecordAge(maxRecordAge);
            return this;
        }

        public Builder onFailure(IEventSourceDlq onFailure) {
            this.props.onFailure(onFailure);
            return this;
        }

        public Builder parallelizationFactor(Number parallelizationFactor) {
            this.props.parallelizationFactor(parallelizationFactor);
            return this;
        }

        public Builder reportBatchItemFailures(Boolean reportBatchItemFailures) {
            this.props.reportBatchItemFailures(reportBatchItemFailures);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        public Builder sourceAccessConfigurations(List<? extends SourceAccessConfiguration> sourceAccessConfigurations) {
            this.props.sourceAccessConfigurations(sourceAccessConfigurations);
            return this;
        }

        public Builder startingPosition(StartingPosition startingPosition) {
            this.props.startingPosition(startingPosition);
            return this;
        }

        public Builder startingPositionTimestamp(Number startingPositionTimestamp) {
            this.props.startingPositionTimestamp(startingPositionTimestamp);
            return this;
        }

        public Builder supportS3OnFailureDestination(Boolean supportS3OnFailureDestination) {
            this.props.supportS3OnFailureDestination(supportS3OnFailureDestination);
            return this;
        }

        public Builder tumblingWindow(Duration tumblingWindow) {
            this.props.tumblingWindow(tumblingWindow);
            return this;
        }

        public Builder target(IFunction target) {
            this.props.target(target);
            return this;
        }

        public EventSourceMapping build() {
            return new EventSourceMapping(this.scope, this.id, this.props.build());
        }
    }
}

