/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.sagemaker.CfnSpace;
import software.amazon.awscdk.services.sagemaker.CfnSpaceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnSpace")
public class CfnSpace
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnSpace.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnSpace(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSpace(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnSpace(@NotNull Construct scope, @NotNull String id, @NotNull CfnSpaceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrSpaceArn() {
        return (String)Kernel.get((Object)this, (String)"attrSpaceArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrUrl() {
        return (String)Kernel.get((Object)this, (String)"attrUrl", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getDomainId() {
        return (String)Kernel.get((Object)this, (String)"domainId", (NativeType)NativeType.forClass(String.class));
    }

    public void setDomainId(@NotNull String value) {
        Kernel.set((Object)this, (String)"domainId", (Object)Objects.requireNonNull(value, "domainId is required"));
    }

    @NotNull
    public String getSpaceName() {
        return (String)Kernel.get((Object)this, (String)"spaceName", (NativeType)NativeType.forClass(String.class));
    }

    public void setSpaceName(@NotNull String value) {
        Kernel.set((Object)this, (String)"spaceName", (Object)Objects.requireNonNull(value, "spaceName is required"));
    }

    @Nullable
    public Object getOwnershipSettings() {
        return Kernel.get((Object)this, (String)"ownershipSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOwnershipSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"ownershipSettings", (Object)value);
    }

    public void setOwnershipSettings(@Nullable OwnershipSettingsProperty value) {
        Kernel.set((Object)this, (String)"ownershipSettings", (Object)value);
    }

    @Nullable
    public String getSpaceDisplayName() {
        return (String)Kernel.get((Object)this, (String)"spaceDisplayName", (NativeType)NativeType.forClass(String.class));
    }

    public void setSpaceDisplayName(@Nullable String value) {
        Kernel.set((Object)this, (String)"spaceDisplayName", (Object)value);
    }

    @Nullable
    public Object getSpaceSettings() {
        return Kernel.get((Object)this, (String)"spaceSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSpaceSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"spaceSettings", (Object)value);
    }

    public void setSpaceSettings(@Nullable SpaceSettingsProperty value) {
        Kernel.set((Object)this, (String)"spaceSettings", (Object)value);
    }

    @Nullable
    public Object getSpaceSharingSettings() {
        return Kernel.get((Object)this, (String)"spaceSharingSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSpaceSharingSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"spaceSharingSettings", (Object)value);
    }

    public void setSpaceSharingSettings(@Nullable SpaceSharingSettingsProperty value) {
        Kernel.set((Object)this, (String)"spaceSharingSettings", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnSpace> {
        private final Construct scope;
        private final String id;
        private final CfnSpaceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnSpaceProps.Builder();
        }

        public Builder domainId(String domainId) {
            this.props.domainId(domainId);
            return this;
        }

        public Builder spaceName(String spaceName) {
            this.props.spaceName(spaceName);
            return this;
        }

        public Builder ownershipSettings(IResolvable ownershipSettings) {
            this.props.ownershipSettings(ownershipSettings);
            return this;
        }

        public Builder ownershipSettings(OwnershipSettingsProperty ownershipSettings) {
            this.props.ownershipSettings(ownershipSettings);
            return this;
        }

        public Builder spaceDisplayName(String spaceDisplayName) {
            this.props.spaceDisplayName(spaceDisplayName);
            return this;
        }

        public Builder spaceSettings(IResolvable spaceSettings) {
            this.props.spaceSettings(spaceSettings);
            return this;
        }

        public Builder spaceSettings(SpaceSettingsProperty spaceSettings) {
            this.props.spaceSettings(spaceSettings);
            return this;
        }

        public Builder spaceSharingSettings(IResolvable spaceSharingSettings) {
            this.props.spaceSharingSettings(spaceSharingSettings);
            return this;
        }

        public Builder spaceSharingSettings(SpaceSharingSettingsProperty spaceSharingSettings) {
            this.props.spaceSharingSettings(spaceSharingSettings);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnSpace build() {
            return new CfnSpace(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceStorageSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpaceStorageSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEbsStorageSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpaceStorageSettingsProperty> {
            Object ebsStorageSettings;

            public Builder ebsStorageSettings(IResolvable ebsStorageSettings) {
                this.ebsStorageSettings = ebsStorageSettings;
                return this;
            }

            public Builder ebsStorageSettings(EbsStorageSettingsProperty ebsStorageSettings) {
                this.ebsStorageSettings = ebsStorageSettings;
                return this;
            }

            public SpaceStorageSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceSharingSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpaceSharingSettingsProperty
    extends JsiiSerializable {
        @NotNull
        public String getSharingType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpaceSharingSettingsProperty> {
            String sharingType;

            public Builder sharingType(String sharingType) {
                this.sharingType = sharingType;
                return this;
            }

            public SpaceSharingSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpaceSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAppType() {
            return null;
        }

        @Nullable
        default public Object getCodeEditorAppSettings() {
            return null;
        }

        @Nullable
        default public Object getCustomFileSystems() {
            return null;
        }

        @Nullable
        default public Object getJupyterLabAppSettings() {
            return null;
        }

        @Nullable
        default public Object getJupyterServerAppSettings() {
            return null;
        }

        @Nullable
        default public Object getKernelGatewayAppSettings() {
            return null;
        }

        @Nullable
        default public Object getSpaceStorageSettings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpaceSettingsProperty> {
            String appType;
            Object codeEditorAppSettings;
            Object customFileSystems;
            Object jupyterLabAppSettings;
            Object jupyterServerAppSettings;
            Object kernelGatewayAppSettings;
            Object spaceStorageSettings;

            public Builder appType(String appType) {
                this.appType = appType;
                return this;
            }

            public Builder codeEditorAppSettings(IResolvable codeEditorAppSettings) {
                this.codeEditorAppSettings = codeEditorAppSettings;
                return this;
            }

            public Builder codeEditorAppSettings(SpaceCodeEditorAppSettingsProperty codeEditorAppSettings) {
                this.codeEditorAppSettings = codeEditorAppSettings;
                return this;
            }

            public Builder customFileSystems(IResolvable customFileSystems) {
                this.customFileSystems = customFileSystems;
                return this;
            }

            public Builder customFileSystems(List<? extends Object> customFileSystems) {
                this.customFileSystems = customFileSystems;
                return this;
            }

            public Builder jupyterLabAppSettings(IResolvable jupyterLabAppSettings) {
                this.jupyterLabAppSettings = jupyterLabAppSettings;
                return this;
            }

            public Builder jupyterLabAppSettings(SpaceJupyterLabAppSettingsProperty jupyterLabAppSettings) {
                this.jupyterLabAppSettings = jupyterLabAppSettings;
                return this;
            }

            public Builder jupyterServerAppSettings(IResolvable jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            public Builder jupyterServerAppSettings(JupyterServerAppSettingsProperty jupyterServerAppSettings) {
                this.jupyterServerAppSettings = jupyterServerAppSettings;
                return this;
            }

            public Builder kernelGatewayAppSettings(IResolvable kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            public Builder kernelGatewayAppSettings(KernelGatewayAppSettingsProperty kernelGatewayAppSettings) {
                this.kernelGatewayAppSettings = kernelGatewayAppSettings;
                return this;
            }

            public Builder spaceStorageSettings(IResolvable spaceStorageSettings) {
                this.spaceStorageSettings = spaceStorageSettings;
                return this;
            }

            public Builder spaceStorageSettings(SpaceStorageSettingsProperty spaceStorageSettings) {
                this.spaceStorageSettings = spaceStorageSettings;
                return this;
            }

            public SpaceSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceJupyterLabAppSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpaceJupyterLabAppSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCodeRepositories() {
            return null;
        }

        @Nullable
        default public Object getDefaultResourceSpec() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpaceJupyterLabAppSettingsProperty> {
            Object codeRepositories;
            Object defaultResourceSpec;

            public Builder codeRepositories(IResolvable codeRepositories) {
                this.codeRepositories = codeRepositories;
                return this;
            }

            public Builder codeRepositories(List<? extends Object> codeRepositories) {
                this.codeRepositories = codeRepositories;
                return this;
            }

            public Builder defaultResourceSpec(IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder defaultResourceSpec(ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public SpaceJupyterLabAppSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnSpace.SpaceCodeEditorAppSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpaceCodeEditorAppSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDefaultResourceSpec() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpaceCodeEditorAppSettingsProperty> {
            Object defaultResourceSpec;

            public Builder defaultResourceSpec(IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder defaultResourceSpec(ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public SpaceCodeEditorAppSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnSpace.ResourceSpecProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourceSpecProperty
    extends JsiiSerializable {
        @Nullable
        default public String getInstanceType() {
            return null;
        }

        @Nullable
        default public String getLifecycleConfigArn() {
            return null;
        }

        @Nullable
        default public String getSageMakerImageArn() {
            return null;
        }

        @Nullable
        default public String getSageMakerImageVersionArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourceSpecProperty> {
            String instanceType;
            String lifecycleConfigArn;
            String sageMakerImageArn;
            String sageMakerImageVersionArn;

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder lifecycleConfigArn(String lifecycleConfigArn) {
                this.lifecycleConfigArn = lifecycleConfigArn;
                return this;
            }

            public Builder sageMakerImageArn(String sageMakerImageArn) {
                this.sageMakerImageArn = sageMakerImageArn;
                return this;
            }

            public Builder sageMakerImageVersionArn(String sageMakerImageVersionArn) {
                this.sageMakerImageVersionArn = sageMakerImageVersionArn;
                return this;
            }

            public ResourceSpecProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnSpace.OwnershipSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OwnershipSettingsProperty
    extends JsiiSerializable {
        @NotNull
        public String getOwnerUserProfileName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OwnershipSettingsProperty> {
            String ownerUserProfileName;

            public Builder ownerUserProfileName(String ownerUserProfileName) {
                this.ownerUserProfileName = ownerUserProfileName;
                return this;
            }

            public OwnershipSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnSpace.KernelGatewayAppSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KernelGatewayAppSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomImages() {
            return null;
        }

        @Nullable
        default public Object getDefaultResourceSpec() {
            return null;
        }

        @Nullable
        default public List<String> getLifecycleConfigArns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KernelGatewayAppSettingsProperty> {
            Object customImages;
            Object defaultResourceSpec;
            List<String> lifecycleConfigArns;

            public Builder customImages(IResolvable customImages) {
                this.customImages = customImages;
                return this;
            }

            public Builder customImages(List<? extends Object> customImages) {
                this.customImages = customImages;
                return this;
            }

            public Builder defaultResourceSpec(IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder defaultResourceSpec(ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder lifecycleConfigArns(List<String> lifecycleConfigArns) {
                this.lifecycleConfigArns = lifecycleConfigArns;
                return this;
            }

            public KernelGatewayAppSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnSpace.JupyterServerAppSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JupyterServerAppSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDefaultResourceSpec() {
            return null;
        }

        @Nullable
        default public List<String> getLifecycleConfigArns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JupyterServerAppSettingsProperty> {
            Object defaultResourceSpec;
            List<String> lifecycleConfigArns;

            public Builder defaultResourceSpec(IResolvable defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder defaultResourceSpec(ResourceSpecProperty defaultResourceSpec) {
                this.defaultResourceSpec = defaultResourceSpec;
                return this;
            }

            public Builder lifecycleConfigArns(List<String> lifecycleConfigArns) {
                this.lifecycleConfigArns = lifecycleConfigArns;
                return this;
            }

            public JupyterServerAppSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnSpace.EbsStorageSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsStorageSettingsProperty
    extends JsiiSerializable {
        @NotNull
        public Number getEbsVolumeSizeInGb();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EbsStorageSettingsProperty> {
            Number ebsVolumeSizeInGb;

            public Builder ebsVolumeSizeInGb(Number ebsVolumeSizeInGb) {
                this.ebsVolumeSizeInGb = ebsVolumeSizeInGb;
                return this;
            }

            public EbsStorageSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnSpace.EFSFileSystemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EFSFileSystemProperty
    extends JsiiSerializable {
        @NotNull
        public String getFileSystemId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EFSFileSystemProperty> {
            String fileSystemId;

            public Builder fileSystemId(String fileSystemId) {
                this.fileSystemId = fileSystemId;
                return this;
            }

            public EFSFileSystemProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnSpace.CustomImageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomImageProperty
    extends JsiiSerializable {
        @NotNull
        public String getAppImageConfigName();

        @NotNull
        public String getImageName();

        @Nullable
        default public Number getImageVersionNumber() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomImageProperty> {
            String appImageConfigName;
            String imageName;
            Number imageVersionNumber;

            public Builder appImageConfigName(String appImageConfigName) {
                this.appImageConfigName = appImageConfigName;
                return this;
            }

            public Builder imageName(String imageName) {
                this.imageName = imageName;
                return this;
            }

            public Builder imageVersionNumber(Number imageVersionNumber) {
                this.imageVersionNumber = imageVersionNumber;
                return this;
            }

            public CustomImageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnSpace.CustomFileSystemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomFileSystemProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEfsFileSystem() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomFileSystemProperty> {
            Object efsFileSystem;

            public Builder efsFileSystem(IResolvable efsFileSystem) {
                this.efsFileSystem = efsFileSystem;
                return this;
            }

            public Builder efsFileSystem(EFSFileSystemProperty efsFileSystem) {
                this.efsFileSystem = efsFileSystem;
                return this;
            }

            public CustomFileSystemProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnSpace.CodeRepositoryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CodeRepositoryProperty
    extends JsiiSerializable {
        @NotNull
        public String getRepositoryUrl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CodeRepositoryProperty> {
            String repositoryUrl;

            public Builder repositoryUrl(String repositoryUrl) {
                this.repositoryUrl = repositoryUrl;
                return this;
            }

            public CodeRepositoryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

