/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.stepfunctions.State;
import software.amazon.awscdk.services.stepfunctions.StateMachine;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_stepfunctions.StateGraph")
public class StateGraph
extends JsiiObject {
    protected StateGraph(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StateGraph(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public StateGraph(@NotNull State startState, @NotNull String graphDescription) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(startState, "startState is required"), Objects.requireNonNull(graphDescription, "graphDescription is required")});
    }

    public void bind(@NotNull StateMachine stateMachine) {
        Kernel.call((Object)((Object)this), (String)"bind", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(stateMachine, "stateMachine is required")});
    }

    public void registerPolicyStatement(@NotNull PolicyStatement statement) {
        Kernel.call((Object)((Object)this), (String)"registerPolicyStatement", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    public void registerState(@NotNull State state) {
        Kernel.call((Object)((Object)this), (String)"registerState", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(state, "state is required")});
    }

    public void registerSuperGraph(@NotNull StateGraph graph) {
        Kernel.call((Object)((Object)this), (String)"registerSuperGraph", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(graph, "graph is required")});
    }

    @NotNull
    public ObjectNode toGraphJson() {
        return (ObjectNode)Kernel.call((Object)((Object)this), (String)"toGraphJson", (NativeType)NativeType.forClass(ObjectNode.class), (Object[])new Object[0]);
    }

    @NotNull
    public String toString() {
        return (String)Kernel.call((Object)((Object)this), (String)"toString", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @NotNull
    public List<PolicyStatement> getPolicyStatements() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"policyStatements", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(PolicyStatement.class))));
    }

    @NotNull
    public State getStartState() {
        return (State)Kernel.get((Object)((Object)this), (String)"startState", (NativeType)NativeType.forClass(State.class));
    }

    @Nullable
    public Duration getTimeout() {
        return (Duration)((Object)Kernel.get((Object)((Object)this), (String)"timeout", (NativeType)NativeType.forClass(Duration.class)));
    }

    public void setTimeout(@Nullable Duration value) {
        Kernel.set((Object)((Object)this), (String)"timeout", (Object)((Object)value));
    }
}

