package software.amazon.awscdk;

/**
 * The type of output that a bundling operation is producing.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * Asset asset = Asset.Builder.create(this, "BundledAsset")
 *         .path("/path/to/asset")
 *         .bundling(BundlingOptions.builder()
 *                 .image(DockerImage.fromRegistry("alpine"))
 *                 .command(List.of("command-that-produces-an-archive.sh"))
 *                 .outputType(BundlingOutput.NOT_ARCHIVED)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:25.966Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.BundlingOutput")
public enum BundlingOutput {
    /**
     * The bundling output directory includes a single .zip or .jar file which will be used as the final bundle. If the output directory does not include exactly a single archive, bundling will fail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ARCHIVED,
    /**
     * The bundling output directory contains one or more files which will be archived and uploaded as a .zip file to S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NOT_ARCHIVED,
    /**
     * If the bundling output directory contains a single archive file (zip or jar) it will be used as the bundle output as-is.
     * <p>
     * Otherwise, all the files in the bundling output directory will be zipped.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AUTO_DISCOVER,
    /**
     * The bundling output directory includes a single file which will be used as the final bundle.
     * <p>
     * If the output directory does not
     * include exactly a single file, bundling will fail.
     * <p>
     * Similar to ARCHIVED but for non-archive files
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SINGLE_FILE,
}
