package software.amazon.awscdk;

/**
 * With scheduled actions, the group size properties of an Auto Scaling group can change at any time.
 * <p>
 * When you update a
 * stack with an Auto Scaling group and scheduled action, AWS CloudFormation always sets the group size property values of
 * your Auto Scaling group to the values that are defined in the AWS::AutoScaling::AutoScalingGroup resource of your template,
 * even if a scheduled action is in effect.
 * <p>
 * If you do not want AWS CloudFormation to change any of the group size property values when you have a scheduled action in
 * effect, use the AutoScalingScheduledAction update policy to prevent AWS CloudFormation from changing the MinSize, MaxSize,
 * or DesiredCapacity properties unless you have modified these values in your template.\
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * CfnAutoScalingScheduledAction cfnAutoScalingScheduledAction = CfnAutoScalingScheduledAction.builder()
 *         .ignoreUnmodifiedGroupSizeProperties(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:25.967Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnAutoScalingScheduledAction")
@software.amazon.jsii.Jsii.Proxy(CfnAutoScalingScheduledAction.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAutoScalingScheduledAction extends software.amazon.jsii.JsiiSerializable {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreUnmodifiedGroupSizeProperties() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAutoScalingScheduledAction}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAutoScalingScheduledAction}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAutoScalingScheduledAction> {
        java.lang.Boolean ignoreUnmodifiedGroupSizeProperties;

        /**
         * Sets the value of {@link CfnAutoScalingScheduledAction#getIgnoreUnmodifiedGroupSizeProperties}
         * @param ignoreUnmodifiedGroupSizeProperties the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreUnmodifiedGroupSizeProperties(java.lang.Boolean ignoreUnmodifiedGroupSizeProperties) {
            this.ignoreUnmodifiedGroupSizeProperties = ignoreUnmodifiedGroupSizeProperties;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAutoScalingScheduledAction}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAutoScalingScheduledAction build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAutoScalingScheduledAction}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAutoScalingScheduledAction {
        private final java.lang.Boolean ignoreUnmodifiedGroupSizeProperties;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ignoreUnmodifiedGroupSizeProperties = software.amazon.jsii.Kernel.get(this, "ignoreUnmodifiedGroupSizeProperties", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ignoreUnmodifiedGroupSizeProperties = builder.ignoreUnmodifiedGroupSizeProperties;
        }

        @Override
        public final java.lang.Boolean getIgnoreUnmodifiedGroupSizeProperties() {
            return this.ignoreUnmodifiedGroupSizeProperties;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getIgnoreUnmodifiedGroupSizeProperties() != null) {
                data.set("ignoreUnmodifiedGroupSizeProperties", om.valueToTree(this.getIgnoreUnmodifiedGroupSizeProperties()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnAutoScalingScheduledAction"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAutoScalingScheduledAction.Jsii$Proxy that = (CfnAutoScalingScheduledAction.Jsii$Proxy) o;

            return this.ignoreUnmodifiedGroupSizeProperties != null ? this.ignoreUnmodifiedGroupSizeProperties.equals(that.ignoreUnmodifiedGroupSizeProperties) : that.ignoreUnmodifiedGroupSizeProperties == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ignoreUnmodifiedGroupSizeProperties != null ? this.ignoreUnmodifiedGroupSizeProperties.hashCode() : 0;
            return result;
        }
    }
}
