package software.amazon.awscdk.customresources;

/**
 * A class used to configure Logging during AwsCustomResource SDK calls.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AwsCustomResource getParameter = AwsCustomResource.Builder.create(this, "GetParameter")
 *         .onUpdate(AwsSdkCall.builder()
 *                 .service("SSM")
 *                 .action("GetParameter")
 *                 .parameters(Map.of(
 *                         "Name", "my-parameter",
 *                         "WithDecryption", true))
 *                 .physicalResourceId(PhysicalResourceId.of(Date.now().toString()))
 *                 .logging(Logging.withDataHidden())
 *                 .build())
 *         .policy(AwsCustomResourcePolicy.fromSdkCalls(SdkCallsPolicyOptions.builder()
 *                 .resources(AwsCustomResourcePolicy.ANY_RESOURCE)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:41.553Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.custom_resources.Logging")
public abstract class Logging extends software.amazon.jsii.JsiiObject {

    protected Logging(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Logging(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Logging(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.customresources.LoggingProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Logging() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Enables logging of all logged data in the lambda handler.
     * <p>
     * This includes the event object, the API call response, all fields in the response object
     * returned by the lambda, and any errors encountered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.Logging all() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.customresources.Logging.class, "all", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.Logging.class));
    }

    /**
     * Hides logging of data associated with the API call response.
     * <p>
     * This includes hiding the raw API
     * call response and the <code>Data</code> field associated with the lambda handler response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.Logging withDataHidden() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.customresources.Logging.class, "withDataHidden", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.Logging.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.customresources.Logging {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
