package software.amazon.awscdk.pipelines;

/**
 * Properties for a <code>StackDeployment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.pipelines.*;
 * StackDeploymentProps stackDeploymentProps = StackDeploymentProps.builder()
 *         .absoluteTemplatePath("absoluteTemplatePath")
 *         .constructPath("constructPath")
 *         .stackArtifactId("stackArtifactId")
 *         .stackName("stackName")
 *         // the properties below are optional
 *         .account("account")
 *         .assets(List.of(StackAsset.builder()
 *                 .assetId("assetId")
 *                 .assetManifestPath("assetManifestPath")
 *                 .assetSelector("assetSelector")
 *                 .assetType(AssetType.FILE)
 *                 .isTemplate(false)
 *                 // the properties below are optional
 *                 .assetPublishingRoleArn("assetPublishingRoleArn")
 *                 .build()))
 *         .assumeRoleArn("assumeRoleArn")
 *         .executionRoleArn("executionRoleArn")
 *         .region("region")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .templateS3Uri("templateS3Uri")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:41.661Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.StackDeploymentProps")
@software.amazon.jsii.Jsii.Proxy(StackDeploymentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StackDeploymentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Template path on disk to cloud assembly (cdk.out).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAbsoluteTemplatePath();

    /**
     * Construct path for this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConstructPath();

    /**
     * Artifact ID for this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStackArtifactId();

    /**
     * Name for this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStackName();

    /**
     * Account where the stack should be deployed.
     * <p>
     * Default: - Pipeline account
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccount() {
        return null;
    }

    /**
     * Assets referenced by this stack.
     * <p>
     * Default: - No assets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.pipelines.StackAsset> getAssets() {
        return null;
    }

    /**
     * Role to assume before deploying this stack.
     * <p>
     * Default: - Don't assume any role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssumeRoleArn() {
        return null;
    }

    /**
     * Execution role to pass to CloudFormation.
     * <p>
     * Default: - No execution role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
        return null;
    }

    /**
     * Region where the stack should be deployed.
     * <p>
     * Default: - Pipeline region
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * Tags to apply to the stack.
     * <p>
     * Default: - No tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * The S3 URL which points to the template asset location in the publishing bucket.
     * <p>
     * Default: - Stack template is not published
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateS3Uri() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StackDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StackDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StackDeploymentProps> {
        java.lang.String absoluteTemplatePath;
        java.lang.String constructPath;
        java.lang.String stackArtifactId;
        java.lang.String stackName;
        java.lang.String account;
        java.util.List<software.amazon.awscdk.pipelines.StackAsset> assets;
        java.lang.String assumeRoleArn;
        java.lang.String executionRoleArn;
        java.lang.String region;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.String templateS3Uri;

        /**
         * Sets the value of {@link StackDeploymentProps#getAbsoluteTemplatePath}
         * @param absoluteTemplatePath Template path on disk to cloud assembly (cdk.out). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder absoluteTemplatePath(java.lang.String absoluteTemplatePath) {
            this.absoluteTemplatePath = absoluteTemplatePath;
            return this;
        }

        /**
         * Sets the value of {@link StackDeploymentProps#getConstructPath}
         * @param constructPath Construct path for this stack. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder constructPath(java.lang.String constructPath) {
            this.constructPath = constructPath;
            return this;
        }

        /**
         * Sets the value of {@link StackDeploymentProps#getStackArtifactId}
         * @param stackArtifactId Artifact ID for this stack. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackArtifactId(java.lang.String stackArtifactId) {
            this.stackArtifactId = stackArtifactId;
            return this;
        }

        /**
         * Sets the value of {@link StackDeploymentProps#getStackName}
         * @param stackName Name for this stack. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackName(java.lang.String stackName) {
            this.stackName = stackName;
            return this;
        }

        /**
         * Sets the value of {@link StackDeploymentProps#getAccount}
         * @param account Account where the stack should be deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link StackDeploymentProps#getAssets}
         * @param assets Assets referenced by this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assets(java.util.List<? extends software.amazon.awscdk.pipelines.StackAsset> assets) {
            this.assets = (java.util.List<software.amazon.awscdk.pipelines.StackAsset>)assets;
            return this;
        }

        /**
         * Sets the value of {@link StackDeploymentProps#getAssumeRoleArn}
         * @param assumeRoleArn Role to assume before deploying this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRoleArn(java.lang.String assumeRoleArn) {
            this.assumeRoleArn = assumeRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link StackDeploymentProps#getExecutionRoleArn}
         * @param executionRoleArn Execution role to pass to CloudFormation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(java.lang.String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link StackDeploymentProps#getRegion}
         * @param region Region where the stack should be deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link StackDeploymentProps#getTags}
         * @param tags Tags to apply to the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link StackDeploymentProps#getTemplateS3Uri}
         * @param templateS3Uri The S3 URL which points to the template asset location in the publishing bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateS3Uri(java.lang.String templateS3Uri) {
            this.templateS3Uri = templateS3Uri;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StackDeploymentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StackDeploymentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StackDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StackDeploymentProps {
        private final java.lang.String absoluteTemplatePath;
        private final java.lang.String constructPath;
        private final java.lang.String stackArtifactId;
        private final java.lang.String stackName;
        private final java.lang.String account;
        private final java.util.List<software.amazon.awscdk.pipelines.StackAsset> assets;
        private final java.lang.String assumeRoleArn;
        private final java.lang.String executionRoleArn;
        private final java.lang.String region;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.String templateS3Uri;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.absoluteTemplatePath = software.amazon.jsii.Kernel.get(this, "absoluteTemplatePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.constructPath = software.amazon.jsii.Kernel.get(this, "constructPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stackArtifactId = software.amazon.jsii.Kernel.get(this, "stackArtifactId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stackName = software.amazon.jsii.Kernel.get(this, "stackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assets = software.amazon.jsii.Kernel.get(this, "assets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StackAsset.class)));
            this.assumeRoleArn = software.amazon.jsii.Kernel.get(this, "assumeRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.templateS3Uri = software.amazon.jsii.Kernel.get(this, "templateS3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.absoluteTemplatePath = java.util.Objects.requireNonNull(builder.absoluteTemplatePath, "absoluteTemplatePath is required");
            this.constructPath = java.util.Objects.requireNonNull(builder.constructPath, "constructPath is required");
            this.stackArtifactId = java.util.Objects.requireNonNull(builder.stackArtifactId, "stackArtifactId is required");
            this.stackName = java.util.Objects.requireNonNull(builder.stackName, "stackName is required");
            this.account = builder.account;
            this.assets = (java.util.List<software.amazon.awscdk.pipelines.StackAsset>)builder.assets;
            this.assumeRoleArn = builder.assumeRoleArn;
            this.executionRoleArn = builder.executionRoleArn;
            this.region = builder.region;
            this.tags = builder.tags;
            this.templateS3Uri = builder.templateS3Uri;
        }

        @Override
        public final java.lang.String getAbsoluteTemplatePath() {
            return this.absoluteTemplatePath;
        }

        @Override
        public final java.lang.String getConstructPath() {
            return this.constructPath;
        }

        @Override
        public final java.lang.String getStackArtifactId() {
            return this.stackArtifactId;
        }

        @Override
        public final java.lang.String getStackName() {
            return this.stackName;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.pipelines.StackAsset> getAssets() {
            return this.assets;
        }

        @Override
        public final java.lang.String getAssumeRoleArn() {
            return this.assumeRoleArn;
        }

        @Override
        public final java.lang.String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTemplateS3Uri() {
            return this.templateS3Uri;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("absoluteTemplatePath", om.valueToTree(this.getAbsoluteTemplatePath()));
            data.set("constructPath", om.valueToTree(this.getConstructPath()));
            data.set("stackArtifactId", om.valueToTree(this.getStackArtifactId()));
            data.set("stackName", om.valueToTree(this.getStackName()));
            if (this.getAccount() != null) {
                data.set("account", om.valueToTree(this.getAccount()));
            }
            if (this.getAssets() != null) {
                data.set("assets", om.valueToTree(this.getAssets()));
            }
            if (this.getAssumeRoleArn() != null) {
                data.set("assumeRoleArn", om.valueToTree(this.getAssumeRoleArn()));
            }
            if (this.getExecutionRoleArn() != null) {
                data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTemplateS3Uri() != null) {
                data.set("templateS3Uri", om.valueToTree(this.getTemplateS3Uri()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.StackDeploymentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StackDeploymentProps.Jsii$Proxy that = (StackDeploymentProps.Jsii$Proxy) o;

            if (!absoluteTemplatePath.equals(that.absoluteTemplatePath)) return false;
            if (!constructPath.equals(that.constructPath)) return false;
            if (!stackArtifactId.equals(that.stackArtifactId)) return false;
            if (!stackName.equals(that.stackName)) return false;
            if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
            if (this.assets != null ? !this.assets.equals(that.assets) : that.assets != null) return false;
            if (this.assumeRoleArn != null ? !this.assumeRoleArn.equals(that.assumeRoleArn) : that.assumeRoleArn != null) return false;
            if (this.executionRoleArn != null ? !this.executionRoleArn.equals(that.executionRoleArn) : that.executionRoleArn != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.templateS3Uri != null ? this.templateS3Uri.equals(that.templateS3Uri) : that.templateS3Uri == null;
        }

        @Override
        public final int hashCode() {
            int result = this.absoluteTemplatePath.hashCode();
            result = 31 * result + (this.constructPath.hashCode());
            result = 31 * result + (this.stackArtifactId.hashCode());
            result = 31 * result + (this.stackName.hashCode());
            result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
            result = 31 * result + (this.assets != null ? this.assets.hashCode() : 0);
            result = 31 * result + (this.assumeRoleArn != null ? this.assumeRoleArn.hashCode() : 0);
            result = 31 * result + (this.executionRoleArn != null ? this.executionRoleArn.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.templateS3Uri != null ? this.templateS3Uri.hashCode() : 0);
            return result;
        }
    }
}
